package software.amazon.awscdk.services.cognito;

/**
 * The DateTime custom attribute type.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * UserPool.Builder.create(this, "myuserpool")
 *         // ...
 *         .standardAttributes(StandardAttributes.builder()
 *                 .fullname(StandardAttribute.builder()
 *                         .required(true)
 *                         .mutable(false)
 *                         .build())
 *                 .address(StandardAttribute.builder()
 *                         .required(false)
 *                         .mutable(true)
 *                         .build())
 *                 .build())
 *         .customAttributes(Map.of(
 *                 "myappid", StringAttribute.Builder.create().minLen(5).maxLen(15).mutable(false).build(),
 *                 "callingcode", NumberAttribute.Builder.create().min(1).max(3).mutable(true).build(),
 *                 "isEmployee", BooleanAttribute.Builder.create().mutable(true).build(),
 *                 "joinedOn", new DateTimeAttribute()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-23T02:06:30.090Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.DateTimeAttribute")
public class DateTimeAttribute extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.cognito.ICustomAttribute {

    protected DateTimeAttribute(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DateTimeAttribute(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public DateTimeAttribute(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.CustomAttributeProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { props });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public DateTimeAttribute() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Bind this custom attribute type to the values as expected by CloudFormation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.CustomAttributeConfig bind() {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.CustomAttributeConfig.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cognito.DateTimeAttribute}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cognito.DateTimeAttribute> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private software.amazon.awscdk.services.cognito.CustomAttributeProps.Builder props;

        private Builder() {
        }

        /**
         * Specifies whether the value of the attribute can be changed.
         * <p>
         * For any user pool attribute that's mapped to an identity provider attribute, you must set this parameter to true.
         * Amazon Cognito updates mapped attributes when users sign in to your application through an identity provider.
         * If an attribute is immutable, Amazon Cognito throws an error when it attempts to update the attribute.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param mutable Specifies whether the value of the attribute can be changed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mutable(final java.lang.Boolean mutable) {
            this.props().mutable(mutable);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.cognito.DateTimeAttribute}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cognito.DateTimeAttribute build() {
            return new software.amazon.awscdk.services.cognito.DateTimeAttribute(
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.cognito.CustomAttributeProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.cognito.CustomAttributeProps.Builder();
            }
            return this.props;
        }
    }
}
