package software.amazon.awscdk.services.customerprofiles;

/**
 * Properties for defining a <code>CfnIntegration</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.customerprofiles.*;
 * CfnIntegrationProps cfnIntegrationProps = CfnIntegrationProps.builder()
 *         .domainName("domainName")
 *         // the properties below are optional
 *         .flowDefinition(FlowDefinitionProperty.builder()
 *                 .flowName("flowName")
 *                 .kmsArn("kmsArn")
 *                 .sourceFlowConfig(SourceFlowConfigProperty.builder()
 *                         .connectorType("connectorType")
 *                         .sourceConnectorProperties(SourceConnectorPropertiesProperty.builder()
 *                                 .marketo(MarketoSourcePropertiesProperty.builder()
 *                                         .object("object")
 *                                         .build())
 *                                 .s3(S3SourcePropertiesProperty.builder()
 *                                         .bucketName("bucketName")
 *                                         // the properties below are optional
 *                                         .bucketPrefix("bucketPrefix")
 *                                         .build())
 *                                 .salesforce(SalesforceSourcePropertiesProperty.builder()
 *                                         .object("object")
 *                                         // the properties below are optional
 *                                         .enableDynamicFieldUpdate(false)
 *                                         .includeDeletedRecords(false)
 *                                         .build())
 *                                 .serviceNow(ServiceNowSourcePropertiesProperty.builder()
 *                                         .object("object")
 *                                         .build())
 *                                 .zendesk(ZendeskSourcePropertiesProperty.builder()
 *                                         .object("object")
 *                                         .build())
 *                                 .build())
 *                         // the properties below are optional
 *                         .connectorProfileName("connectorProfileName")
 *                         .incrementalPullConfig(IncrementalPullConfigProperty.builder()
 *                                 .datetimeTypeFieldName("datetimeTypeFieldName")
 *                                 .build())
 *                         .build())
 *                 .tasks(List.of(TaskProperty.builder()
 *                         .sourceFields(List.of("sourceFields"))
 *                         .taskType("taskType")
 *                         // the properties below are optional
 *                         .connectorOperator(ConnectorOperatorProperty.builder()
 *                                 .marketo("marketo")
 *                                 .s3("s3")
 *                                 .salesforce("salesforce")
 *                                 .serviceNow("serviceNow")
 *                                 .zendesk("zendesk")
 *                                 .build())
 *                         .destinationField("destinationField")
 *                         .taskProperties(List.of(TaskPropertiesMapProperty.builder()
 *                                 .operatorPropertyKey("operatorPropertyKey")
 *                                 .property("property")
 *                                 .build()))
 *                         .build()))
 *                 .triggerConfig(TriggerConfigProperty.builder()
 *                         .triggerType("triggerType")
 *                         // the properties below are optional
 *                         .triggerProperties(TriggerPropertiesProperty.builder()
 *                                 .scheduled(ScheduledTriggerPropertiesProperty.builder()
 *                                         .scheduleExpression("scheduleExpression")
 *                                         // the properties below are optional
 *                                         .dataPullMode("dataPullMode")
 *                                         .firstExecutionFrom(123)
 *                                         .scheduleEndTime(123)
 *                                         .scheduleOffset(123)
 *                                         .scheduleStartTime(123)
 *                                         .timezone("timezone")
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 // the properties below are optional
 *                 .description("description")
 *                 .build())
 *         .objectTypeName("objectTypeName")
 *         .objectTypeNames(List.of(ObjectTypeMappingProperty.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .uri("uri")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-integration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-integration.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-23T02:06:30.409Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_customerprofiles.CfnIntegrationProps")
@software.amazon.jsii.Jsii.Proxy(CfnIntegrationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnIntegrationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The unique name of the domain.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-integration.html#cfn-customerprofiles-integration-domainname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-integration.html#cfn-customerprofiles-integration-domainname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDomainName();

    /**
     * The configuration that controls how Customer Profiles retrieves data from the source.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-integration.html#cfn-customerprofiles-integration-flowdefinition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-integration.html#cfn-customerprofiles-integration-flowdefinition</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getFlowDefinition() {
        return null;
    }

    /**
     * The name of the profile object type mapping to use.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-integration.html#cfn-customerprofiles-integration-objecttypename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-integration.html#cfn-customerprofiles-integration-objecttypename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getObjectTypeName() {
        return null;
    }

    /**
     * The object type mapping.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-integration.html#cfn-customerprofiles-integration-objecttypenames">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-integration.html#cfn-customerprofiles-integration-objecttypenames</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getObjectTypeNames() {
        return null;
    }

    /**
     * The tags used to organize, track, or control access for this resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-integration.html#cfn-customerprofiles-integration-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-integration.html#cfn-customerprofiles-integration-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The URI of the S3 bucket or any other type of data source.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-integration.html#cfn-customerprofiles-integration-uri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-integration.html#cfn-customerprofiles-integration-uri</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getUri() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnIntegrationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnIntegrationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnIntegrationProps> {
        java.lang.String domainName;
        java.lang.Object flowDefinition;
        java.lang.String objectTypeName;
        java.lang.Object objectTypeNames;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String uri;

        /**
         * Sets the value of {@link CfnIntegrationProps#getDomainName}
         * @param domainName The unique name of the domain. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(java.lang.String domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Sets the value of {@link CfnIntegrationProps#getFlowDefinition}
         * @param flowDefinition The configuration that controls how Customer Profiles retrieves data from the source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder flowDefinition(software.amazon.awscdk.IResolvable flowDefinition) {
            this.flowDefinition = flowDefinition;
            return this;
        }

        /**
         * Sets the value of {@link CfnIntegrationProps#getFlowDefinition}
         * @param flowDefinition The configuration that controls how Customer Profiles retrieves data from the source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder flowDefinition(software.amazon.awscdk.services.customerprofiles.CfnIntegration.FlowDefinitionProperty flowDefinition) {
            this.flowDefinition = flowDefinition;
            return this;
        }

        /**
         * Sets the value of {@link CfnIntegrationProps#getObjectTypeName}
         * @param objectTypeName The name of the profile object type mapping to use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder objectTypeName(java.lang.String objectTypeName) {
            this.objectTypeName = objectTypeName;
            return this;
        }

        /**
         * Sets the value of {@link CfnIntegrationProps#getObjectTypeNames}
         * @param objectTypeNames The object type mapping.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder objectTypeNames(software.amazon.awscdk.IResolvable objectTypeNames) {
            this.objectTypeNames = objectTypeNames;
            return this;
        }

        /**
         * Sets the value of {@link CfnIntegrationProps#getObjectTypeNames}
         * @param objectTypeNames The object type mapping.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder objectTypeNames(java.util.List<? extends java.lang.Object> objectTypeNames) {
            this.objectTypeNames = objectTypeNames;
            return this;
        }

        /**
         * Sets the value of {@link CfnIntegrationProps#getTags}
         * @param tags The tags used to organize, track, or control access for this resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnIntegrationProps#getUri}
         * @param uri The URI of the S3 bucket or any other type of data source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder uri(java.lang.String uri) {
            this.uri = uri;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnIntegrationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnIntegrationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnIntegrationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnIntegrationProps {
        private final java.lang.String domainName;
        private final java.lang.Object flowDefinition;
        private final java.lang.String objectTypeName;
        private final java.lang.Object objectTypeNames;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String uri;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.domainName = software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.flowDefinition = software.amazon.jsii.Kernel.get(this, "flowDefinition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.objectTypeName = software.amazon.jsii.Kernel.get(this, "objectTypeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.objectTypeNames = software.amazon.jsii.Kernel.get(this, "objectTypeNames", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.uri = software.amazon.jsii.Kernel.get(this, "uri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.domainName = java.util.Objects.requireNonNull(builder.domainName, "domainName is required");
            this.flowDefinition = builder.flowDefinition;
            this.objectTypeName = builder.objectTypeName;
            this.objectTypeNames = builder.objectTypeNames;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.uri = builder.uri;
        }

        @Override
        public final java.lang.String getDomainName() {
            return this.domainName;
        }

        @Override
        public final java.lang.Object getFlowDefinition() {
            return this.flowDefinition;
        }

        @Override
        public final java.lang.String getObjectTypeName() {
            return this.objectTypeName;
        }

        @Override
        public final java.lang.Object getObjectTypeNames() {
            return this.objectTypeNames;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getUri() {
            return this.uri;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("domainName", om.valueToTree(this.getDomainName()));
            if (this.getFlowDefinition() != null) {
                data.set("flowDefinition", om.valueToTree(this.getFlowDefinition()));
            }
            if (this.getObjectTypeName() != null) {
                data.set("objectTypeName", om.valueToTree(this.getObjectTypeName()));
            }
            if (this.getObjectTypeNames() != null) {
                data.set("objectTypeNames", om.valueToTree(this.getObjectTypeNames()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getUri() != null) {
                data.set("uri", om.valueToTree(this.getUri()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_customerprofiles.CfnIntegrationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnIntegrationProps.Jsii$Proxy that = (CfnIntegrationProps.Jsii$Proxy) o;

            if (!domainName.equals(that.domainName)) return false;
            if (this.flowDefinition != null ? !this.flowDefinition.equals(that.flowDefinition) : that.flowDefinition != null) return false;
            if (this.objectTypeName != null ? !this.objectTypeName.equals(that.objectTypeName) : that.objectTypeName != null) return false;
            if (this.objectTypeNames != null ? !this.objectTypeNames.equals(that.objectTypeNames) : that.objectTypeNames != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.uri != null ? this.uri.equals(that.uri) : that.uri == null;
        }

        @Override
        public final int hashCode() {
            int result = this.domainName.hashCode();
            result = 31 * result + (this.flowDefinition != null ? this.flowDefinition.hashCode() : 0);
            result = 31 * result + (this.objectTypeName != null ? this.objectTypeName.hashCode() : 0);
            result = 31 * result + (this.objectTypeNames != null ? this.objectTypeNames.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.uri != null ? this.uri.hashCode() : 0);
            return result;
        }
    }
}
