package software.amazon.awscdk.services.ec2;

/**
 * The types of IP addresses provisioned in the VPC.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc = Vpc.Builder.create(this, "TheVPC")
 *         .ipProtocol(IpProtocol.DUAL_STACK)
 *         .subnetConfiguration(List.of(SubnetConfiguration.builder()
 *                 // general properties
 *                 .name("Public")
 *                 .subnetType(SubnetType.PUBLIC)
 *                 .reserved(false)
 *                 // IPv4 specific properties
 *                 .mapPublicIpOnLaunch(true)
 *                 .cidrMask(24)
 *                 // new IPv6 specific property
 *                 .ipv6AssignAddressOnCreation(true)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-23T02:06:31.498Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.IpProtocol")
public enum IpProtocol {
    /**
     * The vpc will be configured with only IPv4 addresses.
     * <p>
     * This is the default protocol if unset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    IPV4_ONLY,
    /**
     * The vpc will have both IPv4 and IPv6 addresses.
     * <p>
     * Unless specified, public IPv4 addresses will not be auto assigned,
     * an egress only internet gateway (EIGW) will be created and configured,
     * and NATs and internet gateways (IGW) will be configured with IPv6 addresses.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DUAL_STACK,
}
