package software.amazon.awscdk.services.ec2;

/**
 * Properties for a NAT instance.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Configure the `natGatewayProvider` when defining a Vpc
 * NatInstanceProvider natGatewayProvider = NatProvider.instance(NatInstanceProps.builder()
 *         .instanceType(new InstanceType("t3.small"))
 *         .build());
 * Vpc vpc = Vpc.Builder.create(this, "MyVpc")
 *         .natGatewayProvider(natGatewayProvider)
 *         // The 'natGateways' parameter now controls the number of NAT instances
 *         .natGateways(2)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-23T02:06:31.531Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.NatInstanceProps")
@software.amazon.jsii.Jsii.Proxy(NatInstanceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface NatInstanceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Instance type of the NAT instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InstanceType getInstanceType();

    /**
     * Direction to allow all traffic through the NAT instance by default.
     * <p>
     * By default, inbound and outbound traffic is allowed.
     * <p>
     * If you set this to another value than INBOUND_AND_OUTBOUND, you must
     * configure the NAT instance's security groups in another way, either by
     * passing in a fully configured Security Group using the <code>securityGroup</code>
     * property, or by configuring it using the <code>.securityGroup</code> or
     * <code>.connections</code> members after passing the NAT Instance Provider to a Vpc.
     * <p>
     * Default: NatTrafficDirection.INBOUND_AND_OUTBOUND
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.NatTrafficDirection getDefaultAllowedTraffic() {
        return null;
    }

    /**
     * (deprecated) Name of SSH keypair to grant access to instance.
     * <p>
     * Default: - No SSH access will be possible.
     * <p>
     * @deprecated <ul>
     * <li>Use <code>keyPair</code> instead - https://docs.aws.amazon.com/cdk/api/v2/docs/aws-cdk-lib.aws_ec2-readme.html#using-an-existing-ec2-key-pair</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.lang.String getKeyName() {
        return null;
    }

    /**
     * The SSH keypair to grant access to the instance.
     * <p>
     * Default: - No SSH access will be possible.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IKeyPair getKeyPair() {
        return null;
    }

    /**
     * The machine image (AMI) to use.
     * <p>
     * By default, will do an AMI lookup for the latest NAT instance image.
     * <p>
     * If you have a specific AMI ID you want to use, pass a <code>GenericLinuxImage</code>. For example:
     * <p>
     * <blockquote><pre>
     * NatProvider.instance(NatInstanceProps.builder()
     *         .instanceType(new InstanceType("t3.micro"))
     *         .machineImage(new GenericLinuxImage(Map.of(
     *                 "us-east-2", "ami-0f9c61b5a562a16af")))
     *         .build());
     * </pre></blockquote>
     * <p>
     * Default: - Latest NAT instance image
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IMachineImage getMachineImage() {
        return null;
    }

    /**
     * Security Group for NAT instances.
     * <p>
     * Default: - A new security group will be created
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link NatInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link NatInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<NatInstanceProps> {
        software.amazon.awscdk.services.ec2.InstanceType instanceType;
        software.amazon.awscdk.services.ec2.NatTrafficDirection defaultAllowedTraffic;
        java.lang.String keyName;
        software.amazon.awscdk.services.ec2.IKeyPair keyPair;
        software.amazon.awscdk.services.ec2.IMachineImage machineImage;
        software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;

        /**
         * Sets the value of {@link NatInstanceProps#getInstanceType}
         * @param instanceType Instance type of the NAT instance. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceType(software.amazon.awscdk.services.ec2.InstanceType instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        /**
         * Sets the value of {@link NatInstanceProps#getDefaultAllowedTraffic}
         * @param defaultAllowedTraffic Direction to allow all traffic through the NAT instance by default.
         *                              By default, inbound and outbound traffic is allowed.
         *                              <p>
         *                              If you set this to another value than INBOUND_AND_OUTBOUND, you must
         *                              configure the NAT instance's security groups in another way, either by
         *                              passing in a fully configured Security Group using the <code>securityGroup</code>
         *                              property, or by configuring it using the <code>.securityGroup</code> or
         *                              <code>.connections</code> members after passing the NAT Instance Provider to a Vpc.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultAllowedTraffic(software.amazon.awscdk.services.ec2.NatTrafficDirection defaultAllowedTraffic) {
            this.defaultAllowedTraffic = defaultAllowedTraffic;
            return this;
        }

        /**
         * Sets the value of {@link NatInstanceProps#getKeyName}
         * @param keyName Name of SSH keypair to grant access to instance.
         * @return {@code this}
         * @deprecated - Use `keyPair` instead - https://docs.aws.amazon.com/cdk/api/v2/docs/aws-cdk-lib.aws_ec2-readme.html#using-an-existing-ec2-key-pair
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder keyName(java.lang.String keyName) {
            this.keyName = keyName;
            return this;
        }

        /**
         * Sets the value of {@link NatInstanceProps#getKeyPair}
         * @param keyPair The SSH keypair to grant access to the instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyPair(software.amazon.awscdk.services.ec2.IKeyPair keyPair) {
            this.keyPair = keyPair;
            return this;
        }

        /**
         * Sets the value of {@link NatInstanceProps#getMachineImage}
         * @param machineImage The machine image (AMI) to use.
         *                     By default, will do an AMI lookup for the latest NAT instance image.
         *                     <p>
         *                     If you have a specific AMI ID you want to use, pass a <code>GenericLinuxImage</code>. For example:
         *                     <p>
         *                     <blockquote><pre>
         *                     NatProvider.instance(NatInstanceProps.builder()
         *                             .instanceType(new InstanceType("t3.micro"))
         *                             .machineImage(new GenericLinuxImage(Map.of(
         *                                     "us-east-2", "ami-0f9c61b5a562a16af")))
         *                             .build());
         *                     </pre></blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder machineImage(software.amazon.awscdk.services.ec2.IMachineImage machineImage) {
            this.machineImage = machineImage;
            return this;
        }

        /**
         * Sets the value of {@link NatInstanceProps#getSecurityGroup}
         * @param securityGroup Security Group for NAT instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroup(software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
            this.securityGroup = securityGroup;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link NatInstanceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public NatInstanceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link NatInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NatInstanceProps {
        private final software.amazon.awscdk.services.ec2.InstanceType instanceType;
        private final software.amazon.awscdk.services.ec2.NatTrafficDirection defaultAllowedTraffic;
        private final java.lang.String keyName;
        private final software.amazon.awscdk.services.ec2.IKeyPair keyPair;
        private final software.amazon.awscdk.services.ec2.IMachineImage machineImage;
        private final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InstanceType.class));
            this.defaultAllowedTraffic = software.amazon.jsii.Kernel.get(this, "defaultAllowedTraffic", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.NatTrafficDirection.class));
            this.keyName = software.amazon.jsii.Kernel.get(this, "keyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.keyPair = software.amazon.jsii.Kernel.get(this, "keyPair", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IKeyPair.class));
            this.machineImage = software.amazon.jsii.Kernel.get(this, "machineImage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IMachineImage.class));
            this.securityGroup = software.amazon.jsii.Kernel.get(this, "securityGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.instanceType = java.util.Objects.requireNonNull(builder.instanceType, "instanceType is required");
            this.defaultAllowedTraffic = builder.defaultAllowedTraffic;
            this.keyName = builder.keyName;
            this.keyPair = builder.keyPair;
            this.machineImage = builder.machineImage;
            this.securityGroup = builder.securityGroup;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.InstanceType getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.NatTrafficDirection getDefaultAllowedTraffic() {
            return this.defaultAllowedTraffic;
        }

        @Override
        public final java.lang.String getKeyName() {
            return this.keyName;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IKeyPair getKeyPair() {
            return this.keyPair;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IMachineImage getMachineImage() {
            return this.machineImage;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
            return this.securityGroup;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("instanceType", om.valueToTree(this.getInstanceType()));
            if (this.getDefaultAllowedTraffic() != null) {
                data.set("defaultAllowedTraffic", om.valueToTree(this.getDefaultAllowedTraffic()));
            }
            if (this.getKeyName() != null) {
                data.set("keyName", om.valueToTree(this.getKeyName()));
            }
            if (this.getKeyPair() != null) {
                data.set("keyPair", om.valueToTree(this.getKeyPair()));
            }
            if (this.getMachineImage() != null) {
                data.set("machineImage", om.valueToTree(this.getMachineImage()));
            }
            if (this.getSecurityGroup() != null) {
                data.set("securityGroup", om.valueToTree(this.getSecurityGroup()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.NatInstanceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            NatInstanceProps.Jsii$Proxy that = (NatInstanceProps.Jsii$Proxy) o;

            if (!instanceType.equals(that.instanceType)) return false;
            if (this.defaultAllowedTraffic != null ? !this.defaultAllowedTraffic.equals(that.defaultAllowedTraffic) : that.defaultAllowedTraffic != null) return false;
            if (this.keyName != null ? !this.keyName.equals(that.keyName) : that.keyName != null) return false;
            if (this.keyPair != null ? !this.keyPair.equals(that.keyPair) : that.keyPair != null) return false;
            if (this.machineImage != null ? !this.machineImage.equals(that.machineImage) : that.machineImage != null) return false;
            return this.securityGroup != null ? this.securityGroup.equals(that.securityGroup) : that.securityGroup == null;
        }

        @Override
        public final int hashCode() {
            int result = this.instanceType.hashCode();
            result = 31 * result + (this.defaultAllowedTraffic != null ? this.defaultAllowedTraffic.hashCode() : 0);
            result = 31 * result + (this.keyName != null ? this.keyName.hashCode() : 0);
            result = 31 * result + (this.keyPair != null ? this.keyPair.hashCode() : 0);
            result = 31 * result + (this.machineImage != null ? this.machineImage.hashCode() : 0);
            result = 31 * result + (this.securityGroup != null ? this.securityGroup.hashCode() : 0);
            return result;
        }
    }
}
