package software.amazon.awscdk.services.ec2;

/**
 * Select the image based on a given SSM parameter at instance launch time.
 * <p>
 * This Machine Image comes with an imageId as <code>resolve:ssm:parameter-name</code> or <code>resolve:ssm:parameter-name:version</code> format
 * as described in the document:
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * UserData userData;
 * ResolveSsmParameterAtLaunchImage resolveSsmParameterAtLaunchImage = ResolveSsmParameterAtLaunchImage.Builder.create("parameterName")
 *         .cachedInContext(false)
 *         .os(OperatingSystemType.LINUX)
 *         .parameterVersion("parameterVersion")
 *         .userData(userData)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/using-systems-manager-parameters.html
 * The AMI ID would be selected at instance launch time.">https://docs.aws.amazon.com/autoscaling/ec2/userguide/using-systems-manager-parameters.html
 * The AMI ID would be selected at instance launch time.</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-23T02:06:31.546Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.ResolveSsmParameterAtLaunchImage")
public class ResolveSsmParameterAtLaunchImage extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.IMachineImage {

    protected ResolveSsmParameterAtLaunchImage(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ResolveSsmParameterAtLaunchImage(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param parameterName This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ResolveSsmParameterAtLaunchImage(final @org.jetbrains.annotations.NotNull java.lang.String parameterName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SsmParameterImageOptions props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(parameterName, "parameterName is required"), props });
    }

    /**
     * @param parameterName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ResolveSsmParameterAtLaunchImage(final @org.jetbrains.annotations.NotNull java.lang.String parameterName) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(parameterName, "parameterName is required") });
    }

    /**
     * Return the image to use in the given context.
     * <p>
     * @param _ This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.MachineImageConfig getImage(final @org.jetbrains.annotations.NotNull software.constructs.Construct __) {
        return software.amazon.jsii.Kernel.call(this, "getImage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.MachineImageConfig.class), new Object[] { java.util.Objects.requireNonNull(__, "__ is required") });
    }

    /**
     * Name of the SSM parameter we're looking up.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getParameterName() {
        return software.amazon.jsii.Kernel.get(this, "parameterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.ResolveSsmParameterAtLaunchImage}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.ResolveSsmParameterAtLaunchImage> {
        /**
         * @return a new instance of {@link Builder}.
         * @param parameterName This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final java.lang.String parameterName) {
            return new Builder(parameterName);
        }

        private final java.lang.String parameterName;
        private software.amazon.awscdk.services.ec2.SsmParameterImageOptions.Builder props;

        private Builder(final java.lang.String parameterName) {
            this.parameterName = parameterName;
        }

        /**
         * Whether the AMI ID is cached to be stable between deployments.
         * <p>
         * By default, the newest image is used on each deployment. This will cause
         * instances to be replaced whenever a new version is released, and may cause
         * downtime if there aren't enough running instances in the AutoScalingGroup
         * to reschedule the tasks on.
         * <p>
         * If set to true, the AMI ID will be cached in <code>cdk.context.json</code> and the
         * same value will be used on future runs. Your instances will not be replaced
         * but your AMI version will grow old over time. To refresh the AMI lookup,
         * you will have to evict the value from the cache using the <code>cdk context</code>
         * command. See https://docs.aws.amazon.com/cdk/latest/guide/context.html for
         * more information.
         * <p>
         * Can not be set to <code>true</code> in environment-agnostic stacks.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param cachedInContext Whether the AMI ID is cached to be stable between deployments. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cachedInContext(final java.lang.Boolean cachedInContext) {
            this.props().cachedInContext(cachedInContext);
            return this;
        }

        /**
         * Operating system.
         * <p>
         * Default: OperatingSystemType.LINUX
         * <p>
         * @return {@code this}
         * @param os Operating system. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder os(final software.amazon.awscdk.services.ec2.OperatingSystemType os) {
            this.props().os(os);
            return this;
        }

        /**
         * The version of the SSM parameter.
         * <p>
         * Default: no version specified.
         * <p>
         * @return {@code this}
         * @param parameterVersion The version of the SSM parameter. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameterVersion(final java.lang.String parameterVersion) {
            this.props().parameterVersion(parameterVersion);
            return this;
        }

        /**
         * Custom UserData.
         * <p>
         * Default: - UserData appropriate for the OS
         * <p>
         * @return {@code this}
         * @param userData Custom UserData. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userData(final software.amazon.awscdk.services.ec2.UserData userData) {
            this.props().userData(userData);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ec2.ResolveSsmParameterAtLaunchImage}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ec2.ResolveSsmParameterAtLaunchImage build() {
            return new software.amazon.awscdk.services.ec2.ResolveSsmParameterAtLaunchImage(
                this.parameterName,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.ec2.SsmParameterImageOptions.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.ec2.SsmParameterImageOptions.Builder();
            }
            return this.props;
        }
    }
}
