package software.amazon.awscdk.services.ecs;

/**
 * The details of a task definition run on a Fargate cluster.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * Cluster cluster = Cluster.Builder.create(this, "FargateCPCluster")
 *         .vpc(vpc)
 *         .enableFargateCapacityProviders(true)
 *         .build();
 * FargateTaskDefinition taskDefinition = new FargateTaskDefinition(this, "TaskDef");
 * taskDefinition.addContainer("web", ContainerDefinitionOptions.builder()
 *         .image(ContainerImage.fromRegistry("amazon/amazon-ecs-sample"))
 *         .build());
 * FargateService.Builder.create(this, "FargateService")
 *         .cluster(cluster)
 *         .taskDefinition(taskDefinition)
 *         .capacityProviderStrategies(List.of(CapacityProviderStrategy.builder()
 *                 .capacityProvider("FARGATE_SPOT")
 *                 .weight(2)
 *                 .build(), CapacityProviderStrategy.builder()
 *                 .capacityProvider("FARGATE")
 *                 .weight(1)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-23T02:06:31.876Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.FargateTaskDefinition")
public class FargateTaskDefinition extends software.amazon.awscdk.services.ecs.TaskDefinition implements software.amazon.awscdk.services.ecs.IFargateTaskDefinition {

    protected FargateTaskDefinition(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected FargateTaskDefinition(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Constructs a new instance of the FargateTaskDefinition class.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public FargateTaskDefinition(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.FargateTaskDefinitionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Constructs a new instance of the FargateTaskDefinition class.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public FargateTaskDefinition(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Imports a task definition from the specified task definition ARN.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param fargateTaskDefinitionArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.IFargateTaskDefinition fromFargateTaskDefinitionArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String fargateTaskDefinitionArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.FargateTaskDefinition.class, "fromFargateTaskDefinitionArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.IFargateTaskDefinition.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(fargateTaskDefinitionArn, "fargateTaskDefinitionArn is required") });
    }

    /**
     * Import an existing Fargate task definition from its attributes.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.IFargateTaskDefinition fromFargateTaskDefinitionAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.FargateTaskDefinitionAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.FargateTaskDefinition.class, "fromFargateTaskDefinitionAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.IFargateTaskDefinition.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * The Docker networking mode to use for the containers in the task.
     * <p>
     * Fargate tasks require the awsvpc network mode.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.NetworkMode getNetworkMode() {
        return software.amazon.jsii.Kernel.get(this, "networkMode", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.NetworkMode.class));
    }

    /**
     * The amount (in GiB) of ephemeral storage to be allocated to the task.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getEphemeralStorageGiB() {
        return software.amazon.jsii.Kernel.get(this, "ephemeralStorageGiB", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ecs.FargateTaskDefinition}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ecs.FargateTaskDefinition> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.ecs.FargateTaskDefinitionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The name of the IAM task execution role that grants the ECS agent permission to call AWS APIs on your behalf.
         * <p>
         * The role will be used to retrieve container images from ECR and create CloudWatch log groups.
         * <p>
         * Default: - An execution role will be automatically created if you use ECR images in your task definition.
         * <p>
         * @return {@code this}
         * @param executionRole The name of the IAM task execution role that grants the ECS agent permission to call AWS APIs on your behalf. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionRole(final software.amazon.awscdk.services.iam.IRole executionRole) {
            this.props().executionRole(executionRole);
            return this;
        }

        /**
         * The name of a family that this task definition is registered to.
         * <p>
         * A family groups multiple versions of a task definition.
         * <p>
         * Default: - Automatically generated name.
         * <p>
         * @return {@code this}
         * @param family The name of a family that this task definition is registered to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder family(final java.lang.String family) {
            this.props().family(family);
            return this;
        }

        /**
         * The configuration details for the App Mesh proxy.
         * <p>
         * Default: - No proxy configuration.
         * <p>
         * @return {@code this}
         * @param proxyConfiguration The configuration details for the App Mesh proxy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder proxyConfiguration(final software.amazon.awscdk.services.ecs.ProxyConfiguration proxyConfiguration) {
            this.props().proxyConfiguration(proxyConfiguration);
            return this;
        }

        /**
         * The name of the IAM role that grants containers in the task permission to call AWS APIs on your behalf.
         * <p>
         * Default: - A task role is automatically created for you.
         * <p>
         * @return {@code this}
         * @param taskRole The name of the IAM role that grants containers in the task permission to call AWS APIs on your behalf. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskRole(final software.amazon.awscdk.services.iam.IRole taskRole) {
            this.props().taskRole(taskRole);
            return this;
        }

        /**
         * The list of volume definitions for the task.
         * <p>
         * For more information, see
         * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide//task_definition_parameters.html#volumes">Task Definition Parameter Volumes</a>.
         * <p>
         * Default: - No volumes are passed to the Docker daemon on a container instance.
         * <p>
         * @return {@code this}
         * @param volumes The list of volume definitions for the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumes(final java.util.List<? extends software.amazon.awscdk.services.ecs.Volume> volumes) {
            this.props().volumes(volumes);
            return this;
        }

        /**
         * The number of cpu units used by the task.
         * <p>
         * For tasks using the Fargate launch type,
         * this field is required and you must use one of the following values,
         * which determines your range of valid values for the memory parameter:
         * <p>
         * 256 (.25 vCPU) - Available memory values: 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB)
         * <p>
         * 512 (.5 vCPU) - Available memory values: 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB)
         * <p>
         * 1024 (1 vCPU) - Available memory values: 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB)
         * <p>
         * 2048 (2 vCPU) - Available memory values: Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB)
         * <p>
         * 4096 (4 vCPU) - Available memory values: Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB)
         * <p>
         * 8192 (8 vCPU) - Available memory values: Between 16384 (16 GB) and 61440 (60 GB) in increments of 4096 (4 GB)
         * <p>
         * 16384 (16 vCPU) - Available memory values: Between 32768 (32 GB) and 122880 (120 GB) in increments of 8192 (8 GB)
         * <p>
         * Default: 256
         * <p>
         * @return {@code this}
         * @param cpu The number of cpu units used by the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cpu(final java.lang.Number cpu) {
            this.props().cpu(cpu);
            return this;
        }

        /**
         * The amount (in GiB) of ephemeral storage to be allocated to the task.
         * <p>
         * The maximum supported value is 200 GiB.
         * <p>
         * NOTE: This parameter is only supported for tasks hosted on AWS Fargate using platform version 1.4.0 or later.
         * <p>
         * Default: 20
         * <p>
         * @return {@code this}
         * @param ephemeralStorageGiB The amount (in GiB) of ephemeral storage to be allocated to the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ephemeralStorageGiB(final java.lang.Number ephemeralStorageGiB) {
            this.props().ephemeralStorageGiB(ephemeralStorageGiB);
            return this;
        }

        /**
         * The amount (in MiB) of memory used by the task.
         * <p>
         * For tasks using the Fargate launch type,
         * this field is required and you must use one of the following values, which determines your range of valid values for the cpu parameter:
         * <p>
         * 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available cpu values: 256 (.25 vCPU)
         * <p>
         * 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available cpu values: 512 (.5 vCPU)
         * <p>
         * 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB) - Available cpu values: 1024 (1 vCPU)
         * <p>
         * Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) - Available cpu values: 2048 (2 vCPU)
         * <p>
         * Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) - Available cpu values: 4096 (4 vCPU)
         * <p>
         * Between 16384 (16 GB) and 61440 (60 GB) in increments of 4096 (4 GB) - Available cpu values: 8192 (8 vCPU)
         * <p>
         * Between 32768 (32 GB) and 122880 (120 GB) in increments of 8192 (8 GB) - Available cpu values: 16384 (16 vCPU)
         * <p>
         * Default: 512
         * <p>
         * @return {@code this}
         * @param memoryLimitMiB The amount (in MiB) of memory used by the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memoryLimitMiB(final java.lang.Number memoryLimitMiB) {
            this.props().memoryLimitMiB(memoryLimitMiB);
            return this;
        }

        /**
         * The operating system that your task definitions are running on.
         * <p>
         * A runtimePlatform is supported only for tasks using the Fargate launch type.
         * <p>
         * Default: - Undefined.
         * <p>
         * @return {@code this}
         * @param runtimePlatform The operating system that your task definitions are running on. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runtimePlatform(final software.amazon.awscdk.services.ecs.RuntimePlatform runtimePlatform) {
            this.props().runtimePlatform(runtimePlatform);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ecs.FargateTaskDefinition}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ecs.FargateTaskDefinition build() {
            return new software.amazon.awscdk.services.ecs.FargateTaskDefinition(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.ecs.FargateTaskDefinitionProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.ecs.FargateTaskDefinitionProps.Builder();
            }
            return this.props;
        }
    }
}
