package software.amazon.awscdk.services.kms;

/**
 * The key usage, represents the cryptographic operations of keys.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Key key = Key.Builder.create(this, "MyKey")
 *         .keySpec(KeySpec.ECC_SECG_P256K1) // Default to SYMMETRIC_DEFAULT
 *         .keyUsage(KeyUsage.SIGN_VERIFY)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-23T02:06:34.362Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kms.KeyUsage")
public enum KeyUsage {
    /**
     * Encryption and decryption.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ENCRYPT_DECRYPT,
    /**
     * Signing and verification.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SIGN_VERIFY,
    /**
     * Generating and verifying MACs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GENERATE_VERIFY_MAC,
}
