package software.amazon.awscdk.services.lambda;

/**
 * Represents a permission statement that can be added to a Lambda function's resource policy via the <code>addPermission()</code> method.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Grant permissions to a service
 * Function fn;
 * ServicePrincipal principal = new ServicePrincipal("my-service");
 * fn.grantInvoke(principal);
 * // Equivalent to:
 * fn.addPermission("my-service Invocation", Permission.builder()
 *         .principal(principal)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-23T02:06:34.582Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.Permission")
@software.amazon.jsii.Jsii.Proxy(Permission.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface Permission extends software.amazon.jsii.JsiiSerializable {

    /**
     * The entity for which you are granting permission to invoke the Lambda function.
     * <p>
     * This entity can be any of the following:
     * <p>
     * <ul>
     * <li>a valid AWS service principal, such as <code>s3.amazonaws.com</code> or <code>sns.amazonaws.com</code></li>
     * <li>an AWS account ID for cross-account permissions. For example, you might want
     * to allow a custom application in another AWS account to push events to
     * Lambda by invoking your function.</li>
     * <li>an AWS organization principal to grant permissions to an entire organization.</li>
     * </ul>
     * <p>
     * The principal can be an AccountPrincipal, an ArnPrincipal, a ServicePrincipal,
     * or an OrganizationPrincipal.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal getPrincipal();

    /**
     * The Lambda actions that you want to allow in this statement.
     * <p>
     * For example,
     * you can specify lambda:CreateFunction to specify a certain action, or use
     * a wildcard (<code>lambda:*</code>) to grant permission to all Lambda actions. For a
     * list of actions, see Actions and Condition Context Keys for AWS Lambda in
     * the IAM User Guide.
     * <p>
     * Default: 'lambda:InvokeFunction'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAction() {
        return null;
    }

    /**
     * A unique token that must be supplied by the principal invoking the function.
     * <p>
     * Default: - The caller would not need to present a token.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEventSourceToken() {
        return null;
    }

    /**
     * The authType for the function URL that you are granting permissions for.
     * <p>
     * Default: - No functionUrlAuthType
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.FunctionUrlAuthType getFunctionUrlAuthType() {
        return null;
    }

    /**
     * The organization you want to grant permissions to.
     * <p>
     * Use this ONLY if you
     * need to grant permissions to a subset of the organization. If you want to
     * grant permissions to the entire organization, sending the organization principal
     * through the <code>principal</code> property will suffice.
     * <p>
     * You can use this property to ensure that all source principals are owned by
     * a specific organization.
     * <p>
     * Default: - No organizationId
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getOrganizationId() {
        return null;
    }

    /**
     * The scope to which the permission constructs be attached.
     * <p>
     * The default is
     * the Lambda function construct itself, but this would need to be different
     * in cases such as cross-stack references where the Permissions would need
     * to sit closer to the consumer of this permission (i.e., the caller).
     * <p>
     * Default: - The instance of lambda.IFunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.constructs.Construct getScope() {
        return null;
    }

    /**
     * The AWS account ID (without hyphens) of the source owner.
     * <p>
     * For example, if
     * you specify an S3 bucket in the SourceArn property, this value is the
     * bucket owner's account ID. You can use this property to ensure that all
     * source principals are owned by a specific account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSourceAccount() {
        return null;
    }

    /**
     * The ARN of a resource that is invoking your function.
     * <p>
     * When granting
     * Amazon Simple Storage Service (Amazon S3) permission to invoke your
     * function, specify this property with the bucket ARN as its value. This
     * ensures that events generated only from the specified bucket, not just
     * any bucket from any AWS account that creates a mapping to your function,
     * can invoke the function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSourceArn() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link Permission}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link Permission}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<Permission> {
        software.amazon.awscdk.services.iam.IPrincipal principal;
        java.lang.String action;
        java.lang.String eventSourceToken;
        software.amazon.awscdk.services.lambda.FunctionUrlAuthType functionUrlAuthType;
        java.lang.String organizationId;
        software.constructs.Construct scope;
        java.lang.String sourceAccount;
        java.lang.String sourceArn;

        /**
         * Sets the value of {@link Permission#getPrincipal}
         * @param principal The entity for which you are granting permission to invoke the Lambda function. This parameter is required.
         *                  This entity can be any of the following:
         *                  <p>
         *                  <ul>
         *                  <li>a valid AWS service principal, such as <code>s3.amazonaws.com</code> or <code>sns.amazonaws.com</code></li>
         *                  <li>an AWS account ID for cross-account permissions. For example, you might want
         *                  to allow a custom application in another AWS account to push events to
         *                  Lambda by invoking your function.</li>
         *                  <li>an AWS organization principal to grant permissions to an entire organization.</li>
         *                  </ul>
         *                  <p>
         *                  The principal can be an AccountPrincipal, an ArnPrincipal, a ServicePrincipal,
         *                  or an OrganizationPrincipal.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder principal(software.amazon.awscdk.services.iam.IPrincipal principal) {
            this.principal = principal;
            return this;
        }

        /**
         * Sets the value of {@link Permission#getAction}
         * @param action The Lambda actions that you want to allow in this statement.
         *               For example,
         *               you can specify lambda:CreateFunction to specify a certain action, or use
         *               a wildcard (<code>lambda:*</code>) to grant permission to all Lambda actions. For a
         *               list of actions, see Actions and Condition Context Keys for AWS Lambda in
         *               the IAM User Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder action(java.lang.String action) {
            this.action = action;
            return this;
        }

        /**
         * Sets the value of {@link Permission#getEventSourceToken}
         * @param eventSourceToken A unique token that must be supplied by the principal invoking the function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventSourceToken(java.lang.String eventSourceToken) {
            this.eventSourceToken = eventSourceToken;
            return this;
        }

        /**
         * Sets the value of {@link Permission#getFunctionUrlAuthType}
         * @param functionUrlAuthType The authType for the function URL that you are granting permissions for.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder functionUrlAuthType(software.amazon.awscdk.services.lambda.FunctionUrlAuthType functionUrlAuthType) {
            this.functionUrlAuthType = functionUrlAuthType;
            return this;
        }

        /**
         * Sets the value of {@link Permission#getOrganizationId}
         * @param organizationId The organization you want to grant permissions to.
         *                       Use this ONLY if you
         *                       need to grant permissions to a subset of the organization. If you want to
         *                       grant permissions to the entire organization, sending the organization principal
         *                       through the <code>principal</code> property will suffice.
         *                       <p>
         *                       You can use this property to ensure that all source principals are owned by
         *                       a specific organization.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder organizationId(java.lang.String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        /**
         * Sets the value of {@link Permission#getScope}
         * @param scope The scope to which the permission constructs be attached.
         *              The default is
         *              the Lambda function construct itself, but this would need to be different
         *              in cases such as cross-stack references where the Permissions would need
         *              to sit closer to the consumer of this permission (i.e., the caller).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scope(software.constructs.Construct scope) {
            this.scope = scope;
            return this;
        }

        /**
         * Sets the value of {@link Permission#getSourceAccount}
         * @param sourceAccount The AWS account ID (without hyphens) of the source owner.
         *                      For example, if
         *                      you specify an S3 bucket in the SourceArn property, this value is the
         *                      bucket owner's account ID. You can use this property to ensure that all
         *                      source principals are owned by a specific account.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceAccount(java.lang.String sourceAccount) {
            this.sourceAccount = sourceAccount;
            return this;
        }

        /**
         * Sets the value of {@link Permission#getSourceArn}
         * @param sourceArn The ARN of a resource that is invoking your function.
         *                  When granting
         *                  Amazon Simple Storage Service (Amazon S3) permission to invoke your
         *                  function, specify this property with the bucket ARN as its value. This
         *                  ensures that events generated only from the specified bucket, not just
         *                  any bucket from any AWS account that creates a mapping to your function,
         *                  can invoke the function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceArn(java.lang.String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link Permission}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public Permission build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link Permission}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements Permission {
        private final software.amazon.awscdk.services.iam.IPrincipal principal;
        private final java.lang.String action;
        private final java.lang.String eventSourceToken;
        private final software.amazon.awscdk.services.lambda.FunctionUrlAuthType functionUrlAuthType;
        private final java.lang.String organizationId;
        private final software.constructs.Construct scope;
        private final java.lang.String sourceAccount;
        private final java.lang.String sourceArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.principal = software.amazon.jsii.Kernel.get(this, "principal", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IPrincipal.class));
            this.action = software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.eventSourceToken = software.amazon.jsii.Kernel.get(this, "eventSourceToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.functionUrlAuthType = software.amazon.jsii.Kernel.get(this, "functionUrlAuthType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.FunctionUrlAuthType.class));
            this.organizationId = software.amazon.jsii.Kernel.get(this, "organizationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.scope = software.amazon.jsii.Kernel.get(this, "scope", software.amazon.jsii.NativeType.forClass(software.constructs.Construct.class));
            this.sourceAccount = software.amazon.jsii.Kernel.get(this, "sourceAccount", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sourceArn = software.amazon.jsii.Kernel.get(this, "sourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.principal = java.util.Objects.requireNonNull(builder.principal, "principal is required");
            this.action = builder.action;
            this.eventSourceToken = builder.eventSourceToken;
            this.functionUrlAuthType = builder.functionUrlAuthType;
            this.organizationId = builder.organizationId;
            this.scope = builder.scope;
            this.sourceAccount = builder.sourceAccount;
            this.sourceArn = builder.sourceArn;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IPrincipal getPrincipal() {
            return this.principal;
        }

        @Override
        public final java.lang.String getAction() {
            return this.action;
        }

        @Override
        public final java.lang.String getEventSourceToken() {
            return this.eventSourceToken;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.FunctionUrlAuthType getFunctionUrlAuthType() {
            return this.functionUrlAuthType;
        }

        @Override
        public final java.lang.String getOrganizationId() {
            return this.organizationId;
        }

        @Override
        public final software.constructs.Construct getScope() {
            return this.scope;
        }

        @Override
        public final java.lang.String getSourceAccount() {
            return this.sourceAccount;
        }

        @Override
        public final java.lang.String getSourceArn() {
            return this.sourceArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("principal", om.valueToTree(this.getPrincipal()));
            if (this.getAction() != null) {
                data.set("action", om.valueToTree(this.getAction()));
            }
            if (this.getEventSourceToken() != null) {
                data.set("eventSourceToken", om.valueToTree(this.getEventSourceToken()));
            }
            if (this.getFunctionUrlAuthType() != null) {
                data.set("functionUrlAuthType", om.valueToTree(this.getFunctionUrlAuthType()));
            }
            if (this.getOrganizationId() != null) {
                data.set("organizationId", om.valueToTree(this.getOrganizationId()));
            }
            if (this.getScope() != null) {
                data.set("scope", om.valueToTree(this.getScope()));
            }
            if (this.getSourceAccount() != null) {
                data.set("sourceAccount", om.valueToTree(this.getSourceAccount()));
            }
            if (this.getSourceArn() != null) {
                data.set("sourceArn", om.valueToTree(this.getSourceArn()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lambda.Permission"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            Permission.Jsii$Proxy that = (Permission.Jsii$Proxy) o;

            if (!principal.equals(that.principal)) return false;
            if (this.action != null ? !this.action.equals(that.action) : that.action != null) return false;
            if (this.eventSourceToken != null ? !this.eventSourceToken.equals(that.eventSourceToken) : that.eventSourceToken != null) return false;
            if (this.functionUrlAuthType != null ? !this.functionUrlAuthType.equals(that.functionUrlAuthType) : that.functionUrlAuthType != null) return false;
            if (this.organizationId != null ? !this.organizationId.equals(that.organizationId) : that.organizationId != null) return false;
            if (this.scope != null ? !this.scope.equals(that.scope) : that.scope != null) return false;
            if (this.sourceAccount != null ? !this.sourceAccount.equals(that.sourceAccount) : that.sourceAccount != null) return false;
            return this.sourceArn != null ? this.sourceArn.equals(that.sourceArn) : that.sourceArn == null;
        }

        @Override
        public final int hashCode() {
            int result = this.principal.hashCode();
            result = 31 * result + (this.action != null ? this.action.hashCode() : 0);
            result = 31 * result + (this.eventSourceToken != null ? this.eventSourceToken.hashCode() : 0);
            result = 31 * result + (this.functionUrlAuthType != null ? this.functionUrlAuthType.hashCode() : 0);
            result = 31 * result + (this.organizationId != null ? this.organizationId.hashCode() : 0);
            result = 31 * result + (this.scope != null ? this.scope.hashCode() : 0);
            result = 31 * result + (this.sourceAccount != null ? this.sourceAccount.hashCode() : 0);
            result = 31 * result + (this.sourceArn != null ? this.sourceArn.hashCode() : 0);
            return result;
        }
    }
}
