package software.amazon.awscdk.services.location;

/**
 * The API key resource in your AWS account, which lets you grant actions for Amazon Location resources to the API key bearer.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.location.*;
 * CfnAPIKey cfnAPIKey = CfnAPIKey.Builder.create(this, "MyCfnAPIKey")
 *         .keyName("keyName")
 *         .restrictions(ApiKeyRestrictionsProperty.builder()
 *                 .allowActions(List.of("allowActions"))
 *                 .allowResources(List.of("allowResources"))
 *                 // the properties below are optional
 *                 .allowReferers(List.of("allowReferers"))
 *                 .build())
 *         // the properties below are optional
 *         .description("description")
 *         .expireTime("expireTime")
 *         .forceDelete(false)
 *         .forceUpdate(false)
 *         .noExpiry(false)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-apikey.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-apikey.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-23T02:06:34.823Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_location.CfnAPIKey")
public class CfnAPIKey extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnAPIKey(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnAPIKey(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.location.CfnAPIKey.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnAPIKey(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.location.CfnAPIKeyProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) for the resource.
     * <p>
     * Used when you need to specify a resource across all AWS .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The timestamp for when the API key resource was created in ISO 8601 format: YYYY-MM-DDThh:mm:ss.sssZ.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreateTime() {
        return software.amazon.jsii.Kernel.get(this, "attrCreateTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) for the API key resource.
     * <p>
     * Used when you need to specify a resource across all AWS .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrKeyArn() {
        return software.amazon.jsii.Kernel.get(this, "attrKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The timestamp for when the API key resource was last updated in ISO 8601 format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrUpdateTime() {
        return software.amazon.jsii.Kernel.get(this, "attrUpdateTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A custom name for the API key resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getKeyName() {
        return software.amazon.jsii.Kernel.get(this, "keyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A custom name for the API key resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKeyName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "keyName", java.util.Objects.requireNonNull(value, "keyName is required"));
    }

    /**
     * The API key restrictions for the API key resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getRestrictions() {
        return software.amazon.jsii.Kernel.get(this, "restrictions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The API key restrictions for the API key resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRestrictions(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "restrictions", java.util.Objects.requireNonNull(value, "restrictions is required"));
    }

    /**
     * The API key restrictions for the API key resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRestrictions(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.location.CfnAPIKey.ApiKeyRestrictionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "restrictions", java.util.Objects.requireNonNull(value, "restrictions is required"));
    }

    /**
     * Updates the description for the API key resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Updates the description for the API key resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The optional timestamp for when the API key resource will expire in <a href="https://docs.aws.amazon.com/https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601 format</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getExpireTime() {
        return software.amazon.jsii.Kernel.get(this, "expireTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The optional timestamp for when the API key resource will expire in <a href="https://docs.aws.amazon.com/https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601 format</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExpireTime(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "expireTime", value);
    }

    /**
     * ForceDelete bypasses an API key's expiry conditions and deletes the key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getForceDelete() {
        return software.amazon.jsii.Kernel.get(this, "forceDelete", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * ForceDelete bypasses an API key's expiry conditions and deletes the key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setForceDelete(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "forceDelete", value);
    }

    /**
     * ForceDelete bypasses an API key's expiry conditions and deletes the key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setForceDelete(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "forceDelete", value);
    }

    /**
     * The boolean flag to be included for updating <code>ExpireTime</code> or Restrictions details.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getForceUpdate() {
        return software.amazon.jsii.Kernel.get(this, "forceUpdate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The boolean flag to be included for updating <code>ExpireTime</code> or Restrictions details.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setForceUpdate(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "forceUpdate", value);
    }

    /**
     * The boolean flag to be included for updating <code>ExpireTime</code> or Restrictions details.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setForceUpdate(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "forceUpdate", value);
    }

    /**
     * Whether the API key should expire.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getNoExpiry() {
        return software.amazon.jsii.Kernel.get(this, "noExpiry", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Whether the API key should expire.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNoExpiry(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "noExpiry", value);
    }

    /**
     * Whether the API key should expire.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNoExpiry(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "noExpiry", value);
    }

    /**
     * Applies one or more tags to the map resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Applies one or more tags to the map resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * API Restrictions on the allowed actions, resources, and referers for an API key resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.location.*;
     * ApiKeyRestrictionsProperty apiKeyRestrictionsProperty = ApiKeyRestrictionsProperty.builder()
     *         .allowActions(List.of("allowActions"))
     *         .allowResources(List.of("allowResources"))
     *         // the properties below are optional
     *         .allowReferers(List.of("allowReferers"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-location-apikey-apikeyrestrictions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-location-apikey-apikeyrestrictions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_location.CfnAPIKey.ApiKeyRestrictionsProperty")
    @software.amazon.jsii.Jsii.Proxy(ApiKeyRestrictionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ApiKeyRestrictionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of allowed actions that an API key resource grants permissions to perform.
         * <p>
         * You must have at least one action for each type of resource. For example, if you have a place resource, you must include at least one place action.
         * <p>
         * The following are valid values for the actions.
         * <p>
         * <ul>
         * <li><em>Map actions</em></li>
         * <li><code>geo:GetMap*</code> - Allows all actions needed for map rendering.</li>
         * <li><em>Place actions</em></li>
         * <li><code>geo:SearchPlaceIndexForText</code> - Allows geocoding.</li>
         * <li><code>geo:SearchPlaceIndexForPosition</code> - Allows reverse geocoding.</li>
         * <li><code>geo:SearchPlaceIndexForSuggestions</code> - Allows generating suggestions from text.</li>
         * <li><code>geo:GetPlace</code> - Allows finding a place by place ID.</li>
         * <li><em>Route actions</em></li>
         * <li><code>geo:CalculateRoute</code> - Allows point to point routing.</li>
         * <li><code>geo:CalculateRouteMatrix</code> - Allows calculating a matrix of routes.</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * You must use these strings exactly. For example, to provide access to map rendering, the only valid action is <code>geo:GetMap*</code> as an input to the list. <code>["geo:GetMap*"]</code> is valid but <code>["geo:GetMapTile"]</code> is not. Similarly, you cannot use <code>["geo:SearchPlaceIndexFor*"]</code> - you must list each of the Place actions separately.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-location-apikey-apikeyrestrictions.html#cfn-location-apikey-apikeyrestrictions-allowactions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-location-apikey-apikeyrestrictions.html#cfn-location-apikey-apikeyrestrictions-allowactions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAllowActions();

        /**
         * A list of allowed resource ARNs that a API key bearer can perform actions on.
         * <p>
         * <ul>
         * <li>The ARN must be the correct ARN for a map, place, or route ARN. You may include wildcards in the resource-id to match multiple resources of the same type.</li>
         * <li>The resources must be in the same <code>partition</code> , <code>region</code> , and <code>account-id</code> as the key that is being created.</li>
         * <li>Other than wildcards, you must include the full ARN, including the <code>arn</code> , <code>partition</code> , <code>service</code> , <code>region</code> , <code>account-id</code> and <code>resource-id</code> delimited by colons (:).</li>
         * <li>No spaces allowed, even with wildcards. For example, <code>arn:aws:geo:region: *account-id* :map/ExampleMap*</code> .</li>
         * </ul>
         * <p>
         * For more information about ARN format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-location-apikey-apikeyrestrictions.html#cfn-location-apikey-apikeyrestrictions-allowresources">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-location-apikey-apikeyrestrictions.html#cfn-location-apikey-apikeyrestrictions-allowresources</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAllowResources();

        /**
         * An optional list of allowed HTTP referers for which requests must originate from.
         * <p>
         * Requests using this API key from other domains will not be allowed.
         * <p>
         * Requirements:
         * <p>
         * <ul>
         * <li>Contain only alphanumeric characters (A–Z, a–z, 0–9) or any symbols in this list <code>$\-._+!*</code>(),;/?:&#64;=&amp;`</li>
         * <li>May contain a percent (%) if followed by 2 hexadecimal digits (A-F, a-f, 0-9); this is used for URL encoding purposes.</li>
         * <li>May contain wildcard characters question mark (?) and asterisk (*).</li>
         * </ul>
         * <p>
         * Question mark (?) will replace any single character (including hexadecimal digits).
         * <p>
         * Asterisk (*) will replace any multiple characters (including multiple hexadecimal digits).
         * <p>
         * <ul>
         * <li>No spaces allowed. For example, <code>https://example.com</code> .</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-location-apikey-apikeyrestrictions.html#cfn-location-apikey-apikeyrestrictions-allowreferers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-location-apikey-apikeyrestrictions.html#cfn-location-apikey-apikeyrestrictions-allowreferers</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowReferers() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ApiKeyRestrictionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ApiKeyRestrictionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ApiKeyRestrictionsProperty> {
            java.util.List<java.lang.String> allowActions;
            java.util.List<java.lang.String> allowResources;
            java.util.List<java.lang.String> allowReferers;

            /**
             * Sets the value of {@link ApiKeyRestrictionsProperty#getAllowActions}
             * @param allowActions A list of allowed actions that an API key resource grants permissions to perform. This parameter is required.
             *                     You must have at least one action for each type of resource. For example, if you have a place resource, you must include at least one place action.
             *                     <p>
             *                     The following are valid values for the actions.
             *                     <p>
             *                     <ul>
             *                     <li><em>Map actions</em></li>
             *                     <li><code>geo:GetMap*</code> - Allows all actions needed for map rendering.</li>
             *                     <li><em>Place actions</em></li>
             *                     <li><code>geo:SearchPlaceIndexForText</code> - Allows geocoding.</li>
             *                     <li><code>geo:SearchPlaceIndexForPosition</code> - Allows reverse geocoding.</li>
             *                     <li><code>geo:SearchPlaceIndexForSuggestions</code> - Allows generating suggestions from text.</li>
             *                     <li><code>geo:GetPlace</code> - Allows finding a place by place ID.</li>
             *                     <li><em>Route actions</em></li>
             *                     <li><code>geo:CalculateRoute</code> - Allows point to point routing.</li>
             *                     <li><code>geo:CalculateRouteMatrix</code> - Allows calculating a matrix of routes.</li>
             *                     </ul>
             *                     <p>
             *                     <blockquote>
             *                     <p>
             *                     You must use these strings exactly. For example, to provide access to map rendering, the only valid action is <code>geo:GetMap*</code> as an input to the list. <code>["geo:GetMap*"]</code> is valid but <code>["geo:GetMapTile"]</code> is not. Similarly, you cannot use <code>["geo:SearchPlaceIndexFor*"]</code> - you must list each of the Place actions separately.
             *                     <p>
             *                     </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowActions(java.util.List<java.lang.String> allowActions) {
                this.allowActions = allowActions;
                return this;
            }

            /**
             * Sets the value of {@link ApiKeyRestrictionsProperty#getAllowResources}
             * @param allowResources A list of allowed resource ARNs that a API key bearer can perform actions on. This parameter is required.
             *                       <ul>
             *                       <li>The ARN must be the correct ARN for a map, place, or route ARN. You may include wildcards in the resource-id to match multiple resources of the same type.</li>
             *                       <li>The resources must be in the same <code>partition</code> , <code>region</code> , and <code>account-id</code> as the key that is being created.</li>
             *                       <li>Other than wildcards, you must include the full ARN, including the <code>arn</code> , <code>partition</code> , <code>service</code> , <code>region</code> , <code>account-id</code> and <code>resource-id</code> delimited by colons (:).</li>
             *                       <li>No spaces allowed, even with wildcards. For example, <code>arn:aws:geo:region: *account-id* :map/ExampleMap*</code> .</li>
             *                       </ul>
             *                       <p>
             *                       For more information about ARN format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowResources(java.util.List<java.lang.String> allowResources) {
                this.allowResources = allowResources;
                return this;
            }

            /**
             * Sets the value of {@link ApiKeyRestrictionsProperty#getAllowReferers}
             * @param allowReferers An optional list of allowed HTTP referers for which requests must originate from.
             *                      Requests using this API key from other domains will not be allowed.
             *                      <p>
             *                      Requirements:
             *                      <p>
             *                      <ul>
             *                      <li>Contain only alphanumeric characters (A–Z, a–z, 0–9) or any symbols in this list <code>$\-._+!*</code>(),;/?:&#64;=&amp;`</li>
             *                      <li>May contain a percent (%) if followed by 2 hexadecimal digits (A-F, a-f, 0-9); this is used for URL encoding purposes.</li>
             *                      <li>May contain wildcard characters question mark (?) and asterisk (*).</li>
             *                      </ul>
             *                      <p>
             *                      Question mark (?) will replace any single character (including hexadecimal digits).
             *                      <p>
             *                      Asterisk (*) will replace any multiple characters (including multiple hexadecimal digits).
             *                      <p>
             *                      <ul>
             *                      <li>No spaces allowed. For example, <code>https://example.com</code> .</li>
             *                      </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowReferers(java.util.List<java.lang.String> allowReferers) {
                this.allowReferers = allowReferers;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ApiKeyRestrictionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ApiKeyRestrictionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ApiKeyRestrictionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApiKeyRestrictionsProperty {
            private final java.util.List<java.lang.String> allowActions;
            private final java.util.List<java.lang.String> allowResources;
            private final java.util.List<java.lang.String> allowReferers;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.allowActions = software.amazon.jsii.Kernel.get(this, "allowActions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.allowResources = software.amazon.jsii.Kernel.get(this, "allowResources", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.allowReferers = software.amazon.jsii.Kernel.get(this, "allowReferers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.allowActions = java.util.Objects.requireNonNull(builder.allowActions, "allowActions is required");
                this.allowResources = java.util.Objects.requireNonNull(builder.allowResources, "allowResources is required");
                this.allowReferers = builder.allowReferers;
            }

            @Override
            public final java.util.List<java.lang.String> getAllowActions() {
                return this.allowActions;
            }

            @Override
            public final java.util.List<java.lang.String> getAllowResources() {
                return this.allowResources;
            }

            @Override
            public final java.util.List<java.lang.String> getAllowReferers() {
                return this.allowReferers;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("allowActions", om.valueToTree(this.getAllowActions()));
                data.set("allowResources", om.valueToTree(this.getAllowResources()));
                if (this.getAllowReferers() != null) {
                    data.set("allowReferers", om.valueToTree(this.getAllowReferers()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_location.CfnAPIKey.ApiKeyRestrictionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ApiKeyRestrictionsProperty.Jsii$Proxy that = (ApiKeyRestrictionsProperty.Jsii$Proxy) o;

                if (!allowActions.equals(that.allowActions)) return false;
                if (!allowResources.equals(that.allowResources)) return false;
                return this.allowReferers != null ? this.allowReferers.equals(that.allowReferers) : that.allowReferers == null;
            }

            @Override
            public final int hashCode() {
                int result = this.allowActions.hashCode();
                result = 31 * result + (this.allowResources.hashCode());
                result = 31 * result + (this.allowReferers != null ? this.allowReferers.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.location.CfnAPIKey}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.location.CfnAPIKey> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.location.CfnAPIKeyProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.location.CfnAPIKeyProps.Builder();
        }

        /**
         * A custom name for the API key resource.
         * <p>
         * Requirements:
         * <p>
         * <ul>
         * <li>Contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_).</li>
         * <li>Must be a unique API key name.</li>
         * <li>No spaces allowed. For example, <code>ExampleAPIKey</code> .</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-apikey.html#cfn-location-apikey-keyname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-apikey.html#cfn-location-apikey-keyname</a>
         * @param keyName A custom name for the API key resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyName(final java.lang.String keyName) {
            this.props.keyName(keyName);
            return this;
        }

        /**
         * The API key restrictions for the API key resource.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-apikey.html#cfn-location-apikey-restrictions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-apikey.html#cfn-location-apikey-restrictions</a>
         * @param restrictions The API key restrictions for the API key resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restrictions(final software.amazon.awscdk.IResolvable restrictions) {
            this.props.restrictions(restrictions);
            return this;
        }
        /**
         * The API key restrictions for the API key resource.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-apikey.html#cfn-location-apikey-restrictions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-apikey.html#cfn-location-apikey-restrictions</a>
         * @param restrictions The API key restrictions for the API key resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restrictions(final software.amazon.awscdk.services.location.CfnAPIKey.ApiKeyRestrictionsProperty restrictions) {
            this.props.restrictions(restrictions);
            return this;
        }

        /**
         * Updates the description for the API key resource.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-apikey.html#cfn-location-apikey-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-apikey.html#cfn-location-apikey-description</a>
         * @param description Updates the description for the API key resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The optional timestamp for when the API key resource will expire in <a href="https://docs.aws.amazon.com/https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601 format</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-apikey.html#cfn-location-apikey-expiretime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-apikey.html#cfn-location-apikey-expiretime</a>
         * @param expireTime The optional timestamp for when the API key resource will expire in <a href="https://docs.aws.amazon.com/https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601 format</a> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder expireTime(final java.lang.String expireTime) {
            this.props.expireTime(expireTime);
            return this;
        }

        /**
         * ForceDelete bypasses an API key's expiry conditions and deletes the key.
         * <p>
         * Set the parameter <code>true</code> to delete the key or to <code>false</code> to not preemptively delete the API key.
         * <p>
         * Valid values: <code>true</code> , or <code>false</code> .
         * <p>
         * <blockquote>
         * <p>
         * This action is irreversible. Only use ForceDelete if you are certain the key is no longer in use.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-apikey.html#cfn-location-apikey-forcedelete">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-apikey.html#cfn-location-apikey-forcedelete</a>
         * @param forceDelete ForceDelete bypasses an API key's expiry conditions and deletes the key. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder forceDelete(final java.lang.Boolean forceDelete) {
            this.props.forceDelete(forceDelete);
            return this;
        }
        /**
         * ForceDelete bypasses an API key's expiry conditions and deletes the key.
         * <p>
         * Set the parameter <code>true</code> to delete the key or to <code>false</code> to not preemptively delete the API key.
         * <p>
         * Valid values: <code>true</code> , or <code>false</code> .
         * <p>
         * <blockquote>
         * <p>
         * This action is irreversible. Only use ForceDelete if you are certain the key is no longer in use.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-apikey.html#cfn-location-apikey-forcedelete">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-apikey.html#cfn-location-apikey-forcedelete</a>
         * @param forceDelete ForceDelete bypasses an API key's expiry conditions and deletes the key. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder forceDelete(final software.amazon.awscdk.IResolvable forceDelete) {
            this.props.forceDelete(forceDelete);
            return this;
        }

        /**
         * The boolean flag to be included for updating <code>ExpireTime</code> or Restrictions details.
         * <p>
         * Must be set to <code>true</code> to update an API key resource that has been used in the past 7 days. <code>False</code> if force update is not preferred.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-apikey.html#cfn-location-apikey-forceupdate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-apikey.html#cfn-location-apikey-forceupdate</a>
         * @param forceUpdate The boolean flag to be included for updating <code>ExpireTime</code> or Restrictions details. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder forceUpdate(final java.lang.Boolean forceUpdate) {
            this.props.forceUpdate(forceUpdate);
            return this;
        }
        /**
         * The boolean flag to be included for updating <code>ExpireTime</code> or Restrictions details.
         * <p>
         * Must be set to <code>true</code> to update an API key resource that has been used in the past 7 days. <code>False</code> if force update is not preferred.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-apikey.html#cfn-location-apikey-forceupdate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-apikey.html#cfn-location-apikey-forceupdate</a>
         * @param forceUpdate The boolean flag to be included for updating <code>ExpireTime</code> or Restrictions details. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder forceUpdate(final software.amazon.awscdk.IResolvable forceUpdate) {
            this.props.forceUpdate(forceUpdate);
            return this;
        }

        /**
         * Whether the API key should expire.
         * <p>
         * Set to <code>true</code> to set the API key to have no expiration time.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-apikey.html#cfn-location-apikey-noexpiry">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-apikey.html#cfn-location-apikey-noexpiry</a>
         * @param noExpiry Whether the API key should expire. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder noExpiry(final java.lang.Boolean noExpiry) {
            this.props.noExpiry(noExpiry);
            return this;
        }
        /**
         * Whether the API key should expire.
         * <p>
         * Set to <code>true</code> to set the API key to have no expiration time.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-apikey.html#cfn-location-apikey-noexpiry">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-apikey.html#cfn-location-apikey-noexpiry</a>
         * @param noExpiry Whether the API key should expire. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder noExpiry(final software.amazon.awscdk.IResolvable noExpiry) {
            this.props.noExpiry(noExpiry);
            return this;
        }

        /**
         * Applies one or more tags to the map resource.
         * <p>
         * A tag is a key-value pair that helps manage, identify, search, and filter your resources by labelling them.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-apikey.html#cfn-location-apikey-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-apikey.html#cfn-location-apikey-tags</a>
         * @param tags Applies one or more tags to the map resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.location.CfnAPIKey}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.location.CfnAPIKey build() {
            return new software.amazon.awscdk.services.location.CfnAPIKey(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
