package software.amazon.awscdk.services.networkfirewall;

/**
 * Use the <code>LoggingConfiguration</code> to define the destinations and logging options for an <code>Firewall</code> .
 * <p>
 * You must change the logging configuration by changing one <code>LogDestinationConfig</code> setting at a time in your <code>LogDestinationConfigs</code> .
 * <p>
 * You can make only one of the following changes to your <code>LoggingConfiguration</code> resource:
 * <p>
 * <ul>
 * <li>Create a new log destination object by adding a single <code>LogDestinationConfig</code> array element to <code>LogDestinationConfigs</code> .</li>
 * <li>Delete a log destination object by removing a single <code>LogDestinationConfig</code> array element from <code>LogDestinationConfigs</code> .</li>
 * <li>Change the <code>LogDestination</code> setting in a single <code>LogDestinationConfig</code> array element.</li>
 * </ul>
 * <p>
 * You can't change the <code>LogDestinationType</code> or <code>LogType</code> in a <code>LogDestinationConfig</code> . To change these settings, delete the existing <code>LogDestinationConfig</code> object and create a new one, in two separate modifications.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.networkfirewall.*;
 * CfnLoggingConfiguration cfnLoggingConfiguration = CfnLoggingConfiguration.Builder.create(this, "MyCfnLoggingConfiguration")
 *         .firewallArn("firewallArn")
 *         .loggingConfiguration(LoggingConfigurationProperty.builder()
 *                 .logDestinationConfigs(List.of(LogDestinationConfigProperty.builder()
 *                         .logDestination(Map.of(
 *                                 "logDestinationKey", "logDestination"))
 *                         .logDestinationType("logDestinationType")
 *                         .logType("logType")
 *                         .build()))
 *                 .build())
 *         // the properties below are optional
 *         .firewallName("firewallName")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-loggingconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-loggingconfiguration.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-23T02:06:35.415Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkfirewall.CfnLoggingConfiguration")
public class CfnLoggingConfiguration extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnLoggingConfiguration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnLoggingConfiguration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.networkfirewall.CfnLoggingConfiguration.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnLoggingConfiguration(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.networkfirewall.CfnLoggingConfigurationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The Amazon Resource Name (ARN) of the <code>Firewall</code> that the logging configuration is associated with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFirewallArn() {
        return software.amazon.jsii.Kernel.get(this, "firewallArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the <code>Firewall</code> that the logging configuration is associated with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFirewallArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "firewallArn", java.util.Objects.requireNonNull(value, "firewallArn is required"));
    }

    /**
     * Defines how AWS Network Firewall performs logging for a <code>Firewall</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getLoggingConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "loggingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Defines how AWS Network Firewall performs logging for a <code>Firewall</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLoggingConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "loggingConfiguration", java.util.Objects.requireNonNull(value, "loggingConfiguration is required"));
    }

    /**
     * Defines how AWS Network Firewall performs logging for a <code>Firewall</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLoggingConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.networkfirewall.CfnLoggingConfiguration.LoggingConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "loggingConfiguration", java.util.Objects.requireNonNull(value, "loggingConfiguration is required"));
    }

    /**
     * The name of the firewall that the logging configuration is associated with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getFirewallName() {
        return software.amazon.jsii.Kernel.get(this, "firewallName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the firewall that the logging configuration is associated with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFirewallName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "firewallName", value);
    }
    /**
     * Defines where AWS Network Firewall sends logs for the firewall for one log type.
     * <p>
     * This is used in <code>LoggingConfiguration</code> . You can send each type of log to an Amazon S3 bucket, a CloudWatch log group, or a Kinesis Data Firehose delivery stream.
     * <p>
     * Network Firewall generates logs for stateful rule groups. You can save alert and flow log types. The stateful rules engine records flow logs for all network traffic that it receives. It records alert logs for traffic that matches stateful rules that have the rule action set to <code>DROP</code> or <code>ALERT</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.networkfirewall.*;
     * LogDestinationConfigProperty logDestinationConfigProperty = LogDestinationConfigProperty.builder()
     *         .logDestination(Map.of(
     *                 "logDestinationKey", "logDestination"))
     *         .logDestinationType("logDestinationType")
     *         .logType("logType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-loggingconfiguration-logdestinationconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-loggingconfiguration-logdestinationconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkfirewall.CfnLoggingConfiguration.LogDestinationConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(LogDestinationConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LogDestinationConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The named location for the logs, provided in a key:value mapping that is specific to the chosen destination type.
         * <p>
         * <ul>
         * <li>For an Amazon S3 bucket, provide the name of the bucket, with key <code>bucketName</code> , and optionally provide a prefix, with key <code>prefix</code> . The following example specifies an Amazon S3 bucket named <code>DOC-EXAMPLE-BUCKET</code> and the prefix <code>alerts</code> :</li>
         * </ul>
         * <p>
         * <code>"LogDestination": { "bucketName": "DOC-EXAMPLE-BUCKET", "prefix": "alerts" }</code>
         * <p>
         * <ul>
         * <li>For a CloudWatch log group, provide the name of the CloudWatch log group, with key <code>logGroup</code> . The following example specifies a log group named <code>alert-log-group</code> :</li>
         * </ul>
         * <p>
         * <code>"LogDestination": { "logGroup": "alert-log-group" }</code>
         * <p>
         * <ul>
         * <li>For a Firehose delivery stream, provide the name of the delivery stream, with key <code>deliveryStream</code> . The following example specifies a delivery stream named <code>alert-delivery-stream</code> :</li>
         * </ul>
         * <p>
         * <code>"LogDestination": { "deliveryStream": "alert-delivery-stream" }</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-loggingconfiguration-logdestinationconfig.html#cfn-networkfirewall-loggingconfiguration-logdestinationconfig-logdestination">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-loggingconfiguration-logdestinationconfig.html#cfn-networkfirewall-loggingconfiguration-logdestinationconfig-logdestination</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getLogDestination();

        /**
         * The type of storage destination to send these logs to.
         * <p>
         * You can send logs to an Amazon S3 bucket, a CloudWatch log group, or a Firehose delivery stream.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-loggingconfiguration-logdestinationconfig.html#cfn-networkfirewall-loggingconfiguration-logdestinationconfig-logdestinationtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-loggingconfiguration-logdestinationconfig.html#cfn-networkfirewall-loggingconfiguration-logdestinationconfig-logdestinationtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLogDestinationType();

        /**
         * The type of log to send.
         * <p>
         * Alert logs report traffic that matches a stateful rule with an action setting that sends an alert log message. Flow logs are standard network traffic flow logs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-loggingconfiguration-logdestinationconfig.html#cfn-networkfirewall-loggingconfiguration-logdestinationconfig-logtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-loggingconfiguration-logdestinationconfig.html#cfn-networkfirewall-loggingconfiguration-logdestinationconfig-logtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLogType();

        /**
         * @return a {@link Builder} of {@link LogDestinationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LogDestinationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LogDestinationConfigProperty> {
            java.lang.Object logDestination;
            java.lang.String logDestinationType;
            java.lang.String logType;

            /**
             * Sets the value of {@link LogDestinationConfigProperty#getLogDestination}
             * @param logDestination The named location for the logs, provided in a key:value mapping that is specific to the chosen destination type. This parameter is required.
             *                       <ul>
             *                       <li>For an Amazon S3 bucket, provide the name of the bucket, with key <code>bucketName</code> , and optionally provide a prefix, with key <code>prefix</code> . The following example specifies an Amazon S3 bucket named <code>DOC-EXAMPLE-BUCKET</code> and the prefix <code>alerts</code> :</li>
             *                       </ul>
             *                       <p>
             *                       <code>"LogDestination": { "bucketName": "DOC-EXAMPLE-BUCKET", "prefix": "alerts" }</code>
             *                       <p>
             *                       <ul>
             *                       <li>For a CloudWatch log group, provide the name of the CloudWatch log group, with key <code>logGroup</code> . The following example specifies a log group named <code>alert-log-group</code> :</li>
             *                       </ul>
             *                       <p>
             *                       <code>"LogDestination": { "logGroup": "alert-log-group" }</code>
             *                       <p>
             *                       <ul>
             *                       <li>For a Firehose delivery stream, provide the name of the delivery stream, with key <code>deliveryStream</code> . The following example specifies a delivery stream named <code>alert-delivery-stream</code> :</li>
             *                       </ul>
             *                       <p>
             *                       <code>"LogDestination": { "deliveryStream": "alert-delivery-stream" }</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logDestination(software.amazon.awscdk.IResolvable logDestination) {
                this.logDestination = logDestination;
                return this;
            }

            /**
             * Sets the value of {@link LogDestinationConfigProperty#getLogDestination}
             * @param logDestination The named location for the logs, provided in a key:value mapping that is specific to the chosen destination type. This parameter is required.
             *                       <ul>
             *                       <li>For an Amazon S3 bucket, provide the name of the bucket, with key <code>bucketName</code> , and optionally provide a prefix, with key <code>prefix</code> . The following example specifies an Amazon S3 bucket named <code>DOC-EXAMPLE-BUCKET</code> and the prefix <code>alerts</code> :</li>
             *                       </ul>
             *                       <p>
             *                       <code>"LogDestination": { "bucketName": "DOC-EXAMPLE-BUCKET", "prefix": "alerts" }</code>
             *                       <p>
             *                       <ul>
             *                       <li>For a CloudWatch log group, provide the name of the CloudWatch log group, with key <code>logGroup</code> . The following example specifies a log group named <code>alert-log-group</code> :</li>
             *                       </ul>
             *                       <p>
             *                       <code>"LogDestination": { "logGroup": "alert-log-group" }</code>
             *                       <p>
             *                       <ul>
             *                       <li>For a Firehose delivery stream, provide the name of the delivery stream, with key <code>deliveryStream</code> . The following example specifies a delivery stream named <code>alert-delivery-stream</code> :</li>
             *                       </ul>
             *                       <p>
             *                       <code>"LogDestination": { "deliveryStream": "alert-delivery-stream" }</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logDestination(java.util.Map<java.lang.String, java.lang.String> logDestination) {
                this.logDestination = logDestination;
                return this;
            }

            /**
             * Sets the value of {@link LogDestinationConfigProperty#getLogDestinationType}
             * @param logDestinationType The type of storage destination to send these logs to. This parameter is required.
             *                           You can send logs to an Amazon S3 bucket, a CloudWatch log group, or a Firehose delivery stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logDestinationType(java.lang.String logDestinationType) {
                this.logDestinationType = logDestinationType;
                return this;
            }

            /**
             * Sets the value of {@link LogDestinationConfigProperty#getLogType}
             * @param logType The type of log to send. This parameter is required.
             *                Alert logs report traffic that matches a stateful rule with an action setting that sends an alert log message. Flow logs are standard network traffic flow logs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logType(java.lang.String logType) {
                this.logType = logType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LogDestinationConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LogDestinationConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LogDestinationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LogDestinationConfigProperty {
            private final java.lang.Object logDestination;
            private final java.lang.String logDestinationType;
            private final java.lang.String logType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.logDestination = software.amazon.jsii.Kernel.get(this, "logDestination", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.logDestinationType = software.amazon.jsii.Kernel.get(this, "logDestinationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.logType = software.amazon.jsii.Kernel.get(this, "logType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.logDestination = java.util.Objects.requireNonNull(builder.logDestination, "logDestination is required");
                this.logDestinationType = java.util.Objects.requireNonNull(builder.logDestinationType, "logDestinationType is required");
                this.logType = java.util.Objects.requireNonNull(builder.logType, "logType is required");
            }

            @Override
            public final java.lang.Object getLogDestination() {
                return this.logDestination;
            }

            @Override
            public final java.lang.String getLogDestinationType() {
                return this.logDestinationType;
            }

            @Override
            public final java.lang.String getLogType() {
                return this.logType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("logDestination", om.valueToTree(this.getLogDestination()));
                data.set("logDestinationType", om.valueToTree(this.getLogDestinationType()));
                data.set("logType", om.valueToTree(this.getLogType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_networkfirewall.CfnLoggingConfiguration.LogDestinationConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LogDestinationConfigProperty.Jsii$Proxy that = (LogDestinationConfigProperty.Jsii$Proxy) o;

                if (!logDestination.equals(that.logDestination)) return false;
                if (!logDestinationType.equals(that.logDestinationType)) return false;
                return this.logType.equals(that.logType);
            }

            @Override
            public final int hashCode() {
                int result = this.logDestination.hashCode();
                result = 31 * result + (this.logDestinationType.hashCode());
                result = 31 * result + (this.logType.hashCode());
                return result;
            }
        }
    }
    /**
     * Defines how AWS Network Firewall performs logging for a <code>Firewall</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.networkfirewall.*;
     * LoggingConfigurationProperty loggingConfigurationProperty = LoggingConfigurationProperty.builder()
     *         .logDestinationConfigs(List.of(LogDestinationConfigProperty.builder()
     *                 .logDestination(Map.of(
     *                         "logDestinationKey", "logDestination"))
     *                 .logDestinationType("logDestinationType")
     *                 .logType("logType")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-loggingconfiguration-loggingconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-loggingconfiguration-loggingconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkfirewall.CfnLoggingConfiguration.LoggingConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(LoggingConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LoggingConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Defines the logging destinations for the logs for a firewall.
         * <p>
         * Network Firewall generates logs for stateful rule groups.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-loggingconfiguration-loggingconfiguration.html#cfn-networkfirewall-loggingconfiguration-loggingconfiguration-logdestinationconfigs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-loggingconfiguration-loggingconfiguration.html#cfn-networkfirewall-loggingconfiguration-loggingconfiguration-logdestinationconfigs</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getLogDestinationConfigs();

        /**
         * @return a {@link Builder} of {@link LoggingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LoggingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LoggingConfigurationProperty> {
            java.lang.Object logDestinationConfigs;

            /**
             * Sets the value of {@link LoggingConfigurationProperty#getLogDestinationConfigs}
             * @param logDestinationConfigs Defines the logging destinations for the logs for a firewall. This parameter is required.
             *                              Network Firewall generates logs for stateful rule groups.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logDestinationConfigs(software.amazon.awscdk.IResolvable logDestinationConfigs) {
                this.logDestinationConfigs = logDestinationConfigs;
                return this;
            }

            /**
             * Sets the value of {@link LoggingConfigurationProperty#getLogDestinationConfigs}
             * @param logDestinationConfigs Defines the logging destinations for the logs for a firewall. This parameter is required.
             *                              Network Firewall generates logs for stateful rule groups.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logDestinationConfigs(java.util.List<? extends java.lang.Object> logDestinationConfigs) {
                this.logDestinationConfigs = logDestinationConfigs;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LoggingConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LoggingConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LoggingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoggingConfigurationProperty {
            private final java.lang.Object logDestinationConfigs;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.logDestinationConfigs = software.amazon.jsii.Kernel.get(this, "logDestinationConfigs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.logDestinationConfigs = java.util.Objects.requireNonNull(builder.logDestinationConfigs, "logDestinationConfigs is required");
            }

            @Override
            public final java.lang.Object getLogDestinationConfigs() {
                return this.logDestinationConfigs;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("logDestinationConfigs", om.valueToTree(this.getLogDestinationConfigs()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_networkfirewall.CfnLoggingConfiguration.LoggingConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LoggingConfigurationProperty.Jsii$Proxy that = (LoggingConfigurationProperty.Jsii$Proxy) o;

                return this.logDestinationConfigs.equals(that.logDestinationConfigs);
            }

            @Override
            public final int hashCode() {
                int result = this.logDestinationConfigs.hashCode();
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.networkfirewall.CfnLoggingConfiguration}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.networkfirewall.CfnLoggingConfiguration> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.networkfirewall.CfnLoggingConfigurationProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.networkfirewall.CfnLoggingConfigurationProps.Builder();
        }

        /**
         * The Amazon Resource Name (ARN) of the <code>Firewall</code> that the logging configuration is associated with.
         * <p>
         * You can't change the firewall specification after you create the logging configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-loggingconfiguration.html#cfn-networkfirewall-loggingconfiguration-firewallarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-loggingconfiguration.html#cfn-networkfirewall-loggingconfiguration-firewallarn</a>
         * @param firewallArn The Amazon Resource Name (ARN) of the <code>Firewall</code> that the logging configuration is associated with. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder firewallArn(final java.lang.String firewallArn) {
            this.props.firewallArn(firewallArn);
            return this;
        }

        /**
         * Defines how AWS Network Firewall performs logging for a <code>Firewall</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-loggingconfiguration.html#cfn-networkfirewall-loggingconfiguration-loggingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-loggingconfiguration.html#cfn-networkfirewall-loggingconfiguration-loggingconfiguration</a>
         * @param loggingConfiguration Defines how AWS Network Firewall performs logging for a <code>Firewall</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingConfiguration(final software.amazon.awscdk.IResolvable loggingConfiguration) {
            this.props.loggingConfiguration(loggingConfiguration);
            return this;
        }
        /**
         * Defines how AWS Network Firewall performs logging for a <code>Firewall</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-loggingconfiguration.html#cfn-networkfirewall-loggingconfiguration-loggingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-loggingconfiguration.html#cfn-networkfirewall-loggingconfiguration-loggingconfiguration</a>
         * @param loggingConfiguration Defines how AWS Network Firewall performs logging for a <code>Firewall</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingConfiguration(final software.amazon.awscdk.services.networkfirewall.CfnLoggingConfiguration.LoggingConfigurationProperty loggingConfiguration) {
            this.props.loggingConfiguration(loggingConfiguration);
            return this;
        }

        /**
         * The name of the firewall that the logging configuration is associated with.
         * <p>
         * You can't change the firewall specification after you create the logging configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-loggingconfiguration.html#cfn-networkfirewall-loggingconfiguration-firewallname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-loggingconfiguration.html#cfn-networkfirewall-loggingconfiguration-firewallname</a>
         * @param firewallName The name of the firewall that the logging configuration is associated with. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder firewallName(final java.lang.String firewallName) {
            this.props.firewallName(firewallName);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.networkfirewall.CfnLoggingConfiguration}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.networkfirewall.CfnLoggingConfiguration build() {
            return new software.amazon.awscdk.services.networkfirewall.CfnLoggingConfiguration(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
