package software.amazon.awscdk.services.servicecatalog;

/**
 * A Service Catalog Cloudformation Product.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.*;
 * public class S3BucketProduct extends ProductStack {
 *     public S3BucketProduct(Construct scope, String id) {
 *         super(scope, id);
 *         new Bucket(this, "BucketProduct");
 *     }
 * }
 * CloudFormationProduct product = CloudFormationProduct.Builder.create(this, "Product")
 *         .productName("My Product")
 *         .owner("Product Owner")
 *         .productVersions(List.of(CloudFormationProductVersion.builder()
 *                 .productVersionName("v1")
 *                 .cloudFormationTemplate(CloudFormationTemplate.fromProductStack(new S3BucketProduct(this, "S3BucketProduct")))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-23T02:06:39.985Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_servicecatalog.CloudFormationProduct")
public class CloudFormationProduct extends software.amazon.awscdk.services.servicecatalog.Product {

    protected CloudFormationProduct(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CloudFormationProduct(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CloudFormationProduct(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.CloudFormationProductProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * The asset bucket of a product created via product stack.
     * <p>
     * Default: - Empty - no assets are used in this product
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.s3.IBucket> getAssetBuckets() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "assetBuckets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class))));
    }

    /**
     * The ARN of the product.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getProductArn() {
        return software.amazon.jsii.Kernel.get(this, "productArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The id of the product.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getProductId() {
        return software.amazon.jsii.Kernel.get(this, "productId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.servicecatalog.CloudFormationProduct}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.servicecatalog.CloudFormationProduct> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.servicecatalog.CloudFormationProductProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.servicecatalog.CloudFormationProductProps.Builder();
        }

        /**
         * The owner of the product.
         * <p>
         * @return {@code this}
         * @param owner The owner of the product. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder owner(final java.lang.String owner) {
            this.props.owner(owner);
            return this;
        }

        /**
         * The name of the product.
         * <p>
         * @return {@code this}
         * @param productName The name of the product. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder productName(final java.lang.String productName) {
            this.props.productName(productName);
            return this;
        }

        /**
         * The configuration of the product version.
         * <p>
         * @return {@code this}
         * @param productVersions The configuration of the product version. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder productVersions(final java.util.List<? extends software.amazon.awscdk.services.servicecatalog.CloudFormationProductVersion> productVersions) {
            this.props.productVersions(productVersions);
            return this;
        }

        /**
         * The description of the product.
         * <p>
         * Default: - No description provided
         * <p>
         * @return {@code this}
         * @param description The description of the product. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The distributor of the product.
         * <p>
         * Default: - No distributor provided
         * <p>
         * @return {@code this}
         * @param distributor The distributor of the product. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder distributor(final java.lang.String distributor) {
            this.props.distributor(distributor);
            return this;
        }

        /**
         * The language code.
         * <p>
         * Controls language for logging and errors.
         * <p>
         * Default: - English
         * <p>
         * @return {@code this}
         * @param messageLanguage The language code. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder messageLanguage(final software.amazon.awscdk.services.servicecatalog.MessageLanguage messageLanguage) {
            this.props.messageLanguage(messageLanguage);
            return this;
        }

        /**
         * Whether to give provisioning artifacts a new unique identifier when the product attributes or provisioning artifacts is updated.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param replaceProductVersionIds Whether to give provisioning artifacts a new unique identifier when the product attributes or provisioning artifacts is updated. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replaceProductVersionIds(final java.lang.Boolean replaceProductVersionIds) {
            this.props.replaceProductVersionIds(replaceProductVersionIds);
            return this;
        }

        /**
         * The support information about the product.
         * <p>
         * Default: - No support description provided
         * <p>
         * @return {@code this}
         * @param supportDescription The support information about the product. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder supportDescription(final java.lang.String supportDescription) {
            this.props.supportDescription(supportDescription);
            return this;
        }

        /**
         * The contact email for product support.
         * <p>
         * Default: - No support email provided
         * <p>
         * @return {@code this}
         * @param supportEmail The contact email for product support. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder supportEmail(final java.lang.String supportEmail) {
            this.props.supportEmail(supportEmail);
            return this;
        }

        /**
         * The contact URL for product support.
         * <p>
         * Default: - No support URL provided
         * <p>
         * @return {@code this}
         * @param supportUrl The contact URL for product support. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder supportUrl(final java.lang.String supportUrl) {
            this.props.supportUrl(supportUrl);
            return this;
        }

        /**
         * TagOptions associated directly to a product.
         * <p>
         * Default: - No tagOptions provided
         * <p>
         * @return {@code this}
         * @param tagOptions TagOptions associated directly to a product. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tagOptions(final software.amazon.awscdk.services.servicecatalog.TagOptions tagOptions) {
            this.props.tagOptions(tagOptions);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.servicecatalog.CloudFormationProduct}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.servicecatalog.CloudFormationProduct build() {
            return new software.amazon.awscdk.services.servicecatalog.CloudFormationProduct(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
