package software.amazon.awscdk.services.servicediscovery;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.*;
 * App app = new App();
 * Stack stack = new Stack(app, "aws-servicediscovery-integ");
 * HttpNamespace namespace = HttpNamespace.Builder.create(stack, "MyNamespace")
 *         .name("MyHTTPNamespace")
 *         .build();
 * Service service1 = namespace.createService("NonIpService", BaseServiceProps.builder()
 *         .description("service registering non-ip instances")
 *         .build());
 * service1.registerNonIpInstance("NonIpInstance", NonIpInstanceBaseProps.builder()
 *         .customAttributes(Map.of("arn", "arn:aws:s3:::mybucket"))
 *         .build());
 * Service service2 = namespace.createService("IpService", BaseServiceProps.builder()
 *         .description("service registering ip instances")
 *         .healthCheck(HealthCheckConfig.builder()
 *                 .type(HealthCheckType.HTTP)
 *                 .resourcePath("/check")
 *                 .build())
 *         .build());
 * service2.registerIpInstance("IpInstance", IpInstanceBaseProps.builder()
 *         .ipv4("54.239.25.192")
 *         .build());
 * app.synth();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-23T02:06:40.059Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_servicediscovery.NonIpInstanceBaseProps")
@software.amazon.jsii.Jsii.Proxy(NonIpInstanceBaseProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface NonIpInstanceBaseProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.servicediscovery.BaseInstanceProps {

    /**
     * @return a {@link Builder} of {@link NonIpInstanceBaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link NonIpInstanceBaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<NonIpInstanceBaseProps> {
        java.util.Map<java.lang.String, java.lang.String> customAttributes;
        java.lang.String instanceId;

        /**
         * Sets the value of {@link NonIpInstanceBaseProps#getCustomAttributes}
         * @param customAttributes Custom attributes of the instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customAttributes(java.util.Map<java.lang.String, java.lang.String> customAttributes) {
            this.customAttributes = customAttributes;
            return this;
        }

        /**
         * Sets the value of {@link NonIpInstanceBaseProps#getInstanceId}
         * @param instanceId The id of the instance resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceId(java.lang.String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link NonIpInstanceBaseProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public NonIpInstanceBaseProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link NonIpInstanceBaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NonIpInstanceBaseProps {
        private final java.util.Map<java.lang.String, java.lang.String> customAttributes;
        private final java.lang.String instanceId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.customAttributes = software.amazon.jsii.Kernel.get(this, "customAttributes", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.instanceId = software.amazon.jsii.Kernel.get(this, "instanceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.customAttributes = builder.customAttributes;
            this.instanceId = builder.instanceId;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getCustomAttributes() {
            return this.customAttributes;
        }

        @Override
        public final java.lang.String getInstanceId() {
            return this.instanceId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCustomAttributes() != null) {
                data.set("customAttributes", om.valueToTree(this.getCustomAttributes()));
            }
            if (this.getInstanceId() != null) {
                data.set("instanceId", om.valueToTree(this.getInstanceId()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_servicediscovery.NonIpInstanceBaseProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            NonIpInstanceBaseProps.Jsii$Proxy that = (NonIpInstanceBaseProps.Jsii$Proxy) o;

            if (this.customAttributes != null ? !this.customAttributes.equals(that.customAttributes) : that.customAttributes != null) return false;
            return this.instanceId != null ? this.instanceId.equals(that.instanceId) : that.instanceId == null;
        }

        @Override
        public final int hashCode() {
            int result = this.customAttributes != null ? this.customAttributes.hashCode() : 0;
            result = 31 * result + (this.instanceId != null ? this.instanceId.hashCode() : 0);
            return result;
        }
    }
}
