package software.amazon.awscdk.services.ses;

/**
 * Properties for a configuration set event destination.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ses.*;
 * ConfigurationSet configurationSet;
 * EventDestination eventDestination;
 * ConfigurationSetEventDestinationProps configurationSetEventDestinationProps = ConfigurationSetEventDestinationProps.builder()
 *         .configurationSet(configurationSet)
 *         .destination(eventDestination)
 *         // the properties below are optional
 *         .configurationSetEventDestinationName("configurationSetEventDestinationName")
 *         .enabled(false)
 *         .events(List.of(EmailSendingEvent.SEND))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-23T02:06:40.116Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.ConfigurationSetEventDestinationProps")
@software.amazon.jsii.Jsii.Proxy(ConfigurationSetEventDestinationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ConfigurationSetEventDestinationProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.ses.ConfigurationSetEventDestinationOptions {

    /**
     * The configuration set that contains the event destination.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.IConfigurationSet getConfigurationSet();

    /**
     * @return a {@link Builder} of {@link ConfigurationSetEventDestinationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ConfigurationSetEventDestinationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ConfigurationSetEventDestinationProps> {
        software.amazon.awscdk.services.ses.IConfigurationSet configurationSet;
        software.amazon.awscdk.services.ses.EventDestination destination;
        java.lang.String configurationSetEventDestinationName;
        java.lang.Boolean enabled;
        java.util.List<software.amazon.awscdk.services.ses.EmailSendingEvent> events;

        /**
         * Sets the value of {@link ConfigurationSetEventDestinationProps#getConfigurationSet}
         * @param configurationSet The configuration set that contains the event destination. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurationSet(software.amazon.awscdk.services.ses.IConfigurationSet configurationSet) {
            this.configurationSet = configurationSet;
            return this;
        }

        /**
         * Sets the value of {@link ConfigurationSetEventDestinationProps#getDestination}
         * @param destination The event destination. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destination(software.amazon.awscdk.services.ses.EventDestination destination) {
            this.destination = destination;
            return this;
        }

        /**
         * Sets the value of {@link ConfigurationSetEventDestinationProps#getConfigurationSetEventDestinationName}
         * @param configurationSetEventDestinationName A name for the configuration set event destination.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurationSetEventDestinationName(java.lang.String configurationSetEventDestinationName) {
            this.configurationSetEventDestinationName = configurationSetEventDestinationName;
            return this;
        }

        /**
         * Sets the value of {@link ConfigurationSetEventDestinationProps#getEnabled}
         * @param enabled Whether Amazon SES publishes events to this destination.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Sets the value of {@link ConfigurationSetEventDestinationProps#getEvents}
         * @param events The type of email sending events to publish to the event destination.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder events(java.util.List<? extends software.amazon.awscdk.services.ses.EmailSendingEvent> events) {
            this.events = (java.util.List<software.amazon.awscdk.services.ses.EmailSendingEvent>)events;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ConfigurationSetEventDestinationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ConfigurationSetEventDestinationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ConfigurationSetEventDestinationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConfigurationSetEventDestinationProps {
        private final software.amazon.awscdk.services.ses.IConfigurationSet configurationSet;
        private final software.amazon.awscdk.services.ses.EventDestination destination;
        private final java.lang.String configurationSetEventDestinationName;
        private final java.lang.Boolean enabled;
        private final java.util.List<software.amazon.awscdk.services.ses.EmailSendingEvent> events;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.configurationSet = software.amazon.jsii.Kernel.get(this, "configurationSet", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ses.IConfigurationSet.class));
            this.destination = software.amazon.jsii.Kernel.get(this, "destination", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ses.EventDestination.class));
            this.configurationSetEventDestinationName = software.amazon.jsii.Kernel.get(this, "configurationSetEventDestinationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.events = software.amazon.jsii.Kernel.get(this, "events", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ses.EmailSendingEvent.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.configurationSet = java.util.Objects.requireNonNull(builder.configurationSet, "configurationSet is required");
            this.destination = java.util.Objects.requireNonNull(builder.destination, "destination is required");
            this.configurationSetEventDestinationName = builder.configurationSetEventDestinationName;
            this.enabled = builder.enabled;
            this.events = (java.util.List<software.amazon.awscdk.services.ses.EmailSendingEvent>)builder.events;
        }

        @Override
        public final software.amazon.awscdk.services.ses.IConfigurationSet getConfigurationSet() {
            return this.configurationSet;
        }

        @Override
        public final software.amazon.awscdk.services.ses.EventDestination getDestination() {
            return this.destination;
        }

        @Override
        public final java.lang.String getConfigurationSetEventDestinationName() {
            return this.configurationSetEventDestinationName;
        }

        @Override
        public final java.lang.Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ses.EmailSendingEvent> getEvents() {
            return this.events;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("configurationSet", om.valueToTree(this.getConfigurationSet()));
            data.set("destination", om.valueToTree(this.getDestination()));
            if (this.getConfigurationSetEventDestinationName() != null) {
                data.set("configurationSetEventDestinationName", om.valueToTree(this.getConfigurationSetEventDestinationName()));
            }
            if (this.getEnabled() != null) {
                data.set("enabled", om.valueToTree(this.getEnabled()));
            }
            if (this.getEvents() != null) {
                data.set("events", om.valueToTree(this.getEvents()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.ConfigurationSetEventDestinationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ConfigurationSetEventDestinationProps.Jsii$Proxy that = (ConfigurationSetEventDestinationProps.Jsii$Proxy) o;

            if (!configurationSet.equals(that.configurationSet)) return false;
            if (!destination.equals(that.destination)) return false;
            if (this.configurationSetEventDestinationName != null ? !this.configurationSetEventDestinationName.equals(that.configurationSetEventDestinationName) : that.configurationSetEventDestinationName != null) return false;
            if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
            return this.events != null ? this.events.equals(that.events) : that.events == null;
        }

        @Override
        public final int hashCode() {
            int result = this.configurationSet.hashCode();
            result = 31 * result + (this.destination.hashCode());
            result = 31 * result + (this.configurationSetEventDestinationName != null ? this.configurationSetEventDestinationName.hashCode() : 0);
            result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
            result = 31 * result + (this.events != null ? this.events.hashCode() : 0);
            return result;
        }
    }
}
