package software.amazon.awscdk.services.sns;

/**
 * A new subscription.
 * <p>
 * Prefer to use the <code>ITopic.addSubscription()</code> methods to create instances of
 * this class.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.kinesisfirehose.alpha.DeliveryStream;
 * DeliveryStream stream;
 * Topic topic = new Topic(this, "Topic");
 * Subscription.Builder.create(this, "Subscription")
 *         .topic(topic)
 *         .endpoint(stream.getDeliveryStreamArn())
 *         .protocol(SubscriptionProtocol.FIREHOSE)
 *         .subscriptionRoleArn("SAMPLE_ARN")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-23T02:06:40.200Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sns.Subscription")
public class Subscription extends software.amazon.awscdk.Resource {

    protected Subscription(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Subscription(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Subscription(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sns.SubscriptionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * The DLQ associated with this subscription if present.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sqs.IQueue getDeadLetterQueue() {
        return software.amazon.jsii.Kernel.get(this, "deadLetterQueue", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sqs.IQueue.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.sns.Subscription}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.sns.Subscription> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.sns.SubscriptionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.sns.SubscriptionProps.Builder();
        }

        /**
         * The subscription endpoint.
         * <p>
         * The meaning of this value depends on the value for 'protocol'.
         * <p>
         * @return {@code this}
         * @param endpoint The subscription endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpoint(final java.lang.String endpoint) {
            this.props.endpoint(endpoint);
            return this;
        }

        /**
         * What type of subscription to add.
         * <p>
         * @return {@code this}
         * @param protocol What type of subscription to add. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocol(final software.amazon.awscdk.services.sns.SubscriptionProtocol protocol) {
            this.props.protocol(protocol);
            return this;
        }

        /**
         * Queue to be used as dead letter queue.
         * <p>
         * If not passed no dead letter queue is enabled.
         * <p>
         * Default: - No dead letter queue enabled.
         * <p>
         * @return {@code this}
         * @param deadLetterQueue Queue to be used as dead letter queue. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterQueue(final software.amazon.awscdk.services.sqs.IQueue deadLetterQueue) {
            this.props.deadLetterQueue(deadLetterQueue);
            return this;
        }

        /**
         * The filter policy.
         * <p>
         * Default: - all messages are delivered
         * <p>
         * @return {@code this}
         * @param filterPolicy The filter policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filterPolicy(final java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.sns.SubscriptionFilter> filterPolicy) {
            this.props.filterPolicy(filterPolicy);
            return this;
        }

        /**
         * The filter policy that is applied on the message body.
         * <p>
         * To apply a filter policy to the message attributes, use <code>filterPolicy</code>. A maximum of one of <code>filterPolicyWithMessageBody</code> and <code>filterPolicy</code> may be used.
         * <p>
         * Default: - all messages are delivered
         * <p>
         * @return {@code this}
         * @param filterPolicyWithMessageBody The filter policy that is applied on the message body. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filterPolicyWithMessageBody(final java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.sns.FilterOrPolicy> filterPolicyWithMessageBody) {
            this.props.filterPolicyWithMessageBody(filterPolicyWithMessageBody);
            return this;
        }

        /**
         * true if raw message delivery is enabled for the subscription.
         * <p>
         * Raw messages are free of JSON formatting and can be
         * sent to HTTP/S and Amazon SQS endpoints. For more information, see GetSubscriptionAttributes in the Amazon Simple
         * Notification Service API Reference.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param rawMessageDelivery true if raw message delivery is enabled for the subscription. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rawMessageDelivery(final java.lang.Boolean rawMessageDelivery) {
            this.props.rawMessageDelivery(rawMessageDelivery);
            return this;
        }

        /**
         * The region where the topic resides, in the case of cross-region subscriptions.
         * <p>
         * Default: - the region where the CloudFormation stack is being deployed.
         * <p>
         * @return {@code this}
         * @param region The region where the topic resides, in the case of cross-region subscriptions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(final java.lang.String region) {
            this.props.region(region);
            return this;
        }

        /**
         * Arn of role allowing access to firehose delivery stream.
         * <p>
         * Required for a firehose subscription protocol.
         * <p>
         * Default: - No subscription role is provided
         * <p>
         * @return {@code this}
         * @param subscriptionRoleArn Arn of role allowing access to firehose delivery stream. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subscriptionRoleArn(final java.lang.String subscriptionRoleArn) {
            this.props.subscriptionRoleArn(subscriptionRoleArn);
            return this;
        }

        /**
         * The topic to subscribe to.
         * <p>
         * @return {@code this}
         * @param topic The topic to subscribe to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder topic(final software.amazon.awscdk.services.sns.ITopic topic) {
            this.props.topic(topic);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.sns.Subscription}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.sns.Subscription build() {
            return new software.amazon.awscdk.services.sns.Subscription(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
