package software.amazon.awscdk.services.ssm;

/**
 * Properties for defining a <code>CfnDocument</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ssm.*;
 * Object content;
 * CfnDocumentProps cfnDocumentProps = CfnDocumentProps.builder()
 *         .content(content)
 *         // the properties below are optional
 *         .attachments(List.of(AttachmentsSourceProperty.builder()
 *                 .key("key")
 *                 .name("name")
 *                 .values(List.of("values"))
 *                 .build()))
 *         .documentFormat("documentFormat")
 *         .documentType("documentType")
 *         .name("name")
 *         .requires(List.of(DocumentRequiresProperty.builder()
 *                 .name("name")
 *                 .version("version")
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .targetType("targetType")
 *         .updateMethod("updateMethod")
 *         .versionName("versionName")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-23T02:06:40.267Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssm.CfnDocumentProps")
@software.amazon.jsii.Jsii.Proxy(CfnDocumentProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDocumentProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The content for the new SSM document in JSON or YAML.
     * <p>
     * For more information about the schemas for SSM document content, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/document-schemas-features.html">SSM document schema features and examples</a> in the <em>AWS Systems Manager User Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * This parameter also supports <code>String</code> data types.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html#cfn-ssm-document-content">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html#cfn-ssm-document-content</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getContent();

    /**
     * A list of key-value pairs that describe attachments to a version of a document.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html#cfn-ssm-document-attachments">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html#cfn-ssm-document-attachments</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAttachments() {
        return null;
    }

    /**
     * Specify the document format for the request.
     * <p>
     * JSON is the default format.
     * <p>
     * Default: - "JSON"
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html#cfn-ssm-document-documentformat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html#cfn-ssm-document-documentformat</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDocumentFormat() {
        return null;
    }

    /**
     * The type of document to create.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html#cfn-ssm-document-documenttype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html#cfn-ssm-document-documenttype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDocumentType() {
        return null;
    }

    /**
     * A name for the SSM document.
     * <p>
     * <blockquote>
     * <p>
     * You can't use the following strings as document name prefixes. These are reserved by AWS for use as document name prefixes:
     * <p>
     * <ul>
     * <li><code>aws</code></li>
     * <li><code>amazon</code></li>
     * <li><code>amzn</code></li>
     * </ul>
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html#cfn-ssm-document-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html#cfn-ssm-document-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * A list of SSM documents required by a document.
     * <p>
     * This parameter is used exclusively by AWS AppConfig . When a user creates an AWS AppConfig configuration in an SSM document, the user must also specify a required document for validation purposes. In this case, an <code>ApplicationConfiguration</code> document requires an <code>ApplicationConfigurationSchema</code> document for validation purposes. For more information, see <a href="https://docs.aws.amazon.com/appconfig/latest/userguide/what-is-appconfig.html">What is AWS AppConfig ?</a> in the <em>AWS AppConfig User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html#cfn-ssm-document-requires">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html#cfn-ssm-document-requires</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRequires() {
        return null;
    }

    /**
     * AWS CloudFormation resource tags to apply to the document.
     * <p>
     * Use tags to help you identify and categorize resources.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html#cfn-ssm-document-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html#cfn-ssm-document-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * Specify a target type to define the kinds of resources the document can run on.
     * <p>
     * For example, to run a document on EC2 instances, specify the following value: <code>/AWS::EC2::Instance</code> . If you specify a value of '/' the document can run on all types of resources. If you don't specify a value, the document can't run on any resources. For a list of valid resource types, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">AWS resource and property types reference</a> in the <em>AWS CloudFormation User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html#cfn-ssm-document-targettype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html#cfn-ssm-document-targettype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTargetType() {
        return null;
    }

    /**
     * If the document resource you specify in your template already exists, this parameter determines whether a new version of the existing document is created, or the existing document is replaced.
     * <p>
     * <code>Replace</code> is the default method. If you specify <code>NewVersion</code> for the <code>UpdateMethod</code> parameter, and the <code>Name</code> of the document does not match an existing resource, a new document is created. When you specify <code>NewVersion</code> , the default version of the document is changed to the newly created version.
     * <p>
     * Default: - "Replace"
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html#cfn-ssm-document-updatemethod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html#cfn-ssm-document-updatemethod</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getUpdateMethod() {
        return null;
    }

    /**
     * An optional field specifying the version of the artifact you are creating with the document.
     * <p>
     * For example, <code>Release12.1</code> . This value is unique across all versions of a document, and can't be changed.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html#cfn-ssm-document-versionname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html#cfn-ssm-document-versionname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVersionName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDocumentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDocumentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDocumentProps> {
        java.lang.Object content;
        java.lang.Object attachments;
        java.lang.String documentFormat;
        java.lang.String documentType;
        java.lang.String name;
        java.lang.Object requires;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String targetType;
        java.lang.String updateMethod;
        java.lang.String versionName;

        /**
         * Sets the value of {@link CfnDocumentProps#getContent}
         * @param content The content for the new SSM document in JSON or YAML. This parameter is required.
         *                For more information about the schemas for SSM document content, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/document-schemas-features.html">SSM document schema features and examples</a> in the <em>AWS Systems Manager User Guide</em> .
         *                <p>
         *                <blockquote>
         *                <p>
         *                This parameter also supports <code>String</code> data types.
         *                <p>
         *                </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder content(java.lang.Object content) {
            this.content = content;
            return this;
        }

        /**
         * Sets the value of {@link CfnDocumentProps#getAttachments}
         * @param attachments A list of key-value pairs that describe attachments to a version of a document.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attachments(software.amazon.awscdk.IResolvable attachments) {
            this.attachments = attachments;
            return this;
        }

        /**
         * Sets the value of {@link CfnDocumentProps#getAttachments}
         * @param attachments A list of key-value pairs that describe attachments to a version of a document.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attachments(java.util.List<? extends java.lang.Object> attachments) {
            this.attachments = attachments;
            return this;
        }

        /**
         * Sets the value of {@link CfnDocumentProps#getDocumentFormat}
         * @param documentFormat Specify the document format for the request.
         *                       JSON is the default format.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder documentFormat(java.lang.String documentFormat) {
            this.documentFormat = documentFormat;
            return this;
        }

        /**
         * Sets the value of {@link CfnDocumentProps#getDocumentType}
         * @param documentType The type of document to create.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder documentType(java.lang.String documentType) {
            this.documentType = documentType;
            return this;
        }

        /**
         * Sets the value of {@link CfnDocumentProps#getName}
         * @param name A name for the SSM document.
         *             <blockquote>
         *             <p>
         *             You can't use the following strings as document name prefixes. These are reserved by AWS for use as document name prefixes:
         *             <p>
         *             <ul>
         *             <li><code>aws</code></li>
         *             <li><code>amazon</code></li>
         *             <li><code>amzn</code></li>
         *             </ul>
         *             <p>
         *             </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnDocumentProps#getRequires}
         * @param requires A list of SSM documents required by a document.
         *                 This parameter is used exclusively by AWS AppConfig . When a user creates an AWS AppConfig configuration in an SSM document, the user must also specify a required document for validation purposes. In this case, an <code>ApplicationConfiguration</code> document requires an <code>ApplicationConfigurationSchema</code> document for validation purposes. For more information, see <a href="https://docs.aws.amazon.com/appconfig/latest/userguide/what-is-appconfig.html">What is AWS AppConfig ?</a> in the <em>AWS AppConfig User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requires(software.amazon.awscdk.IResolvable requires) {
            this.requires = requires;
            return this;
        }

        /**
         * Sets the value of {@link CfnDocumentProps#getRequires}
         * @param requires A list of SSM documents required by a document.
         *                 This parameter is used exclusively by AWS AppConfig . When a user creates an AWS AppConfig configuration in an SSM document, the user must also specify a required document for validation purposes. In this case, an <code>ApplicationConfiguration</code> document requires an <code>ApplicationConfigurationSchema</code> document for validation purposes. For more information, see <a href="https://docs.aws.amazon.com/appconfig/latest/userguide/what-is-appconfig.html">What is AWS AppConfig ?</a> in the <em>AWS AppConfig User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requires(java.util.List<? extends java.lang.Object> requires) {
            this.requires = requires;
            return this;
        }

        /**
         * Sets the value of {@link CfnDocumentProps#getTags}
         * @param tags AWS CloudFormation resource tags to apply to the document.
         *             Use tags to help you identify and categorize resources.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnDocumentProps#getTargetType}
         * @param targetType Specify a target type to define the kinds of resources the document can run on.
         *                   For example, to run a document on EC2 instances, specify the following value: <code>/AWS::EC2::Instance</code> . If you specify a value of '/' the document can run on all types of resources. If you don't specify a value, the document can't run on any resources. For a list of valid resource types, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">AWS resource and property types reference</a> in the <em>AWS CloudFormation User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetType(java.lang.String targetType) {
            this.targetType = targetType;
            return this;
        }

        /**
         * Sets the value of {@link CfnDocumentProps#getUpdateMethod}
         * @param updateMethod If the document resource you specify in your template already exists, this parameter determines whether a new version of the existing document is created, or the existing document is replaced.
         *                     <code>Replace</code> is the default method. If you specify <code>NewVersion</code> for the <code>UpdateMethod</code> parameter, and the <code>Name</code> of the document does not match an existing resource, a new document is created. When you specify <code>NewVersion</code> , the default version of the document is changed to the newly created version.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder updateMethod(java.lang.String updateMethod) {
            this.updateMethod = updateMethod;
            return this;
        }

        /**
         * Sets the value of {@link CfnDocumentProps#getVersionName}
         * @param versionName An optional field specifying the version of the artifact you are creating with the document.
         *                    For example, <code>Release12.1</code> . This value is unique across all versions of a document, and can't be changed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder versionName(java.lang.String versionName) {
            this.versionName = versionName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDocumentProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDocumentProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDocumentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDocumentProps {
        private final java.lang.Object content;
        private final java.lang.Object attachments;
        private final java.lang.String documentFormat;
        private final java.lang.String documentType;
        private final java.lang.String name;
        private final java.lang.Object requires;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String targetType;
        private final java.lang.String updateMethod;
        private final java.lang.String versionName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.content = software.amazon.jsii.Kernel.get(this, "content", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.attachments = software.amazon.jsii.Kernel.get(this, "attachments", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.documentFormat = software.amazon.jsii.Kernel.get(this, "documentFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.documentType = software.amazon.jsii.Kernel.get(this, "documentType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.requires = software.amazon.jsii.Kernel.get(this, "requires", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.targetType = software.amazon.jsii.Kernel.get(this, "targetType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.updateMethod = software.amazon.jsii.Kernel.get(this, "updateMethod", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.versionName = software.amazon.jsii.Kernel.get(this, "versionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.content = java.util.Objects.requireNonNull(builder.content, "content is required");
            this.attachments = builder.attachments;
            this.documentFormat = builder.documentFormat;
            this.documentType = builder.documentType;
            this.name = builder.name;
            this.requires = builder.requires;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.targetType = builder.targetType;
            this.updateMethod = builder.updateMethod;
            this.versionName = builder.versionName;
        }

        @Override
        public final java.lang.Object getContent() {
            return this.content;
        }

        @Override
        public final java.lang.Object getAttachments() {
            return this.attachments;
        }

        @Override
        public final java.lang.String getDocumentFormat() {
            return this.documentFormat;
        }

        @Override
        public final java.lang.String getDocumentType() {
            return this.documentType;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getRequires() {
            return this.requires;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getTargetType() {
            return this.targetType;
        }

        @Override
        public final java.lang.String getUpdateMethod() {
            return this.updateMethod;
        }

        @Override
        public final java.lang.String getVersionName() {
            return this.versionName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("content", om.valueToTree(this.getContent()));
            if (this.getAttachments() != null) {
                data.set("attachments", om.valueToTree(this.getAttachments()));
            }
            if (this.getDocumentFormat() != null) {
                data.set("documentFormat", om.valueToTree(this.getDocumentFormat()));
            }
            if (this.getDocumentType() != null) {
                data.set("documentType", om.valueToTree(this.getDocumentType()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getRequires() != null) {
                data.set("requires", om.valueToTree(this.getRequires()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTargetType() != null) {
                data.set("targetType", om.valueToTree(this.getTargetType()));
            }
            if (this.getUpdateMethod() != null) {
                data.set("updateMethod", om.valueToTree(this.getUpdateMethod()));
            }
            if (this.getVersionName() != null) {
                data.set("versionName", om.valueToTree(this.getVersionName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ssm.CfnDocumentProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDocumentProps.Jsii$Proxy that = (CfnDocumentProps.Jsii$Proxy) o;

            if (!content.equals(that.content)) return false;
            if (this.attachments != null ? !this.attachments.equals(that.attachments) : that.attachments != null) return false;
            if (this.documentFormat != null ? !this.documentFormat.equals(that.documentFormat) : that.documentFormat != null) return false;
            if (this.documentType != null ? !this.documentType.equals(that.documentType) : that.documentType != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.requires != null ? !this.requires.equals(that.requires) : that.requires != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.targetType != null ? !this.targetType.equals(that.targetType) : that.targetType != null) return false;
            if (this.updateMethod != null ? !this.updateMethod.equals(that.updateMethod) : that.updateMethod != null) return false;
            return this.versionName != null ? this.versionName.equals(that.versionName) : that.versionName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.content.hashCode();
            result = 31 * result + (this.attachments != null ? this.attachments.hashCode() : 0);
            result = 31 * result + (this.documentFormat != null ? this.documentFormat.hashCode() : 0);
            result = 31 * result + (this.documentType != null ? this.documentType.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.requires != null ? this.requires.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.targetType != null ? this.targetType.hashCode() : 0);
            result = 31 * result + (this.updateMethod != null ? this.updateMethod.hashCode() : 0);
            result = 31 * result + (this.versionName != null ? this.versionName.hashCode() : 0);
            return result;
        }
    }
}
