/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnStack;
import software.amazon.awscdk.CfnStackProps;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.ITaggable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.CfnStack")
public class CfnStack
extends CfnResource
implements IInspectable,
ITaggable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnStack.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnStack(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnStack(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnStack(@NotNull Construct scope, @NotNull String id, @Nullable CfnStackProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public CfnStack(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrChangeSetId() {
        return (String)Kernel.get((Object)this, (String)"attrChangeSetId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrCreationTime() {
        return (String)Kernel.get((Object)this, (String)"attrCreationTime", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrLastUpdateTime() {
        return (String)Kernel.get((Object)this, (String)"attrLastUpdateTime", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public IResolvable getAttrOutputs() {
        return (IResolvable)Kernel.get((Object)this, (String)"attrOutputs", (NativeType)NativeType.forClass(IResolvable.class));
    }

    @NotNull
    public String getAttrParentId() {
        return (String)Kernel.get((Object)this, (String)"attrParentId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrRootId() {
        return (String)Kernel.get((Object)this, (String)"attrRootId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrStackId() {
        return (String)Kernel.get((Object)this, (String)"attrStackId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrStackStatus() {
        return (String)Kernel.get((Object)this, (String)"attrStackStatus", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @Override
    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @Nullable
    public List<String> getNotificationArns() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"notificationArns", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setNotificationArns(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"notificationArns", value);
    }

    @Nullable
    public Object getParameters() {
        return Kernel.get((Object)this, (String)"parameters", (NativeType)NativeType.forClass(Object.class));
    }

    public void setParameters(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"parameters", (Object)value);
    }

    public void setParameters(@Nullable Map<String, String> value) {
        Kernel.set((Object)this, (String)"parameters", value);
    }

    @Nullable
    public List<CfnTag> getTagsRaw() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"tagsRaw", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(CfnTag.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setTagsRaw(@Nullable List<CfnTag> value) {
        Kernel.set((Object)this, (String)"tagsRaw", value);
    }

    @Nullable
    public String getTemplateUrl() {
        return (String)Kernel.get((Object)this, (String)"templateUrl", (NativeType)NativeType.forClass(String.class));
    }

    public void setTemplateUrl(@Nullable String value) {
        Kernel.set((Object)this, (String)"templateUrl", (Object)value);
    }

    @Nullable
    public Number getTimeoutInMinutes() {
        return (Number)Kernel.get((Object)this, (String)"timeoutInMinutes", (NativeType)NativeType.forClass(Number.class));
    }

    public void setTimeoutInMinutes(@Nullable Number value) {
        Kernel.set((Object)this, (String)"timeoutInMinutes", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnStack> {
        private final Construct scope;
        private final String id;
        private CfnStackProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder notificationArns(List<String> notificationArns) {
            this.props().notificationArns(notificationArns);
            return this;
        }

        public Builder parameters(IResolvable parameters) {
            this.props().parameters(parameters);
            return this;
        }

        public Builder parameters(Map<String, String> parameters) {
            this.props().parameters(parameters);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        public Builder templateUrl(String templateUrl) {
            this.props().templateUrl(templateUrl);
            return this;
        }

        public Builder timeoutInMinutes(Number timeoutInMinutes) {
            this.props().timeoutInMinutes(timeoutInMinutes);
            return this;
        }

        public CfnStack build() {
            return new CfnStack(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private CfnStackProps.Builder props() {
            if (this.props == null) {
                this.props = new CfnStackProps.Builder();
            }
            return this.props;
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.CfnStack.OutputProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OutputProperty
    extends JsiiSerializable {
        @Nullable
        default public String getDescription() {
            return null;
        }

        @Nullable
        default public String getExportName() {
            return null;
        }

        @Nullable
        default public String getOutputKey() {
            return null;
        }

        @Nullable
        default public String getOutputValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OutputProperty> {
            String description;
            String exportName;
            String outputKey;
            String outputValue;

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder exportName(String exportName) {
                this.exportName = exportName;
                return this;
            }

            public Builder outputKey(String outputKey) {
                this.outputKey = outputKey;
                return this;
            }

            public Builder outputValue(String outputValue) {
                this.outputValue = outputValue;
                return this;
            }

            public OutputProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

