/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.apigatewayv2;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.apigatewayv2.AddRoutesOptions;
import software.amazon.awscdk.services.apigatewayv2.CorsPreflightOptions;
import software.amazon.awscdk.services.apigatewayv2.DomainMappingOptions;
import software.amazon.awscdk.services.apigatewayv2.HttpApiAttributes;
import software.amazon.awscdk.services.apigatewayv2.HttpApiProps;
import software.amazon.awscdk.services.apigatewayv2.HttpRoute;
import software.amazon.awscdk.services.apigatewayv2.HttpRouteIntegration;
import software.amazon.awscdk.services.apigatewayv2.HttpStage;
import software.amazon.awscdk.services.apigatewayv2.HttpStageOptions;
import software.amazon.awscdk.services.apigatewayv2.IApi;
import software.amazon.awscdk.services.apigatewayv2.IHttpApi;
import software.amazon.awscdk.services.apigatewayv2.IHttpRouteAuthorizer;
import software.amazon.awscdk.services.apigatewayv2.IHttpStage;
import software.amazon.awscdk.services.apigatewayv2.VpcLink;
import software.amazon.awscdk.services.apigatewayv2.VpcLinkProps;
import software.amazon.awscdk.services.cloudwatch.Metric;
import software.amazon.awscdk.services.cloudwatch.MetricOptions;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_apigatewayv2.HttpApi")
public class HttpApi
extends Resource
implements IHttpApi,
IApi {
    protected HttpApi(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected HttpApi(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public HttpApi(@NotNull Construct scope, @NotNull String id, @Nullable HttpApiProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public HttpApi(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public static IHttpApi fromHttpApiAttributes(@NotNull Construct scope, @NotNull String id, @NotNull HttpApiAttributes attrs) {
        return (IHttpApi)JsiiObject.jsiiStaticCall(HttpApi.class, (String)"fromHttpApiAttributes", (NativeType)NativeType.forClass(IHttpApi.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @NotNull
    public List<HttpRoute> addRoutes(@NotNull AddRoutesOptions options) {
        return Collections.unmodifiableList((List)Kernel.call((Object)this, (String)"addRoutes", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(HttpRoute.class)), (Object[])new Object[]{Objects.requireNonNull(options, "options is required")}));
    }

    @NotNull
    public HttpStage addStage(@NotNull String id, @NotNull HttpStageOptions options) {
        return (HttpStage)Kernel.call((Object)this, (String)"addStage", (NativeType)NativeType.forClass(HttpStage.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(options, "options is required")});
    }

    @Override
    @NotNull
    public VpcLink addVpcLink(@NotNull VpcLinkProps options) {
        return (VpcLink)Kernel.call((Object)this, (String)"addVpcLink", (NativeType)NativeType.forClass(VpcLink.class), (Object[])new Object[]{Objects.requireNonNull(options, "options is required")});
    }

    @Override
    @NotNull
    public String arnForExecuteApi(@Nullable String method, @Nullable String path, @Nullable String stage) {
        return (String)Kernel.call((Object)this, (String)"arnForExecuteApi", (NativeType)NativeType.forClass(String.class), (Object[])new Object[]{method, path, stage});
    }

    @Override
    @NotNull
    public String arnForExecuteApi(@Nullable String method, @Nullable String path) {
        return (String)Kernel.call((Object)this, (String)"arnForExecuteApi", (NativeType)NativeType.forClass(String.class), (Object[])new Object[]{method, path});
    }

    @Override
    @NotNull
    public String arnForExecuteApi(@Nullable String method) {
        return (String)Kernel.call((Object)this, (String)"arnForExecuteApi", (NativeType)NativeType.forClass(String.class), (Object[])new Object[]{method});
    }

    @Override
    @NotNull
    public String arnForExecuteApi() {
        return (String)Kernel.call((Object)this, (String)"arnForExecuteApi", (NativeType)NativeType.forClass(String.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metric(@NotNull String metricName, @Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metric", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(metricName, "metricName is required"), props});
    }

    @Override
    @NotNull
    public Metric metric(@NotNull String metricName) {
        return (Metric)Kernel.call((Object)this, (String)"metric", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(metricName, "metricName is required")});
    }

    @Override
    @NotNull
    public Metric metricClientError(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricClientError", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricClientError() {
        return (Metric)Kernel.call((Object)this, (String)"metricClientError", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricCount(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricCount", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricCount() {
        return (Metric)Kernel.call((Object)this, (String)"metricCount", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricDataProcessed(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricDataProcessed", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricDataProcessed() {
        return (Metric)Kernel.call((Object)this, (String)"metricDataProcessed", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricIntegrationLatency(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricIntegrationLatency", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricIntegrationLatency() {
        return (Metric)Kernel.call((Object)this, (String)"metricIntegrationLatency", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricLatency(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricLatency", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricLatency() {
        return (Metric)Kernel.call((Object)this, (String)"metricLatency", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricServerError(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricServerError", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricServerError() {
        return (Metric)Kernel.call((Object)this, (String)"metricServerError", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public String getApiEndpoint() {
        return (String)Kernel.get((Object)this, (String)"apiEndpoint", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getApiId() {
        return (String)Kernel.get((Object)this, (String)"apiId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getHttpApiId() {
        return (String)Kernel.get((Object)this, (String)"httpApiId", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @Nullable
    public List<String> getDefaultAuthorizationScopes() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"defaultAuthorizationScopes", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    @Override
    @Nullable
    public IHttpRouteAuthorizer getDefaultAuthorizer() {
        return (IHttpRouteAuthorizer)Kernel.get((Object)this, (String)"defaultAuthorizer", (NativeType)NativeType.forClass(IHttpRouteAuthorizer.class));
    }

    @Nullable
    public IHttpStage getDefaultStage() {
        return (IHttpStage)Kernel.get((Object)this, (String)"defaultStage", (NativeType)NativeType.forClass(IHttpStage.class));
    }

    @Nullable
    public Boolean getDisableExecuteApiEndpoint() {
        return (Boolean)Kernel.get((Object)this, (String)"disableExecuteApiEndpoint", (NativeType)NativeType.forClass(Boolean.class));
    }

    @Nullable
    public String getHttpApiName() {
        return (String)Kernel.get((Object)this, (String)"httpApiName", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    public String getUrl() {
        return (String)Kernel.get((Object)this, (String)"url", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<HttpApi> {
        private final Construct scope;
        private final String id;
        private HttpApiProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder apiName(String apiName) {
            this.props().apiName(apiName);
            return this;
        }

        public Builder corsPreflight(CorsPreflightOptions corsPreflight) {
            this.props().corsPreflight(corsPreflight);
            return this;
        }

        public Builder createDefaultStage(Boolean createDefaultStage) {
            this.props().createDefaultStage(createDefaultStage);
            return this;
        }

        public Builder defaultAuthorizationScopes(List<String> defaultAuthorizationScopes) {
            this.props().defaultAuthorizationScopes(defaultAuthorizationScopes);
            return this;
        }

        public Builder defaultAuthorizer(IHttpRouteAuthorizer defaultAuthorizer) {
            this.props().defaultAuthorizer(defaultAuthorizer);
            return this;
        }

        public Builder defaultDomainMapping(DomainMappingOptions defaultDomainMapping) {
            this.props().defaultDomainMapping(defaultDomainMapping);
            return this;
        }

        public Builder defaultIntegration(HttpRouteIntegration defaultIntegration) {
            this.props().defaultIntegration(defaultIntegration);
            return this;
        }

        public Builder description(String description) {
            this.props().description(description);
            return this;
        }

        public Builder disableExecuteApiEndpoint(Boolean disableExecuteApiEndpoint) {
            this.props().disableExecuteApiEndpoint(disableExecuteApiEndpoint);
            return this;
        }

        public HttpApi build() {
            return new HttpApi(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private HttpApiProps.Builder props() {
            if (this.props == null) {
                this.props = new HttpApiProps.Builder();
            }
            return this.props;
        }
    }
}

