/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.dynamodb;

import java.util.List;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.RemovalPolicy;
import software.amazon.awscdk.services.dynamodb.Attribute;
import software.amazon.awscdk.services.dynamodb.BillingMode;
import software.amazon.awscdk.services.dynamodb.ImportSourceSpecification;
import software.amazon.awscdk.services.dynamodb.StreamViewType;
import software.amazon.awscdk.services.dynamodb.TableClass;
import software.amazon.awscdk.services.dynamodb.TableEncryption;
import software.amazon.awscdk.services.dynamodb.TableOptions;
import software.amazon.awscdk.services.dynamodb.TableProps;
import software.amazon.awscdk.services.kinesis.IStream;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_dynamodb.TableProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface TableProps
extends JsiiSerializable,
TableOptions {
    @Nullable
    default public IStream getKinesisStream() {
        return null;
    }

    @Nullable
    default public String getTableName() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<TableProps> {
        IStream kinesisStream;
        String tableName;
        BillingMode billingMode;
        Boolean contributorInsightsEnabled;
        Boolean deletionProtection;
        TableEncryption encryption;
        IKey encryptionKey;
        ImportSourceSpecification importSource;
        Boolean pointInTimeRecovery;
        Number readCapacity;
        RemovalPolicy removalPolicy;
        List<String> replicationRegions;
        Duration replicationTimeout;
        StreamViewType stream;
        TableClass tableClass;
        String timeToLiveAttribute;
        Boolean waitForReplicationToFinish;
        Number writeCapacity;
        Attribute partitionKey;
        Attribute sortKey;

        public Builder kinesisStream(IStream kinesisStream) {
            this.kinesisStream = kinesisStream;
            return this;
        }

        public Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder billingMode(BillingMode billingMode) {
            this.billingMode = billingMode;
            return this;
        }

        public Builder contributorInsightsEnabled(Boolean contributorInsightsEnabled) {
            this.contributorInsightsEnabled = contributorInsightsEnabled;
            return this;
        }

        public Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public Builder encryption(TableEncryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public Builder encryptionKey(IKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public Builder importSource(ImportSourceSpecification importSource) {
            this.importSource = importSource;
            return this;
        }

        public Builder pointInTimeRecovery(Boolean pointInTimeRecovery) {
            this.pointInTimeRecovery = pointInTimeRecovery;
            return this;
        }

        public Builder readCapacity(Number readCapacity) {
            this.readCapacity = readCapacity;
            return this;
        }

        public Builder removalPolicy(RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        public Builder replicationRegions(List<String> replicationRegions) {
            this.replicationRegions = replicationRegions;
            return this;
        }

        public Builder replicationTimeout(Duration replicationTimeout) {
            this.replicationTimeout = replicationTimeout;
            return this;
        }

        public Builder stream(StreamViewType stream) {
            this.stream = stream;
            return this;
        }

        public Builder tableClass(TableClass tableClass) {
            this.tableClass = tableClass;
            return this;
        }

        public Builder timeToLiveAttribute(String timeToLiveAttribute) {
            this.timeToLiveAttribute = timeToLiveAttribute;
            return this;
        }

        public Builder waitForReplicationToFinish(Boolean waitForReplicationToFinish) {
            this.waitForReplicationToFinish = waitForReplicationToFinish;
            return this;
        }

        public Builder writeCapacity(Number writeCapacity) {
            this.writeCapacity = writeCapacity;
            return this;
        }

        public Builder partitionKey(Attribute partitionKey) {
            this.partitionKey = partitionKey;
            return this;
        }

        public Builder sortKey(Attribute sortKey) {
            this.sortKey = sortKey;
            return this;
        }

        public TableProps build() {
            return new Jsii.Proxy(this);
        }
    }
}

