/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.events;

import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.events.Authorization;
import software.amazon.awscdk.services.events.ConnectionAttributes;
import software.amazon.awscdk.services.events.ConnectionProps;
import software.amazon.awscdk.services.events.HttpParameter;
import software.amazon.awscdk.services.events.IConnection;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_events.Connection")
public class Connection
extends Resource
implements IConnection {
    protected Connection(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Connection(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Connection(@NotNull Construct scope, @NotNull String id, @NotNull ConnectionProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IConnection fromConnectionAttributes(@NotNull Construct scope, @NotNull String id, @NotNull ConnectionAttributes attrs) {
        return (IConnection)JsiiObject.jsiiStaticCall(Connection.class, (String)"fromConnectionAttributes", (NativeType)NativeType.forClass(IConnection.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @NotNull
    public static IConnection fromEventBusArn(@NotNull Construct scope, @NotNull String id, @NotNull String connectionArn, @NotNull String connectionSecretArn) {
        return (IConnection)JsiiObject.jsiiStaticCall(Connection.class, (String)"fromEventBusArn", (NativeType)NativeType.forClass(IConnection.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(connectionArn, "connectionArn is required"), Objects.requireNonNull(connectionSecretArn, "connectionSecretArn is required")});
    }

    @Override
    @NotNull
    public String getConnectionArn() {
        return (String)Kernel.get((Object)this, (String)"connectionArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getConnectionName() {
        return (String)Kernel.get((Object)this, (String)"connectionName", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getConnectionSecretArn() {
        return (String)Kernel.get((Object)this, (String)"connectionSecretArn", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Connection> {
        private final Construct scope;
        private final String id;
        private final ConnectionProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new ConnectionProps.Builder();
        }

        public Builder authorization(Authorization authorization) {
            this.props.authorization(authorization);
            return this;
        }

        public Builder bodyParameters(Map<String, ? extends HttpParameter> bodyParameters) {
            this.props.bodyParameters(bodyParameters);
            return this;
        }

        public Builder connectionName(String connectionName) {
            this.props.connectionName(connectionName);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder headerParameters(Map<String, ? extends HttpParameter> headerParameters) {
            this.props.headerParameters(headerParameters);
            return this;
        }

        public Builder queryStringParameters(Map<String, ? extends HttpParameter> queryStringParameters) {
            this.props.queryStringParameters(queryStringParameters);
            return this;
        }

        public Connection build() {
            return new Connection(this.scope, this.id, this.props.build());
        }
    }
}

