/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.servicediscovery;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.ITaggable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.servicediscovery.CfnService;
import software.amazon.awscdk.services.servicediscovery.CfnServiceProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_servicediscovery.CfnService")
public class CfnService
extends CfnResource
implements IInspectable,
ITaggable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnService.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnService(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnService(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnService(@NotNull Construct scope, @NotNull String id, @Nullable CfnServiceProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public CfnService(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)this, (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrId() {
        return (String)Kernel.get((Object)this, (String)"attrId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrName() {
        return (String)Kernel.get((Object)this, (String)"attrName", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @Override
    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @Nullable
    public String getDescription() {
        return (String)Kernel.get((Object)this, (String)"description", (NativeType)NativeType.forClass(String.class));
    }

    public void setDescription(@Nullable String value) {
        Kernel.set((Object)this, (String)"description", (Object)value);
    }

    @Nullable
    public Object getDnsConfig() {
        return Kernel.get((Object)this, (String)"dnsConfig", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDnsConfig(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"dnsConfig", (Object)value);
    }

    public void setDnsConfig(@Nullable DnsConfigProperty value) {
        Kernel.set((Object)this, (String)"dnsConfig", (Object)value);
    }

    @Nullable
    public Object getHealthCheckConfig() {
        return Kernel.get((Object)this, (String)"healthCheckConfig", (NativeType)NativeType.forClass(Object.class));
    }

    public void setHealthCheckConfig(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"healthCheckConfig", (Object)value);
    }

    public void setHealthCheckConfig(@Nullable HealthCheckConfigProperty value) {
        Kernel.set((Object)this, (String)"healthCheckConfig", (Object)value);
    }

    @Nullable
    public Object getHealthCheckCustomConfig() {
        return Kernel.get((Object)this, (String)"healthCheckCustomConfig", (NativeType)NativeType.forClass(Object.class));
    }

    public void setHealthCheckCustomConfig(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"healthCheckCustomConfig", (Object)value);
    }

    public void setHealthCheckCustomConfig(@Nullable HealthCheckCustomConfigProperty value) {
        Kernel.set((Object)this, (String)"healthCheckCustomConfig", (Object)value);
    }

    @Nullable
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@Nullable String value) {
        Kernel.set((Object)this, (String)"name", (Object)value);
    }

    @Nullable
    public String getNamespaceId() {
        return (String)Kernel.get((Object)this, (String)"namespaceId", (NativeType)NativeType.forClass(String.class));
    }

    public void setNamespaceId(@Nullable String value) {
        Kernel.set((Object)this, (String)"namespaceId", (Object)value);
    }

    @Nullable
    public List<CfnTag> getTagsRaw() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"tagsRaw", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(CfnTag.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setTagsRaw(@Nullable List<CfnTag> value) {
        Kernel.set((Object)this, (String)"tagsRaw", value);
    }

    @Nullable
    public String getType() {
        return (String)Kernel.get((Object)this, (String)"type", (NativeType)NativeType.forClass(String.class));
    }

    public void setType(@Nullable String value) {
        Kernel.set((Object)this, (String)"type", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnService> {
        private final Construct scope;
        private final String id;
        private CfnServiceProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder description(String description) {
            this.props().description(description);
            return this;
        }

        public Builder dnsConfig(IResolvable dnsConfig) {
            this.props().dnsConfig(dnsConfig);
            return this;
        }

        public Builder dnsConfig(DnsConfigProperty dnsConfig) {
            this.props().dnsConfig(dnsConfig);
            return this;
        }

        public Builder healthCheckConfig(IResolvable healthCheckConfig) {
            this.props().healthCheckConfig(healthCheckConfig);
            return this;
        }

        public Builder healthCheckConfig(HealthCheckConfigProperty healthCheckConfig) {
            this.props().healthCheckConfig(healthCheckConfig);
            return this;
        }

        public Builder healthCheckCustomConfig(IResolvable healthCheckCustomConfig) {
            this.props().healthCheckCustomConfig(healthCheckCustomConfig);
            return this;
        }

        public Builder healthCheckCustomConfig(HealthCheckCustomConfigProperty healthCheckCustomConfig) {
            this.props().healthCheckCustomConfig(healthCheckCustomConfig);
            return this;
        }

        public Builder name(String name) {
            this.props().name(name);
            return this;
        }

        public Builder namespaceId(String namespaceId) {
            this.props().namespaceId(namespaceId);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        public Builder type(String type) {
            this.props().type(type);
            return this;
        }

        public CfnService build() {
            return new CfnService(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private CfnServiceProps.Builder props() {
            if (this.props == null) {
                this.props = new CfnServiceProps.Builder();
            }
            return this.props;
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_servicediscovery.CfnService.HealthCheckCustomConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface HealthCheckCustomConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getFailureThreshold() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<HealthCheckCustomConfigProperty> {
            Number failureThreshold;

            public Builder failureThreshold(Number failureThreshold) {
                this.failureThreshold = failureThreshold;
                return this;
            }

            public HealthCheckCustomConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_servicediscovery.CfnService.HealthCheckConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface HealthCheckConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getType();

        @Nullable
        default public Number getFailureThreshold() {
            return null;
        }

        @Nullable
        default public String getResourcePath() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<HealthCheckConfigProperty> {
            String type;
            Number failureThreshold;
            String resourcePath;

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder failureThreshold(Number failureThreshold) {
                this.failureThreshold = failureThreshold;
                return this;
            }

            public Builder resourcePath(String resourcePath) {
                this.resourcePath = resourcePath;
                return this;
            }

            public HealthCheckConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_servicediscovery.CfnService.DnsRecordProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DnsRecordProperty
    extends JsiiSerializable {
        @NotNull
        public Number getTtl();

        @NotNull
        public String getType();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DnsRecordProperty> {
            Number ttl;
            String type;

            public Builder ttl(Number ttl) {
                this.ttl = ttl;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public DnsRecordProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_servicediscovery.CfnService.DnsConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DnsConfigProperty
    extends JsiiSerializable {
        @NotNull
        public Object getDnsRecords();

        @Nullable
        default public String getNamespaceId() {
            return null;
        }

        @Nullable
        default public String getRoutingPolicy() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DnsConfigProperty> {
            Object dnsRecords;
            String namespaceId;
            String routingPolicy;

            public Builder dnsRecords(IResolvable dnsRecords) {
                this.dnsRecords = dnsRecords;
                return this;
            }

            public Builder dnsRecords(List<? extends Object> dnsRecords) {
                this.dnsRecords = dnsRecords;
                return this;
            }

            public Builder namespaceId(String namespaceId) {
                this.namespaceId = namespaceId;
                return this;
            }

            public Builder routingPolicy(String routingPolicy) {
                this.routingPolicy = routingPolicy;
                return this;
            }

            public DnsConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

