/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.workspaces;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.ITaggable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.workspaces.CfnWorkspace;
import software.amazon.awscdk.services.workspaces.CfnWorkspaceProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_workspaces.CfnWorkspace")
public class CfnWorkspace
extends CfnResource
implements IInspectable,
ITaggable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnWorkspace.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnWorkspace(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnWorkspace(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnWorkspace(@NotNull Construct scope, @NotNull String id, @NotNull CfnWorkspaceProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrId() {
        return (String)Kernel.get((Object)this, (String)"attrId", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @Override
    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public String getBundleId() {
        return (String)Kernel.get((Object)this, (String)"bundleId", (NativeType)NativeType.forClass(String.class));
    }

    public void setBundleId(@NotNull String value) {
        Kernel.set((Object)this, (String)"bundleId", (Object)Objects.requireNonNull(value, "bundleId is required"));
    }

    @NotNull
    public String getDirectoryId() {
        return (String)Kernel.get((Object)this, (String)"directoryId", (NativeType)NativeType.forClass(String.class));
    }

    public void setDirectoryId(@NotNull String value) {
        Kernel.set((Object)this, (String)"directoryId", (Object)Objects.requireNonNull(value, "directoryId is required"));
    }

    @NotNull
    public String getUserName() {
        return (String)Kernel.get((Object)this, (String)"userName", (NativeType)NativeType.forClass(String.class));
    }

    public void setUserName(@NotNull String value) {
        Kernel.set((Object)this, (String)"userName", (Object)Objects.requireNonNull(value, "userName is required"));
    }

    @Nullable
    public Object getRootVolumeEncryptionEnabled() {
        return Kernel.get((Object)this, (String)"rootVolumeEncryptionEnabled", (NativeType)NativeType.forClass(Object.class));
    }

    public void setRootVolumeEncryptionEnabled(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"rootVolumeEncryptionEnabled", (Object)value);
    }

    public void setRootVolumeEncryptionEnabled(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"rootVolumeEncryptionEnabled", (Object)value);
    }

    @Nullable
    public List<CfnTag> getTagsRaw() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"tagsRaw", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(CfnTag.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setTagsRaw(@Nullable List<CfnTag> value) {
        Kernel.set((Object)this, (String)"tagsRaw", value);
    }

    @Nullable
    public Object getUserVolumeEncryptionEnabled() {
        return Kernel.get((Object)this, (String)"userVolumeEncryptionEnabled", (NativeType)NativeType.forClass(Object.class));
    }

    public void setUserVolumeEncryptionEnabled(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"userVolumeEncryptionEnabled", (Object)value);
    }

    public void setUserVolumeEncryptionEnabled(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"userVolumeEncryptionEnabled", (Object)value);
    }

    @Nullable
    public String getVolumeEncryptionKey() {
        return (String)Kernel.get((Object)this, (String)"volumeEncryptionKey", (NativeType)NativeType.forClass(String.class));
    }

    public void setVolumeEncryptionKey(@Nullable String value) {
        Kernel.set((Object)this, (String)"volumeEncryptionKey", (Object)value);
    }

    @Nullable
    public Object getWorkspaceProperties() {
        return Kernel.get((Object)this, (String)"workspaceProperties", (NativeType)NativeType.forClass(Object.class));
    }

    public void setWorkspaceProperties(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"workspaceProperties", (Object)value);
    }

    public void setWorkspaceProperties(@Nullable WorkspacePropertiesProperty value) {
        Kernel.set((Object)this, (String)"workspaceProperties", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnWorkspace> {
        private final Construct scope;
        private final String id;
        private final CfnWorkspaceProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnWorkspaceProps.Builder();
        }

        public Builder bundleId(String bundleId) {
            this.props.bundleId(bundleId);
            return this;
        }

        public Builder directoryId(String directoryId) {
            this.props.directoryId(directoryId);
            return this;
        }

        public Builder userName(String userName) {
            this.props.userName(userName);
            return this;
        }

        public Builder rootVolumeEncryptionEnabled(Boolean rootVolumeEncryptionEnabled) {
            this.props.rootVolumeEncryptionEnabled(rootVolumeEncryptionEnabled);
            return this;
        }

        public Builder rootVolumeEncryptionEnabled(IResolvable rootVolumeEncryptionEnabled) {
            this.props.rootVolumeEncryptionEnabled(rootVolumeEncryptionEnabled);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder userVolumeEncryptionEnabled(Boolean userVolumeEncryptionEnabled) {
            this.props.userVolumeEncryptionEnabled(userVolumeEncryptionEnabled);
            return this;
        }

        public Builder userVolumeEncryptionEnabled(IResolvable userVolumeEncryptionEnabled) {
            this.props.userVolumeEncryptionEnabled(userVolumeEncryptionEnabled);
            return this;
        }

        public Builder volumeEncryptionKey(String volumeEncryptionKey) {
            this.props.volumeEncryptionKey(volumeEncryptionKey);
            return this;
        }

        public Builder workspaceProperties(IResolvable workspaceProperties) {
            this.props.workspaceProperties(workspaceProperties);
            return this;
        }

        public Builder workspaceProperties(WorkspacePropertiesProperty workspaceProperties) {
            this.props.workspaceProperties(workspaceProperties);
            return this;
        }

        public CfnWorkspace build() {
            return new CfnWorkspace(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_workspaces.CfnWorkspace.WorkspacePropertiesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface WorkspacePropertiesProperty
    extends JsiiSerializable {
        @Nullable
        default public String getComputeTypeName() {
            return null;
        }

        @Nullable
        default public Number getRootVolumeSizeGib() {
            return null;
        }

        @Nullable
        default public String getRunningMode() {
            return null;
        }

        @Nullable
        default public Number getRunningModeAutoStopTimeoutInMinutes() {
            return null;
        }

        @Nullable
        default public Number getUserVolumeSizeGib() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<WorkspacePropertiesProperty> {
            String computeTypeName;
            Number rootVolumeSizeGib;
            String runningMode;
            Number runningModeAutoStopTimeoutInMinutes;
            Number userVolumeSizeGib;

            public Builder computeTypeName(String computeTypeName) {
                this.computeTypeName = computeTypeName;
                return this;
            }

            public Builder rootVolumeSizeGib(Number rootVolumeSizeGib) {
                this.rootVolumeSizeGib = rootVolumeSizeGib;
                return this;
            }

            public Builder runningMode(String runningMode) {
                this.runningMode = runningMode;
                return this;
            }

            public Builder runningModeAutoStopTimeoutInMinutes(Number runningModeAutoStopTimeoutInMinutes) {
                this.runningModeAutoStopTimeoutInMinutes = runningModeAutoStopTimeoutInMinutes;
                return this;
            }

            public Builder userVolumeSizeGib(Number userVolumeSizeGib) {
                this.userVolumeSizeGib = userVolumeSizeGib;
                return this;
            }

            public WorkspacePropertiesProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

