/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.alexaforbusiness.model.ConnectionStatus;
import software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetail;
import software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetailsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeviceStatusInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeviceStatusInfo> {
    private static final SdkField<List<DeviceStatusDetail>> DEVICE_STATUS_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DeviceStatusInfo.getter(DeviceStatusInfo::deviceStatusDetails)).setter(DeviceStatusInfo.setter(Builder::deviceStatusDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceStatusDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DeviceStatusDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CONNECTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeviceStatusInfo.getter(DeviceStatusInfo::connectionStatusAsString)).setter(DeviceStatusInfo.setter(Builder::connectionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionStatus").build()}).build();
    private static final SdkField<Instant> CONNECTION_STATUS_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DeviceStatusInfo.getter(DeviceStatusInfo::connectionStatusUpdatedTime)).setter(DeviceStatusInfo.setter(Builder::connectionStatusUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionStatusUpdatedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_STATUS_DETAILS_FIELD, CONNECTION_STATUS_FIELD, CONNECTION_STATUS_UPDATED_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<DeviceStatusDetail> deviceStatusDetails;
    private final String connectionStatus;
    private final Instant connectionStatusUpdatedTime;

    private DeviceStatusInfo(BuilderImpl builder) {
        this.deviceStatusDetails = builder.deviceStatusDetails;
        this.connectionStatus = builder.connectionStatus;
        this.connectionStatusUpdatedTime = builder.connectionStatusUpdatedTime;
    }

    public boolean hasDeviceStatusDetails() {
        return this.deviceStatusDetails != null && !(this.deviceStatusDetails instanceof SdkAutoConstructList);
    }

    public List<DeviceStatusDetail> deviceStatusDetails() {
        return this.deviceStatusDetails;
    }

    public ConnectionStatus connectionStatus() {
        return ConnectionStatus.fromValue(this.connectionStatus);
    }

    public String connectionStatusAsString() {
        return this.connectionStatus;
    }

    public Instant connectionStatusUpdatedTime() {
        return this.connectionStatusUpdatedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceStatusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionStatusUpdatedTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceStatusInfo)) {
            return false;
        }
        DeviceStatusInfo other = (DeviceStatusInfo)obj;
        return Objects.equals(this.deviceStatusDetails(), other.deviceStatusDetails()) && Objects.equals(this.connectionStatusAsString(), other.connectionStatusAsString()) && Objects.equals(this.connectionStatusUpdatedTime(), other.connectionStatusUpdatedTime());
    }

    public String toString() {
        return ToString.builder((String)"DeviceStatusInfo").add("DeviceStatusDetails", this.deviceStatusDetails()).add("ConnectionStatus", (Object)this.connectionStatusAsString()).add("ConnectionStatusUpdatedTime", (Object)this.connectionStatusUpdatedTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeviceStatusDetails": {
                return Optional.ofNullable(clazz.cast(this.deviceStatusDetails()));
            }
            case "ConnectionStatus": {
                return Optional.ofNullable(clazz.cast(this.connectionStatusAsString()));
            }
            case "ConnectionStatusUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.connectionStatusUpdatedTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeviceStatusInfo, T> g) {
        return obj -> g.apply((DeviceStatusInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<DeviceStatusDetail> deviceStatusDetails = DefaultSdkAutoConstructList.getInstance();
        private String connectionStatus;
        private Instant connectionStatusUpdatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceStatusInfo model) {
            this.deviceStatusDetails(model.deviceStatusDetails);
            this.connectionStatus(model.connectionStatus);
            this.connectionStatusUpdatedTime(model.connectionStatusUpdatedTime);
        }

        public final Collection<DeviceStatusDetail.Builder> getDeviceStatusDetails() {
            return this.deviceStatusDetails != null ? (Collection)this.deviceStatusDetails.stream().map(DeviceStatusDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder deviceStatusDetails(Collection<DeviceStatusDetail> deviceStatusDetails) {
            this.deviceStatusDetails = DeviceStatusDetailsCopier.copy(deviceStatusDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceStatusDetails(DeviceStatusDetail ... deviceStatusDetails) {
            this.deviceStatusDetails(Arrays.asList(deviceStatusDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceStatusDetails(Consumer<DeviceStatusDetail.Builder> ... deviceStatusDetails) {
            this.deviceStatusDetails(Stream.of(deviceStatusDetails).map(c -> (DeviceStatusDetail)((DeviceStatusDetail.Builder)DeviceStatusDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDeviceStatusDetails(Collection<DeviceStatusDetail.BuilderImpl> deviceStatusDetails) {
            this.deviceStatusDetails = DeviceStatusDetailsCopier.copyFromBuilder(deviceStatusDetails);
        }

        public final String getConnectionStatus() {
            return this.connectionStatus;
        }

        @Override
        public final Builder connectionStatus(String connectionStatus) {
            this.connectionStatus = connectionStatus;
            return this;
        }

        @Override
        public final Builder connectionStatus(ConnectionStatus connectionStatus) {
            this.connectionStatus(connectionStatus == null ? null : connectionStatus.toString());
            return this;
        }

        public final void setConnectionStatus(String connectionStatus) {
            this.connectionStatus = connectionStatus;
        }

        public final Instant getConnectionStatusUpdatedTime() {
            return this.connectionStatusUpdatedTime;
        }

        @Override
        public final Builder connectionStatusUpdatedTime(Instant connectionStatusUpdatedTime) {
            this.connectionStatusUpdatedTime = connectionStatusUpdatedTime;
            return this;
        }

        public final void setConnectionStatusUpdatedTime(Instant connectionStatusUpdatedTime) {
            this.connectionStatusUpdatedTime = connectionStatusUpdatedTime;
        }

        public DeviceStatusInfo build() {
            return new DeviceStatusInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeviceStatusInfo> {
        public Builder deviceStatusDetails(Collection<DeviceStatusDetail> var1);

        public Builder deviceStatusDetails(DeviceStatusDetail ... var1);

        public Builder deviceStatusDetails(Consumer<DeviceStatusDetail.Builder> ... var1);

        public Builder connectionStatus(String var1);

        public Builder connectionStatus(ConnectionStatus var1);

        public Builder connectionStatusUpdatedTime(Instant var1);
    }
}

