/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.alexaforbusiness.model.EndOfMeetingReminderMinutesListCopier;
import software.amazon.awssdk.services.alexaforbusiness.model.EndOfMeetingReminderType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EndOfMeetingReminder
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EndOfMeetingReminder> {
    private static final SdkField<List<Integer>> REMINDER_AT_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(EndOfMeetingReminder.getter(EndOfMeetingReminder::reminderAtMinutes)).setter(EndOfMeetingReminder.setter(Builder::reminderAtMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReminderAtMinutes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> REMINDER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(EndOfMeetingReminder.getter(EndOfMeetingReminder::reminderTypeAsString)).setter(EndOfMeetingReminder.setter(Builder::reminderType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReminderType").build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(EndOfMeetingReminder.getter(EndOfMeetingReminder::enabled)).setter(EndOfMeetingReminder.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REMINDER_AT_MINUTES_FIELD, REMINDER_TYPE_FIELD, ENABLED_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<Integer> reminderAtMinutes;
    private final String reminderType;
    private final Boolean enabled;

    private EndOfMeetingReminder(BuilderImpl builder) {
        this.reminderAtMinutes = builder.reminderAtMinutes;
        this.reminderType = builder.reminderType;
        this.enabled = builder.enabled;
    }

    public boolean hasReminderAtMinutes() {
        return this.reminderAtMinutes != null && !(this.reminderAtMinutes instanceof SdkAutoConstructList);
    }

    public List<Integer> reminderAtMinutes() {
        return this.reminderAtMinutes;
    }

    public EndOfMeetingReminderType reminderType() {
        return EndOfMeetingReminderType.fromValue(this.reminderType);
    }

    public String reminderTypeAsString() {
        return this.reminderType;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.reminderAtMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.reminderTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndOfMeetingReminder)) {
            return false;
        }
        EndOfMeetingReminder other = (EndOfMeetingReminder)obj;
        return Objects.equals(this.reminderAtMinutes(), other.reminderAtMinutes()) && Objects.equals(this.reminderTypeAsString(), other.reminderTypeAsString()) && Objects.equals(this.enabled(), other.enabled());
    }

    public String toString() {
        return ToString.builder((String)"EndOfMeetingReminder").add("ReminderAtMinutes", this.reminderAtMinutes()).add("ReminderType", (Object)this.reminderTypeAsString()).add("Enabled", (Object)this.enabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReminderAtMinutes": {
                return Optional.ofNullable(clazz.cast(this.reminderAtMinutes()));
            }
            case "ReminderType": {
                return Optional.ofNullable(clazz.cast(this.reminderTypeAsString()));
            }
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EndOfMeetingReminder, T> g) {
        return obj -> g.apply((EndOfMeetingReminder)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Integer> reminderAtMinutes = DefaultSdkAutoConstructList.getInstance();
        private String reminderType;
        private Boolean enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(EndOfMeetingReminder model) {
            this.reminderAtMinutes(model.reminderAtMinutes);
            this.reminderType(model.reminderType);
            this.enabled(model.enabled);
        }

        public final Collection<Integer> getReminderAtMinutes() {
            return this.reminderAtMinutes;
        }

        @Override
        public final Builder reminderAtMinutes(Collection<Integer> reminderAtMinutes) {
            this.reminderAtMinutes = EndOfMeetingReminderMinutesListCopier.copy(reminderAtMinutes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reminderAtMinutes(Integer ... reminderAtMinutes) {
            this.reminderAtMinutes(Arrays.asList(reminderAtMinutes));
            return this;
        }

        public final void setReminderAtMinutes(Collection<Integer> reminderAtMinutes) {
            this.reminderAtMinutes = EndOfMeetingReminderMinutesListCopier.copy(reminderAtMinutes);
        }

        public final String getReminderType() {
            return this.reminderType;
        }

        @Override
        public final Builder reminderType(String reminderType) {
            this.reminderType = reminderType;
            return this;
        }

        @Override
        public final Builder reminderType(EndOfMeetingReminderType reminderType) {
            this.reminderType(reminderType == null ? null : reminderType.toString());
            return this;
        }

        public final void setReminderType(String reminderType) {
            this.reminderType = reminderType;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public EndOfMeetingReminder build() {
            return new EndOfMeetingReminder(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EndOfMeetingReminder> {
        public Builder reminderAtMinutes(Collection<Integer> var1);

        public Builder reminderAtMinutes(Integer ... var1);

        public Builder reminderType(String var1);

        public Builder reminderType(EndOfMeetingReminderType var1);

        public Builder enabled(Boolean var1);
    }
}

