/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.alexaforbusiness.model.AlexaForBusinessResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.Category;
import software.amazon.awssdk.services.alexaforbusiness.model.CategoryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSkillsStoreCategoriesResponse
extends AlexaForBusinessResponse
implements ToCopyableBuilder<Builder, ListSkillsStoreCategoriesResponse> {
    private static final SdkField<List<Category>> CATEGORY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListSkillsStoreCategoriesResponse.getter(ListSkillsStoreCategoriesResponse::categoryList)).setter(ListSkillsStoreCategoriesResponse.setter(Builder::categoryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Category::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListSkillsStoreCategoriesResponse.getter(ListSkillsStoreCategoriesResponse::nextToken)).setter(ListSkillsStoreCategoriesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORY_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<Category> categoryList;
    private final String nextToken;

    private ListSkillsStoreCategoriesResponse(BuilderImpl builder) {
        super(builder);
        this.categoryList = builder.categoryList;
        this.nextToken = builder.nextToken;
    }

    public boolean hasCategoryList() {
        return this.categoryList != null && !(this.categoryList instanceof SdkAutoConstructList);
    }

    public List<Category> categoryList() {
        return this.categoryList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.categoryList());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSkillsStoreCategoriesResponse)) {
            return false;
        }
        ListSkillsStoreCategoriesResponse other = (ListSkillsStoreCategoriesResponse)((Object)obj);
        return Objects.equals(this.categoryList(), other.categoryList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListSkillsStoreCategoriesResponse").add("CategoryList", this.categoryList()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CategoryList": {
                return Optional.ofNullable(clazz.cast(this.categoryList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSkillsStoreCategoriesResponse, T> g) {
        return obj -> g.apply((ListSkillsStoreCategoriesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AlexaForBusinessResponse.BuilderImpl
    implements Builder {
        private List<Category> categoryList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSkillsStoreCategoriesResponse model) {
            super(model);
            this.categoryList(model.categoryList);
            this.nextToken(model.nextToken);
        }

        public final Collection<Category.Builder> getCategoryList() {
            return this.categoryList != null ? (Collection)this.categoryList.stream().map(Category::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder categoryList(Collection<Category> categoryList) {
            this.categoryList = CategoryListCopier.copy(categoryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categoryList(Category ... categoryList) {
            this.categoryList(Arrays.asList(categoryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categoryList(Consumer<Category.Builder> ... categoryList) {
            this.categoryList(Stream.of(categoryList).map(c -> (Category)((Category.Builder)Category.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCategoryList(Collection<Category.BuilderImpl> categoryList) {
            this.categoryList = CategoryListCopier.copyFromBuilder(categoryList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListSkillsStoreCategoriesResponse build() {
            return new ListSkillsStoreCategoriesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AlexaForBusinessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSkillsStoreCategoriesResponse> {
        public Builder categoryList(Collection<Category> var1);

        public Builder categoryList(Category ... var1);

        public Builder categoryList(Consumer<Category.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

