/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.alexaforbusiness.model.AlexaForBusinessResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.RoomSkillParameter;
import software.amazon.awssdk.services.alexaforbusiness.model.RoomSkillParametersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResolveRoomResponse
extends AlexaForBusinessResponse
implements ToCopyableBuilder<Builder, ResolveRoomResponse> {
    private static final SdkField<String> ROOM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ResolveRoomResponse.getter(ResolveRoomResponse::roomArn)).setter(ResolveRoomResponse.setter(Builder::roomArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoomArn").build()}).build();
    private static final SdkField<String> ROOM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ResolveRoomResponse.getter(ResolveRoomResponse::roomName)).setter(ResolveRoomResponse.setter(Builder::roomName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoomName").build()}).build();
    private static final SdkField<List<RoomSkillParameter>> ROOM_SKILL_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ResolveRoomResponse.getter(ResolveRoomResponse::roomSkillParameters)).setter(ResolveRoomResponse.setter(Builder::roomSkillParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoomSkillParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RoomSkillParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROOM_ARN_FIELD, ROOM_NAME_FIELD, ROOM_SKILL_PARAMETERS_FIELD));
    private final String roomArn;
    private final String roomName;
    private final List<RoomSkillParameter> roomSkillParameters;

    private ResolveRoomResponse(BuilderImpl builder) {
        super(builder);
        this.roomArn = builder.roomArn;
        this.roomName = builder.roomName;
        this.roomSkillParameters = builder.roomSkillParameters;
    }

    public String roomArn() {
        return this.roomArn;
    }

    public String roomName() {
        return this.roomName;
    }

    public boolean hasRoomSkillParameters() {
        return this.roomSkillParameters != null && !(this.roomSkillParameters instanceof SdkAutoConstructList);
    }

    public List<RoomSkillParameter> roomSkillParameters() {
        return this.roomSkillParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.roomArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.roomName());
        hashCode = 31 * hashCode + Objects.hashCode(this.roomSkillParameters());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResolveRoomResponse)) {
            return false;
        }
        ResolveRoomResponse other = (ResolveRoomResponse)((Object)obj);
        return Objects.equals(this.roomArn(), other.roomArn()) && Objects.equals(this.roomName(), other.roomName()) && Objects.equals(this.roomSkillParameters(), other.roomSkillParameters());
    }

    public String toString() {
        return ToString.builder((String)"ResolveRoomResponse").add("RoomArn", (Object)this.roomArn()).add("RoomName", (Object)this.roomName()).add("RoomSkillParameters", this.roomSkillParameters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoomArn": {
                return Optional.ofNullable(clazz.cast(this.roomArn()));
            }
            case "RoomName": {
                return Optional.ofNullable(clazz.cast(this.roomName()));
            }
            case "RoomSkillParameters": {
                return Optional.ofNullable(clazz.cast(this.roomSkillParameters()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResolveRoomResponse, T> g) {
        return obj -> g.apply((ResolveRoomResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AlexaForBusinessResponse.BuilderImpl
    implements Builder {
        private String roomArn;
        private String roomName;
        private List<RoomSkillParameter> roomSkillParameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResolveRoomResponse model) {
            super(model);
            this.roomArn(model.roomArn);
            this.roomName(model.roomName);
            this.roomSkillParameters(model.roomSkillParameters);
        }

        public final String getRoomArn() {
            return this.roomArn;
        }

        @Override
        public final Builder roomArn(String roomArn) {
            this.roomArn = roomArn;
            return this;
        }

        public final void setRoomArn(String roomArn) {
            this.roomArn = roomArn;
        }

        public final String getRoomName() {
            return this.roomName;
        }

        @Override
        public final Builder roomName(String roomName) {
            this.roomName = roomName;
            return this;
        }

        public final void setRoomName(String roomName) {
            this.roomName = roomName;
        }

        public final Collection<RoomSkillParameter.Builder> getRoomSkillParameters() {
            return this.roomSkillParameters != null ? (Collection)this.roomSkillParameters.stream().map(RoomSkillParameter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder roomSkillParameters(Collection<RoomSkillParameter> roomSkillParameters) {
            this.roomSkillParameters = RoomSkillParametersCopier.copy(roomSkillParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roomSkillParameters(RoomSkillParameter ... roomSkillParameters) {
            this.roomSkillParameters(Arrays.asList(roomSkillParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roomSkillParameters(Consumer<RoomSkillParameter.Builder> ... roomSkillParameters) {
            this.roomSkillParameters(Stream.of(roomSkillParameters).map(c -> (RoomSkillParameter)((RoomSkillParameter.Builder)RoomSkillParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRoomSkillParameters(Collection<RoomSkillParameter.BuilderImpl> roomSkillParameters) {
            this.roomSkillParameters = RoomSkillParametersCopier.copyFromBuilder(roomSkillParameters);
        }

        @Override
        public ResolveRoomResponse build() {
            return new ResolveRoomResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AlexaForBusinessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ResolveRoomResponse> {
        public Builder roomArn(String var1);

        public Builder roomName(String var1);

        public Builder roomSkillParameters(Collection<RoomSkillParameter> var1);

        public Builder roomSkillParameters(RoomSkillParameter ... var1);

        public Builder roomSkillParameters(Consumer<RoomSkillParameter.Builder> ... var1);
    }
}

