/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.alexaforbusiness.model.AlexaForBusinessResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.ContactData;
import software.amazon.awssdk.services.alexaforbusiness.model.ContactDataListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchContactsResponse
extends AlexaForBusinessResponse
implements ToCopyableBuilder<Builder, SearchContactsResponse> {
    private static final SdkField<List<ContactData>> CONTACTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(SearchContactsResponse.getter(SearchContactsResponse::contacts)).setter(SearchContactsResponse.setter(Builder::contacts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Contacts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContactData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SearchContactsResponse.getter(SearchContactsResponse::nextToken)).setter(SearchContactsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> TOTAL_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(SearchContactsResponse.getter(SearchContactsResponse::totalCount)).setter(SearchContactsResponse.setter(Builder::totalCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACTS_FIELD, NEXT_TOKEN_FIELD, TOTAL_COUNT_FIELD));
    private final List<ContactData> contacts;
    private final String nextToken;
    private final Integer totalCount;

    private SearchContactsResponse(BuilderImpl builder) {
        super(builder);
        this.contacts = builder.contacts;
        this.nextToken = builder.nextToken;
        this.totalCount = builder.totalCount;
    }

    public boolean hasContacts() {
        return this.contacts != null && !(this.contacts instanceof SdkAutoConstructList);
    }

    public List<ContactData> contacts() {
        return this.contacts;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer totalCount() {
        return this.totalCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.contacts());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalCount());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchContactsResponse)) {
            return false;
        }
        SearchContactsResponse other = (SearchContactsResponse)((Object)obj);
        return Objects.equals(this.contacts(), other.contacts()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.totalCount(), other.totalCount());
    }

    public String toString() {
        return ToString.builder((String)"SearchContactsResponse").add("Contacts", this.contacts()).add("NextToken", (Object)this.nextToken()).add("TotalCount", (Object)this.totalCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Contacts": {
                return Optional.ofNullable(clazz.cast(this.contacts()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "TotalCount": {
                return Optional.ofNullable(clazz.cast(this.totalCount()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchContactsResponse, T> g) {
        return obj -> g.apply((SearchContactsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AlexaForBusinessResponse.BuilderImpl
    implements Builder {
        private List<ContactData> contacts = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer totalCount;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchContactsResponse model) {
            super(model);
            this.contacts(model.contacts);
            this.nextToken(model.nextToken);
            this.totalCount(model.totalCount);
        }

        public final Collection<ContactData.Builder> getContacts() {
            return this.contacts != null ? (Collection)this.contacts.stream().map(ContactData::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder contacts(Collection<ContactData> contacts) {
            this.contacts = ContactDataListCopier.copy(contacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contacts(ContactData ... contacts) {
            this.contacts(Arrays.asList(contacts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contacts(Consumer<ContactData.Builder> ... contacts) {
            this.contacts(Stream.of(contacts).map(c -> (ContactData)((ContactData.Builder)ContactData.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setContacts(Collection<ContactData.BuilderImpl> contacts) {
            this.contacts = ContactDataListCopier.copyFromBuilder(contacts);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getTotalCount() {
            return this.totalCount;
        }

        @Override
        public final Builder totalCount(Integer totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public final void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        @Override
        public SearchContactsResponse build() {
            return new SearchContactsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AlexaForBusinessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchContactsResponse> {
        public Builder contacts(Collection<ContactData> var1);

        public Builder contacts(ContactData ... var1);

        public Builder contacts(Consumer<ContactData.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder totalCount(Integer var1);
    }
}

