/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chime.model.ChimeRequest;
import software.amazon.awssdk.services.chime.model.MembershipItem;
import software.amazon.awssdk.services.chime.model.MembershipItemListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchCreateRoomMembershipRequest
extends ChimeRequest
implements ToCopyableBuilder<Builder, BatchCreateRoomMembershipRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BatchCreateRoomMembershipRequest.getter(BatchCreateRoomMembershipRequest::accountId)).setter(BatchCreateRoomMembershipRequest.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("accountId").build()}).build();
    private static final SdkField<String> ROOM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BatchCreateRoomMembershipRequest.getter(BatchCreateRoomMembershipRequest::roomId)).setter(BatchCreateRoomMembershipRequest.setter(Builder::roomId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("roomId").build()}).build();
    private static final SdkField<List<MembershipItem>> MEMBERSHIP_ITEM_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(BatchCreateRoomMembershipRequest.getter(BatchCreateRoomMembershipRequest::membershipItemList)).setter(BatchCreateRoomMembershipRequest.setter(Builder::membershipItemList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MembershipItemList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MembershipItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, ROOM_ID_FIELD, MEMBERSHIP_ITEM_LIST_FIELD));
    private final String accountId;
    private final String roomId;
    private final List<MembershipItem> membershipItemList;

    private BatchCreateRoomMembershipRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.roomId = builder.roomId;
        this.membershipItemList = builder.membershipItemList;
    }

    public String accountId() {
        return this.accountId;
    }

    public String roomId() {
        return this.roomId;
    }

    public boolean hasMembershipItemList() {
        return this.membershipItemList != null && !(this.membershipItemList instanceof SdkAutoConstructList);
    }

    public List<MembershipItem> membershipItemList() {
        return this.membershipItemList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.roomId());
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipItemList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchCreateRoomMembershipRequest)) {
            return false;
        }
        BatchCreateRoomMembershipRequest other = (BatchCreateRoomMembershipRequest)((Object)obj);
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.roomId(), other.roomId()) && Objects.equals(this.membershipItemList(), other.membershipItemList());
    }

    public String toString() {
        return ToString.builder((String)"BatchCreateRoomMembershipRequest").add("AccountId", (Object)this.accountId()).add("RoomId", (Object)this.roomId()).add("MembershipItemList", this.membershipItemList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "RoomId": {
                return Optional.ofNullable(clazz.cast(this.roomId()));
            }
            case "MembershipItemList": {
                return Optional.ofNullable(clazz.cast(this.membershipItemList()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchCreateRoomMembershipRequest, T> g) {
        return obj -> g.apply((BatchCreateRoomMembershipRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeRequest.BuilderImpl
    implements Builder {
        private String accountId;
        private String roomId;
        private List<MembershipItem> membershipItemList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchCreateRoomMembershipRequest model) {
            super(model);
            this.accountId(model.accountId);
            this.roomId(model.roomId);
            this.membershipItemList(model.membershipItemList);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getRoomId() {
            return this.roomId;
        }

        @Override
        public final Builder roomId(String roomId) {
            this.roomId = roomId;
            return this;
        }

        public final void setRoomId(String roomId) {
            this.roomId = roomId;
        }

        public final Collection<MembershipItem.Builder> getMembershipItemList() {
            return this.membershipItemList != null ? (Collection)this.membershipItemList.stream().map(MembershipItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder membershipItemList(Collection<MembershipItem> membershipItemList) {
            this.membershipItemList = MembershipItemListCopier.copy(membershipItemList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder membershipItemList(MembershipItem ... membershipItemList) {
            this.membershipItemList(Arrays.asList(membershipItemList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder membershipItemList(Consumer<MembershipItem.Builder> ... membershipItemList) {
            this.membershipItemList(Stream.of(membershipItemList).map(c -> (MembershipItem)((MembershipItem.Builder)MembershipItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMembershipItemList(Collection<MembershipItem.BuilderImpl> membershipItemList) {
            this.membershipItemList = MembershipItemListCopier.copyFromBuilder(membershipItemList);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchCreateRoomMembershipRequest build() {
            return new BatchCreateRoomMembershipRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchCreateRoomMembershipRequest> {
        public Builder accountId(String var1);

        public Builder roomId(String var1);

        public Builder membershipItemList(Collection<MembershipItem> var1);

        public Builder membershipItemList(MembershipItem ... var1);

        public Builder membershipItemList(Consumer<MembershipItem.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

