/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Account takeover action type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccountTakeoverActionType implements SdkPojo, Serializable,
        ToCopyableBuilder<AccountTakeoverActionType.Builder, AccountTakeoverActionType> {
    private static final SdkField<String> EVENT_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventAction").getter(getter(AccountTakeoverActionType::eventActionAsString))
            .setter(setter(Builder::eventAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventAction").build()).build();

    private static final SdkField<Boolean> SEND_NOTIFICATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SendNotification").getter(getter(AccountTakeoverActionType::sendNotification))
            .setter(setter(Builder::sendNotification))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notify").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_ACTION_FIELD,
            SEND_NOTIFICATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String eventAction;

    private final Boolean sendNotification;

    private AccountTakeoverActionType(BuilderImpl builder) {
        this.eventAction = builder.eventAction;
        this.sendNotification = builder.sendNotification;
    }

    /**
     * <p>
     * The event action.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>BLOCK</code> Choosing this action will block the request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MFA_IF_CONFIGURED</code> Throw MFA challenge if user has configured it, else allow the request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MFA_REQUIRED</code> Throw MFA challenge if user has configured it, else block the request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NO_ACTION</code> Allow the user sign-in.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventAction} will
     * return {@link AccountTakeoverEventActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #eventActionAsString}.
     * </p>
     * 
     * @return The event action.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>BLOCK</code> Choosing this action will block the request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MFA_IF_CONFIGURED</code> Throw MFA challenge if user has configured it, else allow the request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MFA_REQUIRED</code> Throw MFA challenge if user has configured it, else block the request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NO_ACTION</code> Allow the user sign-in.
     *         </p>
     *         </li>
     * @see AccountTakeoverEventActionType
     */
    public AccountTakeoverEventActionType eventAction() {
        return AccountTakeoverEventActionType.fromValue(eventAction);
    }

    /**
     * <p>
     * The event action.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>BLOCK</code> Choosing this action will block the request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MFA_IF_CONFIGURED</code> Throw MFA challenge if user has configured it, else allow the request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MFA_REQUIRED</code> Throw MFA challenge if user has configured it, else block the request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NO_ACTION</code> Allow the user sign-in.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventAction} will
     * return {@link AccountTakeoverEventActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #eventActionAsString}.
     * </p>
     * 
     * @return The event action.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>BLOCK</code> Choosing this action will block the request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MFA_IF_CONFIGURED</code> Throw MFA challenge if user has configured it, else allow the request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MFA_REQUIRED</code> Throw MFA challenge if user has configured it, else block the request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NO_ACTION</code> Allow the user sign-in.
     *         </p>
     *         </li>
     * @see AccountTakeoverEventActionType
     */
    public String eventActionAsString() {
        return eventAction;
    }

    /**
     * <p>
     * Flag specifying whether to send a notification.
     * </p>
     * 
     * @return Flag specifying whether to send a notification.
     */
    public Boolean sendNotification() {
        return sendNotification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eventActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sendNotification());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountTakeoverActionType)) {
            return false;
        }
        AccountTakeoverActionType other = (AccountTakeoverActionType) obj;
        return Objects.equals(eventActionAsString(), other.eventActionAsString())
                && Objects.equals(sendNotification(), other.sendNotification());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AccountTakeoverActionType").add("EventAction", eventActionAsString())
                .add("SendNotification", sendNotification()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EventAction":
            return Optional.ofNullable(clazz.cast(eventActionAsString()));
        case "SendNotification":
            return Optional.ofNullable(clazz.cast(sendNotification()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccountTakeoverActionType, T> g) {
        return obj -> g.apply((AccountTakeoverActionType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccountTakeoverActionType> {
        /**
         * <p>
         * The event action.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>BLOCK</code> Choosing this action will block the request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MFA_IF_CONFIGURED</code> Throw MFA challenge if user has configured it, else allow the request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MFA_REQUIRED</code> Throw MFA challenge if user has configured it, else block the request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NO_ACTION</code> Allow the user sign-in.
         * </p>
         * </li>
         * </ul>
         * 
         * @param eventAction
         *        The event action.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>BLOCK</code> Choosing this action will block the request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MFA_IF_CONFIGURED</code> Throw MFA challenge if user has configured it, else allow the request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MFA_REQUIRED</code> Throw MFA challenge if user has configured it, else block the request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NO_ACTION</code> Allow the user sign-in.
         *        </p>
         *        </li>
         * @see AccountTakeoverEventActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccountTakeoverEventActionType
         */
        Builder eventAction(String eventAction);

        /**
         * <p>
         * The event action.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>BLOCK</code> Choosing this action will block the request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MFA_IF_CONFIGURED</code> Throw MFA challenge if user has configured it, else allow the request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MFA_REQUIRED</code> Throw MFA challenge if user has configured it, else block the request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NO_ACTION</code> Allow the user sign-in.
         * </p>
         * </li>
         * </ul>
         * 
         * @param eventAction
         *        The event action.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>BLOCK</code> Choosing this action will block the request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MFA_IF_CONFIGURED</code> Throw MFA challenge if user has configured it, else allow the request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MFA_REQUIRED</code> Throw MFA challenge if user has configured it, else block the request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NO_ACTION</code> Allow the user sign-in.
         *        </p>
         *        </li>
         * @see AccountTakeoverEventActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccountTakeoverEventActionType
         */
        Builder eventAction(AccountTakeoverEventActionType eventAction);

        /**
         * <p>
         * Flag specifying whether to send a notification.
         * </p>
         * 
         * @param sendNotification
         *        Flag specifying whether to send a notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sendNotification(Boolean sendNotification);
    }

    static final class BuilderImpl implements Builder {
        private String eventAction;

        private Boolean sendNotification;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountTakeoverActionType model) {
            eventAction(model.eventAction);
            sendNotification(model.sendNotification);
        }

        public final String getEventAction() {
            return eventAction;
        }

        @Override
        public final Builder eventAction(String eventAction) {
            this.eventAction = eventAction;
            return this;
        }

        @Override
        public final Builder eventAction(AccountTakeoverEventActionType eventAction) {
            this.eventAction(eventAction == null ? null : eventAction.toString());
            return this;
        }

        public final void setEventAction(String eventAction) {
            this.eventAction = eventAction;
        }

        public final Boolean getSendNotification() {
            return sendNotification;
        }

        @Override
        public final Builder sendNotification(Boolean sendNotification) {
            this.sendNotification = sendNotification;
            return this;
        }

        public final void setSendNotification(Boolean sendNotification) {
            this.sendNotification = sendNotification;
        }

        @Override
        public AccountTakeoverActionType build() {
            return new AccountTakeoverActionType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
