/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum OAuthFlowType {
    CODE("code"),
    IMPLICIT("implicit"),
    CLIENT_CREDENTIALS("client_credentials"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private OAuthFlowType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OAuthFlowType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(OAuthFlowType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OAuthFlowType> knownValues() {
        return Stream.of(OAuthFlowType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

