/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The challenge response type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChallengeResponseType implements SdkPojo, Serializable,
        ToCopyableBuilder<ChallengeResponseType.Builder, ChallengeResponseType> {
    private static final SdkField<String> CHALLENGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChallengeName").getter(getter(ChallengeResponseType::challengeNameAsString))
            .setter(setter(Builder::challengeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChallengeName").build()).build();

    private static final SdkField<String> CHALLENGE_RESPONSE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChallengeResponse").getter(getter(ChallengeResponseType::challengeResponseAsString))
            .setter(setter(Builder::challengeResponse))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChallengeResponse").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHALLENGE_NAME_FIELD,
            CHALLENGE_RESPONSE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String challengeName;

    private final String challengeResponse;

    private ChallengeResponseType(BuilderImpl builder) {
        this.challengeName = builder.challengeName;
        this.challengeResponse = builder.challengeResponse;
    }

    /**
     * <p>
     * The challenge name
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #challengeName}
     * will return {@link ChallengeName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #challengeNameAsString}.
     * </p>
     * 
     * @return The challenge name
     * @see ChallengeName
     */
    public final ChallengeName challengeName() {
        return ChallengeName.fromValue(challengeName);
    }

    /**
     * <p>
     * The challenge name
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #challengeName}
     * will return {@link ChallengeName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #challengeNameAsString}.
     * </p>
     * 
     * @return The challenge name
     * @see ChallengeName
     */
    public final String challengeNameAsString() {
        return challengeName;
    }

    /**
     * <p>
     * The challenge response.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #challengeResponse}
     * will return {@link ChallengeResponse#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #challengeResponseAsString}.
     * </p>
     * 
     * @return The challenge response.
     * @see ChallengeResponse
     */
    public final ChallengeResponse challengeResponse() {
        return ChallengeResponse.fromValue(challengeResponse);
    }

    /**
     * <p>
     * The challenge response.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #challengeResponse}
     * will return {@link ChallengeResponse#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #challengeResponseAsString}.
     * </p>
     * 
     * @return The challenge response.
     * @see ChallengeResponse
     */
    public final String challengeResponseAsString() {
        return challengeResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(challengeNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(challengeResponseAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChallengeResponseType)) {
            return false;
        }
        ChallengeResponseType other = (ChallengeResponseType) obj;
        return Objects.equals(challengeNameAsString(), other.challengeNameAsString())
                && Objects.equals(challengeResponseAsString(), other.challengeResponseAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChallengeResponseType").add("ChallengeName", challengeNameAsString())
                .add("ChallengeResponse", challengeResponseAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChallengeName":
            return Optional.ofNullable(clazz.cast(challengeNameAsString()));
        case "ChallengeResponse":
            return Optional.ofNullable(clazz.cast(challengeResponseAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChallengeResponseType, T> g) {
        return obj -> g.apply((ChallengeResponseType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChallengeResponseType> {
        /**
         * <p>
         * The challenge name
         * </p>
         * 
         * @param challengeName
         *        The challenge name
         * @see ChallengeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChallengeName
         */
        Builder challengeName(String challengeName);

        /**
         * <p>
         * The challenge name
         * </p>
         * 
         * @param challengeName
         *        The challenge name
         * @see ChallengeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChallengeName
         */
        Builder challengeName(ChallengeName challengeName);

        /**
         * <p>
         * The challenge response.
         * </p>
         * 
         * @param challengeResponse
         *        The challenge response.
         * @see ChallengeResponse
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChallengeResponse
         */
        Builder challengeResponse(String challengeResponse);

        /**
         * <p>
         * The challenge response.
         * </p>
         * 
         * @param challengeResponse
         *        The challenge response.
         * @see ChallengeResponse
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChallengeResponse
         */
        Builder challengeResponse(ChallengeResponse challengeResponse);
    }

    static final class BuilderImpl implements Builder {
        private String challengeName;

        private String challengeResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(ChallengeResponseType model) {
            challengeName(model.challengeName);
            challengeResponse(model.challengeResponse);
        }

        public final String getChallengeName() {
            return challengeName;
        }

        @Override
        public final Builder challengeName(String challengeName) {
            this.challengeName = challengeName;
            return this;
        }

        @Override
        public final Builder challengeName(ChallengeName challengeName) {
            this.challengeName(challengeName == null ? null : challengeName.toString());
            return this;
        }

        public final void setChallengeName(String challengeName) {
            this.challengeName = challengeName;
        }

        public final String getChallengeResponse() {
            return challengeResponse;
        }

        @Override
        public final Builder challengeResponse(String challengeResponse) {
            this.challengeResponse = challengeResponse;
            return this;
        }

        @Override
        public final Builder challengeResponse(ChallengeResponse challengeResponse) {
            this.challengeResponse(challengeResponse == null ? null : challengeResponse.toString());
            return this;
        }

        public final void setChallengeResponse(String challengeResponse) {
            this.challengeResponse = challengeResponse;
        }

        @Override
        public ChallengeResponseType build() {
            return new ChallengeResponseType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
