/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A resource server scope.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceServerScopeType implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceServerScopeType.Builder, ResourceServerScopeType> {
    private static final SdkField<String> SCOPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScopeName").getter(getter(ResourceServerScopeType::scopeName)).setter(setter(Builder::scopeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScopeName").build()).build();

    private static final SdkField<String> SCOPE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScopeDescription").getter(getter(ResourceServerScopeType::scopeDescription))
            .setter(setter(Builder::scopeDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScopeDescription").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCOPE_NAME_FIELD,
            SCOPE_DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String scopeName;

    private final String scopeDescription;

    private ResourceServerScopeType(BuilderImpl builder) {
        this.scopeName = builder.scopeName;
        this.scopeDescription = builder.scopeDescription;
    }

    /**
     * <p>
     * The name of the scope.
     * </p>
     * 
     * @return The name of the scope.
     */
    public final String scopeName() {
        return scopeName;
    }

    /**
     * <p>
     * A description of the scope.
     * </p>
     * 
     * @return A description of the scope.
     */
    public final String scopeDescription() {
        return scopeDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scopeName());
        hashCode = 31 * hashCode + Objects.hashCode(scopeDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceServerScopeType)) {
            return false;
        }
        ResourceServerScopeType other = (ResourceServerScopeType) obj;
        return Objects.equals(scopeName(), other.scopeName()) && Objects.equals(scopeDescription(), other.scopeDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceServerScopeType").add("ScopeName", scopeName())
                .add("ScopeDescription", scopeDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScopeName":
            return Optional.ofNullable(clazz.cast(scopeName()));
        case "ScopeDescription":
            return Optional.ofNullable(clazz.cast(scopeDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceServerScopeType, T> g) {
        return obj -> g.apply((ResourceServerScopeType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceServerScopeType> {
        /**
         * <p>
         * The name of the scope.
         * </p>
         * 
         * @param scopeName
         *        The name of the scope.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scopeName(String scopeName);

        /**
         * <p>
         * A description of the scope.
         * </p>
         * 
         * @param scopeDescription
         *        A description of the scope.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scopeDescription(String scopeDescription);
    }

    static final class BuilderImpl implements Builder {
        private String scopeName;

        private String scopeDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceServerScopeType model) {
            scopeName(model.scopeName);
            scopeDescription(model.scopeDescription);
        }

        public final String getScopeName() {
            return scopeName;
        }

        @Override
        public final Builder scopeName(String scopeName) {
            this.scopeName = scopeName;
            return this;
        }

        public final void setScopeName(String scopeName) {
            this.scopeName = scopeName;
        }

        public final String getScopeDescription() {
            return scopeDescription;
        }

        @Override
        public final Builder scopeDescription(String scopeDescription) {
            this.scopeDescription = scopeDescription;
            return this;
        }

        public final void setScopeDescription(String scopeDescription) {
            this.scopeDescription = scopeDescription;
        }

        @Override
        public ResourceServerScopeType build() {
            return new ResourceServerScopeType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
