/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SetUiCustomizationRequest extends CognitoIdentityProviderRequest implements
        ToCopyableBuilder<SetUiCustomizationRequest.Builder, SetUiCustomizationRequest> {
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserPoolId").getter(getter(SetUiCustomizationRequest::userPoolId)).setter(setter(Builder::userPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()).build();

    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientId").getter(getter(SetUiCustomizationRequest::clientId)).setter(setter(Builder::clientId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientId").build()).build();

    private static final SdkField<String> CSS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("CSS")
            .getter(getter(SetUiCustomizationRequest::css)).setter(setter(Builder::css))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CSS").build()).build();

    private static final SdkField<SdkBytes> IMAGE_FILE_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("ImageFile").getter(getter(SetUiCustomizationRequest::imageFile)).setter(setter(Builder::imageFile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageFile").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_ID_FIELD,
            CLIENT_ID_FIELD, CSS_FIELD, IMAGE_FILE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String userPoolId;

    private final String clientId;

    private final String css;

    private final SdkBytes imageFile;

    private SetUiCustomizationRequest(BuilderImpl builder) {
        super(builder);
        this.userPoolId = builder.userPoolId;
        this.clientId = builder.clientId;
        this.css = builder.css;
        this.imageFile = builder.imageFile;
    }

    /**
     * <p>
     * The ID of the user pool where you want to apply branding to the classic hosted UI.
     * </p>
     * 
     * @return The ID of the user pool where you want to apply branding to the classic hosted UI.
     */
    public final String userPoolId() {
        return userPoolId;
    }

    /**
     * <p>
     * The ID of the app client that you want to customize. To apply a default style to all app clients not configured
     * with client-level branding, set this parameter value to <code>ALL</code>.
     * </p>
     * 
     * @return The ID of the app client that you want to customize. To apply a default style to all app clients not
     *         configured with client-level branding, set this parameter value to <code>ALL</code>.
     */
    public final String clientId() {
        return clientId;
    }

    /**
     * <p>
     * A plaintext CSS file that contains the custom fields that you want to apply to your user pool or app client. To
     * download a template, go to the Amazon Cognito console. Navigate to your user pool <i>App clients</i> tab, select
     * <i>Login pages</i>, edit <i>Hosted UI (classic) style</i>, and select the link to <code>CSS template.css</code>.
     * </p>
     * 
     * @return A plaintext CSS file that contains the custom fields that you want to apply to your user pool or app
     *         client. To download a template, go to the Amazon Cognito console. Navigate to your user pool <i>App
     *         clients</i> tab, select <i>Login pages</i>, edit <i>Hosted UI (classic) style</i>, and select the link to
     *         <code>CSS template.css</code>.
     */
    public final String css() {
        return css;
    }

    /**
     * <p>
     * The image that you want to set as your login in the classic hosted UI, as a Base64-formatted binary object.
     * </p>
     * 
     * @return The image that you want to set as your login in the classic hosted UI, as a Base64-formatted binary
     *         object.
     */
    public final SdkBytes imageFile() {
        return imageFile;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(clientId());
        hashCode = 31 * hashCode + Objects.hashCode(css());
        hashCode = 31 * hashCode + Objects.hashCode(imageFile());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetUiCustomizationRequest)) {
            return false;
        }
        SetUiCustomizationRequest other = (SetUiCustomizationRequest) obj;
        return Objects.equals(userPoolId(), other.userPoolId()) && Objects.equals(clientId(), other.clientId())
                && Objects.equals(css(), other.css()) && Objects.equals(imageFile(), other.imageFile());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SetUiCustomizationRequest").add("UserPoolId", userPoolId())
                .add("ClientId", clientId() == null ? null : "*** Sensitive Data Redacted ***").add("CSS", css())
                .add("ImageFile", imageFile()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserPoolId":
            return Optional.ofNullable(clazz.cast(userPoolId()));
        case "ClientId":
            return Optional.ofNullable(clazz.cast(clientId()));
        case "CSS":
            return Optional.ofNullable(clazz.cast(css()));
        case "ImageFile":
            return Optional.ofNullable(clazz.cast(imageFile()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("UserPoolId", USER_POOL_ID_FIELD);
        map.put("ClientId", CLIENT_ID_FIELD);
        map.put("CSS", CSS_FIELD);
        map.put("ImageFile", IMAGE_FILE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SetUiCustomizationRequest, T> g) {
        return obj -> g.apply((SetUiCustomizationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, SetUiCustomizationRequest> {
        /**
         * <p>
         * The ID of the user pool where you want to apply branding to the classic hosted UI.
         * </p>
         * 
         * @param userPoolId
         *        The ID of the user pool where you want to apply branding to the classic hosted UI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolId(String userPoolId);

        /**
         * <p>
         * The ID of the app client that you want to customize. To apply a default style to all app clients not
         * configured with client-level branding, set this parameter value to <code>ALL</code>.
         * </p>
         * 
         * @param clientId
         *        The ID of the app client that you want to customize. To apply a default style to all app clients not
         *        configured with client-level branding, set this parameter value to <code>ALL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientId(String clientId);

        /**
         * <p>
         * A plaintext CSS file that contains the custom fields that you want to apply to your user pool or app client.
         * To download a template, go to the Amazon Cognito console. Navigate to your user pool <i>App clients</i> tab,
         * select <i>Login pages</i>, edit <i>Hosted UI (classic) style</i>, and select the link to
         * <code>CSS template.css</code>.
         * </p>
         * 
         * @param css
         *        A plaintext CSS file that contains the custom fields that you want to apply to your user pool or app
         *        client. To download a template, go to the Amazon Cognito console. Navigate to your user pool <i>App
         *        clients</i> tab, select <i>Login pages</i>, edit <i>Hosted UI (classic) style</i>, and select the link
         *        to <code>CSS template.css</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder css(String css);

        /**
         * <p>
         * The image that you want to set as your login in the classic hosted UI, as a Base64-formatted binary object.
         * </p>
         * 
         * @param imageFile
         *        The image that you want to set as your login in the classic hosted UI, as a Base64-formatted binary
         *        object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageFile(SdkBytes imageFile);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CognitoIdentityProviderRequest.BuilderImpl implements Builder {
        private String userPoolId;

        private String clientId;

        private String css;

        private SdkBytes imageFile;

        private BuilderImpl() {
        }

        private BuilderImpl(SetUiCustomizationRequest model) {
            super(model);
            userPoolId(model.userPoolId);
            clientId(model.clientId);
            css(model.css);
            imageFile(model.imageFile);
        }

        public final String getUserPoolId() {
            return userPoolId;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final String getClientId() {
            return clientId;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final String getCss() {
            return css;
        }

        public final void setCss(String css) {
            this.css = css;
        }

        @Override
        public final Builder css(String css) {
            this.css = css;
            return this;
        }

        public final ByteBuffer getImageFile() {
            return imageFile == null ? null : imageFile.asByteBuffer();
        }

        public final void setImageFile(ByteBuffer imageFile) {
            imageFile(imageFile == null ? null : SdkBytes.fromByteBuffer(imageFile));
        }

        @Override
        public final Builder imageFile(SdkBytes imageFile) {
            this.imageFile = imageFile;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetUiCustomizationRequest build() {
            return new SetUiCustomizationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
