/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A short description of a user pool app client.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserPoolClientDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<UserPoolClientDescription.Builder, UserPoolClientDescription> {
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientId").getter(getter(UserPoolClientDescription::clientId)).setter(setter(Builder::clientId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientId").build()).build();

    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserPoolId").getter(getter(UserPoolClientDescription::userPoolId)).setter(setter(Builder::userPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()).build();

    private static final SdkField<String> CLIENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientName").getter(getter(UserPoolClientDescription::clientName)).setter(setter(Builder::clientName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_ID_FIELD,
            USER_POOL_ID_FIELD, CLIENT_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String clientId;

    private final String userPoolId;

    private final String clientName;

    private UserPoolClientDescription(BuilderImpl builder) {
        this.clientId = builder.clientId;
        this.userPoolId = builder.userPoolId;
        this.clientName = builder.clientName;
    }

    /**
     * <p>
     * The app client ID.
     * </p>
     * 
     * @return The app client ID.
     */
    public final String clientId() {
        return clientId;
    }

    /**
     * <p>
     * The ID of the user pool that's associated with the app client.
     * </p>
     * 
     * @return The ID of the user pool that's associated with the app client.
     */
    public final String userPoolId() {
        return userPoolId;
    }

    /**
     * <p>
     * The app client name.
     * </p>
     * 
     * @return The app client name.
     */
    public final String clientName() {
        return clientName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clientId());
        hashCode = 31 * hashCode + Objects.hashCode(userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(clientName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserPoolClientDescription)) {
            return false;
        }
        UserPoolClientDescription other = (UserPoolClientDescription) obj;
        return Objects.equals(clientId(), other.clientId()) && Objects.equals(userPoolId(), other.userPoolId())
                && Objects.equals(clientName(), other.clientName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UserPoolClientDescription")
                .add("ClientId", clientId() == null ? null : "*** Sensitive Data Redacted ***").add("UserPoolId", userPoolId())
                .add("ClientName", clientName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientId":
            return Optional.ofNullable(clazz.cast(clientId()));
        case "UserPoolId":
            return Optional.ofNullable(clazz.cast(userPoolId()));
        case "ClientName":
            return Optional.ofNullable(clazz.cast(clientName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClientId", CLIENT_ID_FIELD);
        map.put("UserPoolId", USER_POOL_ID_FIELD);
        map.put("ClientName", CLIENT_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UserPoolClientDescription, T> g) {
        return obj -> g.apply((UserPoolClientDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserPoolClientDescription> {
        /**
         * <p>
         * The app client ID.
         * </p>
         * 
         * @param clientId
         *        The app client ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientId(String clientId);

        /**
         * <p>
         * The ID of the user pool that's associated with the app client.
         * </p>
         * 
         * @param userPoolId
         *        The ID of the user pool that's associated with the app client.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolId(String userPoolId);

        /**
         * <p>
         * The app client name.
         * </p>
         * 
         * @param clientName
         *        The app client name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientName(String clientName);
    }

    static final class BuilderImpl implements Builder {
        private String clientId;

        private String userPoolId;

        private String clientName;

        private BuilderImpl() {
        }

        private BuilderImpl(UserPoolClientDescription model) {
            clientId(model.clientId);
            userPoolId(model.userPoolId);
            clientName(model.clientName);
        }

        public final String getClientId() {
            return clientId;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final String getUserPoolId() {
            return userPoolId;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final String getClientName() {
            return clientName;
        }

        public final void setClientName(String clientName) {
            this.clientName = clientName;
        }

        @Override
        public final Builder clientName(String clientName) {
            this.clientName = clientName;
            return this;
        }

        @Override
        public UserPoolClientDescription build() {
            return new UserPoolClientDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
