/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the request to create a user pool client.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateUserPoolClientRequest extends CognitoIdentityProviderRequest implements
        ToCopyableBuilder<CreateUserPoolClientRequest.Builder, CreateUserPoolClientRequest> {
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserPoolId").getter(getter(CreateUserPoolClientRequest::userPoolId)).setter(setter(Builder::userPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()).build();

    private static final SdkField<String> CLIENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientName").getter(getter(CreateUserPoolClientRequest::clientName)).setter(setter(Builder::clientName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientName").build()).build();

    private static final SdkField<Boolean> GENERATE_SECRET_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("GenerateSecret").getter(getter(CreateUserPoolClientRequest::generateSecret))
            .setter(setter(Builder::generateSecret))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GenerateSecret").build()).build();

    private static final SdkField<Integer> REFRESH_TOKEN_VALIDITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RefreshTokenValidity").getter(getter(CreateUserPoolClientRequest::refreshTokenValidity))
            .setter(setter(Builder::refreshTokenValidity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshTokenValidity").build())
            .build();

    private static final SdkField<Integer> ACCESS_TOKEN_VALIDITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AccessTokenValidity").getter(getter(CreateUserPoolClientRequest::accessTokenValidity))
            .setter(setter(Builder::accessTokenValidity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessTokenValidity").build())
            .build();

    private static final SdkField<Integer> ID_TOKEN_VALIDITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("IdTokenValidity").getter(getter(CreateUserPoolClientRequest::idTokenValidity))
            .setter(setter(Builder::idTokenValidity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdTokenValidity").build()).build();

    private static final SdkField<TokenValidityUnitsType> TOKEN_VALIDITY_UNITS_FIELD = SdkField
            .<TokenValidityUnitsType> builder(MarshallingType.SDK_POJO).memberName("TokenValidityUnits")
            .getter(getter(CreateUserPoolClientRequest::tokenValidityUnits)).setter(setter(Builder::tokenValidityUnits))
            .constructor(TokenValidityUnitsType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TokenValidityUnits").build())
            .build();

    private static final SdkField<List<String>> READ_ATTRIBUTES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ReadAttributes")
            .getter(getter(CreateUserPoolClientRequest::readAttributes))
            .setter(setter(Builder::readAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> WRITE_ATTRIBUTES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("WriteAttributes")
            .getter(getter(CreateUserPoolClientRequest::writeAttributes))
            .setter(setter(Builder::writeAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WriteAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> EXPLICIT_AUTH_FLOWS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ExplicitAuthFlows")
            .getter(getter(CreateUserPoolClientRequest::explicitAuthFlowsAsStrings))
            .setter(setter(Builder::explicitAuthFlowsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExplicitAuthFlows").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SUPPORTED_IDENTITY_PROVIDERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SupportedIdentityProviders")
            .getter(getter(CreateUserPoolClientRequest::supportedIdentityProviders))
            .setter(setter(Builder::supportedIdentityProviders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedIdentityProviders").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> CALLBACK_UR_LS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CallbackURLs")
            .getter(getter(CreateUserPoolClientRequest::callbackURLs))
            .setter(setter(Builder::callbackURLs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallbackURLs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> LOGOUT_UR_LS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("LogoutURLs")
            .getter(getter(CreateUserPoolClientRequest::logoutURLs))
            .setter(setter(Builder::logoutURLs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogoutURLs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DEFAULT_REDIRECT_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultRedirectURI").getter(getter(CreateUserPoolClientRequest::defaultRedirectURI))
            .setter(setter(Builder::defaultRedirectURI))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultRedirectURI").build())
            .build();

    private static final SdkField<List<String>> ALLOWED_O_AUTH_FLOWS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AllowedOAuthFlows")
            .getter(getter(CreateUserPoolClientRequest::allowedOAuthFlowsAsStrings))
            .setter(setter(Builder::allowedOAuthFlowsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedOAuthFlows").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ALLOWED_O_AUTH_SCOPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AllowedOAuthScopes")
            .getter(getter(CreateUserPoolClientRequest::allowedOAuthScopes))
            .setter(setter(Builder::allowedOAuthScopes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedOAuthScopes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> ALLOWED_O_AUTH_FLOWS_USER_POOL_CLIENT_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AllowedOAuthFlowsUserPoolClient")
            .getter(getter(CreateUserPoolClientRequest::allowedOAuthFlowsUserPoolClient))
            .setter(setter(Builder::allowedOAuthFlowsUserPoolClient))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedOAuthFlowsUserPoolClient")
                    .build()).build();

    private static final SdkField<AnalyticsConfigurationType> ANALYTICS_CONFIGURATION_FIELD = SdkField
            .<AnalyticsConfigurationType> builder(MarshallingType.SDK_POJO).memberName("AnalyticsConfiguration")
            .getter(getter(CreateUserPoolClientRequest::analyticsConfiguration)).setter(setter(Builder::analyticsConfiguration))
            .constructor(AnalyticsConfigurationType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalyticsConfiguration").build())
            .build();

    private static final SdkField<String> PREVENT_USER_EXISTENCE_ERRORS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PreventUserExistenceErrors")
            .getter(getter(CreateUserPoolClientRequest::preventUserExistenceErrorsAsString))
            .setter(setter(Builder::preventUserExistenceErrors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreventUserExistenceErrors").build())
            .build();

    private static final SdkField<Boolean> ENABLE_TOKEN_REVOCATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableTokenRevocation").getter(getter(CreateUserPoolClientRequest::enableTokenRevocation))
            .setter(setter(Builder::enableTokenRevocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableTokenRevocation").build())
            .build();

    private static final SdkField<Boolean> ENABLE_PROPAGATE_ADDITIONAL_USER_CONTEXT_DATA_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnablePropagateAdditionalUserContextData")
            .getter(getter(CreateUserPoolClientRequest::enablePropagateAdditionalUserContextData))
            .setter(setter(Builder::enablePropagateAdditionalUserContextData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("EnablePropagateAdditionalUserContextData").build()).build();

    private static final SdkField<Integer> AUTH_SESSION_VALIDITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AuthSessionValidity").getter(getter(CreateUserPoolClientRequest::authSessionValidity))
            .setter(setter(Builder::authSessionValidity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthSessionValidity").build())
            .build();

    private static final SdkField<RefreshTokenRotationType> REFRESH_TOKEN_ROTATION_FIELD = SdkField
            .<RefreshTokenRotationType> builder(MarshallingType.SDK_POJO).memberName("RefreshTokenRotation")
            .getter(getter(CreateUserPoolClientRequest::refreshTokenRotation)).setter(setter(Builder::refreshTokenRotation))
            .constructor(RefreshTokenRotationType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshTokenRotation").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_ID_FIELD,
            CLIENT_NAME_FIELD, GENERATE_SECRET_FIELD, REFRESH_TOKEN_VALIDITY_FIELD, ACCESS_TOKEN_VALIDITY_FIELD,
            ID_TOKEN_VALIDITY_FIELD, TOKEN_VALIDITY_UNITS_FIELD, READ_ATTRIBUTES_FIELD, WRITE_ATTRIBUTES_FIELD,
            EXPLICIT_AUTH_FLOWS_FIELD, SUPPORTED_IDENTITY_PROVIDERS_FIELD, CALLBACK_UR_LS_FIELD, LOGOUT_UR_LS_FIELD,
            DEFAULT_REDIRECT_URI_FIELD, ALLOWED_O_AUTH_FLOWS_FIELD, ALLOWED_O_AUTH_SCOPES_FIELD,
            ALLOWED_O_AUTH_FLOWS_USER_POOL_CLIENT_FIELD, ANALYTICS_CONFIGURATION_FIELD, PREVENT_USER_EXISTENCE_ERRORS_FIELD,
            ENABLE_TOKEN_REVOCATION_FIELD, ENABLE_PROPAGATE_ADDITIONAL_USER_CONTEXT_DATA_FIELD, AUTH_SESSION_VALIDITY_FIELD,
            REFRESH_TOKEN_ROTATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String userPoolId;

    private final String clientName;

    private final Boolean generateSecret;

    private final Integer refreshTokenValidity;

    private final Integer accessTokenValidity;

    private final Integer idTokenValidity;

    private final TokenValidityUnitsType tokenValidityUnits;

    private final List<String> readAttributes;

    private final List<String> writeAttributes;

    private final List<String> explicitAuthFlows;

    private final List<String> supportedIdentityProviders;

    private final List<String> callbackURLs;

    private final List<String> logoutURLs;

    private final String defaultRedirectURI;

    private final List<String> allowedOAuthFlows;

    private final List<String> allowedOAuthScopes;

    private final Boolean allowedOAuthFlowsUserPoolClient;

    private final AnalyticsConfigurationType analyticsConfiguration;

    private final String preventUserExistenceErrors;

    private final Boolean enableTokenRevocation;

    private final Boolean enablePropagateAdditionalUserContextData;

    private final Integer authSessionValidity;

    private final RefreshTokenRotationType refreshTokenRotation;

    private CreateUserPoolClientRequest(BuilderImpl builder) {
        super(builder);
        this.userPoolId = builder.userPoolId;
        this.clientName = builder.clientName;
        this.generateSecret = builder.generateSecret;
        this.refreshTokenValidity = builder.refreshTokenValidity;
        this.accessTokenValidity = builder.accessTokenValidity;
        this.idTokenValidity = builder.idTokenValidity;
        this.tokenValidityUnits = builder.tokenValidityUnits;
        this.readAttributes = builder.readAttributes;
        this.writeAttributes = builder.writeAttributes;
        this.explicitAuthFlows = builder.explicitAuthFlows;
        this.supportedIdentityProviders = builder.supportedIdentityProviders;
        this.callbackURLs = builder.callbackURLs;
        this.logoutURLs = builder.logoutURLs;
        this.defaultRedirectURI = builder.defaultRedirectURI;
        this.allowedOAuthFlows = builder.allowedOAuthFlows;
        this.allowedOAuthScopes = builder.allowedOAuthScopes;
        this.allowedOAuthFlowsUserPoolClient = builder.allowedOAuthFlowsUserPoolClient;
        this.analyticsConfiguration = builder.analyticsConfiguration;
        this.preventUserExistenceErrors = builder.preventUserExistenceErrors;
        this.enableTokenRevocation = builder.enableTokenRevocation;
        this.enablePropagateAdditionalUserContextData = builder.enablePropagateAdditionalUserContextData;
        this.authSessionValidity = builder.authSessionValidity;
        this.refreshTokenRotation = builder.refreshTokenRotation;
    }

    /**
     * <p>
     * The ID of the user pool where you want to create an app client.
     * </p>
     * 
     * @return The ID of the user pool where you want to create an app client.
     */
    public final String userPoolId() {
        return userPoolId;
    }

    /**
     * <p>
     * A friendly name for the app client that you want to create.
     * </p>
     * 
     * @return A friendly name for the app client that you want to create.
     */
    public final String clientName() {
        return clientName;
    }

    /**
     * <p>
     * When <code>true</code>, generates a client secret for the app client. Client secrets are used with server-side
     * and machine-to-machine applications. Client secrets are automatically generated; you can't specify a secret
     * value. For more information, see <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-client-apps.html#user-pool-settings-client-app-client-types"
     * >App client types</a>.
     * </p>
     * 
     * @return When <code>true</code>, generates a client secret for the app client. Client secrets are used with
     *         server-side and machine-to-machine applications. Client secrets are automatically generated; you can't
     *         specify a secret value. For more information, see <a href=
     *         "https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-client-apps.html#user-pool-settings-client-app-client-types"
     *         >App client types</a>.
     */
    public final Boolean generateSecret() {
        return generateSecret;
    }

    /**
     * <p>
     * The refresh token time limit. After this limit expires, your user can't use their refresh token. To specify the
     * time unit for <code>RefreshTokenValidity</code> as <code>seconds</code>, <code>minutes</code>, <code>hours</code>
     * , or <code>days</code>, set a <code>TokenValidityUnits</code> value in your API request.
     * </p>
     * <p>
     * For example, when you set <code>RefreshTokenValidity</code> as <code>10</code> and
     * <code>TokenValidityUnits</code> as <code>days</code>, your user can refresh their session and retrieve new access
     * and ID tokens for 10 days.
     * </p>
     * <p>
     * The default time unit for <code>RefreshTokenValidity</code> in an API request is days. You can't set
     * <code>RefreshTokenValidity</code> to 0. If you do, Amazon Cognito overrides the value with the default value of
     * 30 days. <i>Valid range</i> is displayed below in seconds.
     * </p>
     * <p>
     * If you don't specify otherwise in the configuration of your app client, your refresh tokens are valid for 30
     * days.
     * </p>
     * 
     * @return The refresh token time limit. After this limit expires, your user can't use their refresh token. To
     *         specify the time unit for <code>RefreshTokenValidity</code> as <code>seconds</code>, <code>minutes</code>
     *         , <code>hours</code>, or <code>days</code>, set a <code>TokenValidityUnits</code> value in your API
     *         request.</p>
     *         <p>
     *         For example, when you set <code>RefreshTokenValidity</code> as <code>10</code> and
     *         <code>TokenValidityUnits</code> as <code>days</code>, your user can refresh their session and retrieve
     *         new access and ID tokens for 10 days.
     *         </p>
     *         <p>
     *         The default time unit for <code>RefreshTokenValidity</code> in an API request is days. You can't set
     *         <code>RefreshTokenValidity</code> to 0. If you do, Amazon Cognito overrides the value with the default
     *         value of 30 days. <i>Valid range</i> is displayed below in seconds.
     *         </p>
     *         <p>
     *         If you don't specify otherwise in the configuration of your app client, your refresh tokens are valid for
     *         30 days.
     */
    public final Integer refreshTokenValidity() {
        return refreshTokenValidity;
    }

    /**
     * <p>
     * The access token time limit. After this limit expires, your user can't use their access token. To specify the
     * time unit for <code>AccessTokenValidity</code> as <code>seconds</code>, <code>minutes</code>, <code>hours</code>,
     * or <code>days</code>, set a <code>TokenValidityUnits</code> value in your API request.
     * </p>
     * <p>
     * For example, when you set <code>AccessTokenValidity</code> to <code>10</code> and <code>TokenValidityUnits</code>
     * to <code>hours</code>, your user can authorize access with their access token for 10 hours.
     * </p>
     * <p>
     * The default time unit for <code>AccessTokenValidity</code> in an API request is hours. <i>Valid range</i> is
     * displayed below in seconds.
     * </p>
     * <p>
     * If you don't specify otherwise in the configuration of your app client, your access tokens are valid for one
     * hour.
     * </p>
     * 
     * @return The access token time limit. After this limit expires, your user can't use their access token. To specify
     *         the time unit for <code>AccessTokenValidity</code> as <code>seconds</code>, <code>minutes</code>,
     *         <code>hours</code>, or <code>days</code>, set a <code>TokenValidityUnits</code> value in your API
     *         request.</p>
     *         <p>
     *         For example, when you set <code>AccessTokenValidity</code> to <code>10</code> and
     *         <code>TokenValidityUnits</code> to <code>hours</code>, your user can authorize access with their access
     *         token for 10 hours.
     *         </p>
     *         <p>
     *         The default time unit for <code>AccessTokenValidity</code> in an API request is hours. <i>Valid range</i>
     *         is displayed below in seconds.
     *         </p>
     *         <p>
     *         If you don't specify otherwise in the configuration of your app client, your access tokens are valid for
     *         one hour.
     */
    public final Integer accessTokenValidity() {
        return accessTokenValidity;
    }

    /**
     * <p>
     * The ID token time limit. After this limit expires, your user can't use their ID token. To specify the time unit
     * for <code>IdTokenValidity</code> as <code>seconds</code>, <code>minutes</code>, <code>hours</code>, or
     * <code>days</code>, set a <code>TokenValidityUnits</code> value in your API request.
     * </p>
     * <p>
     * For example, when you set <code>IdTokenValidity</code> as <code>10</code> and <code>TokenValidityUnits</code> as
     * <code>hours</code>, your user can authenticate their session with their ID token for 10 hours.
     * </p>
     * <p>
     * The default time unit for <code>IdTokenValidity</code> in an API request is hours. <i>Valid range</i> is
     * displayed below in seconds.
     * </p>
     * <p>
     * If you don't specify otherwise in the configuration of your app client, your ID tokens are valid for one hour.
     * </p>
     * 
     * @return The ID token time limit. After this limit expires, your user can't use their ID token. To specify the
     *         time unit for <code>IdTokenValidity</code> as <code>seconds</code>, <code>minutes</code>,
     *         <code>hours</code>, or <code>days</code>, set a <code>TokenValidityUnits</code> value in your API
     *         request.</p>
     *         <p>
     *         For example, when you set <code>IdTokenValidity</code> as <code>10</code> and
     *         <code>TokenValidityUnits</code> as <code>hours</code>, your user can authenticate their session with
     *         their ID token for 10 hours.
     *         </p>
     *         <p>
     *         The default time unit for <code>IdTokenValidity</code> in an API request is hours. <i>Valid range</i> is
     *         displayed below in seconds.
     *         </p>
     *         <p>
     *         If you don't specify otherwise in the configuration of your app client, your ID tokens are valid for one
     *         hour.
     */
    public final Integer idTokenValidity() {
        return idTokenValidity;
    }

    /**
     * <p>
     * The units that validity times are represented in. The default unit for refresh tokens is days, and the default
     * for ID and access tokens are hours.
     * </p>
     * 
     * @return The units that validity times are represented in. The default unit for refresh tokens is days, and the
     *         default for ID and access tokens are hours.
     */
    public final TokenValidityUnitsType tokenValidityUnits() {
        return tokenValidityUnits;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReadAttributes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReadAttributes() {
        return readAttributes != null && !(readAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of user attributes that you want your app client to have read access to. After your user authenticates
     * in your app, their access token authorizes them to read their own attribute value for any attribute in this list.
     * </p>
     * <p>
     * When you don't specify the <code>ReadAttributes</code> for your app client, your app can read the values of
     * <code>email_verified</code>, <code>phone_number_verified</code>, and the standard attributes of your user pool.
     * When your user pool app client has read access to these default attributes, <code>ReadAttributes</code> doesn't
     * return any information. Amazon Cognito only populates <code>ReadAttributes</code> in the API response if you have
     * specified your own custom set of read attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReadAttributes} method.
     * </p>
     * 
     * @return The list of user attributes that you want your app client to have read access to. After your user
     *         authenticates in your app, their access token authorizes them to read their own attribute value for any
     *         attribute in this list.</p>
     *         <p>
     *         When you don't specify the <code>ReadAttributes</code> for your app client, your app can read the values
     *         of <code>email_verified</code>, <code>phone_number_verified</code>, and the standard attributes of your
     *         user pool. When your user pool app client has read access to these default attributes,
     *         <code>ReadAttributes</code> doesn't return any information. Amazon Cognito only populates
     *         <code>ReadAttributes</code> in the API response if you have specified your own custom set of read
     *         attributes.
     */
    public final List<String> readAttributes() {
        return readAttributes;
    }

    /**
     * For responses, this returns true if the service returned a value for the WriteAttributes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasWriteAttributes() {
        return writeAttributes != null && !(writeAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of user attributes that you want your app client to have write access to. After your user authenticates
     * in your app, their access token authorizes them to set or modify their own attribute value for any attribute in
     * this list.
     * </p>
     * <p>
     * When you don't specify the <code>WriteAttributes</code> for your app client, your app can write the values of the
     * Standard attributes of your user pool. When your user pool has write access to these default attributes,
     * <code>WriteAttributes</code> doesn't return any information. Amazon Cognito only populates
     * <code>WriteAttributes</code> in the API response if you have specified your own custom set of write attributes.
     * </p>
     * <p>
     * If your app client allows users to sign in through an IdP, this array must include all attributes that you have
     * mapped to IdP attributes. Amazon Cognito updates mapped attributes when users sign in to your application through
     * an IdP. If your app client does not have write access to a mapped attribute, Amazon Cognito throws an error when
     * it tries to update the attribute. For more information, see <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-specifying-attribute-mapping.html"
     * >Specifying IdP Attribute Mappings for Your user pool</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWriteAttributes} method.
     * </p>
     * 
     * @return The list of user attributes that you want your app client to have write access to. After your user
     *         authenticates in your app, their access token authorizes them to set or modify their own attribute value
     *         for any attribute in this list.</p>
     *         <p>
     *         When you don't specify the <code>WriteAttributes</code> for your app client, your app can write the
     *         values of the Standard attributes of your user pool. When your user pool has write access to these
     *         default attributes, <code>WriteAttributes</code> doesn't return any information. Amazon Cognito only
     *         populates <code>WriteAttributes</code> in the API response if you have specified your own custom set of
     *         write attributes.
     *         </p>
     *         <p>
     *         If your app client allows users to sign in through an IdP, this array must include all attributes that
     *         you have mapped to IdP attributes. Amazon Cognito updates mapped attributes when users sign in to your
     *         application through an IdP. If your app client does not have write access to a mapped attribute, Amazon
     *         Cognito throws an error when it tries to update the attribute. For more information, see <a href=
     *         "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-specifying-attribute-mapping.html"
     *         >Specifying IdP Attribute Mappings for Your user pool</a>.
     */
    public final List<String> writeAttributes() {
        return writeAttributes;
    }

    /**
     * <p>
     * The <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-authentication-flow-methods.html"
     * >authentication flows</a> that you want your user pool client to support. For each app client in your user pool,
     * you can sign in your users with any combination of one or more flows, including with a user name and Secure
     * Remote Password (SRP), a user name and password, or a custom authentication process that you define with Lambda
     * functions.
     * </p>
     * <note>
     * <p>
     * If you don't specify a value for <code>ExplicitAuthFlows</code>, your app client supports
     * <code>ALLOW_REFRESH_TOKEN_AUTH</code>, <code>ALLOW_USER_SRP_AUTH</code>, and <code>ALLOW_CUSTOM_AUTH</code>.
     * </p>
     * </note>
     * <p>
     * The values for authentication flow options include the following.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALLOW_USER_AUTH</code>: Enable selection-based sign-in with <code>USER_AUTH</code>. This setting covers
     * username-password, secure remote password (SRP), passwordless, and passkey authentication. This authentiation
     * flow can do username-password and SRP authentication without other <code>ExplicitAuthFlows</code> permitting
     * them. For example users can complete an SRP challenge through <code>USER_AUTH</code> without the flow
     * <code>USER_SRP_AUTH</code> being active for the app client. This flow doesn't include <code>CUSTOM_AUTH</code>.
     * </p>
     * <p>
     * To activate this setting, your user pool must be in the <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/feature-plans-features-essentials.html">
     * Essentials tier</a> or higher.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALLOW_ADMIN_USER_PASSWORD_AUTH</code>: Enable admin based user password authentication flow
     * <code>ADMIN_USER_PASSWORD_AUTH</code>. This setting replaces the <code>ADMIN_NO_SRP_AUTH</code> setting. With
     * this authentication flow, your app passes a user name and password to Amazon Cognito in the request, instead of
     * using the Secure Remote Password (SRP) protocol to securely transmit the password.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALLOW_CUSTOM_AUTH</code>: Enable Lambda trigger based authentication.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALLOW_USER_PASSWORD_AUTH</code>: Enable user password-based authentication. In this flow, Amazon Cognito
     * receives the password in the request instead of using the SRP protocol to verify passwords.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALLOW_USER_SRP_AUTH</code>: Enable SRP-based authentication.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALLOW_REFRESH_TOKEN_AUTH</code>: Enable authflow to refresh tokens.
     * </p>
     * </li>
     * </ul>
     * <p>
     * In some environments, you will see the values <code>ADMIN_NO_SRP_AUTH</code>, <code>CUSTOM_AUTH_FLOW_ONLY</code>,
     * or <code>USER_PASSWORD_AUTH</code>. You can't assign these legacy <code>ExplicitAuthFlows</code> values to user
     * pool clients at the same time as values that begin with <code>ALLOW_</code>, like
     * <code>ALLOW_USER_SRP_AUTH</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExplicitAuthFlows} method.
     * </p>
     * 
     * @return The <a href=
     *         "https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-authentication-flow-methods.html"
     *         >authentication flows</a> that you want your user pool client to support. For each app client in your
     *         user pool, you can sign in your users with any combination of one or more flows, including with a user
     *         name and Secure Remote Password (SRP), a user name and password, or a custom authentication process that
     *         you define with Lambda functions.</p> <note>
     *         <p>
     *         If you don't specify a value for <code>ExplicitAuthFlows</code>, your app client supports
     *         <code>ALLOW_REFRESH_TOKEN_AUTH</code>, <code>ALLOW_USER_SRP_AUTH</code>, and
     *         <code>ALLOW_CUSTOM_AUTH</code>.
     *         </p>
     *         </note>
     *         <p>
     *         The values for authentication flow options include the following.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALLOW_USER_AUTH</code>: Enable selection-based sign-in with <code>USER_AUTH</code>. This setting
     *         covers username-password, secure remote password (SRP), passwordless, and passkey authentication. This
     *         authentiation flow can do username-password and SRP authentication without other
     *         <code>ExplicitAuthFlows</code> permitting them. For example users can complete an SRP challenge through
     *         <code>USER_AUTH</code> without the flow <code>USER_SRP_AUTH</code> being active for the app client. This
     *         flow doesn't include <code>CUSTOM_AUTH</code>.
     *         </p>
     *         <p>
     *         To activate this setting, your user pool must be in the <a
     *         href="https://docs.aws.amazon.com/cognito/latest/developerguide/feature-plans-features-essentials.html">
     *         Essentials tier</a> or higher.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALLOW_ADMIN_USER_PASSWORD_AUTH</code>: Enable admin based user password authentication flow
     *         <code>ADMIN_USER_PASSWORD_AUTH</code>. This setting replaces the <code>ADMIN_NO_SRP_AUTH</code> setting.
     *         With this authentication flow, your app passes a user name and password to Amazon Cognito in the request,
     *         instead of using the Secure Remote Password (SRP) protocol to securely transmit the password.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALLOW_CUSTOM_AUTH</code>: Enable Lambda trigger based authentication.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALLOW_USER_PASSWORD_AUTH</code>: Enable user password-based authentication. In this flow, Amazon
     *         Cognito receives the password in the request instead of using the SRP protocol to verify passwords.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALLOW_USER_SRP_AUTH</code>: Enable SRP-based authentication.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALLOW_REFRESH_TOKEN_AUTH</code>: Enable authflow to refresh tokens.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         In some environments, you will see the values <code>ADMIN_NO_SRP_AUTH</code>,
     *         <code>CUSTOM_AUTH_FLOW_ONLY</code>, or <code>USER_PASSWORD_AUTH</code>. You can't assign these legacy
     *         <code>ExplicitAuthFlows</code> values to user pool clients at the same time as values that begin with
     *         <code>ALLOW_</code>, like <code>ALLOW_USER_SRP_AUTH</code>.
     */
    public final List<ExplicitAuthFlowsType> explicitAuthFlows() {
        return ExplicitAuthFlowsListTypeCopier.copyStringToEnum(explicitAuthFlows);
    }

    /**
     * For responses, this returns true if the service returned a value for the ExplicitAuthFlows property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExplicitAuthFlows() {
        return explicitAuthFlows != null && !(explicitAuthFlows instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-authentication-flow-methods.html"
     * >authentication flows</a> that you want your user pool client to support. For each app client in your user pool,
     * you can sign in your users with any combination of one or more flows, including with a user name and Secure
     * Remote Password (SRP), a user name and password, or a custom authentication process that you define with Lambda
     * functions.
     * </p>
     * <note>
     * <p>
     * If you don't specify a value for <code>ExplicitAuthFlows</code>, your app client supports
     * <code>ALLOW_REFRESH_TOKEN_AUTH</code>, <code>ALLOW_USER_SRP_AUTH</code>, and <code>ALLOW_CUSTOM_AUTH</code>.
     * </p>
     * </note>
     * <p>
     * The values for authentication flow options include the following.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALLOW_USER_AUTH</code>: Enable selection-based sign-in with <code>USER_AUTH</code>. This setting covers
     * username-password, secure remote password (SRP), passwordless, and passkey authentication. This authentiation
     * flow can do username-password and SRP authentication without other <code>ExplicitAuthFlows</code> permitting
     * them. For example users can complete an SRP challenge through <code>USER_AUTH</code> without the flow
     * <code>USER_SRP_AUTH</code> being active for the app client. This flow doesn't include <code>CUSTOM_AUTH</code>.
     * </p>
     * <p>
     * To activate this setting, your user pool must be in the <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/feature-plans-features-essentials.html">
     * Essentials tier</a> or higher.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALLOW_ADMIN_USER_PASSWORD_AUTH</code>: Enable admin based user password authentication flow
     * <code>ADMIN_USER_PASSWORD_AUTH</code>. This setting replaces the <code>ADMIN_NO_SRP_AUTH</code> setting. With
     * this authentication flow, your app passes a user name and password to Amazon Cognito in the request, instead of
     * using the Secure Remote Password (SRP) protocol to securely transmit the password.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALLOW_CUSTOM_AUTH</code>: Enable Lambda trigger based authentication.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALLOW_USER_PASSWORD_AUTH</code>: Enable user password-based authentication. In this flow, Amazon Cognito
     * receives the password in the request instead of using the SRP protocol to verify passwords.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALLOW_USER_SRP_AUTH</code>: Enable SRP-based authentication.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALLOW_REFRESH_TOKEN_AUTH</code>: Enable authflow to refresh tokens.
     * </p>
     * </li>
     * </ul>
     * <p>
     * In some environments, you will see the values <code>ADMIN_NO_SRP_AUTH</code>, <code>CUSTOM_AUTH_FLOW_ONLY</code>,
     * or <code>USER_PASSWORD_AUTH</code>. You can't assign these legacy <code>ExplicitAuthFlows</code> values to user
     * pool clients at the same time as values that begin with <code>ALLOW_</code>, like
     * <code>ALLOW_USER_SRP_AUTH</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExplicitAuthFlows} method.
     * </p>
     * 
     * @return The <a href=
     *         "https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-authentication-flow-methods.html"
     *         >authentication flows</a> that you want your user pool client to support. For each app client in your
     *         user pool, you can sign in your users with any combination of one or more flows, including with a user
     *         name and Secure Remote Password (SRP), a user name and password, or a custom authentication process that
     *         you define with Lambda functions.</p> <note>
     *         <p>
     *         If you don't specify a value for <code>ExplicitAuthFlows</code>, your app client supports
     *         <code>ALLOW_REFRESH_TOKEN_AUTH</code>, <code>ALLOW_USER_SRP_AUTH</code>, and
     *         <code>ALLOW_CUSTOM_AUTH</code>.
     *         </p>
     *         </note>
     *         <p>
     *         The values for authentication flow options include the following.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALLOW_USER_AUTH</code>: Enable selection-based sign-in with <code>USER_AUTH</code>. This setting
     *         covers username-password, secure remote password (SRP), passwordless, and passkey authentication. This
     *         authentiation flow can do username-password and SRP authentication without other
     *         <code>ExplicitAuthFlows</code> permitting them. For example users can complete an SRP challenge through
     *         <code>USER_AUTH</code> without the flow <code>USER_SRP_AUTH</code> being active for the app client. This
     *         flow doesn't include <code>CUSTOM_AUTH</code>.
     *         </p>
     *         <p>
     *         To activate this setting, your user pool must be in the <a
     *         href="https://docs.aws.amazon.com/cognito/latest/developerguide/feature-plans-features-essentials.html">
     *         Essentials tier</a> or higher.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALLOW_ADMIN_USER_PASSWORD_AUTH</code>: Enable admin based user password authentication flow
     *         <code>ADMIN_USER_PASSWORD_AUTH</code>. This setting replaces the <code>ADMIN_NO_SRP_AUTH</code> setting.
     *         With this authentication flow, your app passes a user name and password to Amazon Cognito in the request,
     *         instead of using the Secure Remote Password (SRP) protocol to securely transmit the password.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALLOW_CUSTOM_AUTH</code>: Enable Lambda trigger based authentication.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALLOW_USER_PASSWORD_AUTH</code>: Enable user password-based authentication. In this flow, Amazon
     *         Cognito receives the password in the request instead of using the SRP protocol to verify passwords.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALLOW_USER_SRP_AUTH</code>: Enable SRP-based authentication.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALLOW_REFRESH_TOKEN_AUTH</code>: Enable authflow to refresh tokens.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         In some environments, you will see the values <code>ADMIN_NO_SRP_AUTH</code>,
     *         <code>CUSTOM_AUTH_FLOW_ONLY</code>, or <code>USER_PASSWORD_AUTH</code>. You can't assign these legacy
     *         <code>ExplicitAuthFlows</code> values to user pool clients at the same time as values that begin with
     *         <code>ALLOW_</code>, like <code>ALLOW_USER_SRP_AUTH</code>.
     */
    public final List<String> explicitAuthFlowsAsStrings() {
        return explicitAuthFlows;
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedIdentityProviders property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSupportedIdentityProviders() {
        return supportedIdentityProviders != null && !(supportedIdentityProviders instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of provider names for the identity providers (IdPs) that are supported on this client. The following are
     * supported: <code>COGNITO</code>, <code>Facebook</code>, <code>Google</code>, <code>SignInWithApple</code>, and
     * <code>LoginWithAmazon</code>. You can also specify the names that you configured for the SAML and OIDC IdPs in
     * your user pool, for example <code>MySAMLIdP</code> or <code>MyOIDCIdP</code>.
     * </p>
     * <p>
     * This parameter sets the IdPs that <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-managed-login.html">managed
     * login</a> will display on the login page for your app client. The removal of <code>COGNITO</code> from this list
     * doesn't prevent authentication operations for local users with the user pools API in an Amazon Web Services SDK.
     * The only way to prevent SDK-based authentication is to block access with a <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-waf.html">WAF rule</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedIdentityProviders} method.
     * </p>
     * 
     * @return A list of provider names for the identity providers (IdPs) that are supported on this client. The
     *         following are supported: <code>COGNITO</code>, <code>Facebook</code>, <code>Google</code>,
     *         <code>SignInWithApple</code>, and <code>LoginWithAmazon</code>. You can also specify the names that you
     *         configured for the SAML and OIDC IdPs in your user pool, for example <code>MySAMLIdP</code> or
     *         <code>MyOIDCIdP</code>.</p>
     *         <p>
     *         This parameter sets the IdPs that <a
     *         href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-managed-login.html"
     *         >managed login</a> will display on the login page for your app client. The removal of
     *         <code>COGNITO</code> from this list doesn't prevent authentication operations for local users with the
     *         user pools API in an Amazon Web Services SDK. The only way to prevent SDK-based authentication is to
     *         block access with a <a
     *         href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-waf.html">WAF rule</a>.
     */
    public final List<String> supportedIdentityProviders() {
        return supportedIdentityProviders;
    }

    /**
     * For responses, this returns true if the service returned a value for the CallbackURLs property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCallbackURLs() {
        return callbackURLs != null && !(callbackURLs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of allowed redirect, or callback, URLs for managed login authentication. These URLs are the paths where
     * you want to send your users' browsers after they complete authentication with managed login or a third-party IdP.
     * Typically, callback URLs are the home of an application that uses OAuth or OIDC libraries to process
     * authentication outcomes.
     * </p>
     * <p>
     * A redirect URI must meet the following requirements:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Be an absolute URI.
     * </p>
     * </li>
     * <li>
     * <p>
     * Be registered with the authorization server. Amazon Cognito doesn't accept authorization requests with
     * <code>redirect_uri</code> values that aren't in the list of <code>CallbackURLs</code> that you provide in this
     * parameter.
     * </p>
     * </li>
     * <li>
     * <p>
     * Not include a fragment component.
     * </p>
     * </li>
     * </ul>
     * <p>
     * See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.
     * </p>
     * <p>
     * Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.
     * </p>
     * <p>
     * App callback URLs such as myapp://example are also supported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCallbackURLs} method.
     * </p>
     * 
     * @return A list of allowed redirect, or callback, URLs for managed login authentication. These URLs are the paths
     *         where you want to send your users' browsers after they complete authentication with managed login or a
     *         third-party IdP. Typically, callback URLs are the home of an application that uses OAuth or OIDC
     *         libraries to process authentication outcomes.</p>
     *         <p>
     *         A redirect URI must meet the following requirements:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Be an absolute URI.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be registered with the authorization server. Amazon Cognito doesn't accept authorization requests with
     *         <code>redirect_uri</code> values that aren't in the list of <code>CallbackURLs</code> that you provide in
     *         this parameter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not include a fragment component.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.
     *         </p>
     *         <p>
     *         Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.
     *         </p>
     *         <p>
     *         App callback URLs such as myapp://example are also supported.
     */
    public final List<String> callbackURLs() {
        return callbackURLs;
    }

    /**
     * For responses, this returns true if the service returned a value for the LogoutURLs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLogoutURLs() {
        return logoutURLs != null && !(logoutURLs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of allowed logout URLs for managed login authentication. When you pass <code>logout_uri</code> and
     * <code>client_id</code> parameters to <code>/logout</code>, Amazon Cognito signs out your user and redirects them
     * to the logout URL. This parameter describes the URLs that you want to be the permitted targets of
     * <code>logout_uri</code>. A typical use of these URLs is when a user selects "Sign out" and you redirect them to
     * your public homepage. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/logout-endpoint.html">Logout endpoint</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLogoutURLs} method.
     * </p>
     * 
     * @return A list of allowed logout URLs for managed login authentication. When you pass <code>logout_uri</code> and
     *         <code>client_id</code> parameters to <code>/logout</code>, Amazon Cognito signs out your user and
     *         redirects them to the logout URL. This parameter describes the URLs that you want to be the permitted
     *         targets of <code>logout_uri</code>. A typical use of these URLs is when a user selects "Sign out" and you
     *         redirect them to your public homepage. For more information, see <a
     *         href="https://docs.aws.amazon.com/cognito/latest/developerguide/logout-endpoint.html">Logout
     *         endpoint</a>.
     */
    public final List<String> logoutURLs() {
        return logoutURLs;
    }

    /**
     * <p>
     * The default redirect URI. In app clients with one assigned IdP, replaces <code>redirect_uri</code> in
     * authentication requests. Must be in the <code>CallbackURLs</code> list.
     * </p>
     * 
     * @return The default redirect URI. In app clients with one assigned IdP, replaces <code>redirect_uri</code> in
     *         authentication requests. Must be in the <code>CallbackURLs</code> list.
     */
    public final String defaultRedirectURI() {
        return defaultRedirectURI;
    }

    /**
     * <p>
     * The OAuth grant types that you want your app client to generate for clients in managed login authentication. To
     * create an app client that generates client credentials grants, you must add <code>client_credentials</code> as
     * the only allowed OAuth flow.
     * </p>
     * <dl>
     * <dt>code</dt>
     * <dd>
     * <p>
     * Use a code grant flow, which provides an authorization code as the response. This code can be exchanged for
     * access tokens with the <code>/oauth2/token</code> endpoint.
     * </p>
     * </dd>
     * <dt>implicit</dt>
     * <dd>
     * <p>
     * Issue the access token, and the ID token when scopes like <code>openid</code> and <code>profile</code> are
     * requested, directly to your user.
     * </p>
     * </dd>
     * <dt>client_credentials</dt>
     * <dd>
     * <p>
     * Issue the access token from the <code>/oauth2/token</code> endpoint directly to a non-person user, authorized by
     * a combination of the client ID and client secret.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedOAuthFlows} method.
     * </p>
     * 
     * @return The OAuth grant types that you want your app client to generate for clients in managed login
     *         authentication. To create an app client that generates client credentials grants, you must add
     *         <code>client_credentials</code> as the only allowed OAuth flow.</p>
     *         <dl>
     *         <dt>code</dt>
     *         <dd>
     *         <p>
     *         Use a code grant flow, which provides an authorization code as the response. This code can be exchanged
     *         for access tokens with the <code>/oauth2/token</code> endpoint.
     *         </p>
     *         </dd>
     *         <dt>implicit</dt>
     *         <dd>
     *         <p>
     *         Issue the access token, and the ID token when scopes like <code>openid</code> and <code>profile</code>
     *         are requested, directly to your user.
     *         </p>
     *         </dd>
     *         <dt>client_credentials</dt>
     *         <dd>
     *         <p>
     *         Issue the access token from the <code>/oauth2/token</code> endpoint directly to a non-person user,
     *         authorized by a combination of the client ID and client secret.
     *         </p>
     *         </dd>
     */
    public final List<OAuthFlowType> allowedOAuthFlows() {
        return OAuthFlowsTypeCopier.copyStringToEnum(allowedOAuthFlows);
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowedOAuthFlows property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAllowedOAuthFlows() {
        return allowedOAuthFlows != null && !(allowedOAuthFlows instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The OAuth grant types that you want your app client to generate for clients in managed login authentication. To
     * create an app client that generates client credentials grants, you must add <code>client_credentials</code> as
     * the only allowed OAuth flow.
     * </p>
     * <dl>
     * <dt>code</dt>
     * <dd>
     * <p>
     * Use a code grant flow, which provides an authorization code as the response. This code can be exchanged for
     * access tokens with the <code>/oauth2/token</code> endpoint.
     * </p>
     * </dd>
     * <dt>implicit</dt>
     * <dd>
     * <p>
     * Issue the access token, and the ID token when scopes like <code>openid</code> and <code>profile</code> are
     * requested, directly to your user.
     * </p>
     * </dd>
     * <dt>client_credentials</dt>
     * <dd>
     * <p>
     * Issue the access token from the <code>/oauth2/token</code> endpoint directly to a non-person user, authorized by
     * a combination of the client ID and client secret.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedOAuthFlows} method.
     * </p>
     * 
     * @return The OAuth grant types that you want your app client to generate for clients in managed login
     *         authentication. To create an app client that generates client credentials grants, you must add
     *         <code>client_credentials</code> as the only allowed OAuth flow.</p>
     *         <dl>
     *         <dt>code</dt>
     *         <dd>
     *         <p>
     *         Use a code grant flow, which provides an authorization code as the response. This code can be exchanged
     *         for access tokens with the <code>/oauth2/token</code> endpoint.
     *         </p>
     *         </dd>
     *         <dt>implicit</dt>
     *         <dd>
     *         <p>
     *         Issue the access token, and the ID token when scopes like <code>openid</code> and <code>profile</code>
     *         are requested, directly to your user.
     *         </p>
     *         </dd>
     *         <dt>client_credentials</dt>
     *         <dd>
     *         <p>
     *         Issue the access token from the <code>/oauth2/token</code> endpoint directly to a non-person user,
     *         authorized by a combination of the client ID and client secret.
     *         </p>
     *         </dd>
     */
    public final List<String> allowedOAuthFlowsAsStrings() {
        return allowedOAuthFlows;
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowedOAuthScopes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAllowedOAuthScopes() {
        return allowedOAuthScopes != null && !(allowedOAuthScopes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The OAuth, OpenID Connect (OIDC), and custom scopes that you want to permit your app client to authorize access
     * with. Scopes govern access control to user pool self-service API operations, user data from the
     * <code>userInfo</code> endpoint, and third-party APIs. Scope values include <code>phone</code>, <code>email</code>, <code>openid</code>, and <code>profile</code>. The <code>aws.cognito.signin.user.admin</code> scope authorizes
     * user self-service operations. Custom scopes with resource servers authorize access to external APIs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedOAuthScopes} method.
     * </p>
     * 
     * @return The OAuth, OpenID Connect (OIDC), and custom scopes that you want to permit your app client to authorize
     *         access with. Scopes govern access control to user pool self-service API operations, user data from the
     *         <code>userInfo</code> endpoint, and third-party APIs. Scope values include <code>phone</code>,
     *         <code>email</code>, <code>openid</code>, and <code>profile</code>. The
     *         <code>aws.cognito.signin.user.admin</code> scope authorizes user self-service operations. Custom scopes
     *         with resource servers authorize access to external APIs.
     */
    public final List<String> allowedOAuthScopes() {
        return allowedOAuthScopes;
    }

    /**
     * <p>
     * Set to <code>true</code> to use OAuth 2.0 authorization server features in your app client.
     * </p>
     * <p>
     * This parameter must have a value of <code>true</code> before you can configure the following features in your app
     * client.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CallBackURLs</code>: Callback URLs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LogoutURLs</code>: Sign-out redirect URLs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AllowedOAuthScopes</code>: OAuth 2.0 scopes.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AllowedOAuthFlows</code>: Support for authorization code, implicit, and client credentials OAuth 2.0
     * grants.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To use authorization server features, configure one of these features in the Amazon Cognito console or set
     * <code>AllowedOAuthFlowsUserPoolClient</code> to <code>true</code> in a <code>CreateUserPoolClient</code> or
     * <code>UpdateUserPoolClient</code> API request. If you don't set a value for
     * <code>AllowedOAuthFlowsUserPoolClient</code> in a request with the CLI or SDKs, it defaults to <code>false</code>
     * . When <code>false</code>, only SDK-based API sign-in is permitted.
     * </p>
     * 
     * @return Set to <code>true</code> to use OAuth 2.0 authorization server features in your app client.</p>
     *         <p>
     *         This parameter must have a value of <code>true</code> before you can configure the following features in
     *         your app client.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CallBackURLs</code>: Callback URLs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LogoutURLs</code>: Sign-out redirect URLs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AllowedOAuthScopes</code>: OAuth 2.0 scopes.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AllowedOAuthFlows</code>: Support for authorization code, implicit, and client credentials OAuth
     *         2.0 grants.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         To use authorization server features, configure one of these features in the Amazon Cognito console or
     *         set <code>AllowedOAuthFlowsUserPoolClient</code> to <code>true</code> in a
     *         <code>CreateUserPoolClient</code> or <code>UpdateUserPoolClient</code> API request. If you don't set a
     *         value for <code>AllowedOAuthFlowsUserPoolClient</code> in a request with the CLI or SDKs, it defaults to
     *         <code>false</code>. When <code>false</code>, only SDK-based API sign-in is permitted.
     */
    public final Boolean allowedOAuthFlowsUserPoolClient() {
        return allowedOAuthFlowsUserPoolClient;
    }

    /**
     * <p>
     * The user pool analytics configuration for collecting metrics and sending them to your Amazon Pinpoint campaign.
     * </p>
     * <p>
     * In Amazon Web Services Regions where Amazon Pinpoint isn't available, user pools might not have access to
     * analytics or might be configurable with campaigns in the US East (N. Virginia) Region. For more information, see
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-pinpoint-integration.html">
     * Using Amazon Pinpoint analytics</a>.
     * </p>
     * 
     * @return The user pool analytics configuration for collecting metrics and sending them to your Amazon Pinpoint
     *         campaign.</p>
     *         <p>
     *         In Amazon Web Services Regions where Amazon Pinpoint isn't available, user pools might not have access to
     *         analytics or might be configurable with campaigns in the US East (N. Virginia) Region. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-pinpoint-integration.html"
     *         >Using Amazon Pinpoint analytics</a>.
     */
    public final AnalyticsConfigurationType analyticsConfiguration() {
        return analyticsConfiguration;
    }

    /**
     * <p>
     * When <code>ENABLED</code>, suppresses messages that might indicate a valid user exists when someone attempts
     * sign-in. This parameters sets your preference for the errors and responses that you want Amazon Cognito APIs to
     * return during authentication, account confirmation, and password recovery when the user doesn't exist in the user
     * pool. When set to <code>ENABLED</code> and the user doesn't exist, authentication returns an error indicating
     * either the username or password was incorrect. Account confirmation and password recovery return a response
     * indicating a code was sent to a simulated destination. When set to <code>LEGACY</code>, those APIs return a
     * <code>UserNotFoundException</code> exception if the user doesn't exist in the user pool.
     * </p>
     * <p>
     * Defaults to <code>LEGACY</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #preventUserExistenceErrors} will return {@link PreventUserExistenceErrorTypes#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #preventUserExistenceErrorsAsString}.
     * </p>
     * 
     * @return When <code>ENABLED</code>, suppresses messages that might indicate a valid user exists when someone
     *         attempts sign-in. This parameters sets your preference for the errors and responses that you want Amazon
     *         Cognito APIs to return during authentication, account confirmation, and password recovery when the user
     *         doesn't exist in the user pool. When set to <code>ENABLED</code> and the user doesn't exist,
     *         authentication returns an error indicating either the username or password was incorrect. Account
     *         confirmation and password recovery return a response indicating a code was sent to a simulated
     *         destination. When set to <code>LEGACY</code>, those APIs return a <code>UserNotFoundException</code>
     *         exception if the user doesn't exist in the user pool.</p>
     *         <p>
     *         Defaults to <code>LEGACY</code>.
     * @see PreventUserExistenceErrorTypes
     */
    public final PreventUserExistenceErrorTypes preventUserExistenceErrors() {
        return PreventUserExistenceErrorTypes.fromValue(preventUserExistenceErrors);
    }

    /**
     * <p>
     * When <code>ENABLED</code>, suppresses messages that might indicate a valid user exists when someone attempts
     * sign-in. This parameters sets your preference for the errors and responses that you want Amazon Cognito APIs to
     * return during authentication, account confirmation, and password recovery when the user doesn't exist in the user
     * pool. When set to <code>ENABLED</code> and the user doesn't exist, authentication returns an error indicating
     * either the username or password was incorrect. Account confirmation and password recovery return a response
     * indicating a code was sent to a simulated destination. When set to <code>LEGACY</code>, those APIs return a
     * <code>UserNotFoundException</code> exception if the user doesn't exist in the user pool.
     * </p>
     * <p>
     * Defaults to <code>LEGACY</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #preventUserExistenceErrors} will return {@link PreventUserExistenceErrorTypes#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #preventUserExistenceErrorsAsString}.
     * </p>
     * 
     * @return When <code>ENABLED</code>, suppresses messages that might indicate a valid user exists when someone
     *         attempts sign-in. This parameters sets your preference for the errors and responses that you want Amazon
     *         Cognito APIs to return during authentication, account confirmation, and password recovery when the user
     *         doesn't exist in the user pool. When set to <code>ENABLED</code> and the user doesn't exist,
     *         authentication returns an error indicating either the username or password was incorrect. Account
     *         confirmation and password recovery return a response indicating a code was sent to a simulated
     *         destination. When set to <code>LEGACY</code>, those APIs return a <code>UserNotFoundException</code>
     *         exception if the user doesn't exist in the user pool.</p>
     *         <p>
     *         Defaults to <code>LEGACY</code>.
     * @see PreventUserExistenceErrorTypes
     */
    public final String preventUserExistenceErrorsAsString() {
        return preventUserExistenceErrors;
    }

    /**
     * <p>
     * Activates or deactivates <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/token-revocation.html">token revocation</a> in
     * the target app client.
     * </p>
     * <p>
     * If you don't include this parameter, token revocation is automatically activated for the new user pool client.
     * </p>
     * 
     * @return Activates or deactivates <a
     *         href="https://docs.aws.amazon.com/cognito/latest/developerguide/token-revocation.html">token
     *         revocation</a> in the target app client.</p>
     *         <p>
     *         If you don't include this parameter, token revocation is automatically activated for the new user pool
     *         client.
     */
    public final Boolean enableTokenRevocation() {
        return enableTokenRevocation;
    }

    /**
     * <p>
     * When <code>true</code>, your application can include additional <code>UserContextData</code> in authentication
     * requests. This data includes the IP address, and contributes to analysis by threat protection features. For more
     * information about propagation of user context data, see <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-adaptive-authentication.html#user-pool-settings-adaptive-authentication-device-fingerprint"
     * >Adding session data to API requests</a>. If you don’t include this parameter, you can't send the source IP
     * address to Amazon Cognito threat protection features. You can only activate
     * <code>EnablePropagateAdditionalUserContextData</code> in an app client that has a client secret.
     * </p>
     * 
     * @return When <code>true</code>, your application can include additional <code>UserContextData</code> in
     *         authentication requests. This data includes the IP address, and contributes to analysis by threat
     *         protection features. For more information about propagation of user context data, see <a href=
     *         "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-adaptive-authentication.html#user-pool-settings-adaptive-authentication-device-fingerprint"
     *         >Adding session data to API requests</a>. If you don’t include this parameter, you can't send the source
     *         IP address to Amazon Cognito threat protection features. You can only activate
     *         <code>EnablePropagateAdditionalUserContextData</code> in an app client that has a client secret.
     */
    public final Boolean enablePropagateAdditionalUserContextData() {
        return enablePropagateAdditionalUserContextData;
    }

    /**
     * <p>
     * Amazon Cognito creates a session token for each API request in an authentication flow.
     * <code>AuthSessionValidity</code> is the duration, in minutes, of that session token. Your user pool native user
     * must respond to each authentication challenge before the session expires.
     * </p>
     * 
     * @return Amazon Cognito creates a session token for each API request in an authentication flow.
     *         <code>AuthSessionValidity</code> is the duration, in minutes, of that session token. Your user pool
     *         native user must respond to each authentication challenge before the session expires.
     */
    public final Integer authSessionValidity() {
        return authSessionValidity;
    }

    /**
     * <p>
     * The configuration of your app client for refresh token rotation. When enabled, your app client issues new ID,
     * access, and refresh tokens when users renew their sessions with refresh tokens. When disabled, token refresh
     * issues only ID and access tokens.
     * </p>
     * 
     * @return The configuration of your app client for refresh token rotation. When enabled, your app client issues new
     *         ID, access, and refresh tokens when users renew their sessions with refresh tokens. When disabled, token
     *         refresh issues only ID and access tokens.
     */
    public final RefreshTokenRotationType refreshTokenRotation() {
        return refreshTokenRotation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(clientName());
        hashCode = 31 * hashCode + Objects.hashCode(generateSecret());
        hashCode = 31 * hashCode + Objects.hashCode(refreshTokenValidity());
        hashCode = 31 * hashCode + Objects.hashCode(accessTokenValidity());
        hashCode = 31 * hashCode + Objects.hashCode(idTokenValidity());
        hashCode = 31 * hashCode + Objects.hashCode(tokenValidityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(hasReadAttributes() ? readAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasWriteAttributes() ? writeAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasExplicitAuthFlows() ? explicitAuthFlowsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedIdentityProviders() ? supportedIdentityProviders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCallbackURLs() ? callbackURLs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLogoutURLs() ? logoutURLs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(defaultRedirectURI());
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedOAuthFlows() ? allowedOAuthFlowsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedOAuthScopes() ? allowedOAuthScopes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(allowedOAuthFlowsUserPoolClient());
        hashCode = 31 * hashCode + Objects.hashCode(analyticsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(preventUserExistenceErrorsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(enableTokenRevocation());
        hashCode = 31 * hashCode + Objects.hashCode(enablePropagateAdditionalUserContextData());
        hashCode = 31 * hashCode + Objects.hashCode(authSessionValidity());
        hashCode = 31 * hashCode + Objects.hashCode(refreshTokenRotation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUserPoolClientRequest)) {
            return false;
        }
        CreateUserPoolClientRequest other = (CreateUserPoolClientRequest) obj;
        return Objects.equals(userPoolId(), other.userPoolId()) && Objects.equals(clientName(), other.clientName())
                && Objects.equals(generateSecret(), other.generateSecret())
                && Objects.equals(refreshTokenValidity(), other.refreshTokenValidity())
                && Objects.equals(accessTokenValidity(), other.accessTokenValidity())
                && Objects.equals(idTokenValidity(), other.idTokenValidity())
                && Objects.equals(tokenValidityUnits(), other.tokenValidityUnits())
                && hasReadAttributes() == other.hasReadAttributes() && Objects.equals(readAttributes(), other.readAttributes())
                && hasWriteAttributes() == other.hasWriteAttributes()
                && Objects.equals(writeAttributes(), other.writeAttributes())
                && hasExplicitAuthFlows() == other.hasExplicitAuthFlows()
                && Objects.equals(explicitAuthFlowsAsStrings(), other.explicitAuthFlowsAsStrings())
                && hasSupportedIdentityProviders() == other.hasSupportedIdentityProviders()
                && Objects.equals(supportedIdentityProviders(), other.supportedIdentityProviders())
                && hasCallbackURLs() == other.hasCallbackURLs() && Objects.equals(callbackURLs(), other.callbackURLs())
                && hasLogoutURLs() == other.hasLogoutURLs() && Objects.equals(logoutURLs(), other.logoutURLs())
                && Objects.equals(defaultRedirectURI(), other.defaultRedirectURI())
                && hasAllowedOAuthFlows() == other.hasAllowedOAuthFlows()
                && Objects.equals(allowedOAuthFlowsAsStrings(), other.allowedOAuthFlowsAsStrings())
                && hasAllowedOAuthScopes() == other.hasAllowedOAuthScopes()
                && Objects.equals(allowedOAuthScopes(), other.allowedOAuthScopes())
                && Objects.equals(allowedOAuthFlowsUserPoolClient(), other.allowedOAuthFlowsUserPoolClient())
                && Objects.equals(analyticsConfiguration(), other.analyticsConfiguration())
                && Objects.equals(preventUserExistenceErrorsAsString(), other.preventUserExistenceErrorsAsString())
                && Objects.equals(enableTokenRevocation(), other.enableTokenRevocation())
                && Objects.equals(enablePropagateAdditionalUserContextData(), other.enablePropagateAdditionalUserContextData())
                && Objects.equals(authSessionValidity(), other.authSessionValidity())
                && Objects.equals(refreshTokenRotation(), other.refreshTokenRotation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateUserPoolClientRequest").add("UserPoolId", userPoolId()).add("ClientName", clientName())
                .add("GenerateSecret", generateSecret()).add("RefreshTokenValidity", refreshTokenValidity())
                .add("AccessTokenValidity", accessTokenValidity()).add("IdTokenValidity", idTokenValidity())
                .add("TokenValidityUnits", tokenValidityUnits())
                .add("ReadAttributes", hasReadAttributes() ? readAttributes() : null)
                .add("WriteAttributes", hasWriteAttributes() ? writeAttributes() : null)
                .add("ExplicitAuthFlows", hasExplicitAuthFlows() ? explicitAuthFlowsAsStrings() : null)
                .add("SupportedIdentityProviders", hasSupportedIdentityProviders() ? supportedIdentityProviders() : null)
                .add("CallbackURLs", hasCallbackURLs() ? callbackURLs() : null)
                .add("LogoutURLs", hasLogoutURLs() ? logoutURLs() : null).add("DefaultRedirectURI", defaultRedirectURI())
                .add("AllowedOAuthFlows", hasAllowedOAuthFlows() ? allowedOAuthFlowsAsStrings() : null)
                .add("AllowedOAuthScopes", hasAllowedOAuthScopes() ? allowedOAuthScopes() : null)
                .add("AllowedOAuthFlowsUserPoolClient", allowedOAuthFlowsUserPoolClient())
                .add("AnalyticsConfiguration", analyticsConfiguration())
                .add("PreventUserExistenceErrors", preventUserExistenceErrorsAsString())
                .add("EnableTokenRevocation", enableTokenRevocation())
                .add("EnablePropagateAdditionalUserContextData", enablePropagateAdditionalUserContextData())
                .add("AuthSessionValidity", authSessionValidity()).add("RefreshTokenRotation", refreshTokenRotation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserPoolId":
            return Optional.ofNullable(clazz.cast(userPoolId()));
        case "ClientName":
            return Optional.ofNullable(clazz.cast(clientName()));
        case "GenerateSecret":
            return Optional.ofNullable(clazz.cast(generateSecret()));
        case "RefreshTokenValidity":
            return Optional.ofNullable(clazz.cast(refreshTokenValidity()));
        case "AccessTokenValidity":
            return Optional.ofNullable(clazz.cast(accessTokenValidity()));
        case "IdTokenValidity":
            return Optional.ofNullable(clazz.cast(idTokenValidity()));
        case "TokenValidityUnits":
            return Optional.ofNullable(clazz.cast(tokenValidityUnits()));
        case "ReadAttributes":
            return Optional.ofNullable(clazz.cast(readAttributes()));
        case "WriteAttributes":
            return Optional.ofNullable(clazz.cast(writeAttributes()));
        case "ExplicitAuthFlows":
            return Optional.ofNullable(clazz.cast(explicitAuthFlowsAsStrings()));
        case "SupportedIdentityProviders":
            return Optional.ofNullable(clazz.cast(supportedIdentityProviders()));
        case "CallbackURLs":
            return Optional.ofNullable(clazz.cast(callbackURLs()));
        case "LogoutURLs":
            return Optional.ofNullable(clazz.cast(logoutURLs()));
        case "DefaultRedirectURI":
            return Optional.ofNullable(clazz.cast(defaultRedirectURI()));
        case "AllowedOAuthFlows":
            return Optional.ofNullable(clazz.cast(allowedOAuthFlowsAsStrings()));
        case "AllowedOAuthScopes":
            return Optional.ofNullable(clazz.cast(allowedOAuthScopes()));
        case "AllowedOAuthFlowsUserPoolClient":
            return Optional.ofNullable(clazz.cast(allowedOAuthFlowsUserPoolClient()));
        case "AnalyticsConfiguration":
            return Optional.ofNullable(clazz.cast(analyticsConfiguration()));
        case "PreventUserExistenceErrors":
            return Optional.ofNullable(clazz.cast(preventUserExistenceErrorsAsString()));
        case "EnableTokenRevocation":
            return Optional.ofNullable(clazz.cast(enableTokenRevocation()));
        case "EnablePropagateAdditionalUserContextData":
            return Optional.ofNullable(clazz.cast(enablePropagateAdditionalUserContextData()));
        case "AuthSessionValidity":
            return Optional.ofNullable(clazz.cast(authSessionValidity()));
        case "RefreshTokenRotation":
            return Optional.ofNullable(clazz.cast(refreshTokenRotation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("UserPoolId", USER_POOL_ID_FIELD);
        map.put("ClientName", CLIENT_NAME_FIELD);
        map.put("GenerateSecret", GENERATE_SECRET_FIELD);
        map.put("RefreshTokenValidity", REFRESH_TOKEN_VALIDITY_FIELD);
        map.put("AccessTokenValidity", ACCESS_TOKEN_VALIDITY_FIELD);
        map.put("IdTokenValidity", ID_TOKEN_VALIDITY_FIELD);
        map.put("TokenValidityUnits", TOKEN_VALIDITY_UNITS_FIELD);
        map.put("ReadAttributes", READ_ATTRIBUTES_FIELD);
        map.put("WriteAttributes", WRITE_ATTRIBUTES_FIELD);
        map.put("ExplicitAuthFlows", EXPLICIT_AUTH_FLOWS_FIELD);
        map.put("SupportedIdentityProviders", SUPPORTED_IDENTITY_PROVIDERS_FIELD);
        map.put("CallbackURLs", CALLBACK_UR_LS_FIELD);
        map.put("LogoutURLs", LOGOUT_UR_LS_FIELD);
        map.put("DefaultRedirectURI", DEFAULT_REDIRECT_URI_FIELD);
        map.put("AllowedOAuthFlows", ALLOWED_O_AUTH_FLOWS_FIELD);
        map.put("AllowedOAuthScopes", ALLOWED_O_AUTH_SCOPES_FIELD);
        map.put("AllowedOAuthFlowsUserPoolClient", ALLOWED_O_AUTH_FLOWS_USER_POOL_CLIENT_FIELD);
        map.put("AnalyticsConfiguration", ANALYTICS_CONFIGURATION_FIELD);
        map.put("PreventUserExistenceErrors", PREVENT_USER_EXISTENCE_ERRORS_FIELD);
        map.put("EnableTokenRevocation", ENABLE_TOKEN_REVOCATION_FIELD);
        map.put("EnablePropagateAdditionalUserContextData", ENABLE_PROPAGATE_ADDITIONAL_USER_CONTEXT_DATA_FIELD);
        map.put("AuthSessionValidity", AUTH_SESSION_VALIDITY_FIELD);
        map.put("RefreshTokenRotation", REFRESH_TOKEN_ROTATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateUserPoolClientRequest, T> g) {
        return obj -> g.apply((CreateUserPoolClientRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CognitoIdentityProviderRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateUserPoolClientRequest> {
        /**
         * <p>
         * The ID of the user pool where you want to create an app client.
         * </p>
         * 
         * @param userPoolId
         *        The ID of the user pool where you want to create an app client.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolId(String userPoolId);

        /**
         * <p>
         * A friendly name for the app client that you want to create.
         * </p>
         * 
         * @param clientName
         *        A friendly name for the app client that you want to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientName(String clientName);

        /**
         * <p>
         * When <code>true</code>, generates a client secret for the app client. Client secrets are used with
         * server-side and machine-to-machine applications. Client secrets are automatically generated; you can't
         * specify a secret value. For more information, see <a href=
         * "https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-client-apps.html#user-pool-settings-client-app-client-types"
         * >App client types</a>.
         * </p>
         * 
         * @param generateSecret
         *        When <code>true</code>, generates a client secret for the app client. Client secrets are used with
         *        server-side and machine-to-machine applications. Client secrets are automatically generated; you can't
         *        specify a secret value. For more information, see <a href=
         *        "https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-client-apps.html#user-pool-settings-client-app-client-types"
         *        >App client types</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generateSecret(Boolean generateSecret);

        /**
         * <p>
         * The refresh token time limit. After this limit expires, your user can't use their refresh token. To specify
         * the time unit for <code>RefreshTokenValidity</code> as <code>seconds</code>, <code>minutes</code>,
         * <code>hours</code>, or <code>days</code>, set a <code>TokenValidityUnits</code> value in your API request.
         * </p>
         * <p>
         * For example, when you set <code>RefreshTokenValidity</code> as <code>10</code> and
         * <code>TokenValidityUnits</code> as <code>days</code>, your user can refresh their session and retrieve new
         * access and ID tokens for 10 days.
         * </p>
         * <p>
         * The default time unit for <code>RefreshTokenValidity</code> in an API request is days. You can't set
         * <code>RefreshTokenValidity</code> to 0. If you do, Amazon Cognito overrides the value with the default value
         * of 30 days. <i>Valid range</i> is displayed below in seconds.
         * </p>
         * <p>
         * If you don't specify otherwise in the configuration of your app client, your refresh tokens are valid for 30
         * days.
         * </p>
         * 
         * @param refreshTokenValidity
         *        The refresh token time limit. After this limit expires, your user can't use their refresh token. To
         *        specify the time unit for <code>RefreshTokenValidity</code> as <code>seconds</code>,
         *        <code>minutes</code>, <code>hours</code>, or <code>days</code>, set a <code>TokenValidityUnits</code>
         *        value in your API request.</p>
         *        <p>
         *        For example, when you set <code>RefreshTokenValidity</code> as <code>10</code> and
         *        <code>TokenValidityUnits</code> as <code>days</code>, your user can refresh their session and retrieve
         *        new access and ID tokens for 10 days.
         *        </p>
         *        <p>
         *        The default time unit for <code>RefreshTokenValidity</code> in an API request is days. You can't set
         *        <code>RefreshTokenValidity</code> to 0. If you do, Amazon Cognito overrides the value with the default
         *        value of 30 days. <i>Valid range</i> is displayed below in seconds.
         *        </p>
         *        <p>
         *        If you don't specify otherwise in the configuration of your app client, your refresh tokens are valid
         *        for 30 days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder refreshTokenValidity(Integer refreshTokenValidity);

        /**
         * <p>
         * The access token time limit. After this limit expires, your user can't use their access token. To specify the
         * time unit for <code>AccessTokenValidity</code> as <code>seconds</code>, <code>minutes</code>,
         * <code>hours</code>, or <code>days</code>, set a <code>TokenValidityUnits</code> value in your API request.
         * </p>
         * <p>
         * For example, when you set <code>AccessTokenValidity</code> to <code>10</code> and
         * <code>TokenValidityUnits</code> to <code>hours</code>, your user can authorize access with their access token
         * for 10 hours.
         * </p>
         * <p>
         * The default time unit for <code>AccessTokenValidity</code> in an API request is hours. <i>Valid range</i> is
         * displayed below in seconds.
         * </p>
         * <p>
         * If you don't specify otherwise in the configuration of your app client, your access tokens are valid for one
         * hour.
         * </p>
         * 
         * @param accessTokenValidity
         *        The access token time limit. After this limit expires, your user can't use their access token. To
         *        specify the time unit for <code>AccessTokenValidity</code> as <code>seconds</code>,
         *        <code>minutes</code>, <code>hours</code>, or <code>days</code>, set a <code>TokenValidityUnits</code>
         *        value in your API request.</p>
         *        <p>
         *        For example, when you set <code>AccessTokenValidity</code> to <code>10</code> and
         *        <code>TokenValidityUnits</code> to <code>hours</code>, your user can authorize access with their
         *        access token for 10 hours.
         *        </p>
         *        <p>
         *        The default time unit for <code>AccessTokenValidity</code> in an API request is hours. <i>Valid
         *        range</i> is displayed below in seconds.
         *        </p>
         *        <p>
         *        If you don't specify otherwise in the configuration of your app client, your access tokens are valid
         *        for one hour.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessTokenValidity(Integer accessTokenValidity);

        /**
         * <p>
         * The ID token time limit. After this limit expires, your user can't use their ID token. To specify the time
         * unit for <code>IdTokenValidity</code> as <code>seconds</code>, <code>minutes</code>, <code>hours</code>, or
         * <code>days</code>, set a <code>TokenValidityUnits</code> value in your API request.
         * </p>
         * <p>
         * For example, when you set <code>IdTokenValidity</code> as <code>10</code> and <code>TokenValidityUnits</code>
         * as <code>hours</code>, your user can authenticate their session with their ID token for 10 hours.
         * </p>
         * <p>
         * The default time unit for <code>IdTokenValidity</code> in an API request is hours. <i>Valid range</i> is
         * displayed below in seconds.
         * </p>
         * <p>
         * If you don't specify otherwise in the configuration of your app client, your ID tokens are valid for one
         * hour.
         * </p>
         * 
         * @param idTokenValidity
         *        The ID token time limit. After this limit expires, your user can't use their ID token. To specify the
         *        time unit for <code>IdTokenValidity</code> as <code>seconds</code>, <code>minutes</code>,
         *        <code>hours</code>, or <code>days</code>, set a <code>TokenValidityUnits</code> value in your API
         *        request.</p>
         *        <p>
         *        For example, when you set <code>IdTokenValidity</code> as <code>10</code> and
         *        <code>TokenValidityUnits</code> as <code>hours</code>, your user can authenticate their session with
         *        their ID token for 10 hours.
         *        </p>
         *        <p>
         *        The default time unit for <code>IdTokenValidity</code> in an API request is hours. <i>Valid range</i>
         *        is displayed below in seconds.
         *        </p>
         *        <p>
         *        If you don't specify otherwise in the configuration of your app client, your ID tokens are valid for
         *        one hour.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idTokenValidity(Integer idTokenValidity);

        /**
         * <p>
         * The units that validity times are represented in. The default unit for refresh tokens is days, and the
         * default for ID and access tokens are hours.
         * </p>
         * 
         * @param tokenValidityUnits
         *        The units that validity times are represented in. The default unit for refresh tokens is days, and the
         *        default for ID and access tokens are hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenValidityUnits(TokenValidityUnitsType tokenValidityUnits);

        /**
         * <p>
         * The units that validity times are represented in. The default unit for refresh tokens is days, and the
         * default for ID and access tokens are hours.
         * </p>
         * This is a convenience method that creates an instance of the {@link TokenValidityUnitsType.Builder} avoiding
         * the need to create one manually via {@link TokenValidityUnitsType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TokenValidityUnitsType.Builder#build()} is called immediately and
         * its result is passed to {@link #tokenValidityUnits(TokenValidityUnitsType)}.
         * 
         * @param tokenValidityUnits
         *        a consumer that will call methods on {@link TokenValidityUnitsType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tokenValidityUnits(TokenValidityUnitsType)
         */
        default Builder tokenValidityUnits(Consumer<TokenValidityUnitsType.Builder> tokenValidityUnits) {
            return tokenValidityUnits(TokenValidityUnitsType.builder().applyMutation(tokenValidityUnits).build());
        }

        /**
         * <p>
         * The list of user attributes that you want your app client to have read access to. After your user
         * authenticates in your app, their access token authorizes them to read their own attribute value for any
         * attribute in this list.
         * </p>
         * <p>
         * When you don't specify the <code>ReadAttributes</code> for your app client, your app can read the values of
         * <code>email_verified</code>, <code>phone_number_verified</code>, and the standard attributes of your user
         * pool. When your user pool app client has read access to these default attributes, <code>ReadAttributes</code>
         * doesn't return any information. Amazon Cognito only populates <code>ReadAttributes</code> in the API response
         * if you have specified your own custom set of read attributes.
         * </p>
         * 
         * @param readAttributes
         *        The list of user attributes that you want your app client to have read access to. After your user
         *        authenticates in your app, their access token authorizes them to read their own attribute value for
         *        any attribute in this list.</p>
         *        <p>
         *        When you don't specify the <code>ReadAttributes</code> for your app client, your app can read the
         *        values of <code>email_verified</code>, <code>phone_number_verified</code>, and the standard attributes
         *        of your user pool. When your user pool app client has read access to these default attributes,
         *        <code>ReadAttributes</code> doesn't return any information. Amazon Cognito only populates
         *        <code>ReadAttributes</code> in the API response if you have specified your own custom set of read
         *        attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readAttributes(Collection<String> readAttributes);

        /**
         * <p>
         * The list of user attributes that you want your app client to have read access to. After your user
         * authenticates in your app, their access token authorizes them to read their own attribute value for any
         * attribute in this list.
         * </p>
         * <p>
         * When you don't specify the <code>ReadAttributes</code> for your app client, your app can read the values of
         * <code>email_verified</code>, <code>phone_number_verified</code>, and the standard attributes of your user
         * pool. When your user pool app client has read access to these default attributes, <code>ReadAttributes</code>
         * doesn't return any information. Amazon Cognito only populates <code>ReadAttributes</code> in the API response
         * if you have specified your own custom set of read attributes.
         * </p>
         * 
         * @param readAttributes
         *        The list of user attributes that you want your app client to have read access to. After your user
         *        authenticates in your app, their access token authorizes them to read their own attribute value for
         *        any attribute in this list.</p>
         *        <p>
         *        When you don't specify the <code>ReadAttributes</code> for your app client, your app can read the
         *        values of <code>email_verified</code>, <code>phone_number_verified</code>, and the standard attributes
         *        of your user pool. When your user pool app client has read access to these default attributes,
         *        <code>ReadAttributes</code> doesn't return any information. Amazon Cognito only populates
         *        <code>ReadAttributes</code> in the API response if you have specified your own custom set of read
         *        attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readAttributes(String... readAttributes);

        /**
         * <p>
         * The list of user attributes that you want your app client to have write access to. After your user
         * authenticates in your app, their access token authorizes them to set or modify their own attribute value for
         * any attribute in this list.
         * </p>
         * <p>
         * When you don't specify the <code>WriteAttributes</code> for your app client, your app can write the values of
         * the Standard attributes of your user pool. When your user pool has write access to these default attributes,
         * <code>WriteAttributes</code> doesn't return any information. Amazon Cognito only populates
         * <code>WriteAttributes</code> in the API response if you have specified your own custom set of write
         * attributes.
         * </p>
         * <p>
         * If your app client allows users to sign in through an IdP, this array must include all attributes that you
         * have mapped to IdP attributes. Amazon Cognito updates mapped attributes when users sign in to your
         * application through an IdP. If your app client does not have write access to a mapped attribute, Amazon
         * Cognito throws an error when it tries to update the attribute. For more information, see <a href=
         * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-specifying-attribute-mapping.html"
         * >Specifying IdP Attribute Mappings for Your user pool</a>.
         * </p>
         * 
         * @param writeAttributes
         *        The list of user attributes that you want your app client to have write access to. After your user
         *        authenticates in your app, their access token authorizes them to set or modify their own attribute
         *        value for any attribute in this list.</p>
         *        <p>
         *        When you don't specify the <code>WriteAttributes</code> for your app client, your app can write the
         *        values of the Standard attributes of your user pool. When your user pool has write access to these
         *        default attributes, <code>WriteAttributes</code> doesn't return any information. Amazon Cognito only
         *        populates <code>WriteAttributes</code> in the API response if you have specified your own custom set
         *        of write attributes.
         *        </p>
         *        <p>
         *        If your app client allows users to sign in through an IdP, this array must include all attributes that
         *        you have mapped to IdP attributes. Amazon Cognito updates mapped attributes when users sign in to your
         *        application through an IdP. If your app client does not have write access to a mapped attribute,
         *        Amazon Cognito throws an error when it tries to update the attribute. For more information, see <a
         *        href=
         *        "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-specifying-attribute-mapping.html"
         *        >Specifying IdP Attribute Mappings for Your user pool</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder writeAttributes(Collection<String> writeAttributes);

        /**
         * <p>
         * The list of user attributes that you want your app client to have write access to. After your user
         * authenticates in your app, their access token authorizes them to set or modify their own attribute value for
         * any attribute in this list.
         * </p>
         * <p>
         * When you don't specify the <code>WriteAttributes</code> for your app client, your app can write the values of
         * the Standard attributes of your user pool. When your user pool has write access to these default attributes,
         * <code>WriteAttributes</code> doesn't return any information. Amazon Cognito only populates
         * <code>WriteAttributes</code> in the API response if you have specified your own custom set of write
         * attributes.
         * </p>
         * <p>
         * If your app client allows users to sign in through an IdP, this array must include all attributes that you
         * have mapped to IdP attributes. Amazon Cognito updates mapped attributes when users sign in to your
         * application through an IdP. If your app client does not have write access to a mapped attribute, Amazon
         * Cognito throws an error when it tries to update the attribute. For more information, see <a href=
         * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-specifying-attribute-mapping.html"
         * >Specifying IdP Attribute Mappings for Your user pool</a>.
         * </p>
         * 
         * @param writeAttributes
         *        The list of user attributes that you want your app client to have write access to. After your user
         *        authenticates in your app, their access token authorizes them to set or modify their own attribute
         *        value for any attribute in this list.</p>
         *        <p>
         *        When you don't specify the <code>WriteAttributes</code> for your app client, your app can write the
         *        values of the Standard attributes of your user pool. When your user pool has write access to these
         *        default attributes, <code>WriteAttributes</code> doesn't return any information. Amazon Cognito only
         *        populates <code>WriteAttributes</code> in the API response if you have specified your own custom set
         *        of write attributes.
         *        </p>
         *        <p>
         *        If your app client allows users to sign in through an IdP, this array must include all attributes that
         *        you have mapped to IdP attributes. Amazon Cognito updates mapped attributes when users sign in to your
         *        application through an IdP. If your app client does not have write access to a mapped attribute,
         *        Amazon Cognito throws an error when it tries to update the attribute. For more information, see <a
         *        href=
         *        "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-specifying-attribute-mapping.html"
         *        >Specifying IdP Attribute Mappings for Your user pool</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder writeAttributes(String... writeAttributes);

        /**
         * <p>
         * The <a href=
         * "https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-authentication-flow-methods.html"
         * >authentication flows</a> that you want your user pool client to support. For each app client in your user
         * pool, you can sign in your users with any combination of one or more flows, including with a user name and
         * Secure Remote Password (SRP), a user name and password, or a custom authentication process that you define
         * with Lambda functions.
         * </p>
         * <note>
         * <p>
         * If you don't specify a value for <code>ExplicitAuthFlows</code>, your app client supports
         * <code>ALLOW_REFRESH_TOKEN_AUTH</code>, <code>ALLOW_USER_SRP_AUTH</code>, and <code>ALLOW_CUSTOM_AUTH</code>.
         * </p>
         * </note>
         * <p>
         * The values for authentication flow options include the following.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALLOW_USER_AUTH</code>: Enable selection-based sign-in with <code>USER_AUTH</code>. This setting covers
         * username-password, secure remote password (SRP), passwordless, and passkey authentication. This authentiation
         * flow can do username-password and SRP authentication without other <code>ExplicitAuthFlows</code> permitting
         * them. For example users can complete an SRP challenge through <code>USER_AUTH</code> without the flow
         * <code>USER_SRP_AUTH</code> being active for the app client. This flow doesn't include
         * <code>CUSTOM_AUTH</code>.
         * </p>
         * <p>
         * To activate this setting, your user pool must be in the <a
         * href="https://docs.aws.amazon.com/cognito/latest/developerguide/feature-plans-features-essentials.html">
         * Essentials tier</a> or higher.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALLOW_ADMIN_USER_PASSWORD_AUTH</code>: Enable admin based user password authentication flow
         * <code>ADMIN_USER_PASSWORD_AUTH</code>. This setting replaces the <code>ADMIN_NO_SRP_AUTH</code> setting. With
         * this authentication flow, your app passes a user name and password to Amazon Cognito in the request, instead
         * of using the Secure Remote Password (SRP) protocol to securely transmit the password.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALLOW_CUSTOM_AUTH</code>: Enable Lambda trigger based authentication.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALLOW_USER_PASSWORD_AUTH</code>: Enable user password-based authentication. In this flow, Amazon
         * Cognito receives the password in the request instead of using the SRP protocol to verify passwords.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALLOW_USER_SRP_AUTH</code>: Enable SRP-based authentication.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALLOW_REFRESH_TOKEN_AUTH</code>: Enable authflow to refresh tokens.
         * </p>
         * </li>
         * </ul>
         * <p>
         * In some environments, you will see the values <code>ADMIN_NO_SRP_AUTH</code>,
         * <code>CUSTOM_AUTH_FLOW_ONLY</code>, or <code>USER_PASSWORD_AUTH</code>. You can't assign these legacy
         * <code>ExplicitAuthFlows</code> values to user pool clients at the same time as values that begin with
         * <code>ALLOW_</code>, like <code>ALLOW_USER_SRP_AUTH</code>.
         * </p>
         * 
         * @param explicitAuthFlows
         *        The <a href=
         *        "https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-authentication-flow-methods.html"
         *        >authentication flows</a> that you want your user pool client to support. For each app client in your
         *        user pool, you can sign in your users with any combination of one or more flows, including with a user
         *        name and Secure Remote Password (SRP), a user name and password, or a custom authentication process
         *        that you define with Lambda functions.</p> <note>
         *        <p>
         *        If you don't specify a value for <code>ExplicitAuthFlows</code>, your app client supports
         *        <code>ALLOW_REFRESH_TOKEN_AUTH</code>, <code>ALLOW_USER_SRP_AUTH</code>, and
         *        <code>ALLOW_CUSTOM_AUTH</code>.
         *        </p>
         *        </note>
         *        <p>
         *        The values for authentication flow options include the following.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALLOW_USER_AUTH</code>: Enable selection-based sign-in with <code>USER_AUTH</code>. This setting
         *        covers username-password, secure remote password (SRP), passwordless, and passkey authentication. This
         *        authentiation flow can do username-password and SRP authentication without other
         *        <code>ExplicitAuthFlows</code> permitting them. For example users can complete an SRP challenge
         *        through <code>USER_AUTH</code> without the flow <code>USER_SRP_AUTH</code> being active for the app
         *        client. This flow doesn't include <code>CUSTOM_AUTH</code>.
         *        </p>
         *        <p>
         *        To activate this setting, your user pool must be in the <a href=
         *        "https://docs.aws.amazon.com/cognito/latest/developerguide/feature-plans-features-essentials.html">
         *        Essentials tier</a> or higher.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALLOW_ADMIN_USER_PASSWORD_AUTH</code>: Enable admin based user password authentication flow
         *        <code>ADMIN_USER_PASSWORD_AUTH</code>. This setting replaces the <code>ADMIN_NO_SRP_AUTH</code>
         *        setting. With this authentication flow, your app passes a user name and password to Amazon Cognito in
         *        the request, instead of using the Secure Remote Password (SRP) protocol to securely transmit the
         *        password.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALLOW_CUSTOM_AUTH</code>: Enable Lambda trigger based authentication.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALLOW_USER_PASSWORD_AUTH</code>: Enable user password-based authentication. In this flow, Amazon
         *        Cognito receives the password in the request instead of using the SRP protocol to verify passwords.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALLOW_USER_SRP_AUTH</code>: Enable SRP-based authentication.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALLOW_REFRESH_TOKEN_AUTH</code>: Enable authflow to refresh tokens.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        In some environments, you will see the values <code>ADMIN_NO_SRP_AUTH</code>,
         *        <code>CUSTOM_AUTH_FLOW_ONLY</code>, or <code>USER_PASSWORD_AUTH</code>. You can't assign these legacy
         *        <code>ExplicitAuthFlows</code> values to user pool clients at the same time as values that begin with
         *        <code>ALLOW_</code>, like <code>ALLOW_USER_SRP_AUTH</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder explicitAuthFlowsWithStrings(Collection<String> explicitAuthFlows);

        /**
         * <p>
         * The <a href=
         * "https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-authentication-flow-methods.html"
         * >authentication flows</a> that you want your user pool client to support. For each app client in your user
         * pool, you can sign in your users with any combination of one or more flows, including with a user name and
         * Secure Remote Password (SRP), a user name and password, or a custom authentication process that you define
         * with Lambda functions.
         * </p>
         * <note>
         * <p>
         * If you don't specify a value for <code>ExplicitAuthFlows</code>, your app client supports
         * <code>ALLOW_REFRESH_TOKEN_AUTH</code>, <code>ALLOW_USER_SRP_AUTH</code>, and <code>ALLOW_CUSTOM_AUTH</code>.
         * </p>
         * </note>
         * <p>
         * The values for authentication flow options include the following.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALLOW_USER_AUTH</code>: Enable selection-based sign-in with <code>USER_AUTH</code>. This setting covers
         * username-password, secure remote password (SRP), passwordless, and passkey authentication. This authentiation
         * flow can do username-password and SRP authentication without other <code>ExplicitAuthFlows</code> permitting
         * them. For example users can complete an SRP challenge through <code>USER_AUTH</code> without the flow
         * <code>USER_SRP_AUTH</code> being active for the app client. This flow doesn't include
         * <code>CUSTOM_AUTH</code>.
         * </p>
         * <p>
         * To activate this setting, your user pool must be in the <a
         * href="https://docs.aws.amazon.com/cognito/latest/developerguide/feature-plans-features-essentials.html">
         * Essentials tier</a> or higher.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALLOW_ADMIN_USER_PASSWORD_AUTH</code>: Enable admin based user password authentication flow
         * <code>ADMIN_USER_PASSWORD_AUTH</code>. This setting replaces the <code>ADMIN_NO_SRP_AUTH</code> setting. With
         * this authentication flow, your app passes a user name and password to Amazon Cognito in the request, instead
         * of using the Secure Remote Password (SRP) protocol to securely transmit the password.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALLOW_CUSTOM_AUTH</code>: Enable Lambda trigger based authentication.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALLOW_USER_PASSWORD_AUTH</code>: Enable user password-based authentication. In this flow, Amazon
         * Cognito receives the password in the request instead of using the SRP protocol to verify passwords.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALLOW_USER_SRP_AUTH</code>: Enable SRP-based authentication.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALLOW_REFRESH_TOKEN_AUTH</code>: Enable authflow to refresh tokens.
         * </p>
         * </li>
         * </ul>
         * <p>
         * In some environments, you will see the values <code>ADMIN_NO_SRP_AUTH</code>,
         * <code>CUSTOM_AUTH_FLOW_ONLY</code>, or <code>USER_PASSWORD_AUTH</code>. You can't assign these legacy
         * <code>ExplicitAuthFlows</code> values to user pool clients at the same time as values that begin with
         * <code>ALLOW_</code>, like <code>ALLOW_USER_SRP_AUTH</code>.
         * </p>
         * 
         * @param explicitAuthFlows
         *        The <a href=
         *        "https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-authentication-flow-methods.html"
         *        >authentication flows</a> that you want your user pool client to support. For each app client in your
         *        user pool, you can sign in your users with any combination of one or more flows, including with a user
         *        name and Secure Remote Password (SRP), a user name and password, or a custom authentication process
         *        that you define with Lambda functions.</p> <note>
         *        <p>
         *        If you don't specify a value for <code>ExplicitAuthFlows</code>, your app client supports
         *        <code>ALLOW_REFRESH_TOKEN_AUTH</code>, <code>ALLOW_USER_SRP_AUTH</code>, and
         *        <code>ALLOW_CUSTOM_AUTH</code>.
         *        </p>
         *        </note>
         *        <p>
         *        The values for authentication flow options include the following.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALLOW_USER_AUTH</code>: Enable selection-based sign-in with <code>USER_AUTH</code>. This setting
         *        covers username-password, secure remote password (SRP), passwordless, and passkey authentication. This
         *        authentiation flow can do username-password and SRP authentication without other
         *        <code>ExplicitAuthFlows</code> permitting them. For example users can complete an SRP challenge
         *        through <code>USER_AUTH</code> without the flow <code>USER_SRP_AUTH</code> being active for the app
         *        client. This flow doesn't include <code>CUSTOM_AUTH</code>.
         *        </p>
         *        <p>
         *        To activate this setting, your user pool must be in the <a href=
         *        "https://docs.aws.amazon.com/cognito/latest/developerguide/feature-plans-features-essentials.html">
         *        Essentials tier</a> or higher.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALLOW_ADMIN_USER_PASSWORD_AUTH</code>: Enable admin based user password authentication flow
         *        <code>ADMIN_USER_PASSWORD_AUTH</code>. This setting replaces the <code>ADMIN_NO_SRP_AUTH</code>
         *        setting. With this authentication flow, your app passes a user name and password to Amazon Cognito in
         *        the request, instead of using the Secure Remote Password (SRP) protocol to securely transmit the
         *        password.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALLOW_CUSTOM_AUTH</code>: Enable Lambda trigger based authentication.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALLOW_USER_PASSWORD_AUTH</code>: Enable user password-based authentication. In this flow, Amazon
         *        Cognito receives the password in the request instead of using the SRP protocol to verify passwords.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALLOW_USER_SRP_AUTH</code>: Enable SRP-based authentication.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALLOW_REFRESH_TOKEN_AUTH</code>: Enable authflow to refresh tokens.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        In some environments, you will see the values <code>ADMIN_NO_SRP_AUTH</code>,
         *        <code>CUSTOM_AUTH_FLOW_ONLY</code>, or <code>USER_PASSWORD_AUTH</code>. You can't assign these legacy
         *        <code>ExplicitAuthFlows</code> values to user pool clients at the same time as values that begin with
         *        <code>ALLOW_</code>, like <code>ALLOW_USER_SRP_AUTH</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder explicitAuthFlowsWithStrings(String... explicitAuthFlows);

        /**
         * <p>
         * The <a href=
         * "https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-authentication-flow-methods.html"
         * >authentication flows</a> that you want your user pool client to support. For each app client in your user
         * pool, you can sign in your users with any combination of one or more flows, including with a user name and
         * Secure Remote Password (SRP), a user name and password, or a custom authentication process that you define
         * with Lambda functions.
         * </p>
         * <note>
         * <p>
         * If you don't specify a value for <code>ExplicitAuthFlows</code>, your app client supports
         * <code>ALLOW_REFRESH_TOKEN_AUTH</code>, <code>ALLOW_USER_SRP_AUTH</code>, and <code>ALLOW_CUSTOM_AUTH</code>.
         * </p>
         * </note>
         * <p>
         * The values for authentication flow options include the following.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALLOW_USER_AUTH</code>: Enable selection-based sign-in with <code>USER_AUTH</code>. This setting covers
         * username-password, secure remote password (SRP), passwordless, and passkey authentication. This authentiation
         * flow can do username-password and SRP authentication without other <code>ExplicitAuthFlows</code> permitting
         * them. For example users can complete an SRP challenge through <code>USER_AUTH</code> without the flow
         * <code>USER_SRP_AUTH</code> being active for the app client. This flow doesn't include
         * <code>CUSTOM_AUTH</code>.
         * </p>
         * <p>
         * To activate this setting, your user pool must be in the <a
         * href="https://docs.aws.amazon.com/cognito/latest/developerguide/feature-plans-features-essentials.html">
         * Essentials tier</a> or higher.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALLOW_ADMIN_USER_PASSWORD_AUTH</code>: Enable admin based user password authentication flow
         * <code>ADMIN_USER_PASSWORD_AUTH</code>. This setting replaces the <code>ADMIN_NO_SRP_AUTH</code> setting. With
         * this authentication flow, your app passes a user name and password to Amazon Cognito in the request, instead
         * of using the Secure Remote Password (SRP) protocol to securely transmit the password.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALLOW_CUSTOM_AUTH</code>: Enable Lambda trigger based authentication.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALLOW_USER_PASSWORD_AUTH</code>: Enable user password-based authentication. In this flow, Amazon
         * Cognito receives the password in the request instead of using the SRP protocol to verify passwords.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALLOW_USER_SRP_AUTH</code>: Enable SRP-based authentication.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALLOW_REFRESH_TOKEN_AUTH</code>: Enable authflow to refresh tokens.
         * </p>
         * </li>
         * </ul>
         * <p>
         * In some environments, you will see the values <code>ADMIN_NO_SRP_AUTH</code>,
         * <code>CUSTOM_AUTH_FLOW_ONLY</code>, or <code>USER_PASSWORD_AUTH</code>. You can't assign these legacy
         * <code>ExplicitAuthFlows</code> values to user pool clients at the same time as values that begin with
         * <code>ALLOW_</code>, like <code>ALLOW_USER_SRP_AUTH</code>.
         * </p>
         * 
         * @param explicitAuthFlows
         *        The <a href=
         *        "https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-authentication-flow-methods.html"
         *        >authentication flows</a> that you want your user pool client to support. For each app client in your
         *        user pool, you can sign in your users with any combination of one or more flows, including with a user
         *        name and Secure Remote Password (SRP), a user name and password, or a custom authentication process
         *        that you define with Lambda functions.</p> <note>
         *        <p>
         *        If you don't specify a value for <code>ExplicitAuthFlows</code>, your app client supports
         *        <code>ALLOW_REFRESH_TOKEN_AUTH</code>, <code>ALLOW_USER_SRP_AUTH</code>, and
         *        <code>ALLOW_CUSTOM_AUTH</code>.
         *        </p>
         *        </note>
         *        <p>
         *        The values for authentication flow options include the following.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALLOW_USER_AUTH</code>: Enable selection-based sign-in with <code>USER_AUTH</code>. This setting
         *        covers username-password, secure remote password (SRP), passwordless, and passkey authentication. This
         *        authentiation flow can do username-password and SRP authentication without other
         *        <code>ExplicitAuthFlows</code> permitting them. For example users can complete an SRP challenge
         *        through <code>USER_AUTH</code> without the flow <code>USER_SRP_AUTH</code> being active for the app
         *        client. This flow doesn't include <code>CUSTOM_AUTH</code>.
         *        </p>
         *        <p>
         *        To activate this setting, your user pool must be in the <a href=
         *        "https://docs.aws.amazon.com/cognito/latest/developerguide/feature-plans-features-essentials.html">
         *        Essentials tier</a> or higher.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALLOW_ADMIN_USER_PASSWORD_AUTH</code>: Enable admin based user password authentication flow
         *        <code>ADMIN_USER_PASSWORD_AUTH</code>. This setting replaces the <code>ADMIN_NO_SRP_AUTH</code>
         *        setting. With this authentication flow, your app passes a user name and password to Amazon Cognito in
         *        the request, instead of using the Secure Remote Password (SRP) protocol to securely transmit the
         *        password.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALLOW_CUSTOM_AUTH</code>: Enable Lambda trigger based authentication.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALLOW_USER_PASSWORD_AUTH</code>: Enable user password-based authentication. In this flow, Amazon
         *        Cognito receives the password in the request instead of using the SRP protocol to verify passwords.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALLOW_USER_SRP_AUTH</code>: Enable SRP-based authentication.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALLOW_REFRESH_TOKEN_AUTH</code>: Enable authflow to refresh tokens.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        In some environments, you will see the values <code>ADMIN_NO_SRP_AUTH</code>,
         *        <code>CUSTOM_AUTH_FLOW_ONLY</code>, or <code>USER_PASSWORD_AUTH</code>. You can't assign these legacy
         *        <code>ExplicitAuthFlows</code> values to user pool clients at the same time as values that begin with
         *        <code>ALLOW_</code>, like <code>ALLOW_USER_SRP_AUTH</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder explicitAuthFlows(Collection<ExplicitAuthFlowsType> explicitAuthFlows);

        /**
         * <p>
         * The <a href=
         * "https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-authentication-flow-methods.html"
         * >authentication flows</a> that you want your user pool client to support. For each app client in your user
         * pool, you can sign in your users with any combination of one or more flows, including with a user name and
         * Secure Remote Password (SRP), a user name and password, or a custom authentication process that you define
         * with Lambda functions.
         * </p>
         * <note>
         * <p>
         * If you don't specify a value for <code>ExplicitAuthFlows</code>, your app client supports
         * <code>ALLOW_REFRESH_TOKEN_AUTH</code>, <code>ALLOW_USER_SRP_AUTH</code>, and <code>ALLOW_CUSTOM_AUTH</code>.
         * </p>
         * </note>
         * <p>
         * The values for authentication flow options include the following.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALLOW_USER_AUTH</code>: Enable selection-based sign-in with <code>USER_AUTH</code>. This setting covers
         * username-password, secure remote password (SRP), passwordless, and passkey authentication. This authentiation
         * flow can do username-password and SRP authentication without other <code>ExplicitAuthFlows</code> permitting
         * them. For example users can complete an SRP challenge through <code>USER_AUTH</code> without the flow
         * <code>USER_SRP_AUTH</code> being active for the app client. This flow doesn't include
         * <code>CUSTOM_AUTH</code>.
         * </p>
         * <p>
         * To activate this setting, your user pool must be in the <a
         * href="https://docs.aws.amazon.com/cognito/latest/developerguide/feature-plans-features-essentials.html">
         * Essentials tier</a> or higher.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALLOW_ADMIN_USER_PASSWORD_AUTH</code>: Enable admin based user password authentication flow
         * <code>ADMIN_USER_PASSWORD_AUTH</code>. This setting replaces the <code>ADMIN_NO_SRP_AUTH</code> setting. With
         * this authentication flow, your app passes a user name and password to Amazon Cognito in the request, instead
         * of using the Secure Remote Password (SRP) protocol to securely transmit the password.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALLOW_CUSTOM_AUTH</code>: Enable Lambda trigger based authentication.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALLOW_USER_PASSWORD_AUTH</code>: Enable user password-based authentication. In this flow, Amazon
         * Cognito receives the password in the request instead of using the SRP protocol to verify passwords.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALLOW_USER_SRP_AUTH</code>: Enable SRP-based authentication.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALLOW_REFRESH_TOKEN_AUTH</code>: Enable authflow to refresh tokens.
         * </p>
         * </li>
         * </ul>
         * <p>
         * In some environments, you will see the values <code>ADMIN_NO_SRP_AUTH</code>,
         * <code>CUSTOM_AUTH_FLOW_ONLY</code>, or <code>USER_PASSWORD_AUTH</code>. You can't assign these legacy
         * <code>ExplicitAuthFlows</code> values to user pool clients at the same time as values that begin with
         * <code>ALLOW_</code>, like <code>ALLOW_USER_SRP_AUTH</code>.
         * </p>
         * 
         * @param explicitAuthFlows
         *        The <a href=
         *        "https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-authentication-flow-methods.html"
         *        >authentication flows</a> that you want your user pool client to support. For each app client in your
         *        user pool, you can sign in your users with any combination of one or more flows, including with a user
         *        name and Secure Remote Password (SRP), a user name and password, or a custom authentication process
         *        that you define with Lambda functions.</p> <note>
         *        <p>
         *        If you don't specify a value for <code>ExplicitAuthFlows</code>, your app client supports
         *        <code>ALLOW_REFRESH_TOKEN_AUTH</code>, <code>ALLOW_USER_SRP_AUTH</code>, and
         *        <code>ALLOW_CUSTOM_AUTH</code>.
         *        </p>
         *        </note>
         *        <p>
         *        The values for authentication flow options include the following.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALLOW_USER_AUTH</code>: Enable selection-based sign-in with <code>USER_AUTH</code>. This setting
         *        covers username-password, secure remote password (SRP), passwordless, and passkey authentication. This
         *        authentiation flow can do username-password and SRP authentication without other
         *        <code>ExplicitAuthFlows</code> permitting them. For example users can complete an SRP challenge
         *        through <code>USER_AUTH</code> without the flow <code>USER_SRP_AUTH</code> being active for the app
         *        client. This flow doesn't include <code>CUSTOM_AUTH</code>.
         *        </p>
         *        <p>
         *        To activate this setting, your user pool must be in the <a href=
         *        "https://docs.aws.amazon.com/cognito/latest/developerguide/feature-plans-features-essentials.html">
         *        Essentials tier</a> or higher.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALLOW_ADMIN_USER_PASSWORD_AUTH</code>: Enable admin based user password authentication flow
         *        <code>ADMIN_USER_PASSWORD_AUTH</code>. This setting replaces the <code>ADMIN_NO_SRP_AUTH</code>
         *        setting. With this authentication flow, your app passes a user name and password to Amazon Cognito in
         *        the request, instead of using the Secure Remote Password (SRP) protocol to securely transmit the
         *        password.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALLOW_CUSTOM_AUTH</code>: Enable Lambda trigger based authentication.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALLOW_USER_PASSWORD_AUTH</code>: Enable user password-based authentication. In this flow, Amazon
         *        Cognito receives the password in the request instead of using the SRP protocol to verify passwords.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALLOW_USER_SRP_AUTH</code>: Enable SRP-based authentication.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALLOW_REFRESH_TOKEN_AUTH</code>: Enable authflow to refresh tokens.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        In some environments, you will see the values <code>ADMIN_NO_SRP_AUTH</code>,
         *        <code>CUSTOM_AUTH_FLOW_ONLY</code>, or <code>USER_PASSWORD_AUTH</code>. You can't assign these legacy
         *        <code>ExplicitAuthFlows</code> values to user pool clients at the same time as values that begin with
         *        <code>ALLOW_</code>, like <code>ALLOW_USER_SRP_AUTH</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder explicitAuthFlows(ExplicitAuthFlowsType... explicitAuthFlows);

        /**
         * <p>
         * A list of provider names for the identity providers (IdPs) that are supported on this client. The following
         * are supported: <code>COGNITO</code>, <code>Facebook</code>, <code>Google</code>, <code>SignInWithApple</code>
         * , and <code>LoginWithAmazon</code>. You can also specify the names that you configured for the SAML and OIDC
         * IdPs in your user pool, for example <code>MySAMLIdP</code> or <code>MyOIDCIdP</code>.
         * </p>
         * <p>
         * This parameter sets the IdPs that <a
         * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-managed-login.html"
         * >managed login</a> will display on the login page for your app client. The removal of <code>COGNITO</code>
         * from this list doesn't prevent authentication operations for local users with the user pools API in an Amazon
         * Web Services SDK. The only way to prevent SDK-based authentication is to block access with a <a
         * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-waf.html">WAF rule</a>.
         * </p>
         * 
         * @param supportedIdentityProviders
         *        A list of provider names for the identity providers (IdPs) that are supported on this client. The
         *        following are supported: <code>COGNITO</code>, <code>Facebook</code>, <code>Google</code>,
         *        <code>SignInWithApple</code>, and <code>LoginWithAmazon</code>. You can also specify the names that
         *        you configured for the SAML and OIDC IdPs in your user pool, for example <code>MySAMLIdP</code> or
         *        <code>MyOIDCIdP</code>.</p>
         *        <p>
         *        This parameter sets the IdPs that <a href=
         *        "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-managed-login.html"
         *        >managed login</a> will display on the login page for your app client. The removal of
         *        <code>COGNITO</code> from this list doesn't prevent authentication operations for local users with the
         *        user pools API in an Amazon Web Services SDK. The only way to prevent SDK-based authentication is to
         *        block access with a <a
         *        href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-waf.html">WAF rule</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedIdentityProviders(Collection<String> supportedIdentityProviders);

        /**
         * <p>
         * A list of provider names for the identity providers (IdPs) that are supported on this client. The following
         * are supported: <code>COGNITO</code>, <code>Facebook</code>, <code>Google</code>, <code>SignInWithApple</code>
         * , and <code>LoginWithAmazon</code>. You can also specify the names that you configured for the SAML and OIDC
         * IdPs in your user pool, for example <code>MySAMLIdP</code> or <code>MyOIDCIdP</code>.
         * </p>
         * <p>
         * This parameter sets the IdPs that <a
         * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-managed-login.html"
         * >managed login</a> will display on the login page for your app client. The removal of <code>COGNITO</code>
         * from this list doesn't prevent authentication operations for local users with the user pools API in an Amazon
         * Web Services SDK. The only way to prevent SDK-based authentication is to block access with a <a
         * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-waf.html">WAF rule</a>.
         * </p>
         * 
         * @param supportedIdentityProviders
         *        A list of provider names for the identity providers (IdPs) that are supported on this client. The
         *        following are supported: <code>COGNITO</code>, <code>Facebook</code>, <code>Google</code>,
         *        <code>SignInWithApple</code>, and <code>LoginWithAmazon</code>. You can also specify the names that
         *        you configured for the SAML and OIDC IdPs in your user pool, for example <code>MySAMLIdP</code> or
         *        <code>MyOIDCIdP</code>.</p>
         *        <p>
         *        This parameter sets the IdPs that <a href=
         *        "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-managed-login.html"
         *        >managed login</a> will display on the login page for your app client. The removal of
         *        <code>COGNITO</code> from this list doesn't prevent authentication operations for local users with the
         *        user pools API in an Amazon Web Services SDK. The only way to prevent SDK-based authentication is to
         *        block access with a <a
         *        href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-waf.html">WAF rule</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedIdentityProviders(String... supportedIdentityProviders);

        /**
         * <p>
         * A list of allowed redirect, or callback, URLs for managed login authentication. These URLs are the paths
         * where you want to send your users' browsers after they complete authentication with managed login or a
         * third-party IdP. Typically, callback URLs are the home of an application that uses OAuth or OIDC libraries to
         * process authentication outcomes.
         * </p>
         * <p>
         * A redirect URI must meet the following requirements:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Be an absolute URI.
         * </p>
         * </li>
         * <li>
         * <p>
         * Be registered with the authorization server. Amazon Cognito doesn't accept authorization requests with
         * <code>redirect_uri</code> values that aren't in the list of <code>CallbackURLs</code> that you provide in
         * this parameter.
         * </p>
         * </li>
         * <li>
         * <p>
         * Not include a fragment component.
         * </p>
         * </li>
         * </ul>
         * <p>
         * See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.
         * </p>
         * <p>
         * Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.
         * </p>
         * <p>
         * App callback URLs such as myapp://example are also supported.
         * </p>
         * 
         * @param callbackURLs
         *        A list of allowed redirect, or callback, URLs for managed login authentication. These URLs are the
         *        paths where you want to send your users' browsers after they complete authentication with managed
         *        login or a third-party IdP. Typically, callback URLs are the home of an application that uses OAuth or
         *        OIDC libraries to process authentication outcomes.</p>
         *        <p>
         *        A redirect URI must meet the following requirements:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Be an absolute URI.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Be registered with the authorization server. Amazon Cognito doesn't accept authorization requests with
         *        <code>redirect_uri</code> values that aren't in the list of <code>CallbackURLs</code> that you provide
         *        in this parameter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Not include a fragment component.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.
         *        </p>
         *        <p>
         *        Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.
         *        </p>
         *        <p>
         *        App callback URLs such as myapp://example are also supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callbackURLs(Collection<String> callbackURLs);

        /**
         * <p>
         * A list of allowed redirect, or callback, URLs for managed login authentication. These URLs are the paths
         * where you want to send your users' browsers after they complete authentication with managed login or a
         * third-party IdP. Typically, callback URLs are the home of an application that uses OAuth or OIDC libraries to
         * process authentication outcomes.
         * </p>
         * <p>
         * A redirect URI must meet the following requirements:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Be an absolute URI.
         * </p>
         * </li>
         * <li>
         * <p>
         * Be registered with the authorization server. Amazon Cognito doesn't accept authorization requests with
         * <code>redirect_uri</code> values that aren't in the list of <code>CallbackURLs</code> that you provide in
         * this parameter.
         * </p>
         * </li>
         * <li>
         * <p>
         * Not include a fragment component.
         * </p>
         * </li>
         * </ul>
         * <p>
         * See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.
         * </p>
         * <p>
         * Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.
         * </p>
         * <p>
         * App callback URLs such as myapp://example are also supported.
         * </p>
         * 
         * @param callbackURLs
         *        A list of allowed redirect, or callback, URLs for managed login authentication. These URLs are the
         *        paths where you want to send your users' browsers after they complete authentication with managed
         *        login or a third-party IdP. Typically, callback URLs are the home of an application that uses OAuth or
         *        OIDC libraries to process authentication outcomes.</p>
         *        <p>
         *        A redirect URI must meet the following requirements:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Be an absolute URI.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Be registered with the authorization server. Amazon Cognito doesn't accept authorization requests with
         *        <code>redirect_uri</code> values that aren't in the list of <code>CallbackURLs</code> that you provide
         *        in this parameter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Not include a fragment component.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.
         *        </p>
         *        <p>
         *        Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.
         *        </p>
         *        <p>
         *        App callback URLs such as myapp://example are also supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callbackURLs(String... callbackURLs);

        /**
         * <p>
         * A list of allowed logout URLs for managed login authentication. When you pass <code>logout_uri</code> and
         * <code>client_id</code> parameters to <code>/logout</code>, Amazon Cognito signs out your user and redirects
         * them to the logout URL. This parameter describes the URLs that you want to be the permitted targets of
         * <code>logout_uri</code>. A typical use of these URLs is when a user selects "Sign out" and you redirect them
         * to your public homepage. For more information, see <a
         * href="https://docs.aws.amazon.com/cognito/latest/developerguide/logout-endpoint.html">Logout endpoint</a>.
         * </p>
         * 
         * @param logoutURLs
         *        A list of allowed logout URLs for managed login authentication. When you pass <code>logout_uri</code>
         *        and <code>client_id</code> parameters to <code>/logout</code>, Amazon Cognito signs out your user and
         *        redirects them to the logout URL. This parameter describes the URLs that you want to be the permitted
         *        targets of <code>logout_uri</code>. A typical use of these URLs is when a user selects "Sign out" and
         *        you redirect them to your public homepage. For more information, see <a
         *        href="https://docs.aws.amazon.com/cognito/latest/developerguide/logout-endpoint.html">Logout
         *        endpoint</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logoutURLs(Collection<String> logoutURLs);

        /**
         * <p>
         * A list of allowed logout URLs for managed login authentication. When you pass <code>logout_uri</code> and
         * <code>client_id</code> parameters to <code>/logout</code>, Amazon Cognito signs out your user and redirects
         * them to the logout URL. This parameter describes the URLs that you want to be the permitted targets of
         * <code>logout_uri</code>. A typical use of these URLs is when a user selects "Sign out" and you redirect them
         * to your public homepage. For more information, see <a
         * href="https://docs.aws.amazon.com/cognito/latest/developerguide/logout-endpoint.html">Logout endpoint</a>.
         * </p>
         * 
         * @param logoutURLs
         *        A list of allowed logout URLs for managed login authentication. When you pass <code>logout_uri</code>
         *        and <code>client_id</code> parameters to <code>/logout</code>, Amazon Cognito signs out your user and
         *        redirects them to the logout URL. This parameter describes the URLs that you want to be the permitted
         *        targets of <code>logout_uri</code>. A typical use of these URLs is when a user selects "Sign out" and
         *        you redirect them to your public homepage. For more information, see <a
         *        href="https://docs.aws.amazon.com/cognito/latest/developerguide/logout-endpoint.html">Logout
         *        endpoint</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logoutURLs(String... logoutURLs);

        /**
         * <p>
         * The default redirect URI. In app clients with one assigned IdP, replaces <code>redirect_uri</code> in
         * authentication requests. Must be in the <code>CallbackURLs</code> list.
         * </p>
         * 
         * @param defaultRedirectURI
         *        The default redirect URI. In app clients with one assigned IdP, replaces <code>redirect_uri</code> in
         *        authentication requests. Must be in the <code>CallbackURLs</code> list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultRedirectURI(String defaultRedirectURI);

        /**
         * <p>
         * The OAuth grant types that you want your app client to generate for clients in managed login authentication.
         * To create an app client that generates client credentials grants, you must add
         * <code>client_credentials</code> as the only allowed OAuth flow.
         * </p>
         * <dl>
         * <dt>code</dt>
         * <dd>
         * <p>
         * Use a code grant flow, which provides an authorization code as the response. This code can be exchanged for
         * access tokens with the <code>/oauth2/token</code> endpoint.
         * </p>
         * </dd>
         * <dt>implicit</dt>
         * <dd>
         * <p>
         * Issue the access token, and the ID token when scopes like <code>openid</code> and <code>profile</code> are
         * requested, directly to your user.
         * </p>
         * </dd>
         * <dt>client_credentials</dt>
         * <dd>
         * <p>
         * Issue the access token from the <code>/oauth2/token</code> endpoint directly to a non-person user, authorized
         * by a combination of the client ID and client secret.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param allowedOAuthFlows
         *        The OAuth grant types that you want your app client to generate for clients in managed login
         *        authentication. To create an app client that generates client credentials grants, you must add
         *        <code>client_credentials</code> as the only allowed OAuth flow.</p>
         *        <dl>
         *        <dt>code</dt>
         *        <dd>
         *        <p>
         *        Use a code grant flow, which provides an authorization code as the response. This code can be
         *        exchanged for access tokens with the <code>/oauth2/token</code> endpoint.
         *        </p>
         *        </dd>
         *        <dt>implicit</dt>
         *        <dd>
         *        <p>
         *        Issue the access token, and the ID token when scopes like <code>openid</code> and <code>profile</code>
         *        are requested, directly to your user.
         *        </p>
         *        </dd>
         *        <dt>client_credentials</dt>
         *        <dd>
         *        <p>
         *        Issue the access token from the <code>/oauth2/token</code> endpoint directly to a non-person user,
         *        authorized by a combination of the client ID and client secret.
         *        </p>
         *        </dd>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedOAuthFlowsWithStrings(Collection<String> allowedOAuthFlows);

        /**
         * <p>
         * The OAuth grant types that you want your app client to generate for clients in managed login authentication.
         * To create an app client that generates client credentials grants, you must add
         * <code>client_credentials</code> as the only allowed OAuth flow.
         * </p>
         * <dl>
         * <dt>code</dt>
         * <dd>
         * <p>
         * Use a code grant flow, which provides an authorization code as the response. This code can be exchanged for
         * access tokens with the <code>/oauth2/token</code> endpoint.
         * </p>
         * </dd>
         * <dt>implicit</dt>
         * <dd>
         * <p>
         * Issue the access token, and the ID token when scopes like <code>openid</code> and <code>profile</code> are
         * requested, directly to your user.
         * </p>
         * </dd>
         * <dt>client_credentials</dt>
         * <dd>
         * <p>
         * Issue the access token from the <code>/oauth2/token</code> endpoint directly to a non-person user, authorized
         * by a combination of the client ID and client secret.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param allowedOAuthFlows
         *        The OAuth grant types that you want your app client to generate for clients in managed login
         *        authentication. To create an app client that generates client credentials grants, you must add
         *        <code>client_credentials</code> as the only allowed OAuth flow.</p>
         *        <dl>
         *        <dt>code</dt>
         *        <dd>
         *        <p>
         *        Use a code grant flow, which provides an authorization code as the response. This code can be
         *        exchanged for access tokens with the <code>/oauth2/token</code> endpoint.
         *        </p>
         *        </dd>
         *        <dt>implicit</dt>
         *        <dd>
         *        <p>
         *        Issue the access token, and the ID token when scopes like <code>openid</code> and <code>profile</code>
         *        are requested, directly to your user.
         *        </p>
         *        </dd>
         *        <dt>client_credentials</dt>
         *        <dd>
         *        <p>
         *        Issue the access token from the <code>/oauth2/token</code> endpoint directly to a non-person user,
         *        authorized by a combination of the client ID and client secret.
         *        </p>
         *        </dd>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedOAuthFlowsWithStrings(String... allowedOAuthFlows);

        /**
         * <p>
         * The OAuth grant types that you want your app client to generate for clients in managed login authentication.
         * To create an app client that generates client credentials grants, you must add
         * <code>client_credentials</code> as the only allowed OAuth flow.
         * </p>
         * <dl>
         * <dt>code</dt>
         * <dd>
         * <p>
         * Use a code grant flow, which provides an authorization code as the response. This code can be exchanged for
         * access tokens with the <code>/oauth2/token</code> endpoint.
         * </p>
         * </dd>
         * <dt>implicit</dt>
         * <dd>
         * <p>
         * Issue the access token, and the ID token when scopes like <code>openid</code> and <code>profile</code> are
         * requested, directly to your user.
         * </p>
         * </dd>
         * <dt>client_credentials</dt>
         * <dd>
         * <p>
         * Issue the access token from the <code>/oauth2/token</code> endpoint directly to a non-person user, authorized
         * by a combination of the client ID and client secret.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param allowedOAuthFlows
         *        The OAuth grant types that you want your app client to generate for clients in managed login
         *        authentication. To create an app client that generates client credentials grants, you must add
         *        <code>client_credentials</code> as the only allowed OAuth flow.</p>
         *        <dl>
         *        <dt>code</dt>
         *        <dd>
         *        <p>
         *        Use a code grant flow, which provides an authorization code as the response. This code can be
         *        exchanged for access tokens with the <code>/oauth2/token</code> endpoint.
         *        </p>
         *        </dd>
         *        <dt>implicit</dt>
         *        <dd>
         *        <p>
         *        Issue the access token, and the ID token when scopes like <code>openid</code> and <code>profile</code>
         *        are requested, directly to your user.
         *        </p>
         *        </dd>
         *        <dt>client_credentials</dt>
         *        <dd>
         *        <p>
         *        Issue the access token from the <code>/oauth2/token</code> endpoint directly to a non-person user,
         *        authorized by a combination of the client ID and client secret.
         *        </p>
         *        </dd>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedOAuthFlows(Collection<OAuthFlowType> allowedOAuthFlows);

        /**
         * <p>
         * The OAuth grant types that you want your app client to generate for clients in managed login authentication.
         * To create an app client that generates client credentials grants, you must add
         * <code>client_credentials</code> as the only allowed OAuth flow.
         * </p>
         * <dl>
         * <dt>code</dt>
         * <dd>
         * <p>
         * Use a code grant flow, which provides an authorization code as the response. This code can be exchanged for
         * access tokens with the <code>/oauth2/token</code> endpoint.
         * </p>
         * </dd>
         * <dt>implicit</dt>
         * <dd>
         * <p>
         * Issue the access token, and the ID token when scopes like <code>openid</code> and <code>profile</code> are
         * requested, directly to your user.
         * </p>
         * </dd>
         * <dt>client_credentials</dt>
         * <dd>
         * <p>
         * Issue the access token from the <code>/oauth2/token</code> endpoint directly to a non-person user, authorized
         * by a combination of the client ID and client secret.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param allowedOAuthFlows
         *        The OAuth grant types that you want your app client to generate for clients in managed login
         *        authentication. To create an app client that generates client credentials grants, you must add
         *        <code>client_credentials</code> as the only allowed OAuth flow.</p>
         *        <dl>
         *        <dt>code</dt>
         *        <dd>
         *        <p>
         *        Use a code grant flow, which provides an authorization code as the response. This code can be
         *        exchanged for access tokens with the <code>/oauth2/token</code> endpoint.
         *        </p>
         *        </dd>
         *        <dt>implicit</dt>
         *        <dd>
         *        <p>
         *        Issue the access token, and the ID token when scopes like <code>openid</code> and <code>profile</code>
         *        are requested, directly to your user.
         *        </p>
         *        </dd>
         *        <dt>client_credentials</dt>
         *        <dd>
         *        <p>
         *        Issue the access token from the <code>/oauth2/token</code> endpoint directly to a non-person user,
         *        authorized by a combination of the client ID and client secret.
         *        </p>
         *        </dd>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedOAuthFlows(OAuthFlowType... allowedOAuthFlows);

        /**
         * <p>
         * The OAuth, OpenID Connect (OIDC), and custom scopes that you want to permit your app client to authorize
         * access with. Scopes govern access control to user pool self-service API operations, user data from the
         * <code>userInfo</code> endpoint, and third-party APIs. Scope values include <code>phone</code>,
         * <code>email</code>, <code>openid</code>, and <code>profile</code>. The
         * <code>aws.cognito.signin.user.admin</code> scope authorizes user self-service operations. Custom scopes with
         * resource servers authorize access to external APIs.
         * </p>
         * 
         * @param allowedOAuthScopes
         *        The OAuth, OpenID Connect (OIDC), and custom scopes that you want to permit your app client to
         *        authorize access with. Scopes govern access control to user pool self-service API operations, user
         *        data from the <code>userInfo</code> endpoint, and third-party APIs. Scope values include
         *        <code>phone</code>, <code>email</code>, <code>openid</code>, and <code>profile</code>. The
         *        <code>aws.cognito.signin.user.admin</code> scope authorizes user self-service operations. Custom
         *        scopes with resource servers authorize access to external APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedOAuthScopes(Collection<String> allowedOAuthScopes);

        /**
         * <p>
         * The OAuth, OpenID Connect (OIDC), and custom scopes that you want to permit your app client to authorize
         * access with. Scopes govern access control to user pool self-service API operations, user data from the
         * <code>userInfo</code> endpoint, and third-party APIs. Scope values include <code>phone</code>,
         * <code>email</code>, <code>openid</code>, and <code>profile</code>. The
         * <code>aws.cognito.signin.user.admin</code> scope authorizes user self-service operations. Custom scopes with
         * resource servers authorize access to external APIs.
         * </p>
         * 
         * @param allowedOAuthScopes
         *        The OAuth, OpenID Connect (OIDC), and custom scopes that you want to permit your app client to
         *        authorize access with. Scopes govern access control to user pool self-service API operations, user
         *        data from the <code>userInfo</code> endpoint, and third-party APIs. Scope values include
         *        <code>phone</code>, <code>email</code>, <code>openid</code>, and <code>profile</code>. The
         *        <code>aws.cognito.signin.user.admin</code> scope authorizes user self-service operations. Custom
         *        scopes with resource servers authorize access to external APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedOAuthScopes(String... allowedOAuthScopes);

        /**
         * <p>
         * Set to <code>true</code> to use OAuth 2.0 authorization server features in your app client.
         * </p>
         * <p>
         * This parameter must have a value of <code>true</code> before you can configure the following features in your
         * app client.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CallBackURLs</code>: Callback URLs.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LogoutURLs</code>: Sign-out redirect URLs.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AllowedOAuthScopes</code>: OAuth 2.0 scopes.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AllowedOAuthFlows</code>: Support for authorization code, implicit, and client credentials OAuth 2.0
         * grants.
         * </p>
         * </li>
         * </ul>
         * <p>
         * To use authorization server features, configure one of these features in the Amazon Cognito console or set
         * <code>AllowedOAuthFlowsUserPoolClient</code> to <code>true</code> in a <code>CreateUserPoolClient</code> or
         * <code>UpdateUserPoolClient</code> API request. If you don't set a value for
         * <code>AllowedOAuthFlowsUserPoolClient</code> in a request with the CLI or SDKs, it defaults to
         * <code>false</code>. When <code>false</code>, only SDK-based API sign-in is permitted.
         * </p>
         * 
         * @param allowedOAuthFlowsUserPoolClient
         *        Set to <code>true</code> to use OAuth 2.0 authorization server features in your app client.</p>
         *        <p>
         *        This parameter must have a value of <code>true</code> before you can configure the following features
         *        in your app client.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CallBackURLs</code>: Callback URLs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LogoutURLs</code>: Sign-out redirect URLs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AllowedOAuthScopes</code>: OAuth 2.0 scopes.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AllowedOAuthFlows</code>: Support for authorization code, implicit, and client credentials OAuth
         *        2.0 grants.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        To use authorization server features, configure one of these features in the Amazon Cognito console or
         *        set <code>AllowedOAuthFlowsUserPoolClient</code> to <code>true</code> in a
         *        <code>CreateUserPoolClient</code> or <code>UpdateUserPoolClient</code> API request. If you don't set a
         *        value for <code>AllowedOAuthFlowsUserPoolClient</code> in a request with the CLI or SDKs, it defaults
         *        to <code>false</code>. When <code>false</code>, only SDK-based API sign-in is permitted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedOAuthFlowsUserPoolClient(Boolean allowedOAuthFlowsUserPoolClient);

        /**
         * <p>
         * The user pool analytics configuration for collecting metrics and sending them to your Amazon Pinpoint
         * campaign.
         * </p>
         * <p>
         * In Amazon Web Services Regions where Amazon Pinpoint isn't available, user pools might not have access to
         * analytics or might be configurable with campaigns in the US East (N. Virginia) Region. For more information,
         * see <a href=
         * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-pinpoint-integration.html"
         * >Using Amazon Pinpoint analytics</a>.
         * </p>
         * 
         * @param analyticsConfiguration
         *        The user pool analytics configuration for collecting metrics and sending them to your Amazon Pinpoint
         *        campaign.</p>
         *        <p>
         *        In Amazon Web Services Regions where Amazon Pinpoint isn't available, user pools might not have access
         *        to analytics or might be configurable with campaigns in the US East (N. Virginia) Region. For more
         *        information, see <a href=
         *        "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-pinpoint-integration.html"
         *        >Using Amazon Pinpoint analytics</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analyticsConfiguration(AnalyticsConfigurationType analyticsConfiguration);

        /**
         * <p>
         * The user pool analytics configuration for collecting metrics and sending them to your Amazon Pinpoint
         * campaign.
         * </p>
         * <p>
         * In Amazon Web Services Regions where Amazon Pinpoint isn't available, user pools might not have access to
         * analytics or might be configurable with campaigns in the US East (N. Virginia) Region. For more information,
         * see <a href=
         * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-pinpoint-integration.html"
         * >Using Amazon Pinpoint analytics</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link AnalyticsConfigurationType.Builder}
         * avoiding the need to create one manually via {@link AnalyticsConfigurationType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AnalyticsConfigurationType.Builder#build()} is called immediately
         * and its result is passed to {@link #analyticsConfiguration(AnalyticsConfigurationType)}.
         * 
         * @param analyticsConfiguration
         *        a consumer that will call methods on {@link AnalyticsConfigurationType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #analyticsConfiguration(AnalyticsConfigurationType)
         */
        default Builder analyticsConfiguration(Consumer<AnalyticsConfigurationType.Builder> analyticsConfiguration) {
            return analyticsConfiguration(AnalyticsConfigurationType.builder().applyMutation(analyticsConfiguration).build());
        }

        /**
         * <p>
         * When <code>ENABLED</code>, suppresses messages that might indicate a valid user exists when someone attempts
         * sign-in. This parameters sets your preference for the errors and responses that you want Amazon Cognito APIs
         * to return during authentication, account confirmation, and password recovery when the user doesn't exist in
         * the user pool. When set to <code>ENABLED</code> and the user doesn't exist, authentication returns an error
         * indicating either the username or password was incorrect. Account confirmation and password recovery return a
         * response indicating a code was sent to a simulated destination. When set to <code>LEGACY</code>, those APIs
         * return a <code>UserNotFoundException</code> exception if the user doesn't exist in the user pool.
         * </p>
         * <p>
         * Defaults to <code>LEGACY</code>.
         * </p>
         * 
         * @param preventUserExistenceErrors
         *        When <code>ENABLED</code>, suppresses messages that might indicate a valid user exists when someone
         *        attempts sign-in. This parameters sets your preference for the errors and responses that you want
         *        Amazon Cognito APIs to return during authentication, account confirmation, and password recovery when
         *        the user doesn't exist in the user pool. When set to <code>ENABLED</code> and the user doesn't exist,
         *        authentication returns an error indicating either the username or password was incorrect. Account
         *        confirmation and password recovery return a response indicating a code was sent to a simulated
         *        destination. When set to <code>LEGACY</code>, those APIs return a <code>UserNotFoundException</code>
         *        exception if the user doesn't exist in the user pool.</p>
         *        <p>
         *        Defaults to <code>LEGACY</code>.
         * @see PreventUserExistenceErrorTypes
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PreventUserExistenceErrorTypes
         */
        Builder preventUserExistenceErrors(String preventUserExistenceErrors);

        /**
         * <p>
         * When <code>ENABLED</code>, suppresses messages that might indicate a valid user exists when someone attempts
         * sign-in. This parameters sets your preference for the errors and responses that you want Amazon Cognito APIs
         * to return during authentication, account confirmation, and password recovery when the user doesn't exist in
         * the user pool. When set to <code>ENABLED</code> and the user doesn't exist, authentication returns an error
         * indicating either the username or password was incorrect. Account confirmation and password recovery return a
         * response indicating a code was sent to a simulated destination. When set to <code>LEGACY</code>, those APIs
         * return a <code>UserNotFoundException</code> exception if the user doesn't exist in the user pool.
         * </p>
         * <p>
         * Defaults to <code>LEGACY</code>.
         * </p>
         * 
         * @param preventUserExistenceErrors
         *        When <code>ENABLED</code>, suppresses messages that might indicate a valid user exists when someone
         *        attempts sign-in. This parameters sets your preference for the errors and responses that you want
         *        Amazon Cognito APIs to return during authentication, account confirmation, and password recovery when
         *        the user doesn't exist in the user pool. When set to <code>ENABLED</code> and the user doesn't exist,
         *        authentication returns an error indicating either the username or password was incorrect. Account
         *        confirmation and password recovery return a response indicating a code was sent to a simulated
         *        destination. When set to <code>LEGACY</code>, those APIs return a <code>UserNotFoundException</code>
         *        exception if the user doesn't exist in the user pool.</p>
         *        <p>
         *        Defaults to <code>LEGACY</code>.
         * @see PreventUserExistenceErrorTypes
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PreventUserExistenceErrorTypes
         */
        Builder preventUserExistenceErrors(PreventUserExistenceErrorTypes preventUserExistenceErrors);

        /**
         * <p>
         * Activates or deactivates <a
         * href="https://docs.aws.amazon.com/cognito/latest/developerguide/token-revocation.html">token revocation</a>
         * in the target app client.
         * </p>
         * <p>
         * If you don't include this parameter, token revocation is automatically activated for the new user pool
         * client.
         * </p>
         * 
         * @param enableTokenRevocation
         *        Activates or deactivates <a
         *        href="https://docs.aws.amazon.com/cognito/latest/developerguide/token-revocation.html">token
         *        revocation</a> in the target app client.</p>
         *        <p>
         *        If you don't include this parameter, token revocation is automatically activated for the new user pool
         *        client.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableTokenRevocation(Boolean enableTokenRevocation);

        /**
         * <p>
         * When <code>true</code>, your application can include additional <code>UserContextData</code> in
         * authentication requests. This data includes the IP address, and contributes to analysis by threat protection
         * features. For more information about propagation of user context data, see <a href=
         * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-adaptive-authentication.html#user-pool-settings-adaptive-authentication-device-fingerprint"
         * >Adding session data to API requests</a>. If you don’t include this parameter, you can't send the source IP
         * address to Amazon Cognito threat protection features. You can only activate
         * <code>EnablePropagateAdditionalUserContextData</code> in an app client that has a client secret.
         * </p>
         * 
         * @param enablePropagateAdditionalUserContextData
         *        When <code>true</code>, your application can include additional <code>UserContextData</code> in
         *        authentication requests. This data includes the IP address, and contributes to analysis by threat
         *        protection features. For more information about propagation of user context data, see <a href=
         *        "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-adaptive-authentication.html#user-pool-settings-adaptive-authentication-device-fingerprint"
         *        >Adding session data to API requests</a>. If you don’t include this parameter, you can't send the
         *        source IP address to Amazon Cognito threat protection features. You can only activate
         *        <code>EnablePropagateAdditionalUserContextData</code> in an app client that has a client secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enablePropagateAdditionalUserContextData(Boolean enablePropagateAdditionalUserContextData);

        /**
         * <p>
         * Amazon Cognito creates a session token for each API request in an authentication flow.
         * <code>AuthSessionValidity</code> is the duration, in minutes, of that session token. Your user pool native
         * user must respond to each authentication challenge before the session expires.
         * </p>
         * 
         * @param authSessionValidity
         *        Amazon Cognito creates a session token for each API request in an authentication flow.
         *        <code>AuthSessionValidity</code> is the duration, in minutes, of that session token. Your user pool
         *        native user must respond to each authentication challenge before the session expires.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authSessionValidity(Integer authSessionValidity);

        /**
         * <p>
         * The configuration of your app client for refresh token rotation. When enabled, your app client issues new ID,
         * access, and refresh tokens when users renew their sessions with refresh tokens. When disabled, token refresh
         * issues only ID and access tokens.
         * </p>
         * 
         * @param refreshTokenRotation
         *        The configuration of your app client for refresh token rotation. When enabled, your app client issues
         *        new ID, access, and refresh tokens when users renew their sessions with refresh tokens. When disabled,
         *        token refresh issues only ID and access tokens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder refreshTokenRotation(RefreshTokenRotationType refreshTokenRotation);

        /**
         * <p>
         * The configuration of your app client for refresh token rotation. When enabled, your app client issues new ID,
         * access, and refresh tokens when users renew their sessions with refresh tokens. When disabled, token refresh
         * issues only ID and access tokens.
         * </p>
         * This is a convenience method that creates an instance of the {@link RefreshTokenRotationType.Builder}
         * avoiding the need to create one manually via {@link RefreshTokenRotationType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RefreshTokenRotationType.Builder#build()} is called immediately
         * and its result is passed to {@link #refreshTokenRotation(RefreshTokenRotationType)}.
         * 
         * @param refreshTokenRotation
         *        a consumer that will call methods on {@link RefreshTokenRotationType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #refreshTokenRotation(RefreshTokenRotationType)
         */
        default Builder refreshTokenRotation(Consumer<RefreshTokenRotationType.Builder> refreshTokenRotation) {
            return refreshTokenRotation(RefreshTokenRotationType.builder().applyMutation(refreshTokenRotation).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CognitoIdentityProviderRequest.BuilderImpl implements Builder {
        private String userPoolId;

        private String clientName;

        private Boolean generateSecret;

        private Integer refreshTokenValidity;

        private Integer accessTokenValidity;

        private Integer idTokenValidity;

        private TokenValidityUnitsType tokenValidityUnits;

        private List<String> readAttributes = DefaultSdkAutoConstructList.getInstance();

        private List<String> writeAttributes = DefaultSdkAutoConstructList.getInstance();

        private List<String> explicitAuthFlows = DefaultSdkAutoConstructList.getInstance();

        private List<String> supportedIdentityProviders = DefaultSdkAutoConstructList.getInstance();

        private List<String> callbackURLs = DefaultSdkAutoConstructList.getInstance();

        private List<String> logoutURLs = DefaultSdkAutoConstructList.getInstance();

        private String defaultRedirectURI;

        private List<String> allowedOAuthFlows = DefaultSdkAutoConstructList.getInstance();

        private List<String> allowedOAuthScopes = DefaultSdkAutoConstructList.getInstance();

        private Boolean allowedOAuthFlowsUserPoolClient;

        private AnalyticsConfigurationType analyticsConfiguration;

        private String preventUserExistenceErrors;

        private Boolean enableTokenRevocation;

        private Boolean enablePropagateAdditionalUserContextData;

        private Integer authSessionValidity;

        private RefreshTokenRotationType refreshTokenRotation;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUserPoolClientRequest model) {
            super(model);
            userPoolId(model.userPoolId);
            clientName(model.clientName);
            generateSecret(model.generateSecret);
            refreshTokenValidity(model.refreshTokenValidity);
            accessTokenValidity(model.accessTokenValidity);
            idTokenValidity(model.idTokenValidity);
            tokenValidityUnits(model.tokenValidityUnits);
            readAttributes(model.readAttributes);
            writeAttributes(model.writeAttributes);
            explicitAuthFlowsWithStrings(model.explicitAuthFlows);
            supportedIdentityProviders(model.supportedIdentityProviders);
            callbackURLs(model.callbackURLs);
            logoutURLs(model.logoutURLs);
            defaultRedirectURI(model.defaultRedirectURI);
            allowedOAuthFlowsWithStrings(model.allowedOAuthFlows);
            allowedOAuthScopes(model.allowedOAuthScopes);
            allowedOAuthFlowsUserPoolClient(model.allowedOAuthFlowsUserPoolClient);
            analyticsConfiguration(model.analyticsConfiguration);
            preventUserExistenceErrors(model.preventUserExistenceErrors);
            enableTokenRevocation(model.enableTokenRevocation);
            enablePropagateAdditionalUserContextData(model.enablePropagateAdditionalUserContextData);
            authSessionValidity(model.authSessionValidity);
            refreshTokenRotation(model.refreshTokenRotation);
        }

        public final String getUserPoolId() {
            return userPoolId;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final String getClientName() {
            return clientName;
        }

        public final void setClientName(String clientName) {
            this.clientName = clientName;
        }

        @Override
        public final Builder clientName(String clientName) {
            this.clientName = clientName;
            return this;
        }

        public final Boolean getGenerateSecret() {
            return generateSecret;
        }

        public final void setGenerateSecret(Boolean generateSecret) {
            this.generateSecret = generateSecret;
        }

        @Override
        public final Builder generateSecret(Boolean generateSecret) {
            this.generateSecret = generateSecret;
            return this;
        }

        public final Integer getRefreshTokenValidity() {
            return refreshTokenValidity;
        }

        public final void setRefreshTokenValidity(Integer refreshTokenValidity) {
            this.refreshTokenValidity = refreshTokenValidity;
        }

        @Override
        public final Builder refreshTokenValidity(Integer refreshTokenValidity) {
            this.refreshTokenValidity = refreshTokenValidity;
            return this;
        }

        public final Integer getAccessTokenValidity() {
            return accessTokenValidity;
        }

        public final void setAccessTokenValidity(Integer accessTokenValidity) {
            this.accessTokenValidity = accessTokenValidity;
        }

        @Override
        public final Builder accessTokenValidity(Integer accessTokenValidity) {
            this.accessTokenValidity = accessTokenValidity;
            return this;
        }

        public final Integer getIdTokenValidity() {
            return idTokenValidity;
        }

        public final void setIdTokenValidity(Integer idTokenValidity) {
            this.idTokenValidity = idTokenValidity;
        }

        @Override
        public final Builder idTokenValidity(Integer idTokenValidity) {
            this.idTokenValidity = idTokenValidity;
            return this;
        }

        public final TokenValidityUnitsType.Builder getTokenValidityUnits() {
            return tokenValidityUnits != null ? tokenValidityUnits.toBuilder() : null;
        }

        public final void setTokenValidityUnits(TokenValidityUnitsType.BuilderImpl tokenValidityUnits) {
            this.tokenValidityUnits = tokenValidityUnits != null ? tokenValidityUnits.build() : null;
        }

        @Override
        public final Builder tokenValidityUnits(TokenValidityUnitsType tokenValidityUnits) {
            this.tokenValidityUnits = tokenValidityUnits;
            return this;
        }

        public final Collection<String> getReadAttributes() {
            if (readAttributes instanceof SdkAutoConstructList) {
                return null;
            }
            return readAttributes;
        }

        public final void setReadAttributes(Collection<String> readAttributes) {
            this.readAttributes = ClientPermissionListTypeCopier.copy(readAttributes);
        }

        @Override
        public final Builder readAttributes(Collection<String> readAttributes) {
            this.readAttributes = ClientPermissionListTypeCopier.copy(readAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder readAttributes(String... readAttributes) {
            readAttributes(Arrays.asList(readAttributes));
            return this;
        }

        public final Collection<String> getWriteAttributes() {
            if (writeAttributes instanceof SdkAutoConstructList) {
                return null;
            }
            return writeAttributes;
        }

        public final void setWriteAttributes(Collection<String> writeAttributes) {
            this.writeAttributes = ClientPermissionListTypeCopier.copy(writeAttributes);
        }

        @Override
        public final Builder writeAttributes(Collection<String> writeAttributes) {
            this.writeAttributes = ClientPermissionListTypeCopier.copy(writeAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder writeAttributes(String... writeAttributes) {
            writeAttributes(Arrays.asList(writeAttributes));
            return this;
        }

        public final Collection<String> getExplicitAuthFlows() {
            if (explicitAuthFlows instanceof SdkAutoConstructList) {
                return null;
            }
            return explicitAuthFlows;
        }

        public final void setExplicitAuthFlows(Collection<String> explicitAuthFlows) {
            this.explicitAuthFlows = ExplicitAuthFlowsListTypeCopier.copy(explicitAuthFlows);
        }

        @Override
        public final Builder explicitAuthFlowsWithStrings(Collection<String> explicitAuthFlows) {
            this.explicitAuthFlows = ExplicitAuthFlowsListTypeCopier.copy(explicitAuthFlows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder explicitAuthFlowsWithStrings(String... explicitAuthFlows) {
            explicitAuthFlowsWithStrings(Arrays.asList(explicitAuthFlows));
            return this;
        }

        @Override
        public final Builder explicitAuthFlows(Collection<ExplicitAuthFlowsType> explicitAuthFlows) {
            this.explicitAuthFlows = ExplicitAuthFlowsListTypeCopier.copyEnumToString(explicitAuthFlows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder explicitAuthFlows(ExplicitAuthFlowsType... explicitAuthFlows) {
            explicitAuthFlows(Arrays.asList(explicitAuthFlows));
            return this;
        }

        public final Collection<String> getSupportedIdentityProviders() {
            if (supportedIdentityProviders instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedIdentityProviders;
        }

        public final void setSupportedIdentityProviders(Collection<String> supportedIdentityProviders) {
            this.supportedIdentityProviders = SupportedIdentityProvidersListTypeCopier.copy(supportedIdentityProviders);
        }

        @Override
        public final Builder supportedIdentityProviders(Collection<String> supportedIdentityProviders) {
            this.supportedIdentityProviders = SupportedIdentityProvidersListTypeCopier.copy(supportedIdentityProviders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedIdentityProviders(String... supportedIdentityProviders) {
            supportedIdentityProviders(Arrays.asList(supportedIdentityProviders));
            return this;
        }

        public final Collection<String> getCallbackURLs() {
            if (callbackURLs instanceof SdkAutoConstructList) {
                return null;
            }
            return callbackURLs;
        }

        public final void setCallbackURLs(Collection<String> callbackURLs) {
            this.callbackURLs = CallbackURLsListTypeCopier.copy(callbackURLs);
        }

        @Override
        public final Builder callbackURLs(Collection<String> callbackURLs) {
            this.callbackURLs = CallbackURLsListTypeCopier.copy(callbackURLs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder callbackURLs(String... callbackURLs) {
            callbackURLs(Arrays.asList(callbackURLs));
            return this;
        }

        public final Collection<String> getLogoutURLs() {
            if (logoutURLs instanceof SdkAutoConstructList) {
                return null;
            }
            return logoutURLs;
        }

        public final void setLogoutURLs(Collection<String> logoutURLs) {
            this.logoutURLs = LogoutURLsListTypeCopier.copy(logoutURLs);
        }

        @Override
        public final Builder logoutURLs(Collection<String> logoutURLs) {
            this.logoutURLs = LogoutURLsListTypeCopier.copy(logoutURLs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logoutURLs(String... logoutURLs) {
            logoutURLs(Arrays.asList(logoutURLs));
            return this;
        }

        public final String getDefaultRedirectURI() {
            return defaultRedirectURI;
        }

        public final void setDefaultRedirectURI(String defaultRedirectURI) {
            this.defaultRedirectURI = defaultRedirectURI;
        }

        @Override
        public final Builder defaultRedirectURI(String defaultRedirectURI) {
            this.defaultRedirectURI = defaultRedirectURI;
            return this;
        }

        public final Collection<String> getAllowedOAuthFlows() {
            if (allowedOAuthFlows instanceof SdkAutoConstructList) {
                return null;
            }
            return allowedOAuthFlows;
        }

        public final void setAllowedOAuthFlows(Collection<String> allowedOAuthFlows) {
            this.allowedOAuthFlows = OAuthFlowsTypeCopier.copy(allowedOAuthFlows);
        }

        @Override
        public final Builder allowedOAuthFlowsWithStrings(Collection<String> allowedOAuthFlows) {
            this.allowedOAuthFlows = OAuthFlowsTypeCopier.copy(allowedOAuthFlows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedOAuthFlowsWithStrings(String... allowedOAuthFlows) {
            allowedOAuthFlowsWithStrings(Arrays.asList(allowedOAuthFlows));
            return this;
        }

        @Override
        public final Builder allowedOAuthFlows(Collection<OAuthFlowType> allowedOAuthFlows) {
            this.allowedOAuthFlows = OAuthFlowsTypeCopier.copyEnumToString(allowedOAuthFlows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedOAuthFlows(OAuthFlowType... allowedOAuthFlows) {
            allowedOAuthFlows(Arrays.asList(allowedOAuthFlows));
            return this;
        }

        public final Collection<String> getAllowedOAuthScopes() {
            if (allowedOAuthScopes instanceof SdkAutoConstructList) {
                return null;
            }
            return allowedOAuthScopes;
        }

        public final void setAllowedOAuthScopes(Collection<String> allowedOAuthScopes) {
            this.allowedOAuthScopes = ScopeListTypeCopier.copy(allowedOAuthScopes);
        }

        @Override
        public final Builder allowedOAuthScopes(Collection<String> allowedOAuthScopes) {
            this.allowedOAuthScopes = ScopeListTypeCopier.copy(allowedOAuthScopes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedOAuthScopes(String... allowedOAuthScopes) {
            allowedOAuthScopes(Arrays.asList(allowedOAuthScopes));
            return this;
        }

        public final Boolean getAllowedOAuthFlowsUserPoolClient() {
            return allowedOAuthFlowsUserPoolClient;
        }

        public final void setAllowedOAuthFlowsUserPoolClient(Boolean allowedOAuthFlowsUserPoolClient) {
            this.allowedOAuthFlowsUserPoolClient = allowedOAuthFlowsUserPoolClient;
        }

        @Override
        public final Builder allowedOAuthFlowsUserPoolClient(Boolean allowedOAuthFlowsUserPoolClient) {
            this.allowedOAuthFlowsUserPoolClient = allowedOAuthFlowsUserPoolClient;
            return this;
        }

        public final AnalyticsConfigurationType.Builder getAnalyticsConfiguration() {
            return analyticsConfiguration != null ? analyticsConfiguration.toBuilder() : null;
        }

        public final void setAnalyticsConfiguration(AnalyticsConfigurationType.BuilderImpl analyticsConfiguration) {
            this.analyticsConfiguration = analyticsConfiguration != null ? analyticsConfiguration.build() : null;
        }

        @Override
        public final Builder analyticsConfiguration(AnalyticsConfigurationType analyticsConfiguration) {
            this.analyticsConfiguration = analyticsConfiguration;
            return this;
        }

        public final String getPreventUserExistenceErrors() {
            return preventUserExistenceErrors;
        }

        public final void setPreventUserExistenceErrors(String preventUserExistenceErrors) {
            this.preventUserExistenceErrors = preventUserExistenceErrors;
        }

        @Override
        public final Builder preventUserExistenceErrors(String preventUserExistenceErrors) {
            this.preventUserExistenceErrors = preventUserExistenceErrors;
            return this;
        }

        @Override
        public final Builder preventUserExistenceErrors(PreventUserExistenceErrorTypes preventUserExistenceErrors) {
            this.preventUserExistenceErrors(preventUserExistenceErrors == null ? null : preventUserExistenceErrors.toString());
            return this;
        }

        public final Boolean getEnableTokenRevocation() {
            return enableTokenRevocation;
        }

        public final void setEnableTokenRevocation(Boolean enableTokenRevocation) {
            this.enableTokenRevocation = enableTokenRevocation;
        }

        @Override
        public final Builder enableTokenRevocation(Boolean enableTokenRevocation) {
            this.enableTokenRevocation = enableTokenRevocation;
            return this;
        }

        public final Boolean getEnablePropagateAdditionalUserContextData() {
            return enablePropagateAdditionalUserContextData;
        }

        public final void setEnablePropagateAdditionalUserContextData(Boolean enablePropagateAdditionalUserContextData) {
            this.enablePropagateAdditionalUserContextData = enablePropagateAdditionalUserContextData;
        }

        @Override
        public final Builder enablePropagateAdditionalUserContextData(Boolean enablePropagateAdditionalUserContextData) {
            this.enablePropagateAdditionalUserContextData = enablePropagateAdditionalUserContextData;
            return this;
        }

        public final Integer getAuthSessionValidity() {
            return authSessionValidity;
        }

        public final void setAuthSessionValidity(Integer authSessionValidity) {
            this.authSessionValidity = authSessionValidity;
        }

        @Override
        public final Builder authSessionValidity(Integer authSessionValidity) {
            this.authSessionValidity = authSessionValidity;
            return this;
        }

        public final RefreshTokenRotationType.Builder getRefreshTokenRotation() {
            return refreshTokenRotation != null ? refreshTokenRotation.toBuilder() : null;
        }

        public final void setRefreshTokenRotation(RefreshTokenRotationType.BuilderImpl refreshTokenRotation) {
            this.refreshTokenRotation = refreshTokenRotation != null ? refreshTokenRotation.build() : null;
        }

        @Override
        public final Builder refreshTokenRotation(RefreshTokenRotationType refreshTokenRotation) {
            this.refreshTokenRotation = refreshTokenRotation;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateUserPoolClientRequest build() {
            return new CreateUserPoolClientRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
