/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AttributeNameListTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AdminDeleteUserAttributesRequest
extends CognitoIdentityProviderRequest
implements ToCopyableBuilder<Builder, AdminDeleteUserAttributesRequest> {
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserPoolId").getter(AdminDeleteUserAttributesRequest.getter(AdminDeleteUserAttributesRequest::userPoolId)).setter(AdminDeleteUserAttributesRequest.setter(Builder::userPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()}).build();
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Username").getter(AdminDeleteUserAttributesRequest.getter(AdminDeleteUserAttributesRequest::username)).setter(AdminDeleteUserAttributesRequest.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()}).build();
    private static final SdkField<List<String>> USER_ATTRIBUTE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserAttributeNames").getter(AdminDeleteUserAttributesRequest.getter(AdminDeleteUserAttributesRequest::userAttributeNames)).setter(AdminDeleteUserAttributesRequest.setter(Builder::userAttributeNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserAttributeNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_ID_FIELD, USERNAME_FIELD, USER_ATTRIBUTE_NAMES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AdminDeleteUserAttributesRequest.memberNameToFieldInitializer();
    private final String userPoolId;
    private final String username;
    private final List<String> userAttributeNames;

    private AdminDeleteUserAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.userPoolId = builder.userPoolId;
        this.username = builder.username;
        this.userAttributeNames = builder.userAttributeNames;
    }

    public final String userPoolId() {
        return this.userPoolId;
    }

    public final String username() {
        return this.username;
    }

    public final boolean hasUserAttributeNames() {
        return this.userAttributeNames != null && !(this.userAttributeNames instanceof SdkAutoConstructList);
    }

    public final List<String> userAttributeNames() {
        return this.userAttributeNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserAttributeNames() ? this.userAttributeNames() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdminDeleteUserAttributesRequest)) {
            return false;
        }
        AdminDeleteUserAttributesRequest other = (AdminDeleteUserAttributesRequest)((Object)obj);
        return Objects.equals(this.userPoolId(), other.userPoolId()) && Objects.equals(this.username(), other.username()) && this.hasUserAttributeNames() == other.hasUserAttributeNames() && Objects.equals(this.userAttributeNames(), other.userAttributeNames());
    }

    public final String toString() {
        return ToString.builder((String)"AdminDeleteUserAttributesRequest").add("UserPoolId", (Object)this.userPoolId()).add("Username", (Object)(this.username() == null ? null : "*** Sensitive Data Redacted ***")).add("UserAttributeNames", this.hasUserAttributeNames() ? this.userAttributeNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserPoolId": {
                return Optional.ofNullable(clazz.cast(this.userPoolId()));
            }
            case "Username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
            case "UserAttributeNames": {
                return Optional.ofNullable(clazz.cast(this.userAttributeNames()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("UserPoolId", USER_POOL_ID_FIELD);
        map.put("Username", USERNAME_FIELD);
        map.put("UserAttributeNames", USER_ATTRIBUTE_NAMES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AdminDeleteUserAttributesRequest, T> g) {
        return obj -> g.apply((AdminDeleteUserAttributesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderRequest.BuilderImpl
    implements Builder {
        private String userPoolId;
        private String username;
        private List<String> userAttributeNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AdminDeleteUserAttributesRequest model) {
            super(model);
            this.userPoolId(model.userPoolId);
            this.username(model.username);
            this.userAttributeNames(model.userAttributeNames);
        }

        public final String getUserPoolId() {
            return this.userPoolId;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final String getUsername() {
            return this.username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final Collection<String> getUserAttributeNames() {
            if (this.userAttributeNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.userAttributeNames;
        }

        public final void setUserAttributeNames(Collection<String> userAttributeNames) {
            this.userAttributeNames = AttributeNameListTypeCopier.copy(userAttributeNames);
        }

        @Override
        public final Builder userAttributeNames(Collection<String> userAttributeNames) {
            this.userAttributeNames = AttributeNameListTypeCopier.copy(userAttributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAttributeNames(String ... userAttributeNames) {
            this.userAttributeNames(Arrays.asList(userAttributeNames));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AdminDeleteUserAttributesRequest build() {
            return new AdminDeleteUserAttributesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CognitoIdentityProviderRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AdminDeleteUserAttributesRequest> {
        public Builder userPoolId(String var1);

        public Builder username(String var1);

        public Builder userAttributeNames(Collection<String> var1);

        public Builder userAttributeNames(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

