/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The responses to the challenge that you received in the previous request. Each challenge has its own required
 * response parameters. The following examples are partial JSON request bodies that highlight challenge-response
 * parameters.
 * </p>
 * <important>
 * <p>
 * You must provide a SECRET_HASH parameter in all challenge responses to an app client that has a client secret.
 * Include a <code>DEVICE_KEY</code> for device authentication.
 * </p>
 * </important>
 * <dl>
 * <dt>SELECT_CHALLENGE</dt>
 * <dd>
 * <p>
 * <code>"ChallengeName": "SELECT_CHALLENGE", "ChallengeResponses": { "USERNAME": "[username]", "ANSWER": "[Challenge name]"}</code>
 * </p>
 * <p>
 * Available challenges are <code>PASSWORD</code>, <code>PASSWORD_SRP</code>, <code>EMAIL_OTP</code>,
 * <code>SMS_OTP</code>, and <code>WEB_AUTHN</code>.
 * </p>
 * <p>
 * Complete authentication in the <code>SELECT_CHALLENGE</code> response for <code>PASSWORD</code>,
 * <code>PASSWORD_SRP</code>, and <code>WEB_AUTHN</code>:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>"ChallengeName": "SELECT_CHALLENGE", "ChallengeResponses": { "ANSWER": "WEB_AUTHN", "USERNAME": "[username]", "CREDENTIAL": "[AuthenticationResponseJSON]"}</code>
 * </p>
 * <p>
 * See <a href="https://www.w3.org/TR/WebAuthn-3/#dictdef-authenticationresponsejson"> AuthenticationResponseJSON</a>.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>"ChallengeName": "SELECT_CHALLENGE", "ChallengeResponses": { "ANSWER": "PASSWORD", "USERNAME": "[username]", "PASSWORD": "[password]"}</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>"ChallengeName": "SELECT_CHALLENGE", "ChallengeResponses": { "ANSWER": "PASSWORD_SRP", "USERNAME": "[username]", "SRP_A": "[SRP_A]"}</code>
 * </p>
 * </li>
 * </ul>
 * <p>
 * For <code>SMS_OTP</code> and <code>EMAIL_OTP</code>, respond with the username and answer. Your user pool will send a
 * code for the user to submit in the next challenge response.
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>"ChallengeName": "SELECT_CHALLENGE", "ChallengeResponses": { "ANSWER": "SMS_OTP", "USERNAME": "[username]"}</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>"ChallengeName": "SELECT_CHALLENGE", "ChallengeResponses": { "ANSWER": "EMAIL_OTP", "USERNAME": "[username]"}</code>
 * </p>
 * </li>
 * </ul>
 * </dd>
 * <dt>WEB_AUTHN</dt>
 * <dd>
 * <p>
 * <code>"ChallengeName": "WEB_AUTHN", "ChallengeResponses": { "USERNAME": "[username]", "CREDENTIAL": "[AuthenticationResponseJSON]"}</code>
 * </p>
 * <p>
 * See <a href="https://www.w3.org/TR/WebAuthn-3/#dictdef-authenticationresponsejson"> AuthenticationResponseJSON</a>.
 * </p>
 * </dd>
 * <dt>PASSWORD</dt>
 * <dd>
 * <p>
 * <code>"ChallengeName": "PASSWORD", "ChallengeResponses": { "USERNAME": "[username]", "PASSWORD": "[password]"}</code>
 * </p>
 * </dd>
 * <dt>PASSWORD_SRP</dt>
 * <dd>
 * <p>
 * <code>"ChallengeName": "PASSWORD_SRP", "ChallengeResponses": { "USERNAME": "[username]", "SRP_A": "[SRP_A]"}</code>
 * </p>
 * </dd>
 * <dt>SMS_OTP</dt>
 * <dd>
 * <p>
 * <code>"ChallengeName": "SMS_OTP", "ChallengeResponses": {"SMS_OTP_CODE": "[code]", "USERNAME": "[username]"}</code>
 * </p>
 * </dd>
 * <dt>EMAIL_OTP</dt>
 * <dd>
 * <p>
 * <code>"ChallengeName": "EMAIL_OTP", "ChallengeResponses": {"EMAIL_OTP_CODE": "[code]", "USERNAME": "[username]"}</code>
 * </p>
 * </dd>
 * <dt>SMS_MFA</dt>
 * <dd>
 * <p>
 * <code>"ChallengeName": "SMS_MFA", "ChallengeResponses": {"SMS_MFA_CODE": "[code]", "USERNAME": "[username]"}</code>
 * </p>
 * </dd>
 * <dt>PASSWORD_VERIFIER</dt>
 * <dd>
 * <p>
 * This challenge response is part of the SRP flow. Amazon Cognito requires that your application respond to this
 * challenge within a few seconds. When the response time exceeds this period, your user pool returns a
 * <code>NotAuthorizedException</code> error.
 * </p>
 * <p>
 * <code>"ChallengeName": "PASSWORD_VERIFIER", "ChallengeResponses": {"PASSWORD_CLAIM_SIGNATURE": "[claim_signature]", "PASSWORD_CLAIM_SECRET_BLOCK": "[secret_block]", "TIMESTAMP": [timestamp], "USERNAME": "[username]"}</code>
 * </p>
 * </dd>
 * <dt>CUSTOM_CHALLENGE</dt>
 * <dd>
 * <p>
 * <code>"ChallengeName": "CUSTOM_CHALLENGE", "ChallengeResponses": {"USERNAME": "[username]", "ANSWER": "[challenge_answer]"}</code>
 * </p>
 * </dd>
 * <dt>NEW_PASSWORD_REQUIRED</dt>
 * <dd>
 * <p>
 * <code>"ChallengeName": "NEW_PASSWORD_REQUIRED", "ChallengeResponses": {"NEW_PASSWORD": "[new_password]", "USERNAME": "[username]"}</code>
 * </p>
 * <p>
 * To set any required attributes that <code>InitiateAuth</code> returned in an <code>requiredAttributes</code>
 * parameter, add <code>"userAttributes.[attribute_name]": "[attribute_value]"</code>. This parameter can also set
 * values for writable attributes that aren't required by your user pool.
 * </p>
 * <note>
 * <p>
 * In a <code>NEW_PASSWORD_REQUIRED</code> challenge response, you can't modify a required attribute that already has a
 * value. In <code>AdminRespondToAuthChallenge</code> or <code>RespondToAuthChallenge</code>, set a value for any keys
 * that Amazon Cognito returned in the <code>requiredAttributes</code> parameter, then use the
 * <code>AdminUpdateUserAttributes</code> or <code>UpdateUserAttributes</code> API operation to modify the value of any
 * additional attributes.
 * </p>
 * </note></dd>
 * <dt>SOFTWARE_TOKEN_MFA</dt>
 * <dd>
 * <p>
 * <code>"ChallengeName": "SOFTWARE_TOKEN_MFA", "ChallengeResponses": {"USERNAME": "[username]", "SOFTWARE_TOKEN_MFA_CODE": [authenticator_code]}</code>
 * </p>
 * </dd>
 * <dt>DEVICE_SRP_AUTH</dt>
 * <dd>
 * <p>
 * <code>"ChallengeName": "DEVICE_SRP_AUTH", "ChallengeResponses": {"USERNAME": "[username]", "DEVICE_KEY": "[device_key]", "SRP_A": "[srp_a]"}</code>
 * </p>
 * </dd>
 * <dt>DEVICE_PASSWORD_VERIFIER</dt>
 * <dd>
 * <p>
 * <code>"ChallengeName": "DEVICE_PASSWORD_VERIFIER", "ChallengeResponses": {"DEVICE_KEY": "[device_key]", "PASSWORD_CLAIM_SIGNATURE": "[claim_signature]", "PASSWORD_CLAIM_SECRET_BLOCK": "[secret_block]", "TIMESTAMP": [timestamp], "USERNAME": "[username]"}</code>
 * </p>
 * </dd>
 * <dt>MFA_SETUP</dt>
 * <dd>
 * <p>
 * <code>"ChallengeName": "MFA_SETUP", "ChallengeResponses": {"USERNAME": "[username]"}, "SESSION": "[Session ID from VerifySoftwareToken]"</code>
 * </p>
 * </dd>
 * <dt>SELECT_MFA_TYPE</dt>
 * <dd>
 * <p>
 * <code>"ChallengeName": "SELECT_MFA_TYPE", "ChallengeResponses": {"USERNAME": "[username]", "ANSWER": "[SMS_MFA|EMAIL_MFA|SOFTWARE_TOKEN_MFA]"}</code>
 * </p>
 * </dd>
 * </dl>
 * <p>
 * For more information about <code>SECRET_HASH</code>, see <a href=
 * "https://docs.aws.amazon.com/cognito/latest/developerguide/signing-up-users-in-your-app.html#cognito-user-pools-computing-secret-hash"
 * >Computing secret hash values</a>. For information about <code>DEVICE_KEY</code>, see <a
 * href="https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html"
 * >Working with user devices in your user pool</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChallengeResponseType implements SdkPojo, Serializable,
        ToCopyableBuilder<ChallengeResponseType.Builder, ChallengeResponseType> {
    private static final SdkField<String> CHALLENGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChallengeName").getter(getter(ChallengeResponseType::challengeNameAsString))
            .setter(setter(Builder::challengeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChallengeName").build()).build();

    private static final SdkField<String> CHALLENGE_RESPONSE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChallengeResponse").getter(getter(ChallengeResponseType::challengeResponseAsString))
            .setter(setter(Builder::challengeResponse))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChallengeResponse").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHALLENGE_NAME_FIELD,
            CHALLENGE_RESPONSE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String challengeName;

    private final String challengeResponse;

    private ChallengeResponseType(BuilderImpl builder) {
        this.challengeName = builder.challengeName;
        this.challengeResponse = builder.challengeResponse;
    }

    /**
     * <p>
     * The type of challenge that your previous authentication request returned in the parameter
     * <code>ChallengeName</code>, for example <code>SMS_MFA</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #challengeName}
     * will return {@link ChallengeName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #challengeNameAsString}.
     * </p>
     * 
     * @return The type of challenge that your previous authentication request returned in the parameter
     *         <code>ChallengeName</code>, for example <code>SMS_MFA</code>.
     * @see ChallengeName
     */
    public final ChallengeName challengeName() {
        return ChallengeName.fromValue(challengeName);
    }

    /**
     * <p>
     * The type of challenge that your previous authentication request returned in the parameter
     * <code>ChallengeName</code>, for example <code>SMS_MFA</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #challengeName}
     * will return {@link ChallengeName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #challengeNameAsString}.
     * </p>
     * 
     * @return The type of challenge that your previous authentication request returned in the parameter
     *         <code>ChallengeName</code>, for example <code>SMS_MFA</code>.
     * @see ChallengeName
     */
    public final String challengeNameAsString() {
        return challengeName;
    }

    /**
     * <p>
     * The set of key-value pairs that provides a response to the requested challenge.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #challengeResponse}
     * will return {@link ChallengeResponse#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #challengeResponseAsString}.
     * </p>
     * 
     * @return The set of key-value pairs that provides a response to the requested challenge.
     * @see ChallengeResponse
     */
    public final ChallengeResponse challengeResponse() {
        return ChallengeResponse.fromValue(challengeResponse);
    }

    /**
     * <p>
     * The set of key-value pairs that provides a response to the requested challenge.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #challengeResponse}
     * will return {@link ChallengeResponse#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #challengeResponseAsString}.
     * </p>
     * 
     * @return The set of key-value pairs that provides a response to the requested challenge.
     * @see ChallengeResponse
     */
    public final String challengeResponseAsString() {
        return challengeResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(challengeNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(challengeResponseAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChallengeResponseType)) {
            return false;
        }
        ChallengeResponseType other = (ChallengeResponseType) obj;
        return Objects.equals(challengeNameAsString(), other.challengeNameAsString())
                && Objects.equals(challengeResponseAsString(), other.challengeResponseAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChallengeResponseType").add("ChallengeName", challengeNameAsString())
                .add("ChallengeResponse", challengeResponseAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChallengeName":
            return Optional.ofNullable(clazz.cast(challengeNameAsString()));
        case "ChallengeResponse":
            return Optional.ofNullable(clazz.cast(challengeResponseAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ChallengeName", CHALLENGE_NAME_FIELD);
        map.put("ChallengeResponse", CHALLENGE_RESPONSE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChallengeResponseType, T> g) {
        return obj -> g.apply((ChallengeResponseType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChallengeResponseType> {
        /**
         * <p>
         * The type of challenge that your previous authentication request returned in the parameter
         * <code>ChallengeName</code>, for example <code>SMS_MFA</code>.
         * </p>
         * 
         * @param challengeName
         *        The type of challenge that your previous authentication request returned in the parameter
         *        <code>ChallengeName</code>, for example <code>SMS_MFA</code>.
         * @see ChallengeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChallengeName
         */
        Builder challengeName(String challengeName);

        /**
         * <p>
         * The type of challenge that your previous authentication request returned in the parameter
         * <code>ChallengeName</code>, for example <code>SMS_MFA</code>.
         * </p>
         * 
         * @param challengeName
         *        The type of challenge that your previous authentication request returned in the parameter
         *        <code>ChallengeName</code>, for example <code>SMS_MFA</code>.
         * @see ChallengeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChallengeName
         */
        Builder challengeName(ChallengeName challengeName);

        /**
         * <p>
         * The set of key-value pairs that provides a response to the requested challenge.
         * </p>
         * 
         * @param challengeResponse
         *        The set of key-value pairs that provides a response to the requested challenge.
         * @see ChallengeResponse
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChallengeResponse
         */
        Builder challengeResponse(String challengeResponse);

        /**
         * <p>
         * The set of key-value pairs that provides a response to the requested challenge.
         * </p>
         * 
         * @param challengeResponse
         *        The set of key-value pairs that provides a response to the requested challenge.
         * @see ChallengeResponse
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChallengeResponse
         */
        Builder challengeResponse(ChallengeResponse challengeResponse);
    }

    static final class BuilderImpl implements Builder {
        private String challengeName;

        private String challengeResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(ChallengeResponseType model) {
            challengeName(model.challengeName);
            challengeResponse(model.challengeResponse);
        }

        public final String getChallengeName() {
            return challengeName;
        }

        public final void setChallengeName(String challengeName) {
            this.challengeName = challengeName;
        }

        @Override
        public final Builder challengeName(String challengeName) {
            this.challengeName = challengeName;
            return this;
        }

        @Override
        public final Builder challengeName(ChallengeName challengeName) {
            this.challengeName(challengeName == null ? null : challengeName.toString());
            return this;
        }

        public final String getChallengeResponse() {
            return challengeResponse;
        }

        public final void setChallengeResponse(String challengeResponse) {
            this.challengeResponse = challengeResponse;
        }

        @Override
        public final Builder challengeResponse(String challengeResponse) {
            this.challengeResponse = challengeResponse;
            return this;
        }

        @Override
        public final Builder challengeResponse(ChallengeResponse challengeResponse) {
            this.challengeResponse(challengeResponse == null ? null : challengeResponse.toString());
            return this;
        }

        @Override
        public ChallengeResponseType build() {
            return new ChallengeResponseType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
