/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the response from the server to the request to create the user import job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateUserImportJobResponse extends CognitoIdentityProviderResponse implements
        ToCopyableBuilder<CreateUserImportJobResponse.Builder, CreateUserImportJobResponse> {
    private static final SdkField<UserImportJobType> USER_IMPORT_JOB_FIELD = SdkField
            .<UserImportJobType> builder(MarshallingType.SDK_POJO).memberName("UserImportJob")
            .getter(getter(CreateUserImportJobResponse::userImportJob)).setter(setter(Builder::userImportJob))
            .constructor(UserImportJobType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserImportJob").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_IMPORT_JOB_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final UserImportJobType userImportJob;

    private CreateUserImportJobResponse(BuilderImpl builder) {
        super(builder);
        this.userImportJob = builder.userImportJob;
    }

    /**
     * <p>
     * The details of the user import job. Includes logging destination, status, and the Amazon S3 pre-signed URL for
     * CSV upload.
     * </p>
     * 
     * @return The details of the user import job. Includes logging destination, status, and the Amazon S3 pre-signed
     *         URL for CSV upload.
     */
    public final UserImportJobType userImportJob() {
        return userImportJob;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(userImportJob());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUserImportJobResponse)) {
            return false;
        }
        CreateUserImportJobResponse other = (CreateUserImportJobResponse) obj;
        return Objects.equals(userImportJob(), other.userImportJob());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateUserImportJobResponse").add("UserImportJob", userImportJob()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserImportJob":
            return Optional.ofNullable(clazz.cast(userImportJob()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("UserImportJob", USER_IMPORT_JOB_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateUserImportJobResponse, T> g) {
        return obj -> g.apply((CreateUserImportJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CognitoIdentityProviderResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateUserImportJobResponse> {
        /**
         * <p>
         * The details of the user import job. Includes logging destination, status, and the Amazon S3 pre-signed URL
         * for CSV upload.
         * </p>
         * 
         * @param userImportJob
         *        The details of the user import job. Includes logging destination, status, and the Amazon S3 pre-signed
         *        URL for CSV upload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userImportJob(UserImportJobType userImportJob);

        /**
         * <p>
         * The details of the user import job. Includes logging destination, status, and the Amazon S3 pre-signed URL
         * for CSV upload.
         * </p>
         * This is a convenience method that creates an instance of the {@link UserImportJobType.Builder} avoiding the
         * need to create one manually via {@link UserImportJobType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserImportJobType.Builder#build()} is called immediately and its
         * result is passed to {@link #userImportJob(UserImportJobType)}.
         * 
         * @param userImportJob
         *        a consumer that will call methods on {@link UserImportJobType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userImportJob(UserImportJobType)
         */
        default Builder userImportJob(Consumer<UserImportJobType.Builder> userImportJob) {
            return userImportJob(UserImportJobType.builder().applyMutation(userImportJob).build());
        }
    }

    static final class BuilderImpl extends CognitoIdentityProviderResponse.BuilderImpl implements Builder {
        private UserImportJobType userImportJob;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUserImportJobResponse model) {
            super(model);
            userImportJob(model.userImportJob);
        }

        public final UserImportJobType.Builder getUserImportJob() {
            return userImportJob != null ? userImportJob.toBuilder() : null;
        }

        public final void setUserImportJob(UserImportJobType.BuilderImpl userImportJob) {
            this.userImportJob = userImportJob != null ? userImportJob.build() : null;
        }

        @Override
        public final Builder userImportJob(UserImportJobType userImportJob) {
            this.userImportJob = userImportJob;
            return this;
        }

        @Override
        public CreateUserImportJobResponse build() {
            return new CreateUserImportJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
