/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTermsResponse extends CognitoIdentityProviderResponse implements
        ToCopyableBuilder<ListTermsResponse.Builder, ListTermsResponse> {
    private static final SdkField<List<TermsDescriptionType>> TERMS_FIELD = SdkField
            .<List<TermsDescriptionType>> builder(MarshallingType.LIST)
            .memberName("Terms")
            .getter(getter(ListTermsResponse::terms))
            .setter(setter(Builder::terms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Terms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TermsDescriptionType> builder(MarshallingType.SDK_POJO)
                                            .constructor(TermsDescriptionType::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListTermsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(TERMS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<TermsDescriptionType> terms;

    private final String nextToken;

    private ListTermsResponse(BuilderImpl builder) {
        super(builder);
        this.terms = builder.terms;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Terms property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTerms() {
        return terms != null && !(terms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A summary of the requested terms documents. Includes unique identifiers for later changes to the terms documents.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTerms} method.
     * </p>
     * 
     * @return A summary of the requested terms documents. Includes unique identifiers for later changes to the terms
     *         documents.
     */
    public final List<TermsDescriptionType> terms() {
        return terms;
    }

    /**
     * <p>
     * This API operation returns a limited number of results. The pagination token is an identifier that you can
     * present in an additional API request with the same parameters. When you include the pagination token, Amazon
     * Cognito returns the next set of items after the current list. Subsequent requests return a new pagination token.
     * By use of this token, you can paginate through the full list of items.
     * </p>
     * 
     * @return This API operation returns a limited number of results. The pagination token is an identifier that you
     *         can present in an additional API request with the same parameters. When you include the pagination token,
     *         Amazon Cognito returns the next set of items after the current list. Subsequent requests return a new
     *         pagination token. By use of this token, you can paginate through the full list of items.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTerms() ? terms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTermsResponse)) {
            return false;
        }
        ListTermsResponse other = (ListTermsResponse) obj;
        return hasTerms() == other.hasTerms() && Objects.equals(terms(), other.terms())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTermsResponse").add("Terms", hasTerms() ? terms() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Terms":
            return Optional.ofNullable(clazz.cast(terms()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Terms", TERMS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTermsResponse, T> g) {
        return obj -> g.apply((ListTermsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CognitoIdentityProviderResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListTermsResponse> {
        /**
         * <p>
         * A summary of the requested terms documents. Includes unique identifiers for later changes to the terms
         * documents.
         * </p>
         * 
         * @param terms
         *        A summary of the requested terms documents. Includes unique identifiers for later changes to the terms
         *        documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terms(Collection<TermsDescriptionType> terms);

        /**
         * <p>
         * A summary of the requested terms documents. Includes unique identifiers for later changes to the terms
         * documents.
         * </p>
         * 
         * @param terms
         *        A summary of the requested terms documents. Includes unique identifiers for later changes to the terms
         *        documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terms(TermsDescriptionType... terms);

        /**
         * <p>
         * A summary of the requested terms documents. Includes unique identifiers for later changes to the terms
         * documents.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cognitoidentityprovider.model.TermsDescriptionType.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.cognitoidentityprovider.model.TermsDescriptionType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cognitoidentityprovider.model.TermsDescriptionType.Builder#build()} is
         * called immediately and its result is passed to {@link #terms(List<TermsDescriptionType>)}.
         * 
         * @param terms
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.TermsDescriptionType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #terms(java.util.Collection<TermsDescriptionType>)
         */
        Builder terms(Consumer<TermsDescriptionType.Builder>... terms);

        /**
         * <p>
         * This API operation returns a limited number of results. The pagination token is an identifier that you can
         * present in an additional API request with the same parameters. When you include the pagination token, Amazon
         * Cognito returns the next set of items after the current list. Subsequent requests return a new pagination
         * token. By use of this token, you can paginate through the full list of items.
         * </p>
         * 
         * @param nextToken
         *        This API operation returns a limited number of results. The pagination token is an identifier that you
         *        can present in an additional API request with the same parameters. When you include the pagination
         *        token, Amazon Cognito returns the next set of items after the current list. Subsequent requests return
         *        a new pagination token. By use of this token, you can paginate through the full list of items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CognitoIdentityProviderResponse.BuilderImpl implements Builder {
        private List<TermsDescriptionType> terms = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTermsResponse model) {
            super(model);
            terms(model.terms);
            nextToken(model.nextToken);
        }

        public final List<TermsDescriptionType.Builder> getTerms() {
            List<TermsDescriptionType.Builder> result = TermsDescriptionListTypeCopier.copyToBuilder(this.terms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTerms(Collection<TermsDescriptionType.BuilderImpl> terms) {
            this.terms = TermsDescriptionListTypeCopier.copyFromBuilder(terms);
        }

        @Override
        public final Builder terms(Collection<TermsDescriptionType> terms) {
            this.terms = TermsDescriptionListTypeCopier.copy(terms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder terms(TermsDescriptionType... terms) {
            terms(Arrays.asList(terms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder terms(Consumer<TermsDescriptionType.Builder>... terms) {
            terms(Stream.of(terms).map(c -> TermsDescriptionType.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTermsResponse build() {
            return new ListTermsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
