/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of a user pool identity provider (IdP), including name and type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProviderDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<ProviderDescription.Builder, ProviderDescription> {
    private static final SdkField<String> PROVIDER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProviderName").getter(getter(ProviderDescription::providerName)).setter(setter(Builder::providerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProviderName").build()).build();

    private static final SdkField<String> PROVIDER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProviderType").getter(getter(ProviderDescription::providerTypeAsString))
            .setter(setter(Builder::providerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProviderType").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedDate").getter(getter(ProviderDescription::lastModifiedDate))
            .setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationDate").getter(getter(ProviderDescription::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVIDER_NAME_FIELD,
            PROVIDER_TYPE_FIELD, LAST_MODIFIED_DATE_FIELD, CREATION_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String providerName;

    private final String providerType;

    private final Instant lastModifiedDate;

    private final Instant creationDate;

    private ProviderDescription(BuilderImpl builder) {
        this.providerName = builder.providerName;
        this.providerType = builder.providerType;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.creationDate = builder.creationDate;
    }

    /**
     * <p>
     * The name of the IdP, for example <code>MySAMLProvider</code>.
     * </p>
     * 
     * @return The name of the IdP, for example <code>MySAMLProvider</code>.
     */
    public final String providerName() {
        return providerName;
    }

    /**
     * <p>
     * The type of the provider, for example <code>SAML</code>. Amazon Cognito supports SAML 2.0, OIDC, and social IdPs.
     * User pools list supported social IdPs by name in this response parameter: Facebook, Google, Login with Amazon,
     * and Sign in with Apple.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #providerType} will
     * return {@link IdentityProviderTypeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #providerTypeAsString}.
     * </p>
     * 
     * @return The type of the provider, for example <code>SAML</code>. Amazon Cognito supports SAML 2.0, OIDC, and
     *         social IdPs. User pools list supported social IdPs by name in this response parameter: Facebook, Google,
     *         Login with Amazon, and Sign in with Apple.
     * @see IdentityProviderTypeType
     */
    public final IdentityProviderTypeType providerType() {
        return IdentityProviderTypeType.fromValue(providerType);
    }

    /**
     * <p>
     * The type of the provider, for example <code>SAML</code>. Amazon Cognito supports SAML 2.0, OIDC, and social IdPs.
     * User pools list supported social IdPs by name in this response parameter: Facebook, Google, Login with Amazon,
     * and Sign in with Apple.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #providerType} will
     * return {@link IdentityProviderTypeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #providerTypeAsString}.
     * </p>
     * 
     * @return The type of the provider, for example <code>SAML</code>. Amazon Cognito supports SAML 2.0, OIDC, and
     *         social IdPs. User pools list supported social IdPs by name in this response parameter: Facebook, Google,
     *         Login with Amazon, and Sign in with Apple.
     * @see IdentityProviderTypeType
     */
    public final String providerTypeAsString() {
        return providerType;
    }

    /**
     * <p>
     * The date and time when the item was modified. Amazon Cognito returns this timestamp in UNIX epoch time format.
     * Your SDK might render the output in a human-readable format like ISO 8601 or a Java <code>Date</code> object.
     * </p>
     * 
     * @return The date and time when the item was modified. Amazon Cognito returns this timestamp in UNIX epoch time
     *         format. Your SDK might render the output in a human-readable format like ISO 8601 or a Java
     *         <code>Date</code> object.
     */
    public final Instant lastModifiedDate() {
        return lastModifiedDate;
    }

    /**
     * <p>
     * The date and time when the item was created. Amazon Cognito returns this timestamp in UNIX epoch time format.
     * Your SDK might render the output in a human-readable format like ISO 8601 or a Java <code>Date</code> object.
     * </p>
     * 
     * @return The date and time when the item was created. Amazon Cognito returns this timestamp in UNIX epoch time
     *         format. Your SDK might render the output in a human-readable format like ISO 8601 or a Java
     *         <code>Date</code> object.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(providerName());
        hashCode = 31 * hashCode + Objects.hashCode(providerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProviderDescription)) {
            return false;
        }
        ProviderDescription other = (ProviderDescription) obj;
        return Objects.equals(providerName(), other.providerName())
                && Objects.equals(providerTypeAsString(), other.providerTypeAsString())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate())
                && Objects.equals(creationDate(), other.creationDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProviderDescription").add("ProviderName", providerName())
                .add("ProviderType", providerTypeAsString()).add("LastModifiedDate", lastModifiedDate())
                .add("CreationDate", creationDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProviderName":
            return Optional.ofNullable(clazz.cast(providerName()));
        case "ProviderType":
            return Optional.ofNullable(clazz.cast(providerTypeAsString()));
        case "LastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProviderName", PROVIDER_NAME_FIELD);
        map.put("ProviderType", PROVIDER_TYPE_FIELD);
        map.put("LastModifiedDate", LAST_MODIFIED_DATE_FIELD);
        map.put("CreationDate", CREATION_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProviderDescription, T> g) {
        return obj -> g.apply((ProviderDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProviderDescription> {
        /**
         * <p>
         * The name of the IdP, for example <code>MySAMLProvider</code>.
         * </p>
         * 
         * @param providerName
         *        The name of the IdP, for example <code>MySAMLProvider</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerName(String providerName);

        /**
         * <p>
         * The type of the provider, for example <code>SAML</code>. Amazon Cognito supports SAML 2.0, OIDC, and social
         * IdPs. User pools list supported social IdPs by name in this response parameter: Facebook, Google, Login with
         * Amazon, and Sign in with Apple.
         * </p>
         * 
         * @param providerType
         *        The type of the provider, for example <code>SAML</code>. Amazon Cognito supports SAML 2.0, OIDC, and
         *        social IdPs. User pools list supported social IdPs by name in this response parameter: Facebook,
         *        Google, Login with Amazon, and Sign in with Apple.
         * @see IdentityProviderTypeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityProviderTypeType
         */
        Builder providerType(String providerType);

        /**
         * <p>
         * The type of the provider, for example <code>SAML</code>. Amazon Cognito supports SAML 2.0, OIDC, and social
         * IdPs. User pools list supported social IdPs by name in this response parameter: Facebook, Google, Login with
         * Amazon, and Sign in with Apple.
         * </p>
         * 
         * @param providerType
         *        The type of the provider, for example <code>SAML</code>. Amazon Cognito supports SAML 2.0, OIDC, and
         *        social IdPs. User pools list supported social IdPs by name in this response parameter: Facebook,
         *        Google, Login with Amazon, and Sign in with Apple.
         * @see IdentityProviderTypeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityProviderTypeType
         */
        Builder providerType(IdentityProviderTypeType providerType);

        /**
         * <p>
         * The date and time when the item was modified. Amazon Cognito returns this timestamp in UNIX epoch time
         * format. Your SDK might render the output in a human-readable format like ISO 8601 or a Java <code>Date</code>
         * object.
         * </p>
         * 
         * @param lastModifiedDate
         *        The date and time when the item was modified. Amazon Cognito returns this timestamp in UNIX epoch time
         *        format. Your SDK might render the output in a human-readable format like ISO 8601 or a Java
         *        <code>Date</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(Instant lastModifiedDate);

        /**
         * <p>
         * The date and time when the item was created. Amazon Cognito returns this timestamp in UNIX epoch time format.
         * Your SDK might render the output in a human-readable format like ISO 8601 or a Java <code>Date</code> object.
         * </p>
         * 
         * @param creationDate
         *        The date and time when the item was created. Amazon Cognito returns this timestamp in UNIX epoch time
         *        format. Your SDK might render the output in a human-readable format like ISO 8601 or a Java
         *        <code>Date</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);
    }

    static final class BuilderImpl implements Builder {
        private String providerName;

        private String providerType;

        private Instant lastModifiedDate;

        private Instant creationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ProviderDescription model) {
            providerName(model.providerName);
            providerType(model.providerType);
            lastModifiedDate(model.lastModifiedDate);
            creationDate(model.creationDate);
        }

        public final String getProviderName() {
            return providerName;
        }

        public final void setProviderName(String providerName) {
            this.providerName = providerName;
        }

        @Override
        public final Builder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        public final String getProviderType() {
            return providerType;
        }

        public final void setProviderType(String providerType) {
            this.providerType = providerType;
        }

        @Override
        public final Builder providerType(String providerType) {
            this.providerType = providerType;
            return this;
        }

        @Override
        public final Builder providerType(IdentityProviderTypeType providerType) {
            this.providerType(providerType == null ? null : providerType.toString());
            return this;
        }

        public final Instant getLastModifiedDate() {
            return lastModifiedDate;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        @Override
        public ProviderDescription build() {
            return new ProviderDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
