/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTermsRequest extends CognitoIdentityProviderRequest implements
        ToCopyableBuilder<DescribeTermsRequest.Builder, DescribeTermsRequest> {
    private static final SdkField<String> TERMS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TermsId").getter(getter(DescribeTermsRequest::termsId)).setter(setter(Builder::termsId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TermsId").build()).build();

    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserPoolId").getter(getter(DescribeTermsRequest::userPoolId)).setter(setter(Builder::userPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TERMS_ID_FIELD,
            USER_POOL_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String termsId;

    private final String userPoolId;

    private DescribeTermsRequest(BuilderImpl builder) {
        super(builder);
        this.termsId = builder.termsId;
        this.userPoolId = builder.userPoolId;
    }

    /**
     * <p>
     * The ID of the terms documents that you want to describe.
     * </p>
     * 
     * @return The ID of the terms documents that you want to describe.
     */
    public final String termsId() {
        return termsId;
    }

    /**
     * <p>
     * The ID of the user pool that contains the terms documents that you want to describe.
     * </p>
     * 
     * @return The ID of the user pool that contains the terms documents that you want to describe.
     */
    public final String userPoolId() {
        return userPoolId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(termsId());
        hashCode = 31 * hashCode + Objects.hashCode(userPoolId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTermsRequest)) {
            return false;
        }
        DescribeTermsRequest other = (DescribeTermsRequest) obj;
        return Objects.equals(termsId(), other.termsId()) && Objects.equals(userPoolId(), other.userPoolId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeTermsRequest").add("TermsId", termsId()).add("UserPoolId", userPoolId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TermsId":
            return Optional.ofNullable(clazz.cast(termsId()));
        case "UserPoolId":
            return Optional.ofNullable(clazz.cast(userPoolId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TermsId", TERMS_ID_FIELD);
        map.put("UserPoolId", USER_POOL_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeTermsRequest, T> g) {
        return obj -> g.apply((DescribeTermsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CognitoIdentityProviderRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeTermsRequest> {
        /**
         * <p>
         * The ID of the terms documents that you want to describe.
         * </p>
         * 
         * @param termsId
         *        The ID of the terms documents that you want to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder termsId(String termsId);

        /**
         * <p>
         * The ID of the user pool that contains the terms documents that you want to describe.
         * </p>
         * 
         * @param userPoolId
         *        The ID of the user pool that contains the terms documents that you want to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolId(String userPoolId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CognitoIdentityProviderRequest.BuilderImpl implements Builder {
        private String termsId;

        private String userPoolId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTermsRequest model) {
            super(model);
            termsId(model.termsId);
            userPoolId(model.userPoolId);
        }

        public final String getTermsId() {
            return termsId;
        }

        public final void setTermsId(String termsId) {
            this.termsId = termsId;
        }

        @Override
        public final Builder termsId(String termsId) {
            this.termsId = termsId;
            return this;
        }

        public final String getUserPoolId() {
            return userPoolId;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeTermsRequest build() {
            return new DescribeTermsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
