/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DirectoryStage {
    REQUESTED("Requested"),
    CREATING("Creating"),
    CREATED("Created"),
    ACTIVE("Active"),
    INOPERABLE("Inoperable"),
    IMPAIRED("Impaired"),
    RESTORING("Restoring"),
    RESTORE_FAILED("RestoreFailed"),
    DELETING("Deleting"),
    DELETED("Deleted"),
    FAILED("Failed"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DirectoryStage(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DirectoryStage fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DirectoryStage.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DirectoryStage> knownValues() {
        return Stream.of(DirectoryStage.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

