/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum BlueprintType {
    OS("os"),
    APP("app"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private BlueprintType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BlueprintType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(BlueprintType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BlueprintType> knownValues() {
        return Stream.of(BlueprintType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

