/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightAsyncClient;
import software.amazon.awssdk.services.quicksight.model.ListDataSourcesRequest;
import software.amazon.awssdk.services.quicksight.model.ListDataSourcesResponse;

public class ListDataSourcesPublisher
implements SdkPublisher<ListDataSourcesResponse> {
    private final QuickSightAsyncClient client;
    private final ListDataSourcesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDataSourcesPublisher(QuickSightAsyncClient client, ListDataSourcesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDataSourcesPublisher(QuickSightAsyncClient client, ListDataSourcesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDataSourcesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDataSourcesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListDataSourcesResponseFetcher
    implements AsyncPageFetcher<ListDataSourcesResponse> {
        private ListDataSourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListDataSourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDataSourcesResponse> nextPage(ListDataSourcesResponse previousPage) {
            if (previousPage == null) {
                return ListDataSourcesPublisher.this.client.listDataSources(ListDataSourcesPublisher.this.firstRequest);
            }
            return ListDataSourcesPublisher.this.client.listDataSources((ListDataSourcesRequest)((Object)ListDataSourcesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

