/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DocumentHashType {
    SHA256("Sha256"),
    SHA1("Sha1"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DocumentHashType> VALUE_MAP;
    private final String value;

    private DocumentHashType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DocumentHashType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DocumentHashType> knownValues() {
        EnumSet<DocumentHashType> knownValues = EnumSet.allOf(DocumentHashType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DocumentHashType.class, DocumentHashType::toString);
    }
}

