/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sts.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDelegatedAccessTokenRequest extends StsRequest implements
        ToCopyableBuilder<GetDelegatedAccessTokenRequest.Builder, GetDelegatedAccessTokenRequest> {
    private static final SdkField<String> TRADE_IN_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TradeInToken").getter(getter(GetDelegatedAccessTokenRequest::tradeInToken))
            .setter(setter(Builder::tradeInToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TradeInToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRADE_IN_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String tradeInToken;

    private GetDelegatedAccessTokenRequest(BuilderImpl builder) {
        super(builder);
        this.tradeInToken = builder.tradeInToken;
    }

    /**
     * <p>
     * The token to exchange for temporary Amazon Web Services credentials. This token must be valid and unexpired at
     * the time of the request.
     * </p>
     * 
     * @return The token to exchange for temporary Amazon Web Services credentials. This token must be valid and
     *         unexpired at the time of the request.
     */
    public final String tradeInToken() {
        return tradeInToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(tradeInToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDelegatedAccessTokenRequest)) {
            return false;
        }
        GetDelegatedAccessTokenRequest other = (GetDelegatedAccessTokenRequest) obj;
        return Objects.equals(tradeInToken(), other.tradeInToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDelegatedAccessTokenRequest")
                .add("TradeInToken", tradeInToken() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TradeInToken":
            return Optional.ofNullable(clazz.cast(tradeInToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TradeInToken", TRADE_IN_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDelegatedAccessTokenRequest, T> g) {
        return obj -> g.apply((GetDelegatedAccessTokenRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends StsRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetDelegatedAccessTokenRequest> {
        /**
         * <p>
         * The token to exchange for temporary Amazon Web Services credentials. This token must be valid and unexpired
         * at the time of the request.
         * </p>
         * 
         * @param tradeInToken
         *        The token to exchange for temporary Amazon Web Services credentials. This token must be valid and
         *        unexpired at the time of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tradeInToken(String tradeInToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends StsRequest.BuilderImpl implements Builder {
        private String tradeInToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDelegatedAccessTokenRequest model) {
            super(model);
            tradeInToken(model.tradeInToken);
        }

        public final String getTradeInToken() {
            return tradeInToken;
        }

        public final void setTradeInToken(String tradeInToken) {
            this.tradeInToken = tradeInToken;
        }

        @Override
        public final Builder tradeInToken(String tradeInToken) {
            this.tradeInToken = tradeInToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDelegatedAccessTokenRequest build() {
            return new GetDelegatedAccessTokenRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
