/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum UserRole {
    USER("USER"),
    RESOURCE("RESOURCE"),
    SYSTEM_USER("SYSTEM_USER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private UserRole(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static UserRole fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(UserRole.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<UserRole> knownValues() {
        return Stream.of(UserRole.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

