/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.agent;

import com.sshtools.j2ssh.agent.SshAgentForwardingNotice;
import com.sshtools.j2ssh.connection.InvalidChannelException;
import com.sshtools.j2ssh.connection.SocketChannel;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import java.io.IOException;
import java.net.InetAddress;

public class AgentSocketChannel
extends SocketChannel {
    public static final String AGENT_FORWARDING_CHANNEL = "auth-agent";
    private boolean isForwarding;

    public AgentSocketChannel(boolean bl) {
        this.isForwarding = bl;
    }

    public String getChannelType() {
        return AGENT_FORWARDING_CHANNEL;
    }

    protected void onChannelRequest(String string, boolean bl, byte[] byArray) throws IOException {
        if (bl) {
            this.connection.sendChannelRequestFailure(this);
        }
    }

    protected int getMaximumPacketSize() {
        return 32678;
    }

    public byte[] getChannelOpenData() {
        return null;
    }

    protected int getMinimumWindowSpace() {
        return 1024;
    }

    protected void onChannelOpen() throws InvalidChannelException {
        try {
            if (this.isForwarding) {
                SshAgentForwardingNotice sshAgentForwardingNotice = new SshAgentForwardingNotice(InetAddress.getLocalHost().getHostName(), InetAddress.getLocalHost().getHostAddress(), this.socket.getPort());
                ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
                byteArrayWriter.writeBinaryString(sshAgentForwardingNotice.toByteArray());
                this.sendChannelData(byteArrayWriter.toByteArray());
            }
            super.onChannelOpen();
        }
        catch (IOException iOException) {
            throw new InvalidChannelException(iOException.getMessage());
        }
    }

    protected int getMaximumWindowSpace() {
        return 32768;
    }

    public byte[] getChannelConfirmationData() {
        return null;
    }
}

