/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.daemon.scp;

import com.sshtools.daemon.platform.InvalidHandleException;
import com.sshtools.daemon.platform.NativeFileSystemProvider;
import com.sshtools.daemon.platform.NativeProcessProvider;
import com.sshtools.daemon.platform.PermissionDeniedException;
import com.sshtools.daemon.util.StringPattern;
import com.sshtools.daemon.util.StringUtil;
import com.sshtools.j2ssh.SshThread;
import com.sshtools.j2ssh.io.UnsignedInteger32;
import com.sshtools.j2ssh.io.UnsignedInteger64;
import com.sshtools.j2ssh.sftp.FileAttributes;
import com.sshtools.j2ssh.sftp.SftpFile;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScpServer
extends NativeProcessProvider
implements Runnable {
    private static Log log = LogFactory.getLog((Class)(class$com$sshtools$daemon$scp$ScpServer == null ? (class$com$sshtools$daemon$scp$ScpServer = ScpServer.class$("com.sshtools.daemon.scp.ScpServer")) : class$com$sshtools$daemon$scp$ScpServer));
    private static int BUFFER_SIZE = 16384;
    private InputStream in;
    private InputStream err;
    private OutputStream out;
    private String destination;
    private PipedOutputStream pipeIn;
    private PipedOutputStream pipeErr;
    private PipedInputStream pipeOut;
    private SshThread scpServerThread;
    private int verbosity = 0;
    private int exitCode;
    private boolean directory;
    private boolean recursive;
    private boolean from;
    private boolean to;
    private NativeFileSystemProvider nfs;
    private byte[] buffer = new byte[BUFFER_SIZE];
    private String currentDirectory;
    private boolean preserveAttributes;
    static /* synthetic */ Class class$com$sshtools$daemon$scp$ScpServer;

    public ScpServer() {
        this.nfs = NativeFileSystemProvider.getInstance();
    }

    public boolean allocatePseudoTerminal(String string, int n, int n2, int n3, int n4, String string2) {
        return false;
    }

    public boolean createProcess(String string, Map map) throws IOException {
        log.info((Object)"Creating ScpServer");
        if (this.nfs == null) {
            throw new IOException("NativeFileSystem was not instantiated. Please check logs");
        }
        this.scp(string.substring(4));
        return true;
    }

    public String getDefaultTerminalProvider() {
        return null;
    }

    public InputStream getInputStream() throws IOException {
        return this.in;
    }

    public InputStream getStderrInputStream() {
        return this.err;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.out;
    }

    public void kill() {
        log.info((Object)"Killing ScpServer");
        try {
            if (this.pipeIn != null) {
                this.pipeIn.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.pipeOut != null) {
                this.pipeOut.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.pipeErr != null) {
                this.pipeErr.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void start() throws IOException {
        log.debug((Object)"Starting ScpServer thread");
        this.scpServerThread = SshThread.getCurrentThread().cloneThread((Runnable)this, "ScpServer");
        this.scpServerThread.start();
    }

    public boolean stillActive() {
        return false;
    }

    public boolean supportsPseudoTerminal(String string) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitForExitCode() {
        try {
            ScpServer scpServer = this;
            synchronized (scpServer) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        log.debug((Object)("Returning exit code of " + this.exitCode));
        return this.exitCode;
    }

    private void scp(String string) throws IOException {
        log.debug((Object)("Parsing ScpServer options " + string));
        String[] stringArray = StringUtil.current().allParts(string, " ");
        this.destination = null;
        this.directory = false;
        this.from = false;
        this.to = false;
        this.recursive = false;
        this.verbosity = 0;
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].startsWith("-")) {
                String string2 = stringArray[i].substring(1);
                block9: for (int j = 0; j < string2.length(); ++j) {
                    char c = string2.charAt(j);
                    switch (c) {
                        case 't': {
                            this.to = true;
                            continue block9;
                        }
                        case 'd': {
                            this.directory = true;
                            continue block9;
                        }
                        case 'f': {
                            this.from = true;
                            continue block9;
                        }
                        case 'r': {
                            this.recursive = true;
                            continue block9;
                        }
                        case 'v': {
                            ++this.verbosity;
                            continue block9;
                        }
                        case 'p': {
                            this.preserveAttributes = true;
                            continue block9;
                        }
                        default: {
                            log.warn((Object)"Unsupported argument, allowing to continue.");
                        }
                    }
                }
                continue;
            }
            if (this.destination == null) {
                this.destination = stringArray[i];
                continue;
            }
            throw new IOException("More than one destination supplied " + stringArray[i]);
        }
        if (!this.to && !this.from) {
            throw new IOException("Must supply either -t or -f.");
        }
        if (this.destination == null) {
            throw new IOException("Destination not supplied.");
        }
        log.debug((Object)("Destination is " + this.destination));
        log.debug((Object)("Recursive is " + this.recursive));
        log.debug((Object)("Directory is " + this.directory));
        log.debug((Object)("Verbosity is " + this.verbosity));
        log.debug((Object)("From is " + this.from));
        log.debug((Object)("To is " + this.to));
        log.debug((Object)("Preserve Attributes " + this.preserveAttributes));
        log.debug((Object)"Creating pipes");
        this.pipeIn = new PipedOutputStream();
        this.pipeErr = new PipedOutputStream();
        this.pipeOut = new PipedInputStream();
        this.in = new PipedInputStream(this.pipeIn);
        this.err = new PipedInputStream(this.pipeErr);
        this.out = new PipedOutputStream(this.pipeOut);
    }

    private void writeOk() throws IOException {
        log.debug((Object)"Sending client ok command");
        this.pipeIn.write(0);
        this.pipeIn.flush();
    }

    private void writeCommand(String string) throws IOException {
        log.debug((Object)("Sending command '" + string + "'"));
        this.pipeIn.write(string.getBytes());
        if (!string.endsWith("\n")) {
            this.pipeIn.write("\n".getBytes());
        }
        this.pipeIn.flush();
    }

    private void writeError(String string) throws IOException {
        this.writeError(string, false);
    }

    private void writeError(String string, boolean bl) throws IOException {
        log.debug((Object)("Sending error message '" + string + "' to client (serious=" + bl + ")"));
        this.pipeIn.write(bl ? 2 : 1);
        this.pipeIn.write(string.getBytes());
        if (!string.endsWith("\n")) {
            this.pipeIn.write(10);
        }
        this.pipeIn.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Object object;
        block22: {
            log.debug((Object)"Running ScpServer thread");
            try {
                if (this.from) {
                    log.info((Object)"From mode");
                    try {
                        block21: {
                            this.waitForResponse();
                            object = new StringPattern(this.destination);
                            if (((StringPattern)object).hasWildcard()) {
                                log.debug((Object)"Path contains wildcard");
                                String string = this.destination;
                                String string2 = ".";
                                int n = string.lastIndexOf(47);
                                if (n != -1) {
                                    if (n > 0) {
                                        string2 = string.substring(0, n);
                                    }
                                    string = string.substring(n + 1);
                                }
                                log.debug((Object)("Looking for matches in " + string2 + " for " + string));
                                object = new StringPattern(string);
                                byte[] byArray = null;
                                try {
                                    byArray = this.nfs.openDirectory(string2);
                                    SftpFile[] sftpFileArray = this.nfs.readDirectory(byArray);
                                    for (int i = 0; i < sftpFileArray.length; ++i) {
                                        log.debug((Object)("Testing for match against " + sftpFileArray[i].getFilename()));
                                        if (((StringPattern)object).matches(sftpFileArray[i].getFilename())) {
                                            log.debug((Object)"Matched");
                                            this.writeFileToRemote(string2 + "/" + sftpFileArray[i].getFilename());
                                            continue;
                                        }
                                        log.debug((Object)"No match");
                                    }
                                    Object var9_13 = null;
                                    if (byArray == null) break block21;
                                }
                                catch (Throwable throwable) {
                                    Object var9_14 = null;
                                    if (byArray == null) throw throwable;
                                    try {
                                        this.nfs.closeFile(byArray);
                                        throw throwable;
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    throw throwable;
                                }
                                try {}
                                catch (Exception exception) {}
                                this.nfs.closeFile(byArray);
                            } else {
                                log.debug((Object)"No wildcards");
                                this.writeFileToRemote(this.destination);
                            }
                        }
                        log.debug((Object)"File transfers complete");
                        break block22;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        log.error((Object)fileNotFoundException);
                        this.writeError(fileNotFoundException.getMessage(), true);
                        throw new IOException(fileNotFoundException.getMessage());
                    }
                    catch (PermissionDeniedException permissionDeniedException) {
                        log.error((Object)permissionDeniedException);
                        this.writeError(permissionDeniedException.getMessage(), true);
                        throw new IOException(permissionDeniedException.getMessage());
                    }
                    catch (InvalidHandleException invalidHandleException) {
                        log.error((Object)invalidHandleException);
                        this.writeError(invalidHandleException.getMessage(), true);
                        throw new IOException(invalidHandleException.getMessage());
                    }
                    catch (IOException iOException) {
                        log.error((Object)iOException);
                        this.writeError(iOException.getMessage(), true);
                        throw new IOException(iOException.getMessage());
                    }
                }
                log.info((Object)"To mode");
                this.readFromRemote(this.destination);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                log.error((Object)throwable);
                this.exitCode = 1;
            }
        }
        log.debug((Object)"ScpServer stopped, notify block on waitForExitCode().");
        object = this;
        synchronized (object) {
            this.notify();
            return;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean writeDirToRemote(String string) throws IOException {
        FileAttributes fileAttributes = this.nfs.getFileAttributes(string);
        if (fileAttributes.isDirectory() && !this.recursive) {
            this.writeError("File " + string + " is a directory, use recursive mode");
            return false;
        }
        String string2 = string;
        int n = string.lastIndexOf(47);
        if (n != -1) {
            string2 = string.substring(n + 1);
        }
        this.writeCommand("D" + fileAttributes.getMaskString() + " 0 " + string2 + "\n");
        this.waitForResponse();
        byte[] byArray = null;
        byArray = this.nfs.openDirectory(string);
        SftpFile[] sftpFileArray = this.nfs.readDirectory(byArray);
        for (int i = 0; i < sftpFileArray.length; ++i) {
            this.writeFileToRemote(string + "/" + sftpFileArray[i].getFilename());
        }
        this.writeCommand("E");
        Object var9_10 = null;
        if (byArray == null) return true;
        try {
            this.nfs.closeFile(byArray);
            return true;
        }
        catch (Exception exception) {
            log.error((Object)exception);
        }
        return true;
        {
            catch (InvalidHandleException invalidHandleException) {
                throw new IOException(invalidHandleException.getMessage());
            }
            catch (PermissionDeniedException permissionDeniedException) {
                throw new IOException(permissionDeniedException.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (byArray == null) throw throwable;
            try {
                this.nfs.closeFile(byArray);
                throw throwable;
            }
            catch (Exception exception) {
                log.error((Object)exception);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void writeFileToRemote(String var1_1) throws IOException, PermissionDeniedException, InvalidHandleException {
        block16: {
            var2_2 = this.nfs.getFileAttributes(var1_1);
            if (var2_2.isDirectory()) {
                if (!this.writeDirToRemote(var1_1)) {
                    return;
                }
            } else {
                if (var2_2.isFile()) {
                    var3_3 = var1_1;
                    var4_4 = var3_3.lastIndexOf(47);
                    if (var4_4 != -1) {
                        var3_3 = var1_1.substring(var4_4 + 1);
                    }
                    this.writeCommand("C" + var2_2.getMaskString() + " " + var2_2.getSize() + " " + var3_3 + "\n");
                    this.waitForResponse();
                    ScpServer.log.debug((Object)("Opening file " + var1_1));
                    var5_5 = null;
                    try {
                        var5_5 = this.nfs.openFile(var1_1, new UnsignedInteger32(1L), var2_2);
                        ScpServer.log.debug((Object)"Sending file");
                        for (var6_6 = 0; var6_6 < var2_2.getSize().intValue(); var6_6 += var7_7.length) {
                            try {
                                var7_7 = this.nfs.readFile(var5_5, new UnsignedInteger64(String.valueOf(var6_6)), new UnsignedInteger32((long)ScpServer.BUFFER_SIZE));
                                ScpServer.log.debug((Object)("Writing block of " + var7_7.length + " bytes"));
                                this.pipeIn.write(var7_7);
                                continue;
                            }
                            catch (EOFException var7_8) {
                                ScpServer.log.debug((Object)"End of file - finishing transfer");
                                break;
                            }
                        }
                        this.pipeIn.flush();
                        if (var6_6 < var2_2.getSize().intValue()) {
                            throw new IOException("File transfer terminated abnormally.");
                        }
                        ScpServer.log.info((Object)"File transfer complete.");
                        this.writeOk();
                        var9_9 = null;
                        ** if (var5_5 == null) goto lbl-1000
                    }
                    catch (Throwable var8_13) {
                        var9_10 = null;
                        if (var5_5 != null) {
                            try {
                                this.nfs.closeFile(var5_5);
                            }
                            catch (Exception var10_12) {
                                ScpServer.log.error((Object)var10_12);
                            }
                        }
                        throw var8_13;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            this.nfs.closeFile(var5_5);
                        }
                        catch (Exception var10_11) {
                            ScpServer.log.error((Object)var10_11);
                        }
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block16;
                    }
                }
                throw new IOException(var1_1 + " not valid for SCP.");
            }
        }
        this.waitForResponse();
    }

    private void waitForResponse() throws IOException {
        log.debug((Object)"Waiting for response");
        int n = this.pipeOut.read();
        if (n == 0) {
            log.debug((Object)"Got Ok");
            return;
        }
        if (n == -1) {
            throw new EOFException("SCP returned unexpected EOF");
        }
        String string = this.readString();
        log.debug((Object)("Got error '" + string + "'"));
        if (n == 2) {
            log.debug((Object)"This is a serious error");
            throw new IOException(string);
        }
        throw new IOException("SCP returned an unexpected error: " + string);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void readFromRemote(String var1_1) throws IOException {
        var3_2 = new String[3];
        this.writeOk();
        block25: while (true) {
            ScpServer.log.debug((Object)"Waiting for command");
            try {
                var2_3 = this.readString();
            }
            catch (EOFException var4_5) {
                return;
            }
            ScpServer.log.debug((Object)("Got command '" + var2_3 + "'"));
            var4_4 = var2_3.charAt(0);
            switch (var4_4) {
                case 'E': {
                    this.writeOk();
                    return;
                }
                case 'T': {
                    ScpServer.log.error((Object)"SCP time not currently supported");
                    this.writeError("WARNING: This server does not currently support the SCP time command");
                    continue block25;
                }
                case 'C': 
                case 'D': {
                    this.parseCommand(var2_3, var3_2);
                    var5_6 = null;
                    try {
                        ScpServer.log.debug((Object)("Getting attributes for current destination (" + var1_1 + ")"));
                        var5_6 = this.nfs.getFileAttributes(var1_1);
                    }
                    catch (FileNotFoundException var6_8) {
                        ScpServer.log.debug((Object)"Current destination not found");
                    }
                    var6_7 = var1_1;
                    var7_9 = var3_2[2];
                    if (var5_6 != null && var5_6.isDirectory()) {
                        ScpServer.log.debug((Object)"Target is a directory");
                        var6_7 = var6_7 + '/' + var7_9;
                    }
                    var8_10 = null;
                    try {
                        ScpServer.log.debug((Object)("Getting attributes for target destination (" + var6_7 + ")"));
                        var8_10 = this.nfs.getFileAttributes(var6_7);
                    }
                    catch (FileNotFoundException var9_12) {
                        ScpServer.log.debug((Object)"Target destination not found");
                    }
                    if (var4_4 == 'D') {
                        ScpServer.log.debug((Object)"Got directory request");
                        if (var8_10 != null) {
                            if (!var8_10.isDirectory()) {
                                var9_11 /* !! */  = (byte[])("Invalid target " + var7_9 + ", must be a directory");
                                this.writeError((String)var9_11 /* !! */ );
                                throw new IOException((String)var9_11 /* !! */ );
                            }
                        } else {
                            try {
                                ScpServer.log.debug((Object)("Creating directory " + var6_7));
                                if (!this.nfs.makeDirectory(var6_7)) {
                                    var9_11 /* !! */  = (byte[])("Could not create directory: " + var7_9);
                                    this.writeError((String)var9_11 /* !! */ );
                                    throw new IOException((String)var9_11 /* !! */ );
                                }
                                ScpServer.log.debug((Object)"Setting permissions on directory");
                                var5_6.setPermissionsFromMaskString(var3_2[0]);
                            }
                            catch (FileNotFoundException var9_13) {
                                this.writeError("File not found");
                                throw new IOException("File not found");
                            }
                            catch (PermissionDeniedException var9_14) {
                                this.writeError("Permission denied");
                                throw new IOException("Permission denied");
                            }
                        }
                        this.readFromRemote(var6_7);
                        continue block25;
                    }
                    ScpServer.log.debug((Object)"Opening file for writing");
                    var9_11 /* !! */  = null;
                    try {
                        var9_11 /* !! */  = this.nfs.openFile(var6_7, new UnsignedInteger32(26L), var5_6);
                        ScpServer.log.debug((Object)"NFS file opened");
                        this.writeOk();
                        ScpServer.log.debug((Object)"Reading from client");
                        var10_15 = 0;
                        var12_21 = Long.parseLong(var3_2[1]);
                        while ((long)var10_15 < var12_21) {
                            var11_20 = this.pipeOut.read(this.buffer, 0, (int)(var12_21 - (long)var10_15 < (long)this.buffer.length ? var12_21 - (long)var10_15 : (long)this.buffer.length));
                            if (var11_20 == -1) {
                                throw new EOFException("ScpServer received an unexpected EOF during file transfer");
                            }
                            ScpServer.log.debug((Object)("Got block of " + var11_20));
                            this.nfs.writeFile(var9_11 /* !! */ , new UnsignedInteger64(String.valueOf(var10_15)), this.buffer, 0, var11_20);
                            var10_15 += var11_20;
                        }
                        ScpServer.log.debug((Object)"File transfer complete");
                        var15_22 = null;
                        ** if (var9_11 /* !! */  == null) goto lbl-1000
                    }
                    catch (Throwable var14_24) {
                        var15_22 = null;
                        if (var9_11 /* !! */  != null) {
                            try {
                                ScpServer.log.debug((Object)"Closing handle");
                                this.nfs.closeFile(var9_11 /* !! */ );
                            }
                            catch (Exception var16_23) {
                                // empty catch block
                            }
                        }
                        throw var14_24;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            ScpServer.log.debug((Object)"Closing handle");
                            this.nfs.closeFile(var9_11 /* !! */ );
                        }
                        catch (Exception var16_23) {}
                    }
lbl-1000:
                    // 2 sources

                    {
                        ** GOTO lbl114
                        catch (InvalidHandleException var10_16) {
                            this.writeError("Invalid handle.");
                            throw new IOException("Invalid handle.");
                        }
                        catch (FileNotFoundException var10_17) {
                            this.writeError("File not found");
                            throw new IOException("File not found");
                        }
                        catch (PermissionDeniedException var10_18) {
                            this.writeError("Permission denied");
                            throw new IOException("Permission denied");
                        }
                    }
lbl114:
                    // 2 sources

                    this.waitForResponse();
                    if (this.preserveAttributes) {
                        var5_6.setPermissionsFromMaskString(var3_2[0]);
                        ScpServer.log.debug((Object)("Setting permissions on directory to " + var5_6.getPermissionsString()));
                        try {
                            this.nfs.setFileAttributes(var6_7, var5_6);
                        }
                        catch (Exception var10_19) {
                            this.writeError("Failed to set file permissions.");
                            continue block25;
                        }
                    }
                    this.writeOk();
                    continue block25;
                }
            }
            break;
        }
        this.writeError("Unexpected cmd: " + var2_3);
        throw new IOException("SCP unexpected cmd: " + var2_3);
    }

    private void parseCommand(String string, String[] stringArray) throws IOException {
        int n = string.indexOf(32);
        int n2 = string.indexOf(32, n + 1);
        if (n == -1 || n2 == -1) {
            this.writeError("Syntax error in cmd");
            throw new IOException("Syntax error in cmd");
        }
        stringArray[0] = string.substring(1, n);
        stringArray[1] = string.substring(n + 1, n2);
        stringArray[2] = string.substring(n2 + 1);
    }

    private String readString() throws IOException {
        int n;
        int n2 = 0;
        while ((n = this.pipeOut.read()) != 10 && n >= 0) {
            this.buffer[n2++] = (byte)n;
        }
        if (n == -1) {
            throw new EOFException("SCP returned unexpected EOF");
        }
        if (this.buffer[0] == 10) {
            throw new IOException("Unexpected <NL>");
        }
        if (this.buffer[0] == 2 || this.buffer[0] == 1) {
            String string = new String(this.buffer, 1, n2 - 1);
            if (this.buffer[0] == 2) {
                throw new IOException(string);
            }
            throw new IOException("SCP returned an unexpected error: " + string);
        }
        return new String(this.buffer, 0, n2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

