/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.daemon.session;

import com.sshtools.daemon.configuration.AllowedSubsystem;
import com.sshtools.daemon.configuration.ServerConfiguration;
import com.sshtools.daemon.platform.NativeProcessProvider;
import com.sshtools.daemon.scp.ScpServer;
import com.sshtools.daemon.session.PseudoTerminalWrapper;
import com.sshtools.daemon.subsystem.SubsystemServer;
import com.sshtools.j2ssh.SshThread;
import com.sshtools.j2ssh.agent.SshAgentForwardingListener;
import com.sshtools.j2ssh.configuration.ConfigurationException;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.connection.Channel;
import com.sshtools.j2ssh.connection.ChannelOutputStream;
import com.sshtools.j2ssh.connection.ConnectionProtocol;
import com.sshtools.j2ssh.connection.IOChannel;
import com.sshtools.j2ssh.connection.InvalidChannelException;
import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.io.IOStreamConnector;
import com.sshtools.j2ssh.util.StartStopState;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SessionChannelServer
extends IOChannel {
    private static Log log = LogFactory.getLog((Class)(class$com$sshtools$daemon$session$SessionChannelServer == null ? (class$com$sshtools$daemon$session$SessionChannelServer = SessionChannelServer.class$("com.sshtools.daemon.session.SessionChannelServer")) : class$com$sshtools$daemon$session$SessionChannelServer));
    public static final String SESSION_CHANNEL_TYPE = "session";
    private static Map allowedSubsystems = new HashMap();
    private Map environment = new HashMap();
    private NativeProcessProvider processInstance;
    private SubsystemServer subsystemInstance;
    private Thread thread;
    private IOStreamConnector ios;
    private ChannelOutputStream stderrOut;
    private InputStream stderrIn;
    private ProcessMonitorThread processMonitor;
    private PseudoTerminalWrapper pty;
    private SshAgentForwardingListener agent;
    private ServerConfiguration config = (ServerConfiguration)ConfigurationLoader.getConfiguration((Class)(class$com$sshtools$daemon$configuration$ServerConfiguration == null ? (class$com$sshtools$daemon$configuration$ServerConfiguration = SessionChannelServer.class$("com.sshtools.daemon.configuration.ServerConfiguration")) : class$com$sshtools$daemon$configuration$ServerConfiguration));
    static /* synthetic */ Class class$com$sshtools$daemon$session$SessionChannelServer;
    static /* synthetic */ Class class$com$sshtools$daemon$configuration$ServerConfiguration;

    public SessionChannelServer() throws ConfigurationException {
        allowedSubsystems.putAll(this.config.getSubsystems());
    }

    private void bindStderrInputStream(InputStream inputStream) {
        this.stderrIn = inputStream;
        this.ios = new IOStreamConnector(inputStream, (OutputStream)this.stderrOut);
    }

    protected void onChangeTerminalDimensions(int n, int n2, int n3, int n4) {
    }

    protected void onChannelClose() throws IOException {
        if (this.agent != null) {
            this.agent.removeReference((Object)this);
        }
        if (this.processInstance != null && this.processInstance.stillActive()) {
            this.processInstance.kill();
        }
        if (this.subsystemInstance != null) {
            this.subsystemInstance.stop();
        }
        if (this.processMonitor != null) {
            StartStopState startStopState = this.processMonitor.getState();
            try {
                startStopState.waitForState(2);
            }
            catch (InterruptedException interruptedException) {
                throw new IOException("The process monitor was interrupted");
            }
        }
    }

    protected void onChannelEOF() throws IOException {
    }

    protected void onChannelExtData(byte[] byArray) throws IOException {
    }

    protected void onChannelOpen() throws InvalidChannelException {
        this.stderrOut = new ChannelOutputStream((Channel)this, new Integer(1));
    }

    protected boolean onExecuteCommand(String string) throws IOException {
        log.debug((Object)("Executing command " + string));
        if (string.startsWith("scp ") && this.processInstance == null) {
            this.processInstance = new ScpServer();
        }
        if (this.processInstance == null) {
            this.processInstance = NativeProcessProvider.newInstance();
        }
        if (this.processInstance == null) {
            log.debug((Object)"Failed to create process");
            return false;
        }
        boolean bl = this.processInstance.createProcess(string, this.environment);
        if (bl) {
            if (this.pty != null) {
                this.pty.bindMasterOutputStream((OutputStream)this.getOutputStream());
                this.pty.bindMasterInputStream((InputStream)this.getInputStream());
                this.pty.bindSlaveInputStream(this.processInstance.getInputStream());
                this.pty.bindSlaveOutputStream(this.processInstance.getOutputStream());
                this.pty.initialize();
                this.bindInputStream(this.pty.getMasterInputStream());
                this.bindStderrInputStream(this.processInstance.getStderrInputStream());
            } else {
                this.bindInputStream(this.processInstance.getInputStream());
                this.bindOutputStream(this.processInstance.getOutputStream());
                this.bindStderrInputStream(this.processInstance.getStderrInputStream());
            }
        }
        return bl;
    }

    protected boolean onRequestPseudoTerminal(String string, int n, int n2, int n3, int n4, String string2) {
        try {
            this.processInstance = NativeProcessProvider.newInstance();
            if (this.processInstance.supportsPseudoTerminal(string)) {
                return this.processInstance.allocatePseudoTerminal(string, n, n2, n3, n4, string2);
            }
            this.pty = new PseudoTerminalWrapper(string, n, n2, n3, n4, string2);
            return true;
        }
        catch (IOException iOException) {
            log.warn((Object)("Failed to allocate pseudo terminal " + string), (Throwable)iOException);
            return false;
        }
    }

    protected void onSetEnvironmentVariable(String string, String string2) {
        this.environment.put(string, string2);
    }

    protected boolean onStartShell() throws IOException {
        String string = this.config.getTerminalProvider();
        if (this.processInstance == null) {
            this.processInstance = NativeProcessProvider.newInstance();
        }
        if (string != null && !string.trim().equals("")) {
            int n = string.indexOf("%DEFAULT_TERMINAL%");
            if (n > -1) {
                string = (n > 0 ? string.substring(0, n) : "") + this.processInstance.getDefaultTerminalProvider() + (n + 18 < string.length() ? string.substring(n + 18) : "");
            }
        } else {
            string = this.processInstance.getDefaultTerminalProvider();
        }
        return this.onExecuteCommand(string);
    }

    protected boolean onStartSubsystem(String string) {
        boolean bl = false;
        try {
            if (!allowedSubsystems.containsKey(string)) {
                log.error((Object)(string + " Subsystem is not available"));
                return false;
            }
            AllowedSubsystem allowedSubsystem = (AllowedSubsystem)allowedSubsystems.get(string);
            if (allowedSubsystem.getType().equals("class")) {
                Class<?> clazz = Class.forName(allowedSubsystem.getProvider());
                this.subsystemInstance = (SubsystemServer)clazz.newInstance();
                this.subsystemInstance.setSession(this);
                this.bindInputStream(this.subsystemInstance.getInputStream());
                this.bindOutputStream(this.subsystemInstance.getOutputStream());
                return true;
            }
            String string2 = allowedSubsystem.getProvider();
            File file = new File(string2);
            if (!file.exists() && !(file = new File(string2 = ConfigurationLoader.getHomeDirectory() + "bin" + File.separator + string2)).exists()) {
                log.error((Object)("Failed to locate subsystem provider " + allowedSubsystem.getProvider()));
                return false;
            }
            return this.onExecuteCommand(string2);
        }
        catch (Exception exception) {
            log.error((Object)("Failed to start subsystem " + string), (Throwable)exception);
            return false;
        }
    }

    public byte[] getChannelOpenData() {
        return null;
    }

    public byte[] getChannelConfirmationData() {
        return null;
    }

    protected int getMinimumWindowSpace() {
        return 1024;
    }

    protected int getMaximumWindowSpace() {
        return 32648;
    }

    protected int getMaximumPacketSize() {
        return 32648;
    }

    public String getChannelType() {
        return SESSION_CHANNEL_TYPE;
    }

    protected void onChannelRequest(String string, boolean bl, byte[] byArray) throws IOException {
        block32: {
            int n;
            int n2;
            String string2;
            ByteArrayReader byteArrayReader;
            log.debug((Object)("Channel Request received: " + string));
            boolean bl2 = false;
            if (string.equals("shell")) {
                bl2 = this.onStartShell();
                if (bl2) {
                    if (bl) {
                        this.connection.sendChannelRequestSuccess((Channel)this);
                    }
                    this.processInstance.start();
                    this.processMonitor = new ProcessMonitorThread(this.processInstance);
                } else if (bl) {
                    this.connection.sendChannelRequestFailure((Channel)this);
                }
            }
            if (string.equals("env")) {
                byteArrayReader = new ByteArrayReader(byArray);
                string2 = byteArrayReader.readString();
                String string3 = byteArrayReader.readString();
                this.onSetEnvironmentVariable(string2, string3);
                if (bl) {
                    this.connection.sendChannelRequestSuccess((Channel)this);
                }
            }
            if (string.equals("exec")) {
                byteArrayReader = new ByteArrayReader(byArray);
                string2 = byteArrayReader.readString();
                bl2 = this.onExecuteCommand(string2);
                if (bl2) {
                    if (bl) {
                        this.connection.sendChannelRequestSuccess((Channel)this);
                    }
                    this.processInstance.start();
                    this.processMonitor = new ProcessMonitorThread(this.processInstance);
                } else if (bl) {
                    this.connection.sendChannelRequestFailure((Channel)this);
                }
            }
            if (string.equals("subsystem")) {
                byteArrayReader = new ByteArrayReader(byArray);
                string2 = byteArrayReader.readString();
                bl2 = this.onStartSubsystem(string2);
                if (bl2) {
                    if (bl) {
                        this.connection.sendChannelRequestSuccess((Channel)this);
                    }
                    if (this.processInstance != null) {
                        this.processInstance.start();
                        this.processMonitor = new ProcessMonitorThread(this.processInstance);
                    } else if (this.subsystemInstance != null) {
                        this.subsystemInstance.start();
                        this.processMonitor = new ProcessMonitorThread(this.subsystemInstance);
                    }
                } else if (bl) {
                    this.connection.sendChannelRequestFailure((Channel)this);
                }
            }
            if (string.equals("pty-req")) {
                byteArrayReader = new ByteArrayReader(byArray);
                string2 = byteArrayReader.readString();
                int n3 = (int)byteArrayReader.readInt();
                n2 = (int)byteArrayReader.readInt();
                n = (int)byteArrayReader.readInt();
                int n4 = (int)byteArrayReader.readInt();
                String string4 = byteArrayReader.readString();
                bl2 = this.onRequestPseudoTerminal(string2, n3, n2, n, n4, string4);
                if (bl && bl2) {
                    this.connection.sendChannelRequestSuccess((Channel)this);
                } else if (bl) {
                    this.connection.sendChannelRequestFailure((Channel)this);
                }
            }
            if (string.equals("window-change")) {
                byteArrayReader = new ByteArrayReader(byArray);
                int n5 = (int)byteArrayReader.readInt();
                int n6 = (int)byteArrayReader.readInt();
                n2 = (int)byteArrayReader.readInt();
                n = (int)byteArrayReader.readInt();
                this.onChangeTerminalDimensions(n5, n6, n2, n);
                if (bl && bl2) {
                    this.connection.sendChannelRequestSuccess((Channel)this);
                } else if (bl) {
                    this.connection.sendChannelRequestFailure((Channel)this);
                }
            }
            if (string.equals("auth-agent-req")) {
                try {
                    byteArrayReader = SshThread.getCurrentThread();
                    this.agent = SshAgentForwardingListener.getInstance((String)byteArrayReader.getSessionIdString(), (ConnectionProtocol)this.connection);
                    this.agent.addReference((Object)this);
                    this.environment.put("SSH_AGENT_AUTH", this.agent.getConfiguration());
                    byteArrayReader.setProperty("sshtools.agent", (Object)this.agent.getConfiguration());
                    if (bl) {
                        this.connection.sendChannelRequestSuccess((Channel)this);
                    }
                }
                catch (Exception exception) {
                    if (!bl) break block32;
                    this.connection.sendChannelRequestFailure((Channel)this);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ProcessMonitorThread
    extends Thread {
        private NativeProcessProvider process;
        private SubsystemServer subsystem;
        private StartStopState state;

        public ProcessMonitorThread(NativeProcessProvider nativeProcessProvider) {
            this.process = nativeProcessProvider;
            this.state = new StartStopState(1);
            this.start();
        }

        public ProcessMonitorThread(SubsystemServer subsystemServer) {
            this.state = subsystemServer.getState();
        }

        public StartStopState getState() {
            return this.state;
        }

        public void run() {
            try {
                log.info((Object)"Monitor waiting for process exit code");
                int n = this.process.waitForExitCode();
                if (n == 9999999) {
                    log.error((Object)"Process monitor failed to retrieve exit code");
                } else {
                    log.debug((Object)("Process exit code is " + String.valueOf(n)));
                    this.process.getInputStream().close();
                    this.process.getOutputStream().close();
                    this.process.getStderrInputStream().close();
                    ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
                    byteArrayWriter.writeInt(n);
                    if (SessionChannelServer.this.connection.isConnected() && SessionChannelServer.this.isOpen()) {
                        SessionChannelServer.this.connection.sendChannelRequest((Channel)SessionChannelServer.this, "exit-status", false, byteArrayWriter.toByteArray());
                    }
                    this.state.setValue(2);
                    SessionChannelServer.this.close();
                }
            }
            catch (IOException iOException) {
                log.error((Object)"Failed to kill process", (Throwable)iOException);
            }
        }
    }
}

