/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.daemon.terminal;

import com.sshtools.daemon.terminal.Colorizer;
import com.sshtools.daemon.terminal.Terminal;
import com.sshtools.daemon.terminal.TerminalFactory;
import com.sshtools.j2ssh.io.IOStreamConnector;
import com.sshtools.j2ssh.session.PseudoTerminal;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;

public class TerminalIO
implements PseudoTerminal {
    public static final int EOL_CRLF = 1;
    public static final int EOL_CR = 2;
    public static final int[] HOME = new int[]{0, 0};
    public static final int IOERROR = -1;
    public static final int UP = 1001;
    public static final int DOWN = 1002;
    public static final int RIGHT = 1003;
    public static final int LEFT = 1004;
    public static final int STORECURSOR = 1051;
    public static final int RESTORECURSOR = 1052;
    public static final int EEOL = 1100;
    public static final int EBOL = 1101;
    public static final int EEL = 1103;
    public static final int EEOS = 1104;
    public static final int EBOS = 1105;
    public static final int EES = 1106;
    public static final int ESCAPE = 1200;
    public static final int BYTEMISSING = 1201;
    public static final int UNRECOGNIZED = 1202;
    public static final int ENTER = 10;
    public static final int TABULATOR = 1301;
    public static final int DELETE = 1302;
    public static final int BACKSPACE = 1303;
    public static final int COLORINIT = 1304;
    public static final int HANDLED = 1305;
    public static final int LOGOUTREQUEST = 1306;
    public static final int LineUpdate = 475;
    public static final int CharacterUpdate = 476;
    public static final int ScreenpartUpdate = 477;
    public static final int EditBuffer = 575;
    public static final int LineEditBuffer = 576;
    public static final int BEL = 7;
    public static final int BS = 8;
    public static final int DEL = 127;
    public static final int CR = 13;
    public static final int LF = 10;
    public static final int FCOLOR = 10001;
    public static final int BCOLOR = 10002;
    public static final int STYLE = 10003;
    public static final int RESET = 10004;
    public static final int BOLD = 1;
    public static final int BOLD_OFF = 22;
    public static final int ITALIC = 3;
    public static final int ITALIC_OFF = 23;
    public static final int BLINK = 5;
    public static final int BLINK_OFF = 25;
    public static final int UNDERLINED = 4;
    public static final int UNDERLINED_OFF = 24;
    public static final int BLACK = 30;
    public static final int RED = 31;
    public static final int GREEN = 32;
    public static final int YELLOW = 33;
    public static final int BLUE = 34;
    public static final int MAGENTA = 35;
    public static final int CYAN = 36;
    public static final int white = 37;
    public static final String CRLF = "\r\n";
    private Terminal terminal;
    private DataInputStream in;
    private DataOutputStream out;
    private boolean closing;
    private boolean cr;
    private boolean nl;
    private boolean acousticSignalling;
    private boolean autoflush;
    private int eol = 1;
    private int lastByte;
    private boolean uselast = false;
    private Colorizer color = Colorizer.getReference();
    private String term;
    private int cols;
    private int rows;
    private PipedInputStream masterIn;
    private PipedOutputStream masterOut;
    private InputStream slaveIn;
    private OutputStream slaveOut;
    private IOStreamConnector ios;

    public TerminalIO(InputStream inputStream, OutputStream outputStream, String string, int n, int n2) throws IOException {
        this.attachStreams(inputStream, outputStream);
        this.term = string;
        this.rows = n2;
        this.cols = n;
        this.acousticSignalling = true;
        this.masterOut = new PipedOutputStream();
        this.masterIn = new PipedInputStream(this.masterOut);
        this.autoflush = true;
        this.closing = false;
        this.cr = false;
        this.setDefaultTerminal();
    }

    public InputStream getMasterInputStream() {
        return this.masterIn;
    }

    public void bindSlaveInputStream(InputStream inputStream) {
        this.slaveIn = inputStream;
        this.ios = new IOStreamConnector(inputStream, (OutputStream)this.masterOut);
    }

    public void bindSlaveOutputStream(OutputStream outputStream) {
        this.slaveOut = outputStream;
    }

    public OutputStream getSlaveOutputStream() {
        return this.slaveOut;
    }

    public int getWidth() {
        return 0;
    }

    public int getHeight() {
        return 0;
    }

    public String getTerm() {
        return this.terminal.getName();
    }

    public String getEncodedTerminalModes() {
        return "";
    }

    public InputStream getAttachedInputStream() throws IOException {
        if (this.in == null) {
            throw new IOException("The teminal is not attached to an InputStream");
        }
        return this.in;
    }

    public OutputStream getAttachedOutputStream() throws IOException {
        if (this.out == null) {
            throw new IOException("The terminal is not attached to an OutputStream");
        }
        return this.out;
    }

    public void detachStreams() {
        this.in = null;
        this.out = null;
    }

    public int getEOL() {
        return this.eol;
    }

    public String getEOLString() {
        return this.eol == 2 ? "\r" : CRLF;
    }

    public void setEOL(int n) {
        this.eol = n;
    }

    public void attachStreams(InputStream inputStream, OutputStream outputStream) {
        this.in = new DataInputStream(new BufferedInputStream(inputStream));
        this.out = new DataOutputStream(new BufferedOutputStream(outputStream));
    }

    public int read() throws IOException {
        int n = this.stripCRSeq(this.rawread());
        if ((n = this.terminal.translateControlCharacter(n)) > 256 && n == 1200) {
            n = this.handleEscapeSequence(n);
        }
        return n;
    }

    public void write(char c) throws IOException {
        this.write((byte)c);
        if (this.autoflush) {
            this.flush();
        }
    }

    public void write(String string) throws IOException {
        this.write(this.color.colorize(string, this.terminal.supportsSGR()).getBytes());
        if (this.autoflush) {
            this.flush();
        }
    }

    public void println(String string) throws IOException {
        this.write(string);
        this.write(this.getEOLString().getBytes());
        if (this.autoflush) {
            this.flush();
        }
    }

    public void println() throws IOException {
        this.write(this.getEOLString().getBytes());
        if (this.autoflush) {
            this.flush();
        }
    }

    public void eraseToEndOfLine() throws IOException {
        this.doErase(1100);
    }

    public void eraseToBeginOfLine() throws IOException {
        this.doErase(1101);
    }

    public void eraseLine() throws IOException {
        this.doErase(1103);
    }

    public void eraseToEndOfScreen() throws IOException {
        this.doErase(1104);
    }

    public void eraseToBeginOfScreen() throws IOException {
        this.doErase(1105);
    }

    public void eraseScreen() throws IOException {
        this.doErase(1106);
    }

    private void doErase(int n) throws IOException {
        this.write(this.terminal.getEraseSequence(n));
        if (this.autoflush) {
            this.flush();
        }
    }

    public void moveCursor(int n, int n2) throws IOException {
        this.write(this.terminal.getCursorMoveSequence(n, n2));
        if (this.autoflush) {
            this.flush();
        }
    }

    public void moveLeft(int n) throws IOException {
        this.moveCursor(1004, n);
    }

    public void moveRight(int n) throws IOException {
        this.moveCursor(1003, n);
    }

    public void moveUp(int n) throws IOException {
        this.moveCursor(1001, n);
    }

    public void moveDown(int n) throws IOException {
        this.moveCursor(1002, n);
    }

    public void setCursor(int n, int n2) throws IOException {
        int[] nArray = new int[]{n, n2};
        this.write(this.terminal.getCursorPositioningSequence(nArray));
        if (this.autoflush) {
            this.flush();
        }
    }

    public void homeCursor() throws IOException {
        this.write(this.terminal.getCursorPositioningSequence(HOME));
        if (this.autoflush) {
            this.flush();
        }
    }

    public void storeCursor() throws IOException {
        this.write(this.terminal.getSpecialSequence(1051));
    }

    public void restoreCursor() throws IOException {
        this.write(this.terminal.getSpecialSequence(1052));
    }

    public void closeInput() throws IOException {
        if (this.in == null) {
            throw new IOException("The terminal is not attached to an inputstream");
        }
        this.in.close();
    }

    private int read16int() throws IOException {
        if (this.in == null) {
            throw new IOException("The terminal is not attached to an inputstream");
        }
        return this.in.readUnsignedShort();
    }

    private int rawread() throws IOException {
        if (this.in == null) {
            throw new IOException("The terminal is not attached to an inputstream");
        }
        return this.in.readUnsignedByte();
    }

    private int stripCRSeq(int n) throws IOException {
        if (this.in == null) {
            throw new IOException("The terminal is not attached to an inputstream");
        }
        if (n == 13) {
            int n2;
            this.in.mark(1);
            if (this.in.available() > 0 && (n2 = this.in.readUnsignedByte()) != 10) {
                this.in.reset();
            }
            return 10;
        }
        return n;
    }

    public void write(byte by) throws IOException {
        if (this.out == null) {
            throw new IOException("The terminal is not attached to an outputstream");
        }
        if (this.eol == 1) {
            if (!this.cr && by == 10) {
                this.out.write(13);
            }
            if (this.cr && by != 10) {
                this.out.write(10);
            }
            this.out.write(by);
            this.cr = by == 13;
        } else {
            this.out.write(by);
        }
    }

    public void write(int n) throws IOException {
        this.write((byte)n);
    }

    public void write(byte[] byArray) throws IOException {
        for (int i = 0; i < byArray.length; ++i) {
            this.write(byArray[i]);
        }
    }

    public void write(int[] nArray) throws IOException {
        for (int i = 0; i < nArray.length; ++i) {
            this.write((byte)nArray[i]);
        }
    }

    public void flush() throws IOException {
        if (this.out == null) {
            throw new IOException("The terminal is not attached to an outputstream");
        }
        this.out.flush();
    }

    public void closeOutput() throws IOException {
        if (this.out == null) {
            throw new IOException("The terminal is not attached to an outputstream");
        }
        this.closing = true;
        this.out.close();
    }

    public void setSignalling(boolean bl) {
        this.acousticSignalling = bl;
    }

    public boolean isSignalling() {
        return this.acousticSignalling;
    }

    public void bell() throws IOException {
        if (this.acousticSignalling) {
            this.write(7);
        }
        if (this.autoflush) {
            this.flush();
        }
    }

    public boolean defineScrollRegion(int n, int n2) throws IOException {
        if (this.terminal.supportsScrolling()) {
            this.write(this.terminal.getScrollMarginsSequence(n, n2));
            this.flush();
            return true;
        }
        return false;
    }

    public void setForegroundColor(int n) throws IOException {
        if (this.terminal.supportsSGR()) {
            this.write(this.terminal.getGRSequence(10001, n));
            if (this.autoflush) {
                this.flush();
            }
        }
    }

    public void setBackgroundColor(int n) throws IOException {
        if (this.terminal.supportsSGR()) {
            this.write(this.terminal.getGRSequence(10002, n + 10));
            if (this.autoflush) {
                this.flush();
            }
        }
    }

    public void setBold(boolean bl) throws IOException {
        if (this.terminal.supportsSGR()) {
            if (bl) {
                this.write(this.terminal.getGRSequence(10003, 1));
            } else {
                this.write(this.terminal.getGRSequence(10003, 22));
            }
            if (this.autoflush) {
                this.flush();
            }
        }
    }

    public void setUnderlined(boolean bl) throws IOException {
        if (this.terminal.supportsSGR()) {
            if (bl) {
                this.write(this.terminal.getGRSequence(10003, 4));
            } else {
                this.write(this.terminal.getGRSequence(10003, 24));
            }
            if (this.autoflush) {
                this.flush();
            }
        }
    }

    public void setItalic(boolean bl) throws IOException {
        if (this.terminal.supportsSGR()) {
            if (bl) {
                this.write(this.terminal.getGRSequence(10003, 3));
            } else {
                this.write(this.terminal.getGRSequence(10003, 23));
            }
            if (this.autoflush) {
                this.flush();
            }
        }
    }

    public void setBlink(boolean bl) throws IOException {
        if (this.terminal.supportsSGR()) {
            if (bl) {
                this.write(this.terminal.getGRSequence(10003, 5));
            } else {
                this.write(this.terminal.getGRSequence(10003, 25));
            }
            if (this.autoflush) {
                this.flush();
            }
        }
    }

    public void resetAttributes() throws IOException {
        if (this.terminal.supportsSGR()) {
            this.write(this.terminal.getGRSequence(10004, 0));
        }
    }

    private int handleEscapeSequence(int n) throws IOException {
        if (n == 1200) {
            int[] nArray = new int[this.terminal.getAtomicSequenceLength()];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = this.read();
            }
            return this.terminal.translateEscapeSequence(nArray);
        }
        if (n == 1201) {
            // empty if block
        }
        return 1305;
    }

    public boolean isAutoflushing() {
        return this.autoflush;
    }

    public void setAutoflushing(boolean bl) {
        this.autoflush = bl;
    }

    public void close() throws IOException {
        this.closeOutput();
    }

    public Terminal getTerminal() {
        return this.terminal;
    }

    public void setDefaultTerminal() throws IOException {
        this.setTerminal(this.term);
    }

    public void setTerminal(String string) throws IOException {
        this.terminal = TerminalFactory.newInstance(string);
        this.initTerminal();
    }

    private void initTerminal() throws IOException {
        this.write(this.terminal.getInitSequence());
        this.flush();
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.cols;
    }
}

